﻿---@diagnostic disable: deprecated
if not (C_Seasons and C_Seasons.GetActiveSeason() == 2) then return; end
-----------------------------------------------------------------
--   L O C A L I Z A T I O N   D A T A B A S E   M O D U L E   --
-----------------------------------------------------------------
local localize = function(t, data) for k,v in pairs(data) do t[k] = v; end end
local appName, _, a = ...;
local L = _.L;

-- Category Database Module
_.CategoryNames = {
	[1] = "Bullets",
	[2] = "Consumable",
	[3] = "Tarot Decks",
	[58] = "Holiday Cooking",
	[63] = "Everyday Cooking",
	[70] = "Unusual Delights",
	[106] = "Card",
	[183] = "Parts",
	[184] = "Explosives",
	[185] = "Goggles",
	[188] = "Devices",
	[189] = "Guns & Bows",
	[190] = "Scopes",
	[191] = "Tools",
	[194] = "Fireworks",
	[215] = "Materials",
	[216] = "Weapon Mods",
	[217] = "Armor Mods",
	[218] = "Helms",
	[219] = "Shoulders",
	[220] = "Chest",
	[221] = "Gauntlets",
	[222] = "Bracers",
	[223] = "Belts",
	[224] = "Legs",
	[225] = "Boots",
	[226] = "Shields",
	[227] = "Weapons",
	[228] = "Skeleton Keys",
	[230] = "Materials",
	[233] = "Bags",
	[234] = "Hats & Hoods",
	[235] = "Shoulders",
	[236] = "Robes & Tunics",
	[237] = "Bracers",
	[238] = "Belts",
	[239] = "Gloves",
	[240] = "Pants",
	[241] = "Boots",
	[242] = "Cloaks",
	[243] = "Shirts",
	[247] = "Materials",
	[249] = "Armor Kits",
	[250] = "Bags",
	[251] = "Helms",
	[252] = "Shoulders",
	[253] = "Chest",
	[254] = "Bracers",
	[255] = "Gloves",
	[256] = "Belts",
	[257] = "Pants",
	[258] = "Boots",
	[259] = "Cloaks",
	[260] = "Special",
	[638] = "Potions",
	[639] = "Elixirs",
	[640] = "Flasks",
	[641] = "Transmutation",
	[642] = "Trinkets",
	[643] = "Oils",
	[644] = "Materials",
	[690] = "Boot Enchantments",
	[691] = "Bracer Enchantments",
	[692] = "Chest Enchantments",
	[693] = "Cloak Enchantments",
	[694] = "Glove Enchantments",
	[695] = "Weapon Enchantments",
	[696] = "Shield Enchantments",
	[697] = "Rods",
	[698] = "Wands",
	[699] = "Oils",
	[700] = "Trinkets",
	[701] = "Reagents",
}
_.CategoryIcons = {
	[1] = 132383,
	[2] = 132108,
	[3] = 134492,
	[58] = 134018,
	[63] = 133968,
	[70] = 133168,
	[106] = 134492,
	[183] = 133006,
	[184] = 133711,
	[185] = 133149,
	[188] = 132766,
	[189] = 135612,
	[190] = 134442,
	[191] = 134520,
	[194] = 135815,
	[215] = 135247,
	[216] = 135250,
	[217] = 133597,
	[218] = 133127,
	[219] = 135053,
	[220] = 132624,
	[221] = 132938,
	[222] = 132616,
	[223] = 132516,
	[224] = 134584,
	[225] = 132535,
	[226] = 134952,
	[227] = 135580,
	[228] = 134245,
	[230] = 132907,
	[233] = 133652,
	[234] = 133133,
	[235] = 135033,
	[236] = 132659,
	[237] = 132606,
	[238] = 132503,
	[239] = 132940,
	[240] = 134586,
	[241] = 132539,
	[242] = 133768,
	[243] = 135029,
	[247] = 134252,
	[249] = 133611,
	[250] = 133628,
	[251] = 133076,
	[252] = 135032,
	[253] = 132635,
	[254] = 132607,
	[255] = 132939,
	[256] = 132513,
	[257] = 134592,
	[258] = 132544,
	[259] = 133755,
	[638] = 134831,
	[639] = 134836,
	[640] = 134821,
	[641] = 135830,
	[642] = 134333,
	[643] = 132799,
	[644] = 132621,
	[690] = 132535,
	[691] = 132616,
	[692] = 132624,
	[693] = 133770,
	[694] = 132938,
	[695] = 135792,
	[696] = 134951,
	[697] = 135138,
	[698] = 135468,
	[699] = 134711,
	[700] = 134084,
	[701] = 133229,
}

-- Custom Header Database Module
_.HeaderConstants = {
	ACHIEVEMENTS = -1000004,
	BLACK_MARKET_AUCTION_HOUSE = -1000083,
	CHEST = -1000062,
	CHILDRENS_WEEK_HEADER = -1000200,
	COMMON_BOSS_DROPS = -1000010,
	COMMON_VENDOR_ITEMS = -1000013,
	CRAFTED_ITEMS = -1000014,
	DARKMOON_FAIRE_HEADER = -1000201,
	EXPLORATION = -1000019,
	FACTIONS = -1000020,
	FEAST_OF_WINTER_VEIL_HEADER = -1000215,
	FLIGHT_PATHS = -1000021,
	HALLOWS_END_HEADER = -1000217,
	HANDS = -1000065,
	HARVEST_FESTIVAL_HEADER = -1000218,
	HEAD = -1000066,
	HOLIDAYS = -1000025,
	HONOR_TITLES = -1000142,
	LEGS = -1000067,
	LOVE_IS_IN_THE_AIR_HEADER = -1000220,
	LUNAR_FESTIVAL_HEADER = -1000221,
	MIDSUMMER_FIRE_FESTIVAL_HEADER = -1000223,
	NOBLEGARDEN_HEADER = -1000224,
	PROFESSIONS = -1000030,
	PVP = -1000144,
	QUESTS = -1000031,
	RARES = -1000032,
	REWARDS = -1000033,
	SEASON_OF_DISCOVERY = -1000273,
	SHARED_APPEARANCES = -1000162,
	SHOULDER = -1000070,
	SPECIAL = -1000037,
	TIER_ZERO_POINT_FIVE_SETS = -1000165,
	TREASURES = -1000038,
	UI_BOUNTY_WINDOW = -1000380,
	UNIQUE_APPEARANCE = -1000163,
	UPGRADE = -1001070,
	VENDORS = -1000039,
	WEAPONS = -1000073,
	WORLD_BOSSES = -1000042,
	ZONE_DROPS = -1000044,
};
_.HeaderData = {
	FILLNPCS = {[-1000070]=1,[-1000067]=1,[-1000066]=1,[-1000065]=1,[-1000062]=1,[-1000044]=1,[-1000033]=1,[-1000013]=1,[-1000010]=1},
};
localize(L.HEADER_NAMES, {
	[-1000004] = ACHIEVEMENTS,
	[-1000009] = CLASS,
	[-1000010] = BATTLE_PET_BREED_QUALITY2.." "..TRANSMOG_SOURCE_1,
	[-1000013] = "Common Vendor Items",
	[-1000014] = LOOT_JOURNAL_LEGENDARIES_SOURCE_CRAFTED_ITEM,
	[-1000015] = "Demon Trainer",
	[-1000019] = "Exploration",
	[-1000020] = FACTION,
	[-1000021] = "Flight Paths",
	[-1000025] = "Holidays",
	[-1000026] = MINIMAP_TRACKING_MAILBOX,
	[-1000027] = BRAWL_TOOLTIP_MAPS,
	[-1000030] = TRADE_SKILLS,
	[-1000031] = TRACKER_HEADER_QUESTS,
	[-1000032] = BATTLE_PET_BREED_QUALITY4,
	[-1000033] = QUEST_REWARDS,
	[-1000034] = "Riding Trainer",
	[-1000036] = WARDROBE_SETS,
	[-1000037] = SPECIAL,
	[-1000038] = "Treasures",
	[-1000039] = TUTORIAL_TITLE20,
	[-1000040] = "Weapon Master",
	[-1000042] = WORLD.." "..RAID_BOSSES,
	[-1000044] = ZONE.." "..BATTLE_PET_SOURCE_1,
	[-1000048] = "Dragons of Nightmare",
	[-1000049] = DUNGEON_FLOOR_NAXXRAMAS2,
	[-1000050] = DUNGEON_FLOOR_NAXXRAMAS1,
	[-1000051] = DUNGEON_FLOOR_NAXXRAMAS3,
	[-1000052] = DUNGEON_FLOOR_NAXXRAMAS4,
	[-1000053] = DUNGEON_FLOOR_NAXXRAMAS6,
	[-1000060] = ARMOR,
	[-1000061] = INVTYPE_CLOAK,
	[-1000062] = INVTYPE_CHEST,
	[-1000063] = INVTYPE_FEET,
	[-1000065] = INVTYPE_HAND,
	[-1000066] = INVTYPE_HEAD,
	[-1000067] = INVTYPE_LEGS,
	[-1000069] = "Relics",
	[-1000070] = INVTYPE_SHOULDER,
	[-1000072] = INVTYPE_WAIST,
	[-1000073] = AUCTION_CATEGORY_WEAPONS,
	[-1000074] = INVTYPE_WRIST,
	[-1000083] = BLACK_MARKET_AUCTION_HOUSE,
	[-1000093] = FACTION_ALLIANCE,
	[-1000095] = FACTION_HORDE,
	[-1000099] = ITEM_QUALITY1_DESC,
	[-1000106] = ITEM_QUALITY0_DESC,
	[-1000114] = "Patch 1.x.x",
	[-1000123] = "Armor Enchantments",
	[-1000125] = "Weapon Enchantments",
	[-1000137] = BATTLEGROUNDS,
	[-1000142] = "Honor Titles",
	[-1000144] = PVP,
	[-1000162] = "Shared Appearances",
	[-1000163] = "Unique Appearance",
	[-1000164] = "Crieve's Never Implemented List",
	[-1000165] = "Tier 0.5 Sets",
	[-1000166] = "Captains",
	[-1000167] = "Silithid Royalty",
	[-1000168] = "The Four Horsemen",
	[-1000169] = DUNGEON_FLOOR_BLACKROCKDEPTHS1,
	[-1000170] = DUNGEON_FLOOR_BLACKROCKDEPTHS2,
	[-1000171] = DUNGEON_FLOOR_BLACKROCKSPIRE3,
	[-1000172] = DUNGEON_FLOOR_UPPERBLACKROCKSPIRE1,
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (East)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (North)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (West)",
	[-1000176] = GetSpellInfo(21127),
	[-1000177] = DUNGEON_FLOOR_DESOLACE22.." (Orange Path)",
	[-1000178] = DUNGEON_FLOOR_DESOLACE21.." (Purple Path)",
	[-1000179] = "Graveyard",
	[-1000180] = "Library",
	[-1000181] = "Armory",
	[-1000182] = "Cathedral",
	[-1000183] = "Main Gate",
	[-1000184] = "Service Entrance",
	[-1000185] = "Atal'ai Defenders",
	[-1000191] = "Defeat a Lieutenant",
	[-1000192] = "Win the Battle",
	[-1000193] = "Speak to the Dead",
	[-1000195] = "Speak to Grizzby",
	[-1000196] = "Speak to N'ora",
	[-1000197] = C_Map.GetAreaInfo(1769),
	[-1000198] = "Speak to Brother Romulus",
	[-1000200] = "Children's Week",
	[-1000201] = "Darkmoon Faire",
	[-1000215] = GetSpellInfo(21953),
	[-1000217] = "Hallow's End",
	[-1000218] = "Harvest Festival",
	[-1000220] = "Love is in the Air",
	[-1000221] = "Lunar Festival",
	[-1000223] = "Midsummer Fire Festival",
	[-1000224] = "Noblegarden",
	[-1000227] = "Stranglethorn Fishing Extravaganza",
	[-1000234] = "The Ahn'Qiraj War Effort",
	[-1000235] = "The Opening of the Dark Portal",
	[-1000236] = "The Scepter of the Shifting Sands",
	[-1000237] = "The Scourge Invasion",
	[-1000243] = "BlizzCon",
	[-1000244] = "Collector's Edition",
	[-1000263] = "iCoke",
	[-1000264] =  AUCTION_CATEGORY_MISCELLANEOUS,
	[-1000267] = BATTLE_PET_SOURCE_9,
	[-1000273] = "Season of Discovery",
	[-1000274] = "Comprehension",
	[-1000275] = "Tier 1",
	[-1000276] = "Tier 2",
	[-1000277] = "Monster Hunting",
	[-1000278] = "Rune Engraving",
	[-1000279] = "Waylaid Supplies",
	[-1000280] = "Crafted",
	[-1000281] = "Gathering",
	[-1000373] = "New Character",
	[-1000376] = "Burly Brawl",
	[-1000377] = "Wild Polymorph",
	[-1000378] = "Soul Brokers",
	[-1000380] = "Bounty",
	[-1000872] = WOWLABS_GAMEMODE_HEADER,
	[-1000904] = "Source IDs",
	[-1000968] = "The Blood Moon",
	[-1000969] = "Nightmare Incursions",
	[-1000970] = "Tier 3",
	[-1000971] = "Aeonas: Journey to Felwood",
	[-1000979] = "Speak to Harold",
	[-1000980] = "Aura of Paralyzing Dread",
	[-1000981] = "Emotional Damage",
	[-1000982] = "Bless the Fallen",
	[-1000983] = "Burn the Fallen Knight",
	[-1000984] = "Squire Training",
	[-1000985] = "Inspiration Rank One",
	[-1000986] = "Inspiration Rank Two",
	[-1000987] = "Aeonas: Trust in a Friend",
	[-1000988] = "Gregory: You Can Trust Me... Probably.",
	[-1000997] = "Blackrock Eruption",
	[-1001035] = "Seasonal Fish: Summer Bass",
	[-1001036] = "Seasonal Fish: Winter Squid",
	[-1001058] = "Nightmare Grove",
	[-1001070] = UPGRADE,
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000015] = "Warlocks can teach their demons new tricks. Some of the higher level grimoires can only be purchased from the Demon Trainer in your faction's capital cities.",
	[-1000025] = "A specific holiday may need to be active for you to complete the referenced Things within this section.",
	[-1000030] = "This section will only show your current character's professions outside of Account and Debug Mode.",
	[-1000033] = "Contains Things which are rewarded or are available from other content within the containing section.\nThey are consolidated here in an effort to reduce duplication from many possible Sources.",
	[-1000040] = "A weapon master is an NPC that offers characters the opportunity to learn specific weapon skills, the availability of which varies from one weapon master to another. All weapon skills can be trained at level 1, except for Polearms which require level 20.\n\nTraining with a weapon master became obsolete in Patch 4.0.1, as all class-appropriate weapon proficiencies are now learned by each class upon creation. Weapon masters were removed from the game shortly after.",
	[-1000162] = "The items in this list are shared appearances for the above item. In Unique Appearance Mode, this list can help you understand why or why not a specific item would be marked Collected.",
	[-1000163] = "This item has a Unique Appearance. You must collect this item specifically to earn the appearance.",
	[-1000164] = "If the following are sorted somewhere, please delete them from this list. Thanks.",
	[-1000171] = "Also known as 'Lower' Blackrock Spire.",
	[-1000172] = "Also known as 'Upper' Blackrock Spire.",
	[-1000173] = "This part of the instance can be accessed from the eastern-most portal. (right side)",
	[-1000174] = "This part of the instance can be accessed from the northern-most portal.",
	[-1000175] = "This part of the instance can be accessed from the western-most portal. (left side)",
	[-1000183] = "Stratholme is divided into two sides.\n\nThis side is commonly referred to as the \"Live\" or \"Scarlet\" side, which the Scarlet Crusade has taken over.",
	[-1000184] = "Stratholme is divided into two sides.\n\nThis side is commonly referred to as the \"Dead\" or \"Scourge\" side, which the Scourge has taken over.",
	[-1000185] = "You must kill all 6 mini bosses around the room in order to unlock the way to Jammal'an the Prophet.",
	[-1000234] = "When Phase 5 is eventually released, the Ruins of Ahn'Qiraj and Temple of Ahn'Qiraj will not be immediately available. Instead, server communities will have to undertake a massive war effort to open the raids by gathering supplies to prepare for the war and completing an epic questline that ultimately culminates in the banging of a gong to open the gates and release the horrors within upon the world.\n\nOnce both factions have finished their contribution, there is a 5-day grace period where. Afterwards, there is a server-wide 10 hour event which spans several zones in Kalimdor the moment someone bangs the gong.\n\nHow quickly Ahn'Qiraj opens depends on the server and its faction balance.\n\nWe recommend delaying the War Effort as long as possible to allow for the most number of people to obtain the Scarab Lord mount as everyone that finishes The Scepter of the Shifting Sands quest line will be granted the same rewards!",
	[-1000235] = "The Opening of the Dark Portal was a one-time event that happened between Prepatch and the launch of TBC and subsequentially removed after. The tabard is the only tabard in the game with the Flex emote built into it and is highly covetted by collectors. Highlord Kruul would spawn randomly outside of the major cities and max level zones of the time.",
	[-1000236] = "In addition to all players on a realm working towards completing the War Effort, one player had to create the Scepter of the Shifting Sands - a very difficult task that could only be solved by a server's top guild back when the questline was added. After the war effort was finished and the army of the Alliance and the Horde arrived in Silithus, the Scepter of the Shifting Sands could be used on the Scarab Gong. Doing so resulted in the opening of Ahn'Qiraj. The first player to bang the Scarab Gong on each server would be rewarded with the Scarab Lord title (in Burning Crusade, the title will not be available in Classic!) and the Black Qiraji Resonating Crystal mount. Anyone else who followed them within 10 hours was rewarded with the title as well.\n\nAlthough it is still possible to complete the questline for the Scepter of the Shifting Sands after the gates have been opened on your server, doing so will not reward neither the Black Qiraji Resonating Crystal nor the Scarab Lord title.",
	[-1000237] = "The Scourge Invasion was a world event in Patch 1.11 and again during the Wrath of the Lich King Pre-Patch during 3.0.1 that heralded the opening of Naxxramas, the citadel of the dreaded Kel'Thuzad.\n\nSeveral regions of Azeroth came under attack by Scourge forces. Members of the Argent Dawn organized a worldwide counter to the Scourge invasion, keeping an eye out for any necropolis sightings and passing on their information to all adventurers willing to aid them in their struggle.\n\nWith each victory against the Scourge, the defense grows stronger. As more and more invasion attempts are beaten back by the defenders, the Argent Dawn will be able to bestow increasingly more powerful blessings upon those fighting the invaders. If the mortal races focus on clearing the Scourge camps all over the world that have sprung up beneath each necropolis, perhaps the invasion can effectively be halted or even repelled. Those who wish to take up arms against the undead invaders should speak with a representative of the Argent Dawn to learn what regions need help and how the defense is holding up.",
	[-1000263] = "These were only available through the 2006 iCoke Promotion (China Only)",
	[-1000264] = "This section is for miscellaneous promotions that took place in the real world or something to do with account management.",
	[-1000273] = "This Season brings an initial level cap of 25 and a new level-25 endgame, including a 10-player Blackfathom Deeps raid with new mechanics, new and reimagined bosses to challenge player tactics and strategies, and fresh rewards.",
	[-1000278] = "Rune Engraving is a new class system for Season of Discovery. It allows each class to tailor their gameplay experience by unlocking new unique abilities!",
	[-1000279] = "Waylaid Supplies quest items drop from mobs of level 6 and above all over Azeroth. These quests request delivery of the Waylaid Supplies to an organization representative in return for a few silver, experience, and Reputation. Of course, there are items missing from the supply shipment, and you can supplement it for greater reputation rewards.",
	[-1000376] = "Only the person who gets the final hit on the drunk will get credit, regardless of who tapped the target first. There is no group credit for this.",
	[-1000377] = "Cast Polymorph on critters afflicted by Wild Polymorph to turn them back into apprentices. Each one will give you a note. Collect 6 notes to learn the rune.",
	[-1000380] = "This list contains Unobtainable items that the ATT Discord has reported as bugs that Blizzard has yet to fix.\n\nNOTE: All filters are ignored within this list for visibility. Only items removed from the game due to negligence rather than a gigantic fire breathing dragon are present on this list.\n\nTo Blizzard Devs: Please fix the items and encounters listed below.",
	[-1000872] = "Get swept away in the Plunderstorm— a fun, new, limited-time, pirate-themed event of prodigious proportions lasting the next several weeks. Scour the map and try to be the last pirate standing while dashing across the Arathi Highlands to find abilities, upgrades, and loot to plunder just to survive!\n\nTo Play: Login to Retail WoW and select 'Plunderstorm' from the Game Mode on the top left of your Character Select screen.",
	[-1000968] = "This is a free-for-all PvP event that takes place in Stranglethorn Vale for 30 minutes once every 3 hours starting at midnight server time.\n\nKill players to receive the stacking buff Blood for the Blood Loa. This stacks 255 times.\nYou receive 5 stacks of blood per kill.\nYou can lose blood from dying.\nTravel to blood altars |cffffffff(red flag on map)|r to exchange Blood for the Blood Loa stacks for Copper Blood Coin, Silver Blood Coin, Gold Blood Coin. You simply walk up to the altar and the coins will automatically appear in your bags.\n\nYou can opt out of the event by speaking to a Zandalarian Emissary.",
	[-1000969] = "This event focuses on the portals found across Azeroth, typically hosting an Emerald Dragon World Boss. These new events are PvE focused, asking players to complete quests around and inside the portals.\n\nThe event is intended to provide both endgame content and variation, with a new faction, the Emerald Wardens as well as new items and sets, but also to supplement the leveling experience. As early as level 25, players will be able to start doing Nightmare Incursions for experience and reputation.\n\nIncursions are also intended to be done in a group, with quests being shareable to up to 4 other players. Some quests will also require killing boss-type enemies, or require you to utilize gathering professions. This doesn't mean that you can't do them solo, it is just unlikely to be very efficient.",
	[-1000980] = "You need to be debuffed from the Nightmare Amalgam to proc this quest. (do not engage it, just run away)",
	[-1000984] = "Starting at level 50, Paladins can complete a quest chain in Western Plaguelands that will give them a Relic that calls forth their own personal Squire. This Squire can level up by fighting in combat as well as by being healed by the Paladin's spells. (Get into combat and just spam rank 1 Flash of Light while he attacks the mobs.)",
	[-1000985] = "After receiving your squire, summon him forth using the Relic and then level him up by getting into combat and keeping him alive.",
	[-1000997] = "This event occurs every 2 hours from Midnight and lasts 60 minutes. While this event is active, Daily Quests will be available in Searing Gorge for the Thorium Brotherhood. Traditionally Thorium Brotherhood can be quite a grind to achieve reputation with so this addition of a Daily Quest Hub will be very welcome.\nWhen the event is active, new NPCs will spawn and some environmental changes will occur to the outside area of Searing Gorge.",
	[-1001058] = "Nightmare Grove can be found near the portals to the Emerald Dream.",
});
localize(L.HEADER_LORE, {
	[-1000048] = "One of these dragons will spawn randomly at the associated coordinates across Azeroth.",
	[-1000165] = "The Dungeon Set 2 class sets, commonly referred to as Tier 0.5, are obtained by completing a long quest chain to upgrade the first set available as drops in end game dungeons into stronger versions of themselves. In current WoW, these sets are covetted by Collectors as the quest chain was completely removed from the game with Cataclysm. In WoW Classic, you should finish this quest chain on all of your characters before then!",
	[-1000166] = "These can be farmed infinitely by resetting the boss.",
	[-1000197] = "The Timbermaw Furbolgs inhabit two areas: Azshara and Felwood. They are presumed to be the only furbolg tribe to escape demonic corruption, though this may not be true due to the existence of Krolg, an uncorrupted furbolg of unknown tribe, and the Stillpine tribe on Azuremyst Isle in Burning Crusade. However, many other races kill furbolg blindly now, without bothering to see if they are friend or foe. For this reason, the Timbermaw furbolg trust very few.\n\nAdventurers who seek out Timbermaw Hold in northern Felwood and prove themselves as friends of the Timbermaw will learn that the furbolgs value their friends above all else. Though they possess no fine jewels or any worldly riches, the Timbermaw's shamanistic tradition is still strong. They know much about the art of crafting armors from animal hides, and they are more than happy to share their healing/resurrection knowledge with friends of their tribe. Besides, any reputation above Unfriendly will also grant you untroubled access to Moonglade and Winterspring through their tunnels.",
});
localize(L.HEADER_ICONS, {
	[-1000004] = _.asset("category_achievements"),
	[-1000009] = 136455,
	[-1000010] = _.asset("category_commonbossdrop"),
	[-1000013] = 133785,
	[-1000014] = _.asset("category_crafting"),
	[-1000015] = 133738,
	[-1000019] = _.asset("category_exploration"),
	[-1000020] = _.asset("category_factions"),
	[-1000021] = _.asset("category_flightpaths"),
	[-1000025] = _.asset("category_holidays"),
	[-1000026] = 133473,
	[-1000027] = 237381,
	[-1000030] = _.asset("category_professions"),
	[-1000031] = _.asset("interface_quest_header"),
	[-1000032] = _.asset("interface_rare"),
	[-1000033] = _.asset("interface_rewards"),
	[-1000034] = 132261,
	[-1000036] = 1602705,
	[-1000037] = 135350,
	[-1000038] = _.asset("interface_tchest"),
	[-1000039] = _.asset("interface_vendor"),
	[-1000040] = 135580,
	[-1000042] = _.asset("interface_world_boss"),
	[-1000044] = _.asset("interface_zone_drop"),
	[-1000048] = 134157,
	[-1000049] = 135442,
	[-1000050] = 236271,
	[-1000051] = 135771,
	[-1000052] = 133781,
	[-1000053] = 134155,
	[-1000060] = 132738,
	[-1000061] = 133763,
	[-1000062] = 132624,
	[-1000063] = 132543,
	[-1000065] = 132958,
	[-1000066] = 133071,
	[-1000067] = 134589,
	[-1000069] = 134916,
	[-1000070] = 135036,
	[-1000072] = 132513,
	[-1000073] = _.asset("weapon_type_epic"),
	[-1000074] = 132606,
	[-1000083] = _.asset("category_blackmarket"),
	[-1000093] = 374217,
	[-1000095] = 374221,
	[-1000099] = 135030,
	[-1000106] = 135025,
	[-1000114] = _.asset("expansion_classic"),
	[-1000123] = 237019,
	[-1000125] = 237018,
	[-1000137] = 132486,
	[-1000142] = 135358,
	[-1000144] = _.asset("category_pvp"),
	[-1000162] = 132874,
	[-1000163] = 132873,
	[-1000164] = 132738,
	[-1000165] = 132738,
	[-1000166] = 236623,
	[-1000167] = 133575,
	[-1000168] = 132264,
	[-1000169] = 236718,
	[-1000170] = 236718,
	[-1000171] = 236429,
	[-1000172] = 134153,
	[-1000173] = 236292,
	[-1000174] = 236695,
	[-1000175] = 134162,
	[-1000176] = 135743,
	[-1000177] = 134116,
	[-1000178] = 134075,
	[-1000179] = 133730,
	[-1000180] = 133745,
	[-1000181] = 133127,
	[-1000182] = 133101,
	[-1000183] = 134503,
	[-1000184] = 134247,
	[-1000185] = 134177,
	[-1000191] = 131013,
	[-1000192] = _.asset("category_pvp"),
	[-1000193] = 131038,
	[-1000195] = 131038,
	[-1000196] = 131038,
	[-1000197] = 236696,
	[-1000198] = 131038,
	[-1000200] = _.asset("holiday_children"),
	[-1000201] = _.asset("event_dmf"),
	[-1000215] = _.asset("holiday_winter_veil"),
	[-1000217] = _.asset("holiday_hallows_end"),
	[-1000218] = _.asset("holiday_harvestfest"),
	[-1000220] = _.asset("holiday_love"),
	[-1000221] = _.asset("holiday_lunar"),
	[-1000223] = _.asset("holiday_midsummer"),
	[-1000224] = _.asset("holiday_noblegarden"),
	[-1000227] = _.asset("holiday_stv_fishing"),
	[-1000234] = 132594,
	[-1000235] = 255348,
	[-1000236] = 133062,
	[-1000237] = 135228,
	[-1000243] = _.asset("promotion_blizzcon"),
	[-1000244] = _.asset("promotion_collector"),
	[-1000263] = 132797,
	[-1000264] = 135999,
	[-1000267] = 134493,
	[-1000273] = 134269,
	[-1000274] = 135933,
	[-1000275] = 134937,
	[-1000276] = 237449,
	[-1000277] = 131013,
	[-1000278] = 136244,
	[-1000279] = 132763,
	[-1000280] = 131034,
	[-1000281] = 131025,
	[-1000373] = 1530081,
	[-1000376] = 131013,
	[-1000377] = 136071,
	[-1000378] = 136169,
	[-1000380] = 236188,
	[-1000872] = 133168,
	[-1000904] = 134400,
	[-1000968] = 237513,
	[-1000969] = 134108,
	[-1000970] = 237446,
	[-1000971] = 131039,
	[-1000979] = 131038,
	[-1000980] = 136147,
	[-1000981] = 237552,
	[-1000982] = 131038,
	[-1000983] = 131038,
	[-1000984] = 237377,
	[-1000985] = 131013,
	[-1000986] = 131013,
	[-1000987] = 131038,
	[-1000988] = 131038,
	[-1000997] = 237588,
	[-1001035] = 133889,
	[-1001036] = 133899,
	[-1001070] = _.asset("interface_upgrade"),
});
localize(L.HEADER_EVENTS, {
	[-1000200] = 201,
	[-1000201] = 479,
	[-1000215] = 141,
	[-1000217] = 324,
	[-1000218] = 321,
	[-1000220] = 423,
	[-1000221] = 327,
	[-1000223] = 341,
	[-1000224] = 181,
	[-1000227] = 301,
	[-1000243] = 1181,
	[-1000872] = 446916,
	[-1001035] = 133889,
	[-1001036] = 133899,
});
localize(L.EVENT_REMAPPING, {
	[374] = 479,
	[375] = 479,
});

-- Programmatic Event Scheduling
_.Modules.Events.SetEventInformation(446916, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=14,["weekday"]=3,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=18,["weekday"]=3,["year"]=2025})
});
_.Modules.Events.SetEventInformation(133899, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=2,["year"]=2024},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=4,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=3,["year"]=2025},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=5,["year"]=2026}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=4,["year"]=2026},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=6,["year"]=2027})
});
_.Modules.Events.SetEventInformation(181, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=17,["weekday"]=4,["year"]=2024},{["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=18,["weekday"]=5,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=17,["weekday"]=5,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=18,["weekday"]=6,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=17,["weekday"]=6,["year"]=2026},{["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=18,["weekday"]=7,["year"]=2026})
});
_.Modules.Events.SetEventInformation(341, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=6,["monthDay"]=21,["weekday"]=6,["year"]=2024},{["hour"]=10,["minute"]=0,["month"]=7,["monthDay"]=5,["weekday"]=6,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=6,["monthDay"]=21,["weekday"]=7,["year"]=2025},{["hour"]=10,["minute"]=0,["month"]=7,["monthDay"]=5,["weekday"]=7,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=6,["monthDay"]=21,["weekday"]=1,["year"]=2026},{["hour"]=10,["minute"]=0,["month"]=7,["monthDay"]=5,["weekday"]=1,["year"]=2026})
});
_.Modules.Events.SetEventInformation(327, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=28,["weekday"]=1,["year"]=2024},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=18,["weekday"]=1,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=28,["weekday"]=3,["year"]=2025},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=18,["weekday"]=3,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=28,["weekday"]=4,["year"]=2026},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=18,["weekday"]=4,["year"]=2026})
});
_.Modules.Events.SetEventInformation(423, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=6,["weekday"]=3,["year"]=2024},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=20,["weekday"]=3,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=6,["weekday"]=5,["year"]=2025},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=20,["weekday"]=5,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=6,["weekday"]=6,["year"]=2026},{["hour"]=10,["minute"]=0,["month"]=2,["monthDay"]=20,["weekday"]=6,["year"]=2026})
});
_.Modules.Events.SetEventInformation(321, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=6,["weekday"]=6,["year"]=2024},{["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=13,["weekday"]=6,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=6,["weekday"]=7,["year"]=2025},{["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=13,["weekday"]=7,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=6,["weekday"]=1,["year"]=2026},{["hour"]=10,["minute"]=0,["month"]=9,["monthDay"]=13,["weekday"]=1,["year"]=2026})
});
_.Modules.Events.SetEventInformation(324, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=18,["weekday"]=6,["year"]=2024},{["hour"]=11,["minute"]=0,["month"]=11,["monthDay"]=1,["weekday"]=6,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=18,["weekday"]=7,["year"]=2025},{["hour"]=11,["minute"]=0,["month"]=11,["monthDay"]=1,["weekday"]=7,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=18,["weekday"]=1,["year"]=2026},{["hour"]=11,["minute"]=0,["month"]=11,["monthDay"]=1,["weekday"]=1,["year"]=2026})
});
_.Modules.Events.SetEventInformation(141, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=12,["monthDay"]=16,["weekday"]=2,["year"]=2024},{["hour"]=6,["minute"]=0,["month"]=1,["monthDay"]=2,["weekday"]=5,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=12,["monthDay"]=16,["weekday"]=3,["year"]=2025},{["hour"]=6,["minute"]=0,["month"]=1,["monthDay"]=2,["weekday"]=6,["year"]=2026}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=12,["monthDay"]=16,["weekday"]=4,["year"]=2026},{["hour"]=6,["minute"]=0,["month"]=1,["monthDay"]=2,["weekday"]=7,["year"]=2027})
});
_.Modules.Events.SetEventInformation(479, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=27,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=3,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=10,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=17,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=24,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=3,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=10,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=17,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=24,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=31,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=7,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=14,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=21,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=4,["monthDay"]=28,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=5,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=12,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=19,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=26,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=6,["monthDay"]=2,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=6,["monthDay"]=9,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=6,["monthDay"]=16,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=6,["monthDay"]=23,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=6,["monthDay"]=30,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=7,["monthDay"]=7,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=7,["monthDay"]=14,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=7,["monthDay"]=21,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=7,["monthDay"]=28,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=8,["monthDay"]=4,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=8,["monthDay"]=11,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=8,["monthDay"]=18,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=8,["monthDay"]=25,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=1,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=8,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=15,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=22,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=29,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=10,["monthDay"]=6,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=10,["monthDay"]=13,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=10,["monthDay"]=20,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=10,["monthDay"]=27,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=3,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=10,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=17,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=24,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=1,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=8,["weekday"]=2,["year"]=2025},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=15,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=22,["weekday"]=2,["year"]=2025},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=29,["weekday"]=2,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=5,["weekday"]=2,["year"]=2026},{["remappedID"]=375}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=12,["weekday"]=2,["year"]=2026},{["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=19,["weekday"]=2,["year"]=2026},{["remappedID"]=374}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=26,["weekday"]=2,["year"]=2026},{["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=2,["weekday"]=2,["year"]=2026},{["remappedID"]=375})
});
_.Modules.Events.SetEventInformation(201, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=1,["weekday"]=4,["year"]=2024},{["hour"]=23,["minute"]=59,["month"]=5,["monthDay"]=7,["weekday"]=3,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=1,["weekday"]=5,["year"]=2025},{["hour"]=23,["minute"]=59,["month"]=5,["monthDay"]=7,["weekday"]=4,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=1,["weekday"]=6,["year"]=2026},{["hour"]=23,["minute"]=59,["month"]=5,["monthDay"]=7,["weekday"]=5,["year"]=2026})
});
_.Modules.Events.SetEventInformation(133889, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=4,["year"]=2024},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=1,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=5,["year"]=2025},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=2,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=6,["year"]=2026},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=3,["year"]=2026})
});

-- Filter Database Module
_.FilterConstants = {
	ACHIEVEMENTS = 105,
	AMMO = 37,
	ARTIFACTS = 11,
	BAGS = 113,
	BATTLE_PETS = 101,
	BOWS = 32,
	CLOAKS = 3,
	CLOTH = 4,
	CONSUMABLES = 55,
	COSMETIC = 2,
	CROSSBOWS = 33,
	DAGGERS = 20,
	FINGER = 52,
	FIST_WEAPONS = 34,
	GUNS = 31,
	HELD_IN_OFF_HAND = 1,
	HOLIDAY = 106,
	LEATHER = 5,
	MAIL = 6,
	MISCELLANEOUS = 50,
	MOUNT_EQUIPMENT = 114,
	MOUNTS = 100,
	NECK = 51,
	ONE_HANDED_AXES = 21,
	ONE_HANDED_MACES = 23,
	ONE_HANDED_SWORDS = 25,
	PLATE = 7,
	POLEARMS = 29,
	PROFESSION_EQUIPMENT = 57,
	QUEST_ITEMS = 104,
	REAGENTS = 56,
	RECIPES = 200,
	RELIC = 54,
	SHIELDS = 8,
	SHIRTS = 10,
	STAVES = 28,
	TABARDS = 9,
	THROWN = 36,
	TOYS = 102,
	TRINKET = 53,
	TWO_HANDED_AXES = 22,
	TWO_HANDED_MACES = 24,
	TWO_HANDED_SWORDS = 26,
	WANDS = 27,
	WARGLAIVES = 35,
};
L.FILTER_ID_TYPES = {
	[1] = INVTYPE_HOLDABLE,
	[2] = "Cosmetic",
	[3] = INVTYPE_CLOAK,
	[4] = GetItemSubClassInfo(4,1),
	[5] = GetItemSubClassInfo(4,2),
	[6] = GetItemSubClassInfo(4,3),
	[7] = GetItemSubClassInfo(4,4),
	[8] = GetItemSubClassInfo(4,6),
	[9] = INVTYPE_TABARD,
	[10] = INVTYPE_BODY,
	[11] = "Artifacts",
	[20] = GetItemSubClassInfo(2,15),
	[21] = GetItemSubClassInfo(2,0),
	[22] = GetItemSubClassInfo(2,1),
	[23] = GetItemSubClassInfo(2,4),
	[24] = GetItemSubClassInfo(2,5),
	[25] = GetItemSubClassInfo(2,7),
	[26] = GetItemSubClassInfo(2,8),
	[27] = GetItemSubClassInfo(2,19),
	[28] = GetItemSubClassInfo(2,10),
	[29] = GetItemSubClassInfo(2,6),
	[31] = GetItemSubClassInfo(2,3),
	[32] = GetItemSubClassInfo(2,2),
	[33] = GetItemSubClassInfo(2,18),
	[34] = GetItemSubClassInfo(2,13),
	[35] = "Warglaives",
	[36] = GetItemSubClassInfo(2,16),
	[37] = INVTYPE_AMMO,
	[50] = AUCTION_CATEGORY_MISCELLANEOUS,
	[51] = INVTYPE_NECK,
	[52] = INVTYPE_FINGER,
	[53] = INVTYPE_TRINKET,
	[54] = INVTYPE_RELIC,
	[55] = AUCTION_CATEGORY_CONSUMABLES,
	[56] = GetItemClassInfo(5),
	[57] = "Profession Equipment",
	[100] = MOUNTS,
	[101] = AUCTION_CATEGORY_BATTLE_PETS,
	[102] = TOY,
	[104] = AUCTION_CATEGORY_QUEST_ITEMS,
	[105] = TRACKER_FILTER_ACHIEVEMENTS,
	[106] = CALENDAR_FILTER_WEEKLY_HOLIDAYS,
	[113] = INVTYPE_BAG,
	[114] = "Mount Equipment",
	[200] = AUCTION_CATEGORY_RECIPES,
}
L.FILTER_ID_ICONS = {
	[1] = 134333,
	[2] = _.asset("interface_cosmetic"),
	[3] = 133763,
	[4] = 132662,
	[5] = 132724,
	[6] = 132627,
	[7] = 132736,
	[8] = 134952,
	[9] = 135026,
	[10] = 135025,
	[11] = 535594,
	[20] = 135637,
	[21] = 132408,
	[22] = 132400,
	[23] = 133477,
	[24] = 133053,
	[25] = 135274,
	[26] = 135277,
	[27] = 135464,
	[28] = 135164,
	[29] = 135127,
	[31] = 135610,
	[32] = 135493,
	[33] = 135530,
	[34] = 134295,
	[35] = 135277,
	[36] = 135426,
	[37] = 132383,
	[50] = 135999,
	[51] = 133289,
	[52] = 133346,
	[53] = 135443,
	[54] = 134916,
	[55] = 132812,
	[56] = _.asset("interface_zone_drop"),
	[57] = 132932,
	[100] = _.asset("category_mounts"),
	[101] = _.asset("category_petjournal"),
	[102] = _.asset("category_toybox"),
	[104] = _.asset("interface_quest_header"),
	[105] = _.asset("category_achievements"),
	[106] = 133202,
	[113] = 133633,
	[114] = 132261,
	[200] = 134941,
}

-- Flight Path Database Module
_.FlightPathNames = {
	[1] = "Northshire Abbey",
	[2] = "Stormwind, Elwynn",
	[3] = "Programmer Isle",
	[4] = "Sentinel Hill, Westfall",
	[5] = "Lakeshire, Redridge",
	[6] = "Ironforge, Dun Morogh",
	[7] = "Menethil Harbor, Wetlands",
	[8] = "Thelsamar, Loch Modan",
	[9] = "Booty Bay, Stranglethorn",
	[10] = "The Sepulcher, Silverpine Forest",
	[11] = "Undercity, Tirisfal",
	[12] = "Darkshire, Duskwood",
	[13] = "Tarren Mill, Hillsbrad",
	[14] = "Southshore, Hillsbrad",
	[15] = "Eastern Plaguelands",
	[16] = "Refuge Pointe, Arathi",
	[17] = "Hammerfall, Arathi",
	[18] = "Booty Bay, Stranglethorn",
	[19] = "Booty Bay, Stranglethorn",
	[20] = "Grom'gol, Stranglethorn",
	[21] = "Kargath, Badlands",
	[22] = "Thunder Bluff, Mulgore",
	[23] = "Orgrimmar, Durotar",
	[24] = "Generic, World Target 002",
	[25] = "Crossroads, The Barrens",
	[26] = "Auberdine, Darkshore",
	[27] = "Rut'theran Village, Teldrassil",
	[28] = "Astranaar, Ashenvale",
	[29] = "Sun Rock Retreat, Stonetalon Mountains",
	[30] = "Freewind Post, Thousand Needles",
	[31] = "Thalanaar, Feralas",
	[32] = "Theramore, Dustwallow Marsh",
	[33] = "Stonetalon Peak, Stonetalon Mountains",
	[34] = "Transport, Booty Bay",
	[35] = "Transport, Orgrimmar",
	[36] = "Generic, World Target 001",
	[37] = "Nijel's Point, Desolace",
	[38] = "Shadowprey Village, Desolace",
	[39] = "Gadgetzan, Tanaris",
	[40] = "Gadgetzan, Tanaris",
	[41] = "Feathermoon, Feralas",
	[42] = "Camp Mojache, Feralas",
	[43] = "Aerie Peak, The Hinterlands",
	[44] = "Valormok, Azshara",
	[45] = "Nethergarde Keep, Blasted Lands",
	[46] = "Transport, Southshore",
	[47] = "Transport, Grom'gol",
	[48] = "Bloodvenom Post, Felwood",
	[49] = "Moonglade",
	[50] = "Transport, Menethil Harbor",
	[51] = "Transport, Auberdine",
	[52] = "Everlook, Winterspring",
	[53] = "Everlook, Winterspring",
	[54] = "Transport, Feathermoon",
	[55] = "Brackenwall Village, Dustwallow Marsh",
	[56] = "Stonard, Swamp of Sorrows",
	[57] = "Fishing Village, Teldrassil",
	[58] = "Zoram'gar Outpost, Ashenvale",
	[59] = "Dun Baldar, Alterac Valley",
	[60] = "Frostwolf Keep, Alterac Valley",
	[61] = "Splintertree Post, Ashenvale",
	[62] = "Nighthaven, Moonglade",
	[63] = "Nighthaven, Moonglade",
	[64] = "Talrendis Point, Azshara",
	[65] = "Talonbranch Glade, Felwood",
	[66] = "Chillwind Camp, Western Plaguelands",
	[67] = "Light's Hope Chapel, Eastern Plaguelands",
	[68] = "Light's Hope Chapel, Eastern Plaguelands",
	[69] = "Moonglade",
	[70] = "Flame Crest, Burning Steppes",
	[71] = "Morgan's Vigil, Burning Steppes",
	[72] = "Cenarion Hold, Silithus",
	[73] = "Cenarion Hold, Silithus",
	[74] = "Thorium Point, Searing Gorge",
	[75] = "Thorium Point, Searing Gorge",
	[76] = "Revantusk Village, The Hinterlands",
	[77] = "Camp Taurajo, The Barrens",
	[78] = "Naxxramas",
	[79] = "Marshal's Refuge, Un'Goro Crater",
	[80] = "Ratchet, The Barrens",
	[84] = "Plaguewood Tower, Eastern Plaguelands",
	[85] = "Northpass Tower, Eastern Plaguelands",
	[86] = "Eastwall Tower, Eastern Plaguelands",
	[87] = "Crown Guard Tower, Eastern Plaguelands",
}

-- Object Database Module
local ObjectNames = {
	[31] = "Old Lion Statue",
	[32] = "Sunken Chest",
	[33] = "Locked Chest",
	[34] = "Old Jug",
	[35] = "Captain's Footlocker",
	[36] = "Broken Barrel",
	[47] = "Wanted: Lieutenant Fangore",
	[52] = "Fall of Gurubashi",
	[54] = "The Emperor's Tomb",
	[55] = "A half-eaten body",
	[56] = "Rolf's corpse",
	[57] = "Moon Over the Vale",
	[58] = "Gri'lek the Wanderer",
	[59] = "Mound of loose dirt",
	[60] = "Wanted: Gath'Ilzogg",
	[61] = "A Weathered Grave",
	[68] = "Wanted Poster",
	[76] = "An Empty Jar",
	[119] = "Abercrombie's Crate",
	[256] = "WANTED",
	[257] = "Suspicious Barrel",
	[259] = "Half-buried Barrel",
	[261] = "Damaged Crate",
	[263] = "Kurzen Supplies",
	[264] = "Kurzen Supplies",
	[269] = "Guarded Thunder Ale Barrel",
	[270] = "Unguarded Thunder Ale Barrel",
	[271] = "Miners' League Crates",
	[272] = "MacGrann's Meat Locker",
	[276] = "Shimmerweed Basket",
	[287] = "Bookie Herod's Records",
	[288] = "Bookie Herod's Strongbox",
	[290] = "Furlbrow's Wardrobe",
	[321] = "Tear of Tilloa",
	[331] = "Loose Soil",
	[333] = "Ancient Relic",
	[334] = "Ancient Relic",
	[375] = "Tirisfal Pumpkin",
	[711] = "Wanted!",
	[759] = "The Holy Spring",
	[1166] = "Alexston's Chest",
	[1557] = "Lillith's Dinner Table",
	[1560] = "Storage Chest",
	[1561] = "Sealed Crate",
	[1562] = "Marshal Haggard's Chest",
	[1571] = "Dusty Spellbooks",
	[1585] = "Explosive Charge",
	[1586] = "Crate of Candles",
	[1593] = "Corpse Laden Boat",
	[1594] = "Berard's Bookshelf",
	[1599] = "Shallow Grave",
	[1609] = "Dragonmaw Catapult",
	[1610] = "Incendicite Mineral Vein",
	[1627] = "Dalaran Crate",
	[1673] = "Fel Cone",
	[1721] = "Locked ball and chain",
	[1722] = "Locked ball and chain",
	[1723] = "Mudsnout Blossom",
	[1727] = "Keg of Shindigger Stout",
	[1728] = "Dusty Rug",
	[1736] = "Shipment of Iron",
	[1738] = "Syndicate Documents",
	[1739] = "Syndicate Documents",
	[1740] = "Syndicate Documents",
	[1759] = "Hillsbrad Town Registry",
	[1760] = "Weathered Bookcase",
	[1761] = "Hillsbrad Proclamation",
	[1763] = "WANTED",
	[1765] = "Worn Wooden Chest",
	[1768] = "Flame of Azel",
	[1769] = "Flame of Veraz",
	[1770] = "Flame of Uzel",
	[2008] = "Dangerous!",
	[2059] = "A Dwarven Corpse",
	[2068] = "Pupellyverbos Port",
	[2076] = "Bubbling Cauldron",
	[2083] = "Bloodsail Correspondence",
	[2084] = "Musquash Root",
	[2086] = "Bloodsail Charts",
	[2087] = "Bloodsail Orders",
	[2289] = "Ruined Lifeboat",
	[2553] = "A Soggy Scroll",
	[2554] = "Cortello's Riddle",
	[2555] = "Musty Scroll",
	[2560] = "Half-Buried Bottle",
	[2576] = "Altar of the Tides",
	[2652] = "Ebenezer Rustlocke's Corpse",
	[2656] = "Waterlogged Letter",
	[2688] = "Keystone",
	[2689] = "Stone of West Binding",
	[2690] = "Stone of Outer Binding",
	[2691] = "Stone of East Binding",
	[2701] = "Iridescent Shards",
	[2702] = "Stone of Inner Binding",
	[2703] = "Trollbane's Tomb",
	[2704] = "Cache of Explosives",
	[2707] = "Maiden's Folly Charts",
	[2708] = "Spirit of Silverpine Charts",
	[2709] = "Maiden's Folly Log",
	[2710] = "Spirit of Silverpine Log",
	[2712] = "Calcified Elven Gem",
	[2713] = "Wanted Board",
	[2714] = "Alterac Granite",
	[2716] = "Trelane's Chest",
	[2717] = "Trelane's Footlocker",
	[2718] = "Trelane's Lockbox",
	[2724] = "Sack of Oats",
	[2734] = "Waterlogged Chest",
	[2739] = "Chest of the Black Feather",
	[2740] = "Chest of the Raven Claw",
	[2741] = "Chest of the Sky",
	[2742] = "Chest of Nesting",
	[2743] = "Carved Stone Urn",
	[2744] = "Giant Clam",
	[2842] = "Pillar of Diamond",
	[2848] = "Pillar of Opal",
	[2858] = "Pillar of Amethyst",
	[2867] = "Excavation Supply Crate",
	[2868] = "Crumpled Map",
	[2875] = "Battered Dwarven Skeleton",
	[2891] = "Balia'mah Trophy Skulls",
	[2892] = "Ziata'jai Trophy Skulls",
	[2893] = "Zul'Mamwe Trophy Skulls",
	[2907] = "Water Pitcher",
	[2908] = "Sealed Supply Crate",
	[2910] = "Well Stone",
	[2912] = "Ambercorn",
	[2933] = "Seal of the Earth",
	[3076] = "Dirt-stained Map",
	[3189] = "Attack Plan: Valley of Trials",
	[3190] = "Attack Plan: Sen'jin Village",
	[3192] = "Attack Plan: Orgrimmar",
	[3236] = "Gnomish Toolbox",
	[3237] = "Imprisoned Darkspear",
	[3238] = "Chen's Empty Keg",
	[3239] = "Benedict's Chest",
	[3240] = "Taillasher Eggs",
	[3290] = "Stolen Supply Sack",
	[3525] = "The Altar of Fire",
	[3640] = "Laden Mushroom",
	[3642] = "Kolkars' Booty",
	[3643] = "Old Footlocker",
	[3644] = "Bael Modan Flying Machine",
	[3646] = "General Twinbraid's Strongbox",
	[3685] = "Silithid Mound",
	[3737] = "Bubbling Fissure",
	[3767] = "Drizzlik's Emporium",
	[3768] = "Fragile - Do Not Drop",
	[3972] = "WANTED",
	[4072] = "Main Control Valve",
	[4141] = "Control Console",
	[4406] = "Webwood Eggs",
	[4608] = "Timberling Sprout",
	[5620] = "Flawed Power Stones",
	[6751] = "Strange Fruited Plant",
	[6752] = "Strange Fronded Plant",
	[6906] = "Red Raptor Nest",
	[6907] = "Blue Raptor Nest",
	[6908] = "Yellow Raptor Nest",
	[7510] = "Sprouted Frond",
	[9630] = "Flagongut's Fossil",
	[10076] = "Scrying Bowl",
	[11713] = "Death Cap",
	[11714] = "Scaber Stalk",
	[12666] = "Twilight Tome",
	[13360] = "Mathystra Relic",
	[13891] = "Serpentbloom",
	[13949] = "Pitted Iron Chest",
	[15084] = "The Sparklematic 5200",
	[15085] = "The Sparklematic 5200",
	[16393] = "Ancient Flame",
	[17182] = "Buzzbox 827",
	[17183] = "Buzzbox 411",
	[17184] = "Buzzbox 323",
	[17188] = "The Lay of Ameth'Aran",
	[17189] = "The Fall of Ameth'Aran",
	[17282] = "Plant Bundle",
	[17783] = "Ancient Statuette",
	[19015] = "Elune's Tear",
	[19016] = "Stardust Covered Bush",
	[19021] = "Rusty Chest",
	[19022] = "Worn Chest",
	[19024] = "Hidden Shrine",
	[19027] = "Tome of Mel'Thandris",
	[19030] = "Mound of Dirt",
	[19283] = "Compendium of the Fallen",
	[19284] = "Mythology of the Titans",
	[19542] = "Deepmoss Eggs",
	[19595] = "Gatekeeper's Hold",
	[19596] = "Sleepers' Cache",
	[19597] = "Druids' Cache",
	[19598] = "Barrow Cache",
	[19599] = "Talon Den Hoard",
	[19602] = "Venture Co. Engineering Plans",
	[19603] = "Venture Co. Documents",
	[19861] = "Henrig Lonebrow's Journal",
	[19869] = "Rocket Car Rubble",
	[19877] = "Velinde's Locker",
	[19901] = "Circle of Imprisonment",
	[20352] = "Circle of Imprisonment",
	[20359] = "Egg of Onyxia",
	[20447] = "Harpy Foodstuffs",
	[20691] = "Cozzle's Footlocker",
	[20725] = "The Legacy of the Aspects",
	[20726] = "Beginnings of the Undead Threat",
	[20727] = "Gizmorium Shipping Crate",
	[20805] = "Rizzle's Unguarded Plans",
	[20807] = "Ancient Brazier",
	[20920] = "Blueleaf Tuber",
	[20985] = "Loose Dirt",
	[20992] = "Black Shield",
	[21015] = "Hoofprints",
	[21016] = "Hoofprints",
	[21042] = "Theramore Guard Badge",
	[21052] = "Defias Strongbox",
	[21277] = "Crate with Holes",
	[21530] = "Snufflenose Owner's Manual",
	[22245] = "Sack of Meat",
	[22246] = "Tear of Theradras",
	[22550] = "Draenethyst Crystals",
	[24798] = "Sundried Driftwood",
	[28024] = "Caravan Chest",
	[28604] = "Scattered Crate",
	[30854] = "Atal'ai Artifact",
	[30855] = "Atal'ai Artifact",
	[30856] = "Atal'ai Artifact",
	[32569] = "Galen's Strongbox",
	[35251] = "Karnitol's Chest",
	[35252] = "Ancient Relic",
	[36738] = "The Book of Ur",
	[37099] = "Atal'ai Tablet",
	[50935] = "Sack of Corn",
	[50936] = "Sack of Barley",
	[50937] = "Sack of Rye",
	[50961] = "Malem Chest",
	[50982] = "The Charred Oak",
	[51708] = "Eliza's Grave Dirt",
	[58369] = "Stolen Iron Chest",
	[58595] = "Burning Blade Stash",
	[61934] = "Brazier of the Dormant Flame",
	[61935] = "Regulator Valve",
	[61936] = "Fuel Control Valve",
	[68865] = "Snufflenose Command Sticks",
	[85562] = "Ironband's Strongbox",
	[85563] = "Dead-tooth's Strongbox",
	[86492] = "Crate of Elunite",
	[89634] = "Iron Coral",
	[89635] = "Sunscorched Shell",
	[91138] = "Jordan's Hammer",
	[92013] = "Tome of the Cabal",
	[92420] = "Bailor's Ore",
	[92423] = "Damaged Chest",
	[93192] = "Heartswood",
	[102984] = "Bink's Toolbox",
	[102985] = "Balnir Snapdragons",
	[103574] = "Filled Containment Coffer",
	[103628] = "Ur's Treatise on Shadow Magic",
	[103821] = "Doan's Strongbox",
	[104564] = "Bingles's Toolbucket",
	[104569] = "Bingles's Toolbucket",
	[104574] = "Bingles's Toolbucket",
	[104575] = "Bingles's Blastencapper",
	[105169] = "Agamand Weapon Rack",
	[105170] = "Agamand Weapon Rack",
	[105171] = "Agamand Weapon Rack",
	[105172] = "Agamand Weapon Rack",
	[105174] = "Chest of Containment Coffers",
	[105175] = "Cantation of Manifestation",
	[112888] = "Dusty Shelf",
	[112948] = "Intrepid's Locked Strongbox",
	[113757] = "Shadowforge Cache",
	[113768] = "Brightly Colored Egg",
	[113791] = "Brazier of Everfount",
	[123329] = "Baelog's Chest",
	[123462] = "The Jewel of the Southsea",
	[124388] = "Garrett Family Chest",
	[124389] = "Krom Stoutarm's Chest",
	[125477] = "Conspicuous Urn",
	[126049] = "Magenta Cap Clusters",
	[126158] = "Tallonkai's Dresser",
	[126260] = "Ancient Chest",
	[129127] = "Gallywix's Lockbox",
	[131474] = "The Discs of Norgannon",
	[138492] = "Shards of Myzrael",
	[140911] = "Spool of Light Chartreuse Silk Thread",
	[140971] = "Gahz'ridian",
	[141812] = "Stone of Binding",
	[141832] = "Gong of Zul'Farrak",
	[141853] = "Violet Tragan",
	[141857] = "Stone of Binding",
	[141858] = "Stone of Binding",
	[141859] = "Stone of Binding",
	[141931] = "Hippogryph Egg",
	[141979] = "Ancient Treasure",
	[141980] = "Spectral Lockbox",
	[142071] = "Egg-O-Matic",
	[142076] = "Clara's Fresh Apples",
	[142088] = "Tablet of Will",
	[142122] = "Wanted Poster",
	[142127] = "Rin'ji's Secret",
	[142151] = "Sealed Barrel",
	[142179] = "Solarsal Gazebo",
	[142181] = "Stolen Cargo",
	[142184] = "Captain's Chest",
	[142185] = "Flame of Byltan",
	[142186] = "Flame of Lahassa",
	[142187] = "Flame of Imbel",
	[142188] = "Flame of Samha",
	[142189] = "Inconspicuous Landmark",
	[142191] = "Horde Supply Crate",
	[142195] = "Woodpaw Battle Map",
	[142343] = "Uldum Pedestal",
	[142344] = "Artificial Extrapolator",
	[142345] = "Matrix Punchograph 3005-A",
	[142475] = "Matrix Punchograph 3005-B",
	[142476] = "Matrix Punchograph 3005-C",
	[142477] = "Thermaplugg's Safe",
	[142487] = "The Sparklematic 5200",
	[142696] = "Matrix Punchograph 3005-D",
	[142702] = "Venom Bottle",
	[142715] = "Tablet of Theka",
	[142958] = "Feralas: A History",
	[143980] = "Gordunni Scroll",
	[144053] = "Scrimshank's Surveying Gear",
	[144054] = "Shay's Chest",
	[144063] = "Equinex Monolith",
	[144064] = "Gordunni Dirt Mound",
	[144066] = "First Witherbark Cage",
	[144067] = "Second Witherbark Cage",
	[144068] = "Third Witherbark Cage",
	[144070] = "Sharpbeak's Cage",
	[147557] = "Stolen Silver",
	[148498] = "Altar of Suntara",
	[148499] = "Felix's Box",
	[148503] = "Fire Plume Ridge Hot Spot",
	[148504] = "A Conspicuous Gravestone",
	[148506] = "Twilight Artifact",
	[148512] = "Essence Font",
	[148513] = "Tablet of Jin'yael",
	[148514] = "Tablet of Markri",
	[148515] = "Tablet of Sael'hai",
	[148516] = "Tablet of Beth'Amara",
	[148832] = "Atal'ai Statue",
	[148836] = "Altar of Hakkar",
	[148838] = "Idol of Hakkar",
	[149025] = "Sentry Brazier",
	[149030] = "Sentry Brazier",
	[149031] = "Sentry Brazier",
	[149032] = "Sentry Brazier",
	[149036] = "Marvon's Chest",
	[149047] = "Torch of Retribution",
	[149480] = "Rune of Jin'yael",
	[149481] = "Rune of Beth'Amara",
	[149482] = "Rune of Markri",
	[149483] = "Rune of Sael'hai",
	[149502] = "Hoard of the Black Dragonflight",
	[150075] = "Wanted Poster",
	[150140] = "Arcane Focusing Crystal",
	[151286] = "Kaldorei Tome of Summoning",
	[152094] = "Hyacinth Mushroom",
	[152095] = "Moonpetal Lily",
	[152097] = "Belnistrasz's Brazier",
	[152608] = "Kolkar's Booty",
	[152618] = "Kolkar's Booty",
	[152622] = "Azsharite Formation",
	[153123] = "Kim'jael's Equipment",
	[153205] = "Altar of the Defiler",
	[153239] = "Wildkin Feather",
	[153556] = "Thaurissan Relic",
	[154357] = "Glinting Mud",
	[156561] = "Wanted Poster",
	[157936] = "Un'Goro Dirt Pile",
	[160836] = "Relic Coffer",
	[160840] = "Soft Dirt Mound",
	[160845] = "Dark Coffer",
	[161495] = "Secret Safe",
	[161504] = "A Small Pack",
	[161505] = "A Wrecked Raft",
	[161521] = "Research Equipment",
	[161526] = "Crate of Foodstuffs",
	[161527] = "Dinosaur Bone",
	[161557] = "Milly's Harvest",
	[161752] = "Tool Bucket",
	[164659] = "Green Power Crystal",
	[164661] = "Yellow Power Crystal",
	[164662] = "Equipment Boxes",
	[164689] = "Monument of Franclorn Forgewright",
	[164778] = "Blue Power Crystal",
	[164780] = "Red Power Crystal",
	[164798] = "Evoroot",
	[164820] = "Dark Keeper Nameplate",
	[164867] = "WANTED",
	[164868] = "KILL ON SIGHT",
	[164869] = "Spectral Chalice",
	[164885] = "Corrupted Night Dragon",
	[164886] = "Corrupted Songflower",
	[164887] = "Corrupted Windblossom",
	[164888] = "Corrupted Whipper Root",
	[164909] = "Wrecked Row Boat",
	[164910] = "Ornate Chest",
	[164911] = "Thunderbrew Lager Keg",
	[164953] = "Large Leather Backpacks",
	[164954] = "Zukk'ash Pod",
	[164955] = "Northern Crystal Pylon",
	[164956] = "Western Crystal Pylon",
	[164957] = "Eastern Crystal Pylon",
	[164958] = "Bloodpetal Sprout",
	[165554] = "Heart of the Mountain",
	[166863] = "Fresh Threshadon Carcass",
	[169243] = "Chest of The Seven",
	[169294] = "Tablet of the Seven",
	[171938] = "Cactus Apple",
	[171939] = "Corrupted Songflower",
	[171942] = "Corrupted Songflower",
	[173232] = "Blacksmithing Plans",
	[173265] = "Wooden Outhouse",
	[173266] = "Goodsteel Ledger",
	[173284] = "Corrupted Whipper Root",
	[173324] = "Corrupted Night Dragon",
	[173327] = "Corrupted Windblossom",
	[174594] = "Corrupted Songflower",
	[174595] = "Corrupted Songflower",
	[174596] = "Corrupted Songflower",
	[174597] = "Corrupted Songflower",
	[174598] = "Corrupted Songflower",
	[174599] = "Corrupted Windblossom",
	[174600] = "Corrupted Windblossom",
	[174601] = "Corrupted Windblossom",
	[174602] = "Corrupted Windblossom",
	[174603] = "Corrupted Windblossom",
	[174604] = "Corrupted Windblossom",
	[174605] = "Corrupted Whipper Root",
	[174606] = "Corrupted Whipper Root",
	[174607] = "Corrupted Whipper Root",
	[174608] = "Corrupted Night Dragon",
	[174682] = "Beware of Pterrordax",
	[174684] = "Corrupted Night Dragon",
	[174686] = "Corrupted Whipper Root",
	[174708] = "Corrupted Windblossom",
	[174709] = "Corrupted Windblossom",
	[174712] = "Corrupted Songflower",
	[174713] = "Corrupted Songflower",
	[174728] = "Damaged Crate",
	[174792] = "Gorishi Silithid Crystal",
	[174793] = "Gorishi Hive Hatchery",
	[174848] = "Testing Equipment",
	[175084] = "The Sparklematic 5200",
	[175124] = "Rookery Egg",
	[175165] = "Silver Dawning's Lockbox",
	[175166] = "Mist Veil's Lockbox",
	[175207] = "Beached Sea Creature",
	[175226] = "Beached Sea Creature",
	[175227] = "Beached Sea Creature",
	[175230] = "Beached Sea Creature",
	[175233] = "Beached Sea Creature",
	[175245] = "Father Flame",
	[175264] = "Broodling Essence",
	[175320] = "WANTED: Murkdeep!",
	[175324] = "Frostmaul Shards",
	[175329] = "Blackwood Nut Stores",
	[175330] = "Blackwood Fruit Stores",
	[175331] = "Blackwood Grain Stores",
	[175334] = "Bijou's Belongings",
	[175369] = "Elders' Square Service Entrance",
	[175382] = "Doomrigger's Coffer",
	[175384] = "Highperch Wyvern Egg",
	[175385] = "Darkstone Tablet",
	[175407] = "Moontouched Feather",
	[175487] = "Third Mosh'aru Tablet",
	[175488] = "Fourth Mosh'aru Tablet",
	[175524] = "Mysterious Red Crystal",
	[175564] = "Brazier of the Herald",
	[175565] = "Alien Egg",
	[175566] = "Gloom Weed",
	[175586] = "Jaron's Wagon",
	[175587] = "Damaged Crate",
	[175606] = "Spire Spider Egg",
	[175621] = "Urok's Tribute Pile",
	[175629] = "Jaron's Supplies",
	[175704] = "Singed Letter",
	[175708] = "Crossroads' Supply Crates",
	[175785] = "Inconspicuous Documents",
	[175802] = "Small Lockbox",
	[175886] = "Roughshod Pike",
	[175888] = "Highborne Relic Fragment",
	[175889] = "Ancient Egg",
	[175891] = "Highborne Relic Fragment",
	[175892] = "Highborne Relic Fragment",
	[175893] = "Highborne Relic Fragment",
	[175894] = "Janice's Parcel",
	[175924] = "Locked Cabinet",
	[175925] = "Outhouse",
	[175926] = "Mrs. Dalson's Diary",
	[175928] = "Incendia Agave",
	[175944] = "Sacred Fire of Life",
	[175949] = "Fifth Mosh'aru Tablet",
	[175950] = "Sixth Mosh'aru Tablet",
	[175965] = "Frostwhisper's Embalming Fluid",
	[175966] = "Enchanted Scarlet Thread",
	[175970] = "Unforged Runic Breastplate",
	[176089] = "Unfired Plate Gauntlets",
	[176090] = "Human Remains",
	[176091] = "Deadwood Cauldron",
	[176092] = "Box of Incendiaries",
	[176112] = "Malor's Strongbox",
	[176115] = "Wanted Poster - Arnak Grimtotem",
	[176116] = "Pamela's Doll's Head",
	[176142] = "Pamela's Doll's Left Side",
	[176143] = "Pamela's Doll's Right Side",
	[176145] = "Joseph Redpath's Monument",
	[176150] = "Musty Tome",
	[176158] = "Brazier of Pain",
	[176159] = "Brazier of Malice",
	[176160] = "Brazier of Suffering",
	[176161] = "Brazier of Hatred",
	[176189] = "Skeletal Sea Turtle",
	[176190] = "Beached Sea Turtle",
	[176191] = "Beached Sea Turtle",
	[176192] = "Catalogue of the Wayward",
	[176196] = "Beached Sea Turtle",
	[176197] = "Beached Sea Turtle",
	[176198] = "Beached Sea Turtle",
	[176206] = "Davil's Libram",
	[176207] = "Redpath's Shield",
	[176208] = "Horgus' Skull",
	[176209] = "Shattered Sword of Marduk",
	[176210] = "Command Tent",
	[176213] = "Blood of Heroes",
	[176245] = "Scarlet Archive",
	[176249] = "Scourge Data",
	[176317] = "The Argent Hold",
	[176325] = "Blacksmithing Plans",
	[176344] = "Document Chest",
	[176356] = "Sacred Highborne Writings",
	[176361] = "Scourge Cauldron",
	[176392] = "Scourge Cauldron",
	[176393] = "Scourge Cauldron",
	[176484] = "The Deed to Brill",
	[176485] = "The Deed to Caer Darrow",
	[176486] = "The Deed to Southshore",
	[176487] = "The Deed to Tarren Mill",
	[176544] = "Remains of Eva Sarkhoff",
	[176545] = "Remains of Lucien Sarkhoff",
	[176581] = "Hand of Iruxos Crystal",
	[176582] = "Shellfish Trap",
	[176630] = "Keepsake of Remembrance",
	[176631] = "Menethil's Gift",
	[176634] = "Kerlonian's Chest",
	[176751] = "Kodo Bones",
	[176785] = "Ammo Crate",
	[176793] = "Bundle of Wood",
	[177240] = "Loose Dirt Mound",
	[177241] = "Araj's Phylactery",
	[177243] = "Demon Portal",
	[177264] = "Symbol of Lost Honor",
	[177287] = "Unfinished Painting",
	[177289] = "Scourge Cauldron",
	[177464] = "Large Termite Mound",
	[177490] = "Northridge Lumber Mill Crate",
	[177491] = "Termite Barrel",
	[177544] = "Joseph's Chest",
	[177624] = "Xabraxxis' Demon Bag",
	[177667] = "Torn Scroll",
	[177673] = "Serpent Statue",
	[177675] = "Mound of Dirt",
	[177684] = "Stone of Shy-Rotam",
	[177747] = "Quel'Thalas Registry",
	[177750] = "Lunar Fungal Bloom",
	[177784] = "Giant Softshell Clam",
	[177786] = "Rackmore's Chest",
	[177787] = "Rackmore's Log",
	[177789] = "Augustus' Receipt Book",
	[177804] = "Mangled Human Remains",
	[177805] = "Mangled Human Remains",
	[177806] = "Mangled Human Remains",
	[177904] = "Wanted Poster: Besseleth",
	[177926] = "Gaea Seed",
	[177929] = "Gaea Dirt Mound",
	[177964] = "Fathom Stone",
	[178084] = "Felix's Chest",
	[178085] = "Felix's Bucket of Bolts",
	[178087] = "Thazz'ril's Pick",
	[178090] = "Marla's Grave",
	[178104] = "Resonite Crystal",
	[178144] = "Troll Chest",
	[178145] = "Resonite Cask",
	[178184] = "Sapphire of Aku'Mai",
	[178185] = "Sapphire of Aku'Mai",
	[178186] = "Sapphire of Aku'Mai",
	[178195] = "Warsong Oil",
	[178204] = "Warsong Axe Shipment",
	[178224] = "Dire Pool",
	[178227] = "Murgut's Totem Basket",
	[178247] = "Naga Brazier",
	[178553] = "Hive'Ashi Pod",
	[178609] = "Holiday Snow",
	[179485] = "Broken Trap",
	[179499] = "Ogre Tannin Basket",
	[179501] = "Knot Thimblejack's Cache",
	[179516] = "Fengus's Chest",
	[179517] = "Treasure of the Shen'dralar",
	[179544] = "Skeletal Remains of Telmius Dreamseeker",
	[179545] = "The Prince's Chest",
	[179547] = "A Dusty Tome",
	[179551] = "Hydraxis' Coffer",
	[179552] = "Schematic: Field Repair Bot 74A",
	[179553] = "Core Fragment",
	[179559] = "Felvine Shard",
	[179562] = "Ancient Heated Blade",
	[179564] = "Gordok Tribute",
	[179565] = "Dusty Reliquary",
	[179644] = "Imprisoned Doomguard",
	[179697] = "Arena Treasure Chest",
	[179703] = "Cache of the Firelord",
	[179826] = "Secret Plans: Fiery Flux",
	[179827] = "Wanted/Missing/Lost & Found",
	[179828] = "Dark Iron Pillow",
	[179832] = "Pillaclencher's Ornate Pillow",
	[179879] = "Orb of Command",
	[179880] = "Drakkisath's Brand",
	[179913] = "Call to Arms!",
	[179914] = "Pile of Bones",
	[179915] = "Pile of Skulls",
	[179922] = "Vessel of Tainted Blood",
	[180215] = "Hakkari Thorium Vein",
	[180229] = "Jinxed Hoodoo Pile",
	[180248] = "School of Tastyfish",
	[180327] = "Brazier of Madness",
	[180366] = "Battered Tackle Box",
	[180368] = "Tablet of Madness",
	[180369] = "Muddy Churning Waters",
	[180435] = "Noggle's Satchel",
	[180436] = "Twilight Tablet Fragment",
	[180448] = "Wanted Poster: Deathclasp",
	[180453] = "Hive'Regal Glyphed Crystal",
	[180454] = "Hive'Ashi Glyphed Crystal",
	[180455] = "Hive'Zora Glyphed Crystal",
	[180456] = "Lesser Wind Stone",
	[180461] = "Wind Stone",
	[180466] = "Greater Wind Stone",
	[180501] = "Twilight Tablet Fragment",
	[180503] = "Sandy Cookbook",
	[180526] = "Gong of Bethekk",
	[180570] = "Keg",
	[180633] = "Crystalline Tear",
	[180642] = "Inconspicuous Crate",
	[180652] = "Freshly Dug Dirt",
	[180662] = "Schooner Wreckage",
	[180665] = "Draconic for Dummies",
	[180666] = "Draconic for Dummies",
	[180667] = "Draconic for Dummies",
	[180669] = "Swirling Maelstrom",
	[180682] = "Oily Blackmouth School",
	[180684] = "Greater Sagefish School",
	[180685] = "Waterlogged Wreckage",
	[180690] = "Large Scarab Coffer",
	[180691] = "Scarab Coffer",
	[180712] = "Stonescale Eel Swarm",
	[180717] = "The Scarab Gong",
	[180743] = "Carefully Wrapped Present",
	[180746] = "Gently Shaken Gift",
	[180747] = "Gaily Wrapped Present",
	[180748] = "Ticking Present",
	[180751] = "Floating Wreckage",
	[180793] = "Festive Gift",
	[180794] = "Journal of Jandice Barov",
	[180901] = "Bloodsail Wreckage",
	[181053] = "Basket of Bloodkelp",
	[181073] = "Fragrant Cauldron",
	[181074] = "Arena Spoils",
	[181083] = "Sothos and Jarien's Heirlooms",
	[181085] = "Stratholme Supply Crate",
	[181098] = "Volcanic Ash",
	[181366] = "Four Horsemen Chest",
	[181597] = "Silithyst Mound",
	[181598] = "Silithyst Geyser",
	[181672] = "Wickerman Effigy",
	[181686] = "Warsong Lumber Pile",
	[181687] = "Lumber Pile",
	[190483] = "Document Chest",
	[190484] = "Document Chest",
	[201579] = "Keystone Shard",
	[207724] = "Shipwreck Debris",
	[375544] = "Wooden Figurine",
	[386675] = "Buried Treasure",
	[386691] = "Library Book",
	[386759] = "Library Book",
	[386777] = "Dusty Chest",
	[387466] = "Rusty Lockbox",
	[387477] = "Defias Stashbox",
	[392029] = "Swordsman's Reward",
	[397987] = "Kobold Stashbox",
	[402215] = "Charred Note",
	[403041] = "Blasting Supplies",
	[403102] = "Bristleback Loot Cache",
	[403105] = "Windfury Cone",
	[403718] = "Prairie Flower",
	[404352] = "Artifact Storage",
	[404433] = "Lunar Chest",
	[404695] = "Waterlogged Stashbox",
	[404830] = "Dusty Chest",
	[404911] = "Hidden Cache",
	[404941] = "Relic Coffer",
	[405149] = "Mural of Ta'zo",
	[405201] = "Shipwreck Cache",
	[405628] = "Frostmane Loot Cache",
	[405633] = "Rockjaw Footlocker",
	[405879] = "Apothecary Society Primer",
	[405946] = "Dusty Chest",
	[406006] = "Idol",
	[406736] = "Lost Stash",
	[406918] = "Messenger Bag",
	[407117] = "Abandoned Snapjaw Nest",
	[407120] = "Empty Snapjaw Nest",
	[407247] = "Glade Flower",
	[407289] = "Horde Warbanner",
	[407291] = "Alliance Warbanner",
	[407312] = "Hungry Idol",
	[407347] = "Altar of Thorns",
	[407352] = "Gnarlpine Stash",
	[407453] = "Southsea Loot Stash",
	[407454] = "Gunpowder Keg",
	[407457] = "Stable Hand's Trunk",
	[407505] = "Etched Carving",
	[407510] = "Etched Carving",
	[407566] = "Goblin Tome",
	[407731] = "Stonemason's Toolbox",
	[407734] = "Gnarlpine Cache",
	[407850] = "Sunken Reliquary",
	[407918] = "Empty Trophy Display",
	[407983] = "Pile of Stolen Books",
	[408004] = "Tangled Blight Pile",
	[408014] = "Gnomish Tome",
	[408718] = "Equipment Stash",
	[408799] = "Idol of the Deep",
	[408802] = "Gnarled Harpoon",
	[409131] = "Rusty Chest",
	[409289] = "Strange Orb",
	[409311] = "Spear of Mannoroth",
	[409315] = "Shattered Orb",
	[409496] = "Scrolls",
	[409501] = "Dalaran Digest",
	[409562] = "Spellbook",
	[409692] = "Scrolls",
	[409700] = "Manual",
	[409711] = "Scrolls",
	[409717] = "Scrolls",
	[409731] = "Scrolls",
	[409735] = "Spellbook",
	[409754] = "Wall-Mounted Shield",
	[409758] = "Discarded Helm",
	[409942] = "Twin Owl Statue",
	[409949] = "Twin Owl Statue",
	[410020] = "Owl Statue",
	[410299] = "Arcane Secrets",
	[410369] = "Dead Drop",
	[410528] = "Ornamented Chest",
	[410847] = "Rusty Safe",
	[411328] = "Slumbering Bones",
	[411348] = "Dusty Coffer",
	[411358] = "Artisan's Chest",
	[411674] = "Prophecy of a King's Demise",
	[411710] = "Demonic Reliquary",
	[411715] = "Bough of Altek",
	[412224] = "Dark Ritual Stone",
	[414532] = "Clliffspring Chest",
	[414624] = "Lighthouse Stash",
	[414646] = "Remnant",
	[414658] = "Rubble",
	[414663] = "Shatterspear Idol",
	[414713] = "Storage Locker",
	[415106] = "Burned-Out Remains",
	[415107] = "Burned-Out Remains",
	[415614] = "Mysterious Formulae",
	[417072] = "Nailed Plank",
	[417353] = "Extinguished Campfire",
	[418855] = "Illari's Loot Cache",
	[422483] = "The Salvagematic 9000",
	[422911] = "Sealed Barrel",
	[422919] = "Tapped Shadowforge Keg",
	[423569] = "Dropped Pouch",
	[423695] = "Libram of Deliverance",
	[423703] = "Broken Warhammer",
	[423841] = "Frozen Remains",
	[424005] = "Pocket Litter",
	[424006] = "Hastily Rolled-Up Satchel",
	[424007] = "Carved Figurine",
	[424010] = "Nailed Plank",
	[424012] = "Mound of Dirt",
	[424074] = "Quadrangulation Beacon 001",
	[424075] = "Quadrangulation Beacon 002",
	[424076] = "Quadrangulation Beacon 003",
	[424077] = "Quadrangulation Beacon 004",
	[433596] = "Spellbound War Chest",
	[439557] = "Nightmare Moss",
	[439558] = "Cold Iron Deposit",
	[439627] = "Dreamroot",
	[439628] = "Fool's Gold Vein",
	[439762] = "Star Lotus",
	[439778] = "Starsilver Vein",
	[439810] = "Moonroot",
	[439815] = "Greater Moonstone Formation",
	[441113] = "Ogre Magi Text",
	[441114] = "Mysterious Box",
	[441119] = "Unhatched Green Dragon Egg",
	[441124] = "Dream-Touched Dragon Egg",
	[441128] = "Vibrating Crate",
	[441129] = "Azsharan Prophecy",
	[441133] = "Star-Touched Dragon Egg",
	[441140] = "Humming Box",
	[441141] = "Dreampearl",
	[441222] = "Grave Mound",
	[441310] = "Moonglow Dragon Egg",
	[441312] = "Mad Keeper's Notes",
	[441314] = "Harpy Screed",
	[441848] = "Small Burrow",
	[441946] = "Shrine of the Moon",
	[441947] = "Shrine of the Beast",
	[441948] = "Shrine of the Warden",
	[455812] = "Squire Cuthbert's Sword",
	[457088] = "Advanced Swordplay",
	[457089] = "The Shadow Connection",
	[457090] = "Famous (and Infamous) Rangers of Azeroth",
	[457091] = "Chen's Training Manual",
	[457092] = "The Fury of Stormrage",
	[457093] = "Blunt Justice: A Dwarf's Tale",
	[457094] = "The True Nature of the Light",
	[457095] = "Elements for Dummies Volume I: Frost",
	[457096] = "Be First: A Brawler's Guide to Boxing",
	[457097] = "Elements for Dummies Volume II: Fire",
	[457098] = "Finding Your Inner Feline: A Guide to Modern Druidism",
	[457099] = "Zirene's Guide to Getting Punched",
	[457100] = "Renzik's Thoughts on \"Fair\" Fighting",
	[457101] = "The Rites of Mak'Gora",
	[457102] = "Elements for Dummies Volume III: Arcane",
	[461639] = "Orthas' Hammer",
	[462233] = "Shimmering Molten Crag",
	[462236] = "Mysterious Chest",
	[495500] = "Shadowflame Cache",
	[495503] = "Chromatic Hoard",
	[495505] = "Favored Riches",
	[495577] = "Chromatic Stash",
	[495578] = "Chromatic Supplies",
	[100000000] = "Archaeologist's Cart",
	[100000001] = "Unlit Torch",
}; _.ObjectNames = ObjectNames;
local ObjectIcons = {
	[31] = 464140,
	[34] = 132798,
	[55] = 133730,
	[56] = 133730,
	[61] = 236399,
	[256] = 134939,
	[259] = 132798,
	[261] = 132762,
	[270] = 133201,
	[711] = 134939,
	[1593] = 1126431,
	[1627] = 132761,
	[1673] = 133944,
	[1738] = 134939,
	[1739] = 134939,
	[1740] = 134939,
	[1761] = 134939,
	[1763] = 134939,
	[1765] = 132763,
	[1768] = 135813,
	[1769] = 135813,
	[1770] = 135813,
	[2008] = 134166,
	[2059] = 133728,
	[2076] = 133778,
	[2083] = 1500889,
	[2553] = 134939,
	[2555] = 134939,
	[2688] = 1003587,
	[2701] = 1003587,
	[2702] = 1003587,
	[2704] = 132761,
	[2713] = 134939,
	[2739] = 132914,
	[2740] = 134334,
	[2741] = 134132,
	[2742] = 134414,
	[2908] = 132763,
	[2910] = 135238,
	[2912] = 133944,
	[3189] = 134939,
	[3190] = 134939,
	[3192] = 134939,
	[3236] = 134520,
	[3237] = 133730,
	[3238] = 132623,
	[3240] = 132833,
	[3290] = 133639,
	[3525] = 135805,
	[3640] = 133848,
	[3644] = 133714,
	[3646] = 134075,
	[3685] = 132834,
	[3737] = 133849,
	[3767] = 134143,
	[3768] = 134442,
	[3972] = 134939,
	[4072] = 134063,
	[4141] = 134063,
	[4406] = 132833,
	[4608] = 136065,
	[5620] = 134095,
	[6751] = 134220,
	[6752] = 960672,
	[6906] = 294479,
	[6907] = 294479,
	[6908] = 294479,
	[7510] = 458173,
	[10076] = 134715,
	[11713] = 134523,
	[11714] = 134531,
	[13360] = 134231,
	[15084] = 133867,
	[15085] = 133867,
	[16393] = 135805,
	[17182] = 133867,
	[17183] = 133867,
	[17184] = 133867,
	[17188] = 133734,
	[17189] = 133735,
	[17282] = 134185,
	[17783] = 134230,
	[19015] = 134564,
	[19016] = 133849,
	[19021] = 132594,
	[19024] = 132867,
	[19027] = 133741,
	[19030] = 133852,
	[19542] = 132834,
	[19869] = 132997,
	[19901] = 134128,
	[20359] = 132832,
	[20691] = 134330,
	[20725] = 133741,
	[20727] = 132385,
	[20805] = 134943,
	[20985] = 463521,
	[20992] = 134950,
	[21042] = 134951,
	[22245] = 133972,
	[22246] = 134133,
	[35251] = 1001977,
	[37099] = 134457,
	[58369] = 133233,
	[61935] = 134063,
	[61936] = 134063,
	[112948] = 1041430,
	[113768] = _.asset("holiday_noblegarden"),
	[113791] = 135805,
	[126049] = 134530,
	[126158] = 134430,
	[129127] = 134846,
	[131474] = 574567,
	[138492] = 1003587,
	[140971] = 133439,
	[141832] = 133056,
	[141853] = 134527,
	[141979] = 985959,
	[142071] = 132833,
	[142122] = 134939,
	[142151] = 132622,
	[142181] = 132620,
	[142184] = 132595,
	[142195] = 237386,
	[142343] = 134375,
	[142344] = 132995,
	[142345] = 134393,
	[142475] = 134394,
	[142476] = 134390,
	[142487] = 133867,
	[142696] = 134392,
	[142702] = 134799,
	[142958] = 133734,
	[143980] = 134943,
	[144064] = 135228,
	[144066] = 132761,
	[144067] = 132761,
	[144068] = 132761,
	[147557] = 133787,
	[148503] = 135805,
	[148504] = 135349,
	[148513] = 134458,
	[148514] = 134455,
	[148515] = 134456,
	[148516] = 134457,
	[149036] = 132594,
	[150075] = 134939,
	[152622] = 134088,
	[153123] = 132761,
	[153239] = 132927,
	[156561] = 134939,
	[157936] = 133849,
	[160836] = 132596,
	[160845] = 132597,
	[161495] = 132595,
	[161505] = 132594,
	[161521] = _.asset("icon_petfamily_mechanical"),
	[161526] = 132594,
	[161557] = 134014,
	[161752] = 134063,
	[164659] = 134105,
	[164661] = 134136,
	[164778] = 134133,
	[164780] = 134130,
	[164820] = 236444,
	[164867] = 134939,
	[164868] = 134939,
	[164869] = 133748,
	[164910] = 132594,
	[164955] = 134087,
	[164956] = 134087,
	[164957] = 134087,
	[164958] = 134001,
	[165554] = 134085,
	[166863] = 133972,
	[169243] = 985959,
	[171938] = 133975,
	[173232] = 1500877,
	[174682] = 134939,
	[174793] = 134822,
	[175165] = 132596,
	[175166] = 132597,
	[175207] = 133719,
	[175226] = 133719,
	[175227] = 133719,
	[175230] = 133719,
	[175233] = 133719,
	[175245] = 134337,
	[175320] = 134939,
	[175324] = 134087,
	[175329] = 133944,
	[175330] = 134013,
	[175331] = 134059,
	[175382] = 133276,
	[175384] = 132833,
	[175385] = 134419,
	[175407] = 132926,
	[175524] = 134396,
	[175564] = 134804,
	[175565] = 132833,
	[175606] = 132833,
	[175629] = 132765,
	[175708] = 132761,
	[175802] = 134377,
	[175888] = 135152,
	[175889] = 132834,
	[175891] = 135152,
	[175892] = 135152,
	[175893] = 135152,
	[175894] = 134144,
	[175926] = 133739,
	[175928] = 134196,
	[176091] = 133778,
	[176115] = 134060,
	[176158] = 134754,
	[176159] = 134754,
	[176160] = 134754,
	[176161] = 134754,
	[176189] = 133724,
	[176190] = 133724,
	[176191] = 133724,
	[176192] = 133740,
	[176196] = 133724,
	[176197] = 133724,
	[176198] = 133724,
	[176213] = 134813,
	[176344] = 134943,
	[176484] = 134328,
	[176485] = 134331,
	[176486] = 134332,
	[176487] = 134327,
	[176544] = 133972,
	[176545] = 133972,
	[176582] = 133900,
	[176631] = 133736,
	[176634] = 134229,
	[176751] = 133726,
	[177241] = 136162,
	[177243] = 136224,
	[177491] = 132620,
	[177544] = 132594,
	[177673] = 133738,
	[177684] = 133972,
	[177750] = 134522,
	[177787] = 132594,
	[177904] = 132196,
	[177964] = 134462,
	[178144] = 133447,
	[178195] = 134844,
	[178204] = 132761,
	[178224] = 134805,
	[178227] = 134232,
	[178553] = 134437,
	[178609] = 132387,
	[179485] = 461122,
	[179501] = 132761,
	[179552] = 134939,
	[179553] = 134116,
	[179559] = 132884,
	[179562] = 135279,
	[179564] = 985959,
	[179697] = 132595,
	[179827] = 134939,
	[179828] = 133601,
	[179832] = 133601,
	[180248] = 133907,
	[180327] = 134711,
	[180366] = 132932,
	[180368] = 134462,
	[180369] = 133891,
	[180435] = 133645,
	[180436] = 134419,
	[180448] = 134939,
	[180453] = 134944,
	[180454] = 134945,
	[180455] = 134946,
	[180456] = 134455,
	[180461] = 134462,
	[180466] = 134459,
	[180501] = 134419,
	[180503] = 133741,
	[180526] = 132594,
	[180633] = 132787,
	[180642] = 132763,
	[180652] = 133849,
	[180662] = 132594,
	[180665] = 134457,
	[180666] = 134457,
	[180667] = 134457,
	[180669] = 133001,
	[180685] = 132594,
	[180690] = 132595,
	[180691] = 132594,
	[180717] = 133575,
	[180743] = 133202,
	[180746] = 133202,
	[180747] = 133202,
	[180748] = 133202,
	[180751] = 132594,
	[180793] = 133202,
	[180794] = 133738,
	[180901] = 132594,
	[181053] = 134192,
	[181074] = 132597,
	[181083] = 132597,
	[181098] = 133849,
	[181597] = 135867,
	[181598] = 135867,
	[181672] = 134450,
	[181687] = 135437,
	[190483] = 134943,
	[190484] = 134943,
	[100000001] = 135434,
}; _.ObjectIcons = ObjectIcons;
local ObjectModels = {
	[31] = 189908,
	[32] = 196976,
	[33] = 196979,
	[34] = 189821,
	[35] = 198238,
	[36] = 199567,
	[47] = 199421,
	[52] = 200640,
	[54] = 200640,
	[55] = 198343,
	[56] = 198343,
	[57] = 200640,
	[58] = 200640,
	[59] = 189528,
	[60] = 199426,
	[61] = 189541,
	[68] = 199421,
	[76] = 199180,
	[119] = 190543,
	[256] = 199424,
	[257] = 198280,
	[259] = 199563,
	[261] = 198168,
	[263] = 198085,
	[264] = 198085,
	[269] = 199563,
	[270] = 199563,
	[271] = 198085,
	[272] = 196979,
	[276] = 200351,
	[287] = 198056,
	[288] = 196979,
	[290] = 198634,
	[321] = 198203,
	[331] = 204112,
	[333] = 199751,
	[334] = 199753,
	[375] = 189409,
	[711] = 199421,
	[759] = 190361,
	[1166] = 196976,
	[1557] = 198598,
	[1560] = 196979,
	[1561] = 198168,
	[1562] = 196982,
	[1571] = 198055,
	[1585] = 197464,
	[1586] = 199634,
	[1593] = 190104,
	[1594] = 198054,
	[1599] = 189528,
	[1609] = 189709,
	[1610] = 219531,
	[1627] = 198168,
	[1673] = 202013,
	[1721] = 197946,
	[1722] = 197946,
	[1723] = 219474,
	[1727] = 199563,
	[1728] = 198435,
	[1736] = 198168,
	[1738] = 198451,
	[1739] = 198453,
	[1740] = 198451,
	[1759] = 198017,
	[1760] = 198047,
	[1761] = 201113,
	[1763] = 199424,
	[1765] = 196979,
	[1768] = 198065,
	[1769] = 198065,
	[1770] = 198065,
	[2008] = 199428,
	[2059] = 197330,
	[2068] = 198057,
	[2076] = 198100,
	[2083] = 198455,
	[2084] = 190384,
	[2086] = 198457,
	[2087] = 198452,
	[2289] = 190677,
	[2553] = 198453,
	[2554] = 198453,
	[2555] = 198453,
	[2560] = 198061,
	[2576] = 197832,
	[2652] = 197330,
	[2656] = 198453,
	[2688] = 199976,
	[2689] = 198951,
	[2690] = 198951,
	[2691] = 198951,
	[2701] = 202445,
	[2702] = 198951,
	[2704] = 200898,
	[2707] = 198457,
	[2708] = 198457,
	[2709] = 198016,
	[2710] = 198029,
	[2712] = 198950,
	[2713] = 199428,
	[2714] = 203668,
	[2716] = 196976,
	[2717] = 196979,
	[2718] = 196982,
	[2724] = 197608,
	[2734] = 196979,
	[2739] = 196976,
	[2740] = 196976,
	[2741] = 196976,
	[2742] = 196976,
	[2743] = 199751,
	[2744] = 196998,
	[2842] = 199976,
	[2848] = 199976,
	[2858] = 199976,
	[2867] = 198168,
	[2868] = 198457,
	[2875] = 197330,
	[2891] = 200638,
	[2892] = 200638,
	[2893] = 200638,
	[2907] = 189815,
	[2908] = 198167,
	[2910] = 198947,
	[2912] = 202297,
	[2933] = 199975,
	[3076] = 198457,
	[3189] = 201113,
	[3190] = 201113,
	[3192] = 201113,
	[3236] = 197617,
	[3237] = 190440,
	[3238] = 198006,
	[3239] = 196982,
	[3240] = 199225,
	[3290] = 200442,
	[3525] = 189280,
	[3640] = 219476,
	[3642] = 196979,
	[3643] = 198238,
	[3644] = 201006,
	[3646] = 196976,
	[3685] = 201386,
	[3737] = 201001,
	[3767] = 198168,
	[3768] = 198158,
	[3972] = 199424,
	[4072] = 198618,
	[4141] = 197760,
	[4406] = 200974,
	[4608] = 201087,
	[5620] = 198947,
	[6751] = 190381,
	[6752] = 190380,
	[6906] = 199223,
	[6907] = 199223,
	[6908] = 199223,
	[7510] = 189772,
	[9630] = 197456,
	[10076] = 201115,
	[11713] = 219475,
	[11714] = 219476,
	[12666] = 198025,
	[13360] = 201093,
	[13891] = 219488,
	[13949] = 196976,
	[15084] = 201020,
	[15085] = 201020,
	[16393] = 198836,
	[17182] = 197760,
	[17183] = 197760,
	[17184] = 197760,
	[17188] = 201080,
	[17189] = 201080,
	[17282] = 203748,
	[17783] = 201094,
	[19015] = 198719,
	[19016] = 201233,
	[19021] = 196976,
	[19022] = 196976,
	[19024] = 198951,
	[19027] = 200924,
	[19030] = 189528,
	[19283] = 198025,
	[19284] = 198026,
	[19542] = 200974,
	[19595] = 198780,
	[19596] = 198754,
	[19597] = 198754,
	[19598] = 198754,
	[19599] = 198951,
	[19602] = 203429,
	[19603] = 198055,
	[19861] = 198036,
	[19869] = 197733,
	[19877] = 196982,
	[19901] = 201106,
	[20352] = 201103,
	[20359] = 200964,
	[20447] = 200960,
	[20691] = 196979,
	[20725] = 198020,
	[20726] = 198020,
	[20727] = 200960,
	[20805] = 198452,
	[20807] = 199138,
	[20920] = 200825,
	[20985] = 204113,
	[20992] = 189676,
	[21015] = 202786,
	[21016] = 202786,
	[21042] = 198660,
	[21052] = 196976,
	[21277] = 200963,
	[21530] = 198036,
	[22245] = 200442,
	[22246] = 190809,
	[22550] = 190809,
	[24798] = 190574,
	[28024] = 196976,
	[28604] = 200960,
	[30854] = 190341,
	[30855] = 190358,
	[30856] = 190354,
	[32569] = 196976,
	[35251] = 196979,
	[35252] = 199748,
	[36738] = 198017,
	[37099] = 201080,
	[50935] = 190015,
	[50936] = 197608,
	[50937] = 190015,
	[50961] = 200961,
	[50982] = 189260,
	[51708] = 201030,
	[58369] = 196976,
	[58595] = 196976,
	[61934] = 200925,
	[61935] = 198616,
	[61936] = 198618,
	[68865] = 202821,
	[85562] = 196976,
	[85563] = 197617,
	[86492] = 200960,
	[89634] = 201354,
	[89635] = 202738,
	[91138] = 198648,
	[92013] = 203385,
	[92420] = 198168,
	[92423] = 196979,
	[93192] = 203691,
	[102984] = 196976,
	[102985] = 203732,
	[103574] = 201015,
	[103628] = 198022,
	[103821] = 196976,
	[104564] = 197640,
	[104569] = 197641,
	[104574] = 197642,
	[104575] = 197464,
	[105169] = 198636,
	[105170] = 198636,
	[105171] = 198636,
	[105172] = 198636,
	[105174] = 196979,
	[105175] = 198453,
	[112888] = 198053,
	[112948] = 197617,
	[113757] = 200953,
	[113768] = 199691,
	[113791] = 198067,
	[123329] = 196979,
	[123462] = 196982,
	[125477] = 199753,
	[126049] = 201860,
	[126158] = 198749,
	[126260] = 200953,
	[129127] = 196979,
	[131474] = 203420,
	[138492] = 202443,
	[140911] = 198131,
	[140971] = 201032,
	[141812] = 201125,
	[141832] = 201029,
	[141853] = 203791,
	[141857] = 201125,
	[141858] = 201125,
	[141859] = 201125,
	[141931] = 201375,
	[141979] = 199748,
	[141980] = 196976,
	[142071] = 197760,
	[142076] = 199734,
	[142088] = 200640,
	[142122] = 199421,
	[142127] = 200640,
	[142151] = 199737,
	[142179] = 201529,
	[142181] = 198085,
	[142184] = 196976,
	[142185] = 199138,
	[142186] = 199138,
	[142187] = 199138,
	[142188] = 199138,
	[142189] = 200259,
	[142191] = 199102,
	[142195] = 198457,
	[142343] = 201041,
	[142344] = 201018,
	[142345] = 201022,
	[142475] = 201022,
	[142476] = 201022,
	[142477] = 196976,
	[142487] = 201020,
	[142696] = 201022,
	[142702] = 198061,
	[142715] = 200640,
	[142958] = 200913,
	[143980] = 198455,
	[144053] = 197760,
	[144054] = 196976,
	[144063] = 201267,
	[144064] = 189528,
	[144066] = 200937,
	[144067] = 200937,
	[144068] = 200937,
	[144070] = 200937,
	[147557] = 196976,
	[148498] = 189280,
	[148499] = 190013,
	[148504] = 190634,
	[148506] = 202136,
	[148512] = 201422,
	[148513] = 201275,
	[148514] = 201276,
	[148515] = 201277,
	[148516] = 201273,
	[148832] = 190304,
	[148836] = 190363,
	[148838] = 190304,
	[149025] = 201422,
	[149030] = 201422,
	[149031] = 201422,
	[149032] = 201422,
	[149036] = 197063,
	[149047] = 198655,
	[149480] = 199976,
	[149481] = 199976,
	[149482] = 199976,
	[149483] = 199976,
	[149502] = 196976,
	[150075] = 199473,
	[150140] = 201271,
	[151286] = 198029,
	[152094] = 201860,
	[152095] = 189752,
	[152097] = 198067,
	[152608] = 196979,
	[152618] = 196979,
	[152622] = 190809,
	[153123] = 198165,
	[153205] = 219250,
	[153239] = 199706,
	[153556] = 201094,
	[154357] = 204112,
	[156561] = 199421,
	[157936] = 204112,
	[160836] = 196976,
	[160840] = 189528,
	[160845] = 196976,
	[161495] = 196976,
	[161504] = 200442,
	[161505] = 190677,
	[161521] = 198085,
	[161526] = 197150,
	[161527] = 199754,
	[161557] = 189806,
	[161752] = 198069,
	[164659] = 202750,
	[164661] = 202754,
	[164662] = 198085,
	[164689] = 203024,
	[164778] = 202749,
	[164780] = 202753,
	[164798] = 199220,
	[164820] = 203051,
	[164867] = 199473,
	[164868] = 199477,
	[164869] = 203016,
	[164885] = 201871,
	[164886] = 201873,
	[164887] = 201877,
	[164888] = 201875,
	[164909] = 190677,
	[164910] = 196979,
	[164911] = 201058,
	[164953] = 198989,
	[164954] = 219553,
	[164955] = 202759,
	[164956] = 202759,
	[164957] = 202759,
	[164958] = 201087,
	[165554] = 203112,
	[166863] = 202781,
	[169243] = 200953,
	[169294] = 189538,
	[171938] = 201766,
	[171939] = 201873,
	[171942] = 201873,
	[173232] = 203431,
	[173265] = 190617,
	[173266] = 200910,
	[173284] = 201875,
	[173324] = 201871,
	[173327] = 201877,
	[174594] = 201873,
	[174595] = 201873,
	[174596] = 201873,
	[174597] = 201873,
	[174598] = 201873,
	[174599] = 201877,
	[174600] = 201877,
	[174601] = 201877,
	[174602] = 201877,
	[174603] = 201877,
	[174604] = 201877,
	[174605] = 201875,
	[174606] = 201875,
	[174607] = 201875,
	[174608] = 201871,
	[174682] = 199473,
	[174684] = 201871,
	[174686] = 201875,
	[174708] = 201877,
	[174709] = 201877,
	[174712] = 201873,
	[174713] = 201873,
	[174728] = 198168,
	[174848] = 203218,
	[175084] = 201020,
	[175165] = 196976,
	[175166] = 196976,
	[175207] = 201573,
	[175226] = 190548,
	[175227] = 201568,
	[175230] = 201573,
	[175233] = 201568,
	[175245] = 202443,
	[175264] = 202447,
	[175320] = 199473,
	[175324] = 190810,
	[175329] = 200401,
	[175330] = 200401,
	[175331] = 200401,
	[175334] = 196982,
	[175382] = 200953,
	[175384] = 202737,
	[175385] = 201080,
	[175407] = 199704,
	[175487] = 200640,
	[175488] = 200640,
	[175524] = 201845,
	[175565] = 198527,
	[175566] = 204103,
	[175586] = 197394,
	[175587] = 199103,
	[175606] = 198527,
	[175621] = 200638,
	[175629] = 198165,
	[175704] = 198452,
	[175708] = 199099,
	[175785] = 198455,
	[175802] = 197617,
	[175886] = 198986,
	[175888] = 191347,
	[175889] = 203777,
	[175891] = 191347,
	[175892] = 191347,
	[175893] = 191347,
	[175894] = 191107,
	[175924] = 197626,
	[175925] = 190617,
	[175926] = 198043,
	[175928] = 219267,
	[175944] = 200899,
	[175949] = 200640,
	[175950] = 200640,
	[175965] = 219399,
	[175966] = 198130,
	[175970] = 197864,
	[176089] = 198169,
	[176090] = 199671,
	[176091] = 198100,
	[176092] = 200960,
	[176112] = 196979,
	[176115] = 191094,
	[176116] = 203711,
	[176142] = 203712,
	[176143] = 203713,
	[176145] = 189538,
	[176150] = 200911,
	[176158] = 199138,
	[176159] = 199138,
	[176160] = 199138,
	[176161] = 199138,
	[176189] = 201475,
	[176190] = 201475,
	[176191] = 201475,
	[176192] = 200902,
	[176196] = 201475,
	[176197] = 201476,
	[176198] = 201476,
	[176206] = 200924,
	[176207] = 189680,
	[176208] = 190439,
	[176209] = 189687,
	[176213] = 203722,
	[176245] = 200900,
	[176249] = 197617,
	[176317] = 196982,
	[176325] = 203431,
	[176344] = 196976,
	[176356] = 200913,
	[176361] = 191217,
	[176392] = 191217,
	[176393] = 191217,
	[176484] = 198455,
	[176485] = 198455,
	[176486] = 198455,
	[176487] = 198455,
	[176544] = 198343,
	[176545] = 198343,
	[176581] = 202141,
	[176582] = 200938,
	[176630] = 198028,
	[176631] = 202952,
	[176634] = 196976,
	[176751] = 201598,
	[176785] = 200960,
	[176793] = 198389,
	[177240] = 189528,
	[177241] = 199744,
	[177243] = 190858,
	[177264] = 197961,
	[177287] = 203417,
	[177289] = 191217,
	[177464] = 201386,
	[177490] = 198168,
	[177491] = 201007,
	[177544] = 197617,
	[177624] = 200351,
	[177667] = 203400,
	[177675] = 189528,
	[177747] = 198046,
	[177750] = 189761,
	[177784] = 196998,
	[177786] = 196987,
	[177787] = 200910,
	[177789] = 198030,
	[177804] = 199671,
	[177805] = 199671,
	[177806] = 199671,
	[177904] = 191094,
	[177926] = 202297,
	[177929] = 202605,
	[177964] = 200024,
	[178084] = 197617,
	[178085] = 197644,
	[178087] = 189834,
	[178090] = 189528,
	[178104] = 202123,
	[178144] = 197063,
	[178145] = 201125,
	[178184] = 190804,
	[178185] = 190805,
	[178186] = 190806,
	[178195] = 190343,
	[178204] = 198168,
	[178227] = 200352,
	[178553] = 201279,
	[178609] = 196993,
	[179485] = 199580,
	[179499] = 200377,
	[179501] = 200961,
	[179516] = 196982,
	[179517] = 200953,
	[179544] = 199673,
	[179545] = 196976,
	[179547] = 198028,
	[179551] = 200953,
	[179552] = 203431,
	[179553] = 189214,
	[179559] = 201617,
	[179562] = 189687,
	[179564] = 200953,
	[179565] = 200953,
	[179644] = 202443,
	[179697] = 219372,
	[179703] = 199748,
	[179826] = 198451,
	[179827] = 199473,
	[179828] = 190895,
	[179832] = 190595,
	[179879] = 203892,
	[179880] = 219250,
	[179913] = 199475,
	[179914] = 200638,
	[179915] = 200638,
	[179922] = 198100,
	[180215] = 219550,
	[180229] = 190688,
	[180248] = 219404,
	[180366] = 197617,
	[180368] = 200640,
	[180369] = 219404,
	[180435] = 200442,
	[180436] = 202595,
	[180448] = 199475,
	[180453] = 202129,
	[180454] = 202130,
	[180455] = 202131,
	[180456] = 202456,
	[180461] = 202457,
	[180466] = 202458,
	[180501] = 202596,
	[180503] = 198020,
	[180526] = 201029,
	[180570] = 198006,
	[180633] = 201617,
	[180642] = 200963,
	[180652] = 204112,
	[180662] = 219411,
	[180665] = 198055,
	[180666] = 198055,
	[180667] = 198044,
	[180669] = 219411,
	[180682] = 219404,
	[180684] = 219406,
	[180685] = 219411,
	[180690] = 200952,
	[180691] = 200952,
	[180712] = 219407,
	[180717] = 202508,
	[180743] = 199604,
	[180746] = 199605,
	[180747] = 199606,
	[180748] = 199608,
	[180751] = 219411,
	[180793] = 199609,
	[180794] = 198032,
	[180901] = 219411,
	[181053] = 200351,
	[181073] = 198100,
	[181074] = 196976,
	[181083] = 196976,
	[181085] = 199636,
	[181098] = 204112,
	[181366] = 200953,
	[181597] = 200156,
	[181598] = 200154,
	[181672] = 199787,
	[181686] = 198339,
	[181687] = 198340,
	[190483] = 196976,
	[190484] = 196976,
	[201579] = 125452,
	[207724] = 219411,
	[375544] = 201094,
	[386675] = 196988,
	[386691] = 198017,
	[386759] = 198036,
	[386777] = 219372,
	[387466] = 196976,
	[387477] = 196976,
	[392029] = 196988,
	[397987] = 196982,
	[403041] = 200898,
	[403102] = 196987,
	[403105] = 202297,
	[403718] = 219436,
	[404352] = 196988,
	[404433] = 219372,
	[404695] = 196987,
	[404830] = 196988,
	[404911] = 196989,
	[404941] = 196988,
	[405149] = 200337,
	[405201] = 196989,
	[405628] = 196987,
	[405633] = 196976,
	[405879] = 198025,
	[405946] = 196988,
	[406006] = 198936,
	[406736] = 196987,
	[407117] = 199226,
	[407120] = 199452,
	[407247] = 219436,
	[407289] = 200276,
	[407291] = 200268,
	[407347] = 199989,
	[407352] = 197063,
	[407453] = 196979,
	[407454] = 197463,
	[407457] = 196982,
	[407505] = 199989,
	[407510] = 199989,
	[407566] = 198039,
	[407731] = 197621,
	[407734] = 196989,
	[407850] = 200953,
	[407918] = 197279,
	[407983] = 198056,
	[408004] = 201087,
	[408014] = 198039,
	[408718] = 196982,
	[408799] = 201452,
	[408802] = 189097,
	[409131] = 196988,
	[409289] = 201095,
	[409311] = 201649,
	[409496] = 198453,
	[409501] = 198036,
	[409562] = 198039,
	[409692] = 198453,
	[409700] = 198039,
	[409711] = 198452,
	[409717] = 198453,
	[409731] = 198453,
	[409735] = 198038,
	[409942] = 201662,
	[409949] = 201662,
	[410020] = 201662,
	[410299] = 198039,
	[410369] = 196989,
	[410528] = 196987,
	[410847] = 203020,
	[411348] = 200953,
	[411358] = 196987,
	[411674] = 198455,
	[411710] = 196976,
	[412224] = 201097,
	[414532] = 196989,
	[414624] = 204112,
	[414646] = 202430,
	[414658] = 189478,
	[414663] = 190354,
	[414713] = 196976,
	[415106] = 197145,
	[415107] = 197145,
	[415614] = 198455,
	[417072] = 200454,
	[418855] = 196976,
	[422483] = 201020,
	[422911] = 199713,
	[423569] = 200442,
	[423695] = 198036,
	[423703] = 203177,
	[424005] = 197641,
	[424006] = 203429,
	[424007] = 200296,
	[424010] = 200454,
	[424012] = 189528,
	[424074] = 197768,
	[424075] = 197768,
	[424076] = 197768,
	[424077] = 197768,
	[433596] = 196987,
	[439557] = 219463,
	[439558] = 219532,
	[439627] = 219469,
	[439628] = 219524,
	[439762] = 219483,
	[439778] = 219569,
	[439810] = 219486,
	[439815] = 190809,
	[441113] = 198021,
	[441114] = 196976,
	[441119] = 200964,
	[441124] = 200964,
	[441128] = 197150,
	[441129] = 198454,
	[441133] = 200964,
	[441140] = 196989,
	[441141] = 198719,
	[441222] = 219463,
	[441310] = 200964,
	[441312] = 198036,
	[441314] = 201113,
	[441848] = 189528,
	[441946] = 201267,
	[441947] = 201267,
	[441948] = 201267,
	[457088] = 198028,
	[457089] = 198028,
	[457090] = 198028,
	[457091] = 198028,
	[457092] = 198028,
	[457093] = 198028,
	[457094] = 198028,
	[457095] = 198028,
	[457096] = 198028,
	[457097] = 198028,
	[457098] = 198028,
	[457099] = 198028,
	[457100] = 198028,
	[457101] = 198028,
	[457102] = 198028,
	[461639] = 203177,
	[462233] = 219531,
	[462236] = 219372,
	[495500] = 199748,
	[495503] = 200953,
	[495505] = 200953,
	[495577] = 200953,
	[495578] = 200953,
	[100000001] = 201129,
}; _.ObjectModels = ObjectModels;

-- Phase Database Module
_.PhaseConstants = {
	ELITE_PVP_REQUIREMENT = 4,
	NEVER_IMPLEMENTED = 1,
	REAL_MONEY = 3,
	REMOVED_FROM_GAME = 2,
	UNLEARNABLE = 5,
};
local phases = {
	[1] = {
		name = "Never Implemented [NYI]",
		description = "|cFFFF0000This was never available to players.|r",
		state = 1,
	},
	[2] = {
		name = "Removed From Game",
		description = "|cFFFF0000This has been removed from the game.|r",
		state = 1,
	},
	[3] = {
		name = "Real Money",
		description = "|cFFAAFFAAThis Thing is locked behind a paywall which requires Blizzard Balance or Real Money.|r",
		lore = "|cFFFFAAAAThe act of encouraging the use of real money in any version of the game is widely frowned upon. Participate in this content at your own risk.|r",
		state = 3,
	},
	[4] = {
		name = "PvP Elite/Gladiator",
		description = "|cFFFFAAAAThis can no longer be purchased or unlocked as Transmog unless you have the required PvP Title, required PvP Rating or were in the Top % of that season.|r",
		state = 2,
	},
	[5] = {
		name = "Unlearnable",
		description = "|cFFFFAAAAThis cannot be permanently collected, learned or used for transmog.|r",
		state = 2,
	},
	[11] = {
		name = "Phase 1",
		description = "|cFFAAFFAAThis was not available until Phase 1 of WoW Classic.|r",
		lore = "|cFFFFAAAAIncluded Molten Core and Onyxia's Lair.|r",
		minimumBuildVersion = 1130100,
		buildVersion = 11301,
		state = 2,
	},
	[1605] = {
		name = "Season of Discovery",
		description = "|cFFAAFFAAThis was not available until Phase 1 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded the Blackfathom Deeps raid, Ashenvale World PvP, and had a level cap of 25.|r",
		minimumBuildVersion = 11500,
		buildVersion = 11500,
		state = 2,
	},
	[1606] = {
		name = "Phase 2",
		description = "|cFFAAFFAAThis was not available until Phase 2 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded the Gnomeregan raid, Stranglethorn Vale World PvP, and raised the level cap to 40.|r",
		minimumBuildVersion = 11500,
		buildVersion = 11501,
		state = 2,
	},
	[1607] = {
		name = "Phase 3",
		description = "|cFFAAFFAAThis was not available until Phase 3 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded the Sunken Temple raid and raised the level cap to 50.|r",
		minimumBuildVersion = 11500,
		buildVersion = 11502,
		state = 2,
	},
	[1608] = {
		name = "Phase 4",
		description = "|cFFAAFFAAThis was not available until Phase 4 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded Molten Core, Onyxia's Lair, Demon Fall Canyon, the Storm Cliffs, the Tainted Scar, and raised the level cap to 60.|r",
		minimumBuildVersion = 11500,
		buildVersion = 11503,
		state = 2,
	},
	[1609] = {
		name = "Phase 5",
		description = "|cFFAAFFAAThis was not available until Phase 5 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded Blackwing Lair, Zul'Gurub, and the new Crystal Vale raid.|r",
		minimumBuildVersion = 11500,
		buildVersion = 11504,
		state = 2,
	},
	[1610] = {
		name = "Phase 6",
		description = "|cFFAAFFAAThis was not available until Phase 6 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded Ahn'Qiraj, and the new Nightmare Grove raid|r",
		minimumBuildVersion = 11500,
		buildVersion = 11505,
		state = 2,
	},
	[1611] = {
		name = "Phase 7",
		description = "|cFFAAFFAAThis was not available until Phase 7 of Season of Discovery.|r",
		lore = "|cFFFFAAAAIncluded Naxxramas, and the new Karazhan Crypts dungeon|r",
		minimumBuildVersion = 11500,
		buildVersion = 11506,
		state = 2,
	},
};
L.PHASES = phases;

-- Achievement Data Module
local achievements = {
	[6] = {
		name = "Level 10",
		description = "Reach level 10.",
		icon = 236562,
		category = 92,
	},
	[7] = {
		name = "Level 20",
		description = "Reach level 20.",
		icon = 236563,
		category = 92,
	},
	[8] = {
		name = "Level 30",
		description = "Reach level 30.",
		icon = 236564,
		category = 92,
	},
	[9] = {
		name = "Level 40",
		description = "Reach level 40.",
		icon = 236565,
		category = 92,
	},
	[10] = {
		name = "Level 50",
		description = "Reach level 50.",
		icon = 236566,
		category = 92,
	},
	[11] = {
		name = "Level 60",
		description = "Reach level 60.",
		icon = 236567,
		category = 92,
	},
	[42] = {
		name = "Explore Eastern Kingdoms",
		description = "Explore the regions of Eastern Kingdoms.",
		icon = 236759,
		category = 97,
	},
	[43] = {
		name = "Explore Kalimdor",
		description = "Explore the regions of Kalimdor.",
		icon = 236807,
		category = 97,
	},
	[121] = {
		name = "Journeyman Cook",
		description = "Become a Journeyman Cook.",
		icon = 133971,
		category = 170,
	},
	[122] = {
		name = "Expert Cook",
		description = "Become an Expert Cook.",
		icon = 133971,
		category = 170,
	},
	[123] = {
		name = "Artisan Cook",
		description = "Become an Artisan Cook.",
		icon = 133971,
		category = 170,
	},
	[126] = {
		name = "Journeyman Fisherman",
		description = "Become a Journeyman Fisherman.",
		icon = 136245,
		category = 171,
	},
	[127] = {
		name = "Expert Fisherman",
		description = "Become an Expert Fisherman.",
		icon = 136245,
		category = 171,
	},
	[128] = {
		name = "Artisan Fisherman",
		description = "Become an Artisan Fisherman.",
		icon = 136245,
		category = 171,
	},
	[131] = {
		name = "Journeyman in First Aid",
		description = "Become a Journeyman in first aid.",
		icon = 135966,
		category = 172,
	},
	[132] = {
		name = "Expert in First Aid",
		description = "Become an Expert in first aid.",
		icon = 135966,
		category = 172,
	},
	[133] = {
		name = "Artisan in First Aid",
		description = "Become an Artisan in first aid.",
		icon = 135966,
		category = 172,
	},
	[238] = {
		name = "An Honorable Kill",
		description = "Achieve an honorable kill.",
		icon = 236647,
		category = 95,
	},
	[239] = {
		name = "25000 Honorable Kills",
		description = "Get 25000 honorable kills.",
		icon = 236657,
		category = 95,
	},
	[306] = {
		name = "Master Angler of Azeroth",
		description = "Win the Booty Bay fishing contest or the Kalu'ak Fishing Derby.",
		icon = 133892,
		category = 171,
	},
	[389] = {
		name = "Gurubashi Arena Master",
		description = "Loot the Arena Master trinket from the Gurubashi Arena.",
		icon = 133608,
		category = 95,
	},
	[396] = {
		name = "Gurubashi Arena Grand Master",
		description = "Complete Short John Mithril's quest to obtain the Arena Grand Master trinket.",
		icon = 133599,
		category = 95,
	},
	[416] = {
		name = "Scarab Lord",
		description = "Opened the gates of Ahn'Qiraj.",
		icon = 236829,
		category = 81,
	},
	[424] = {
		name = "Why? Because It's Red",
		description = "Obtain a Red Qiraji Resonating Crystal.",
		icon = 134396,
		category = 81,
	},
	[425] = {
		name = "Atiesh, Greatstaff of the Guardian",
		description = "Wielder of Atiesh, Greatstaff of the Guardian.",
		icon = 135226,
		category = 81,
	},
	[428] = {
		name = "Thunderfury, Blessed Blade of the Windseeker",
		description = "Wielder of Thunderfury, Blessed Blade of the Windseeker.",
		icon = 135349,
		category = 81,
	},
	[429] = {
		name = "Sulfuras, Hand of Ragnaros",
		description = "Wielder of Sulfuras, Hand of Ragnaros.",
		icon = 133066,
		category = 81,
	},
	[509] = {
		name = "10000 Honorable Kills",
		description = "Get 10000 honorable kills.",
		icon = 236655,
		category = 95,
	},
	[512] = {
		name = "5000 Honorable Kills",
		description = "Get 5000 honorable kills.",
		icon = 236652,
		category = 95,
	},
	[513] = {
		name = "100 Honorable Kills",
		description = "Get 100 honorable kills.",
		icon = 236648,
		category = 95,
	},
	[515] = {
		name = "500 Honorable Kills",
		description = "Get 500 honorable kills.",
		icon = 236649,
		category = 95,
	},
	[516] = {
		name = "1000 Honorable Kills",
		description = "Get 1000 honorable kills.",
		icon = 236650,
		category = 95,
	},
	[520] = {
		name = "20 Exalted Reputations",
		description = "Raise 20 reputations to Exalted.",
		icon = 236684,
		category = 201,
	},
	[521] = {
		name = "15 Exalted Reputations",
		description = "Raise 15 reputations to Exalted.",
		icon = 236683,
		category = 201,
	},
	[522] = {
		name = "Somebody Likes Me",
		description = "Raise a reputation to Exalted.",
		icon = 236681,
		category = 201,
	},
	[523] = {
		name = "5 Exalted Reputations",
		description = "Raise 5 reputations to Exalted.",
		icon = 236681,
		category = 201,
	},
	[524] = {
		name = "10 Exalted Reputations",
		description = "Raise 10 reputations to Exalted.",
		icon = 236682,
		category = 201,
	},
	[546] = {
		name = "Safe Deposit",
		description = "Buy 7 additional bank slots.",
		icon = 132594,
		category = 92,
	},
	[627] = {
		name = "Explore Dun Morogh",
		description = "Explore Dun Morogh, revealing the covered areas of the world map.",
		icon = 236755,
		category = 14777,
	},
	[628] = {
		name = "Deadmines",
		description = "Defeat Edwin VanCleef.",
		icon = 236409,
		category = 14808,
	},
	[629] = {
		name = "Ragefire Chasm",
		description = "Defeat Taragaman the Hungerer.",
		icon = 136216,
		category = 14808,
	},
	[630] = {
		name = "Wailing Caverns",
		description = "Defeat Mutanus the Devourer.",
		icon = 236425,
		category = 14808,
	},
	[631] = {
		name = "Shadowfang Keep",
		description = "Defeat Archmage Arugal.",
		icon = 254646,
		category = 14808,
	},
	[633] = {
		name = "Stormwind Stockade",
		description = "Defeat Bazil Thredd.",
		icon = 236404,
		category = 14808,
	},
	[634] = {
		name = "Gnomeregan",
		description = "Defeat Mekgineer Thermaplugg.",
		icon = 236424,
		category = 14808,
	},
	[635] = {
		name = "Razorfen Kraul",
		description = "Defeat Charlga Razorflank.",
		icon = 236405,
		category = 14808,
	},
	[636] = {
		name = "Razorfen Downs",
		description = "Defeat Amnennar the Coldbringer.",
		icon = 236400,
		category = 14808,
	},
	[638] = {
		name = "Uldaman",
		description = "Defeat Archaedas.",
		icon = 236401,
		category = 14808,
	},
	[640] = {
		name = "Maraudon",
		description = "Defeat Princess Theradras.",
		icon = 236432,
		category = 14808,
	},
	[641] = {
		name = "Sunken Temple",
		description = "Defeat Shade of Eranikus.",
		icon = 236434,
		category = 14808,
	},
	[642] = {
		name = "Blackrock Depths",
		description = "Defeat Emperor Dagran Thaurissan.",
		icon = 236410,
		category = 14808,
	},
	[643] = {
		name = "Lower Blackrock Spire",
		description = "Defeat Overlord Wyrmthalak.",
		icon = 236429,
		category = 14808,
	},
	[646] = {
		name = "Stratholme",
		description = "Defeat the evil masterminds inhabiting Stratholme.",
		icon = 237511,
		category = 14808,
	},
	[684] = {
		name = "Onyxia's Lair (Level 60)",
		description = "Defeat the classic, level 60 version of Onyxia.",
		icon = 254650,
		category = 81,
	},
	[685] = {
		name = "Blackwing Lair",
		description = "Defeat Nefarian.",
		icon = 254649,
		category = 14808,
	},
	[686] = {
		name = "Molten Core",
		description = "Defeat Ragnaros.",
		icon = 254652,
		category = 14808,
	},
	[687] = {
		name = "Temple of Ahn'Qiraj",
		description = "Defeat C'Thun.",
		icon = 236407,
		category = 14808,
	},
	[688] = {
		name = "Zul'Gurub",
		description = "Defeat Hakkar.",
		icon = 236413,
		category = 14808,
	},
	[689] = {
		name = "Ruins of Ahn'Qiraj",
		description = "Defeat Ossirian the Unscarred.",
		icon = 236428,
		category = 14808,
	},
	[706] = {
		name = "Frostwolf Howler",
		description = "Obtain a Frostwolf Howler.",
		icon = 133283,
		category = 14801,
	},
	[707] = {
		name = "Stormpike Battle Charger",
		description = "Obtain a Stormpike Battle Charger.",
		icon = 133429,
		category = 14801,
	},
	[708] = {
		name = "Hero of the Frostwolf Clan",
		description = "Gain exalted reputation with the Frostwolf Clan.",
		icon = 133287,
		category = 14801,
	},
	[709] = {
		name = "Hero of the Stormpike Guard",
		description = "Gain exalted reputation with the Stormpike Guard.",
		icon = 133433,
		category = 14801,
	},
	[710] = {
		name = "The Defiler",
		description = "Gain exalted reputation with The Forsaken Defilers.",
		icon = 237568,
		category = 14802,
	},
	[711] = {
		name = "Knight of Arathor",
		description = "Gain exalted reputation with The League of Arathor.",
		icon = 132351,
		category = 14802,
	},
	[712] = {
		name = "Warsong Outrider",
		description = "Gain exalted reputation with the Warsong Outriders.",
		icon = 132366,
		category = 14804,
	},
	[713] = {
		name = "Silverwing Sentinel",
		description = "Gain exalted reputation with the Silverwing Sentinels.",
		icon = 132279,
		category = 14804,
	},
	[714] = {
		name = "The Conqueror",
		description = "Raise your reputation values in Warsong Gulch, Arathi Basin and Alterac Valley to Exalted.",
		icon = 134475,
		category = 95,
	},
	[727] = {
		name = "Call in the Cavalry",
		description = "Obtain one of the war mounts through the honor system.",
		icon = 132224,
		category = 95,
	},
	[728] = {
		name = "Explore Durotar",
		description = "Explore Durotar, revealing the covered areas of the world map.",
		icon = 236756,
		category = 14778,
	},
	[729] = {
		name = "Deathcharger's Reins",
		description = "Obtain the Deathcharger's Reins from Baron Rivendare in Stratholme.",
		icon = 132264,
		category = 81,
	},
	[736] = {
		name = "Explore Mulgore",
		description = "Explore Mulgore, revealing the covered areas of the world map.",
		icon = 236809,
		category = 14778,
	},
	[750] = {
		name = "Explore The Barrens",
		description = "Explore The Barrens, revealing the covered areas of the world map.",
		icon = 236717,
		category = 14778,
	},
	[760] = {
		name = "Explore Alterac Mountains",
		description = "Explore Alterac Mountains, revealing the covered areas of the world map.",
		icon = 236711,
		category = 14777,
	},
	[761] = {
		name = "Explore Arathi Highlands",
		description = "Explore Arathi Highlands, revealing the covered areas of the world map.",
		icon = 236712,
		category = 14777,
	},
	[765] = {
		name = "Explore Badlands",
		description = "Explore Badlands, revealing the covered areas of the world map.",
		icon = 236716,
		category = 14777,
	},
	[766] = {
		name = "Explore Blasted Lands",
		description = "Explore Blasted Lands, revealing the covered areas of the world map.",
		icon = 236720,
		category = 14777,
	},
	[768] = {
		name = "Explore Tirisfal Glades",
		description = "Explore Tirisfal Glades, revealing the covered areas of the world map.",
		icon = 236849,
		category = 14777,
	},
	[769] = {
		name = "Explore Silverpine Forest",
		description = "Explore Silverpine Forest, revealing the covered areas of the world map.",
		icon = 236830,
		category = 14777,
	},
	[770] = {
		name = "Explore Western Plaguelands",
		description = "Explore Western Plaguelands, revealing the covered areas of the world map.",
		icon = 236851,
		category = 14777,
	},
	[771] = {
		name = "Explore Eastern Plaguelands",
		description = "Explore Eastern Plaguelands, revealing the covered areas of the world map.",
		icon = 236760,
		category = 14777,
	},
	[772] = {
		name = "Explore Hillsbrad Foothills",
		description = "Explore Hillsbrad Foothills, revealing the covered areas of the world map.",
		icon = 236779,
		category = 14777,
	},
	[773] = {
		name = "Explore The Hinterlands",
		description = "Explore The Hinterlands, revealing the covered areas of the world map.",
		icon = 236780,
		category = 14777,
	},
	[774] = {
		name = "Explore Searing Gorge",
		description = "Explore Searing Gorge, revealing the covered areas of the world map.",
		icon = 236815,
		category = 14777,
	},
	[775] = {
		name = "Explore Burning Steppes",
		description = "Explore Burning Steppes, revealing the covered areas of the world map.",
		icon = 236734,
		category = 14777,
	},
	[776] = {
		name = "Explore Elwynn Forest",
		description = "Explore Elwynn Forest, revealing the covered areas of the world map.",
		icon = 236761,
		category = 14777,
	},
	[777] = {
		name = "Explore Deadwind Pass",
		description = "Explore Deadwind Pass, revealing the covered areas of the world map.",
		icon = 236741,
		category = 14777,
	},
	[778] = {
		name = "Explore Duskwood",
		description = "Explore Duskwood, revealing the covered areas of the world map.",
		icon = 236757,
		category = 14777,
	},
	[779] = {
		name = "Explore Loch Modan",
		description = "Explore Loch Modan, revealing the covered areas of the world map.",
		icon = 236808,
		category = 14777,
	},
	[780] = {
		name = "Explore Redridge Mountains",
		description = "Explore Redridge Mountains, revealing the covered areas of the world map.",
		icon = 236814,
		category = 14777,
	},
	[781] = {
		name = "Explore Stranglethorn Vale",
		description = "Explore Stranglethorn Vale, revealing the covered areas of the world map.",
		icon = 236844,
		category = 14777,
	},
	[782] = {
		name = "Explore Swamp of Sorrows",
		description = "Explore Swamp of Sorrows, revealing the covered areas of the world map.",
		icon = 236845,
		category = 14777,
	},
	[802] = {
		name = "Explore Westfall",
		description = "Explore Westfall, revealing the covered areas of the world map.",
		icon = 236852,
		category = 14777,
	},
	[841] = {
		name = "Explore Wetlands",
		description = "Explore Wetlands, revealing the covered areas of the world map.",
		icon = 236853,
		category = 14777,
	},
	[842] = {
		name = "Explore Teldrassil",
		description = "Explore Teldrassil, revealing the covered areas of the world map.",
		icon = 236740,
		category = 14778,
	},
	[844] = {
		name = "Explore Darkshore",
		description = "Explore Darkshore, revealing the covered areas of the world map.",
		icon = 236739,
		category = 14778,
	},
	[845] = {
		name = "Explore Ashenvale",
		description = "Explore Ashenvale, revealing the covered areas of the world map.",
		icon = 236713,
		category = 14778,
	},
	[846] = {
		name = "Explore Thousand Needles",
		description = "Explore Thousand Needles, revealing the covered areas of the world map.",
		icon = 236848,
		category = 14778,
	},
	[847] = {
		name = "Explore Stonetalon Mountains",
		description = "Explore Stonetalon Mountains, revealing the covered areas of the world map.",
		icon = 236831,
		category = 14778,
	},
	[848] = {
		name = "Explore Desolace",
		description = "Explore Desolace, revealing the covered areas of the world map.",
		icon = 236742,
		category = 14778,
	},
	[849] = {
		name = "Explore Feralas",
		description = "Explore Feralas, revealing the covered areas of the world map.",
		icon = 236764,
		category = 14778,
	},
	[850] = {
		name = "Explore Dustwallow Marsh",
		description = "Explore Dustwallow Marsh, revealing the covered areas of the world map.",
		icon = 236758,
		category = 14778,
	},
	[851] = {
		name = "Explore Tanaris Desert",
		description = "Explore Tanaris Desert, revealing the covered areas of the world map.",
		icon = 236846,
		category = 14778,
	},
	[852] = {
		name = "Explore Azshara",
		description = "Explore Azshara, revealing the covered areas of the world map.",
		icon = 236714,
		category = 14778,
	},
	[853] = {
		name = "Explore Felwood",
		description = "Explore Felwood, revealing the covered areas of the world map.",
		icon = 236763,
		category = 14778,
	},
	[854] = {
		name = "Explore Un'Goro Crater",
		description = "Explore Un'Goro Crater, revealing the covered areas of the world map.",
		icon = 236850,
		category = 14778,
	},
	[855] = {
		name = "Explore Moonglade",
		description = "Explore Moonglade, revealing the covered areas of the world map.",
		icon = 135758,
		category = 14778,
	},
	[856] = {
		name = "Explore Silithus",
		description = "Explore Silithus, revealing the covered areas of the world map.",
		icon = 236829,
		category = 14778,
	},
	[857] = {
		name = "Explore Winterspring",
		description = "Explore Winterspring, revealing the covered areas of the world map.",
		icon = 236854,
		category = 14778,
	},
	[871] = {
		name = "Avast Ye, Admiral!",
		description = "Obtain the Bloodsail Admiral's Hat... and try to get some fresh air every now and then.",
		icon = 133168,
		category = 81,
	},
	[879] = {
		name = "Old School Ride",
		description = "Owner of one of the original epic mounts that are no longer attainable.",
		icon = 132248,
		category = 81,
	},
	[880] = {
		name = "Swift Zulian Tiger",
		description = "Obtain the Swift Zulian Tiger from High Priest Thekal in Zul'Gurub.",
		icon = 132242,
		category = 81,
	},
	[881] = {
		name = "Swift Razzashi Raptor",
		description = "Obtain the Swift Razzashi Raptor from Bloodlord Mandokir in Zul'Gurub.",
		icon = 132253,
		category = 81,
	},
	[891] = {
		name = "Giddy Up!",
		description = "Learn the apprentice riding skill.",
		icon = 132261,
		category = 92,
	},
	[907] = {
		name = "The Justicar",
		description = "Raise your reputation values in Warsong Gulch, Arathi Basin and Alterac Valley to Exalted.",
		icon = 134474,
		category = 95,
	},
	[940] = {
		name = "The Green Hills of Stranglethorn",
		description = "Complete all of Hemet Nesingwary quests in Stranglethorn Vale up to and including The Green Hills of Stranglethorn and Big Game Hunter.",
		icon = 132267,
		category = 14861,
	},
	[944] = {
		name = "They Love Me In That Tunnel",
		description = "Earn exalted status with Timbermaw Hold.",
		icon = 236696,
		category = 14864,
	},
	[946] = {
		name = "The Argent Dawn",
		description = "Earn exalted status with the Argent Dawn.",
		icon = 133440,
		category = 14864,
	},
	[955] = {
		name = "Hydraxian Waterlords",
		description = "Earn exalted status with the Hydraxian Waterlords.",
		icon = 135862,
		category = 14864,
	},
	[956] = {
		name = "Brood of Nozdormu",
		description = "Earn exalted status with the Brood of Nozdormu.",
		icon = 134156,
		category = 14864,
	},
	[957] = {
		name = "Hero of the Zandalar Tribe",
		description = "Earn exalted status with the Zandalar Tribe.",
		icon = 132529,
		category = 14864,
	},
	[1307] = {
		name = "Upper Blackrock Spire",
		description = "Defeat General Drakkisath.",
		icon = 254648,
		category = 14808,
	},
	[1676] = {
		name = "Loremaster of Eastern Kingdoms",
		description = "Complete 700 quests in Eastern Kingdoms.",
		icon = 236759,
		category = 14861,
	},
	[1677] = {
		name = "Loremaster of Eastern Kingdoms",
		description = "Complete 550 quests in Eastern Kingdoms.",
		icon = 236759,
		category = 14861,
	},
	[1678] = {
		name = "Loremaster of Kalimdor",
		description = "Complete 700 quests in Kalimdor.",
		icon = 236807,
		category = 14861,
	},
	[1680] = {
		name = "Loremaster of Kalimdor",
		description = "Complete 685 quests in Kalimdor.",
		icon = 236807,
		category = 14861,
	},
	[2116] = {
		name = "Tabard of the Argent Dawn",
		description = "Obtained a Tabard of the Argent Dawn from the Scourge Invasion event.",
		icon = 135026,
		category = 81,
	},
	[2141] = {
		name = "Stable Keeper",
		description = "Obtain 10 mounts.",
		icon = 132254,
		category = 92,
	},
	[2142] = {
		name = "Filling Up The Barn",
		description = "Obtain 25 mounts.",
		icon = 132259,
		category = 92,
	},
	[2336] = {
		name = "Insane in the Membrane",
		description = "Raise your reputation to Honored with the Bloodsail Buccaneers, and Exalted with Booty Bay, Everlook, Gadgetzan, Ratchet, Darkmoon Faire, Ravenholdt, and Shen'dralar.",
		icon = 236206,
		category = 81,
	},
	[2357] = {
		name = "Dreadsteed of Xoroth",
		description = "Completed the Dreadsteed of Xoroth warlock quest.",
		icon = 132238,
		category = 81,
	},
	[2358] = {
		name = "Charger",
		description = "Completed the paladin quest to obtain a Charger.",
		icon = 132226,
		category = 81,
	},
	[2496] = {
		name = "The Fifth Element",
		description = "Obtain an Aqual Quintessence.",
		icon = 135862,
		category = 81,
	},
	[3356] = {
		name = "Winterspring Frostsaber",
		description = "Obtain a Winterspring Frosaber.",
		icon = 132252,
		category = 81,
	},
	[5788] = {
		name = "Agent of the Shen'dralar",
		description = "Earn exalted status with the Shen'dralar.",
		icon = 133736,
		category = 81,
	},
	[16433] = {
		name = "Soul of Iron (Season of Mastery)",
		description = "Reach level 60 without ever dying during the Season of Mastery.",
		icon = 134902,
		category = 81,
	},
};
L.ACHIEVEMENT_DATA = achievements;

local achievementCategories = {
	[81] = {
		name = "Feats of Strength",
		parent = -1,
	},
	[92] = {
		name = "General",
		parent = -1,
	},
	[95] = {
		name = "Player vs. Player",
		parent = -1,
	},
	[96] = {
		name = "Quests",
		parent = -1,
	},
	[97] = {
		name = "Exploration",
		parent = -1,
	},
	[168] = {
		name = "Dungeons & Raids",
		parent = -1,
	},
	[169] = {
		name = "Professions",
		parent = -1,
	},
	[170] = {
		name = "Cooking",
		parent = 169,
	},
	[171] = {
		name = "Fishing",
		parent = 169,
	},
	[172] = {
		name = "First Aid",
		parent = 169,
	},
	[201] = {
		name = "Reputation",
		parent = -1,
	},
	[14777] = {
		name = "Eastern Kingdoms",
		parent = 97,
	},
	[14778] = {
		name = "Kalimdor",
		parent = 97,
	},
	[14801] = {
		name = "Alterac Valley",
		parent = 95,
	},
	[14802] = {
		name = "Arathi Basin",
		parent = 95,
	},
	[14804] = {
		name = "Warsong Gulch",
		parent = 95,
	},
	[14808] = {
		name = "Classic",
		parent = 168,
	},
	[14861] = {
		name = "Classic",
		parent = 96,
	},
	[14864] = {
		name = "Classic",
		parent = 201,
	},
};
L.ACHIEVEMENT_CATEGORY_DATA = achievementCategories;

-- Supported Locales
local simplifiedLocale = GetLocale():sub(1,2);
if simplifiedLocale == "de" then
localize(L.HEADER_NAMES, {
	[-1000010] = "Gemeinsame Bossbeute",
	[-1000015] = "Dämonenausbilderin",
	[-1000019] = "Erkundung",
	[-1000025] = "Feiertage",
	[-1000034] = "Reitlehrerin",
	[-1000040] = "Waffenmeisterin",
	[-1000048] = "Drachen des Alptraums",
	[-1000162] = "Geteilte Vorlagen",
	[-1000163] = "Einzigartige Vorlagen",
	[-1000168] = "Die Vier Reiter",
	[-1000179] = "Friedhof",
	[-1000180] = "Bibliothek",
	[-1000181] = "Waffenkammer",
	[-1000182] = "Kathedrale",
	[-1000191] = "Besiege einen Leutnant",
	[-1000192] = "Gewinne den Kampf",
	[-1000193] = "Sprich mit den Toten",
	[-1000195] = "Sprich mit Grizzby",
	[-1000196] = "Sprich mit N'ora",
	[-1000198] = "Sprich mit Bruder Romulus",
	[-1000201] = "Dunkelmond-Jahrmarkt",
	[-1000223] = "Sonnenwendfest",
	[-1000227] = "Anglerwettbewerb im Schlingendorntal",
	[-1000235] = "Die Öffnung des Dunklen Portals",
	[-1000236] = "Das Szepter der Sandstürme",
	[-1000273] = "Saison der Entdeckungen",
	[-1000274] = "Verständnis",
	[-1000275] = "Stufe 1",
	[-1000276] = "Stufe 2",
	[-1000277] = "Monsterjagd",
	[-1000278] = "Runenschnitzen",
	[-1000279] = "Weggelegte Vorräte",
	[-1000373] = "Neuer Charakter",
	[-1000376] = "Gewaltige Schlägerei",
	[-1000377] = "Wilder Polymorph",
	[-1000378] = "Seelenvermittler",
	[-1000380] = "Kopfgeld",
	[-1000970] = "Stufe 3",
	[-1001035] = "Saisonfisch: Sommerbarsch",
	[-1001036] = "Saisonfisch: Winterkalmar",
	[-1001058] = "Alptraumhain",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000025] = "Es muss möglicherweise ein bestimmter Feiertag aktiv sein, um hier genannte Dinge abschließen zu können.",
	[-1000040] = "Ein Waffenmeister ist ein NPC, der Charakteren die Möglichkeit bietet, bestimmte Waffenfertigkeiten zu erlernen, deren Verfügbarkeit von Waffenmeister zu Waffenmeister unterschiedlich ist. Alle Waffenfähigkeiten können auf Stufe 1 trainiert werden, mit Ausnahme von Stangenwaffen, für die Stufe 20 erforderlich ist.\n\nDas Training mit einem Waffenmeister wurde in Patch 4.0.1 obsolet, da nun alle klassengerechten Waffenfertigkeiten von jeder Klasse bei der Erstellung erlernt werden. Waffenmeister wurden kurz darauf aus dem Spiel entfernt.",
	[-1000162] = "Die Gegenstände in dieser Liste teilen ihre Vorlage mit dem oben genannten Gegenstand. Im Modus für Einzigartige Vorlagen kann diese Liste Ihnen helfen zu verstehen, warum ein bestimmter Gegenstand als gesammelt markiert ist, oder ob nicht.",
	[-1000163] = "Dieser Gegenstand hat eine einzigartige Vorlage. Ihr müsst diesen Gegenstand erhalten, um die Vorlage eurer Sammlung hinzuzufügen.",
	[-1000273] = "Diese Saison bringt eine anfängliche Levelobergrenze von 25 und ein neues Level-25-Endspiel, einschließlich eines Blackfathom Deeps-Raids für 10 Spieler mit neuen Mechaniken, neuen und neu gestalteten Bossen, die die Taktiken und Strategien der Spieler herausfordern, und neuen Belohnungen.",
	[-1000278] = "Runengravur ist ein neues System, das kürzlich für Season of Discovery angekündigt wurde. Es ermöglicht jeder Klasse, ihr Spielerlebnis individuell anzupassen, indem sie neue einzigartige Fähigkeiten freischaltet!",
	[-1000279] = "Questgegenstände für „Weggelegte Vorräte“ fallen von Mobs der Stufe 6 und höher in ganz Azeroth. Diese Quests erfordern die Lieferung der Waylaid-Vorräte an einen Vertreter der Organisation als Gegenleistung für ein paar Silbermünzen, Erfahrung und Ansehen. Natürlich fehlen in der Versorgungslieferung Gegenstände, und Sie können sie ergänzen, um höhere Reputationsbelohnungen zu erhalten.",
	[-1000376] = "Nur die Person, die den letzten Treffer beim Betrunkenen erzielt, erhält Anerkennung, unabhängig davon, wer zuerst auf das Ziel getippt hat. Hierfür gibt es keine Gruppengutschrift.",
	[-1000377] = "Wirke „Polymorph“ auf Lebewesen, die von „Wilder Polymorph“ betroffen sind, um sie wieder in Lehrlinge zu verwandeln. Jeder wird Ihnen eine Notiz geben. Sammle 6 Notizen, um die Rune zu lernen.",
	[-1000380] = "Diese Liste enthält nicht erhältliche Gegenstände, die von ATT Discord als Fehler gemeldet wurden, die Blizzard noch beheben muss.\n\nHINWEIS: Alle Filter werden aus Sichtbarkeitsgründen in dieser Liste ignoriert. In dieser Liste sind nur Gegenstände enthalten, die aufgrund von Fahrlässigkeit aus dem Spiel entfernt wurden, und nicht ein riesiger feuerspeiender Drache.\n\nAn Blizzard-Entwickler: Bitte beheben Sie die unten aufgeführten Gegenstände und Begegnungen.",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "Artefakte",
});
localize(ObjectNames, {
	[31] = "Alte Löwenstatue",
	[32] = "Versunkene Truhe",
	[33] = "Verschlossene Truhe",
	[34] = "Alter Henkelkrug",
	[35] = "Schließkiste des Kapitäns",
	[36] = "Zerbrochenes Fass",
	[47] = "GESUCHT:",
	[52] = "Gurubashis Untergang",
	[54] = "Das Grabmal des Imperators",
	[55] = "Ein halb aufgefressener Körper",
	[56] = "Rolfs Leichnam",
	[57] = "Mond über dem Tal",
	[58] = "Gri’lek der Wanderer",
	[59] = "Ein Haufen lockere Erde",
	[60] = "GESUCHT: Gath'Ilzogg",
	[61] = "Ein verwittertes Grab",
	[68] = "Steckbrief",
	[76] = "Ein leerer Krug",
	[119] = "Calvinius' Kiste",
	[256] = "GESUCHT",
	[257] = "Verdächtiges Fass",
	[259] = "Halb vergrabenes Fass",
	[261] = "Beschädigte Kiste",
	[263] = "Kurzens Vorräte",
	[264] = "Kurzens Vorräte",
	[269] = "Bewachtes Fass mit Donnerbräu Lager",
	[270] = "Unbewachtes Fass mit Donnerbräu Lager",
	[271] = "Kisten der Minenarbeiterliga",
	[272] = "MacGranns Fleisch-Spind",
	[276] = "Schimmerkrautkorb",
	[287] = "Buchmacher Herods Aufzeichnungen",
	[288] = "Buchmacher Herods Geldkassette",
	[290] = "Furlbrows Kleiderschrank",
	[321] = "Tilloaträne",
	[331] = "Lockere Erde",
	[333] = "Uraltes Relikt",
	[334] = "Uraltes Relikt",
	[375] = "Tirisfalkürbis",
	[711] = "GESUCHT!",
	[759] = "Der Heilige Quell",
	[1166] = "Alexstons Truhe",
	[1557] = "Lilliths Esstisch",
	[1560] = "Aufbewahrungstruhe",
	[1561] = "Versiegelte Kiste",
	[1562] = "Truhe von Marshal Haggard",
	[1571] = "Staubige Zauberbücher",
	[1585] = "Sprengladung",
	[1586] = "Kiste mit Kerzen",
	[1593] = "Boot mit Leichen",
	[1594] = "Berards Bücherregal",
	[1599] = "Flaches Grab",
	[1609] = "Katapult des Drachenmals",
	[1610] = "Pyrophor-Mineralvorkommen",
	[1627] = "Kiste aus Dalaran",
	[1673] = "Teufelszapfen",
	[1721] = "Verschlossene Kugel und Kette",
	[1722] = "Verschlossene Kugel und Kette",
	[1723] = "Morastschnauzenkappe",
	[1727] = "Fässchen Shindigger-Starkbier",
	[1728] = "Staubiger Teppich",
	[1736] = "Eisenlieferung",
	[1738] = "Dokumente des Syndikats",
	[1739] = "Dokumente des Syndikats",
	[1740] = "Dokumente des Syndikats",
	[1759] = "Stadtverzeichnis von Hillsbrad",
	[1760] = "Verwitterter Bücherschrank",
	[1761] = "Proklamation des Hügellands",
	[1763] = "GESUCHT",
	[1765] = "Abgenutzte Holztruhe",
	[1768] = "Flamme von Azel",
	[1769] = "Flamme von Veraz",
	[1770] = "Flamme von Uzel",
	[2008] = "Gefährlich!",
	[2059] = "Eine Zwergenleiche",
	[2068] = "Pupellyverbos-Portwein",
	[2076] = "Blubbernder Kessel",
	[2083] = "Blutsegelkorrespondenz",
	[2084] = "Bisamwurzel",
	[2086] = "Blutsegelkarten",
	[2087] = "Blutsegelbefehle",
	[2289] = "Unbrauchbares Rettungsboot",
	[2553] = "Eine glitschige Rolle",
	[2554] = "Cortellos Rätsel",
	[2555] = "Modrige Rolle",
	[2560] = "Halb vergrabene Flasche",
	[2576] = "Altar der Gezeiten",
	[2652] = "Ebenezer Rostlockes Leichnam",
	[2656] = "Durchnässter Brief",
	[2688] = "Schlüsselstein",
	[2689] = "Stein der Westlichen Bindung",
	[2690] = "Stein der Äußeren Bindung",
	[2691] = "Stein der Östlichen Bindung",
	[2701] = "Regenbogenfarbene Splitter",
	[2702] = "Stein der Inneren Bindung",
	[2704] = "Sprengstofflager",
	[2707] = "Karten der TOLLEN MINNA",
	[2708] = "Karten der SILBERGEIST",
	[2709] = "Logbuch der TOLLEN MINNA",
	[2710] = "Logbuch der SILBERGEIST",
	[2712] = "Verkalkter Elfenedelstein",
	[2713] = "Steckbriefbrett",
	[2714] = "Alteracgranit",
	[2716] = "Trelanes Truhe",
	[2717] = "Trelanes Schließkiste",
	[2718] = "Trelanes Schließkassette",
	[2724] = "Sack Hafer",
	[2734] = "Vollgelaufene Truhe",
	[2739] = "Truhe der schwarzen Feder",
	[2740] = "Truhe der Rabenkralle",
	[2741] = "Truhe des Himmels",
	[2742] = "Truhe des Nistens",
	[2743] = "Verzierte Steinurne",
	[2744] = "Riesenmuschel",
	[2842] = "Diamantsäule",
	[2848] = "Opalsäule",
	[2858] = "Amethystsäule",
	[2867] = "Ausgrabungsgrundbedarfskiste",
	[2868] = "Zerknitterte Karte",
	[2875] = "Ramponiertes Zwergenskelett",
	[2891] = "Balia’mah-Trophäenschädel",
	[2892] = "Ziata’jai-Trophäenschädel",
	[2893] = "Zul’Mamwe-Trophäenschädel",
	[2907] = "Wasserkanne",
	[2908] = "Versiegelte Vorratskiste",
	[2910] = "Quellstein",
	[2912] = "Bernsteinkorn",
	[2933] = "Siegel der Erde",
	[3076] = "Schmutzbefleckte Karte",
	[3189] = "Angriffsplan: Tal der Prüfungen",
	[3190] = "Angriffsplan: Sen'jin",
	[3192] = "Angriffsplan: Orgrimmar",
	[3236] = "Gnomenwerkzeugkasten",
	[3237] = "Eingekerkerter Dunkelspeertroll",
	[3238] = "Chens leeres Fässchen",
	[3239] = "Benedicts Truhe",
	[3240] = "Schwanzpeitschereier",
	[3290] = "Gestohlener Vorratssack",
	[3525] = "Der Altar des Feuers",
	[3640] = "Potenter Pilz",
	[3642] = "Kolkars Beute",
	[3643] = "Alte Schließkiste",
	[3644] = "Flugapparat von Bael Modan",
	[3646] = "Geldkassette von General Doppelzopf",
	[3685] = "Silithid-Buckel",
	[3737] = "Blubbernder Felsspalt",
	[3767] = "Drizzliks Kaufhaus",
	[3768] = "Zerbrechlich - nicht fallen lassen",
	[3972] = "GESUCHT",
	[4072] = "Hauptsteuerventil",
	[4141] = "Steuerkonsole",
	[4406] = "Waldwebereier",
	[4608] = "Bäumlingsspross",
	[5620] = "Fehlerhafte Kraftsteine",
	[6751] = "Sonderbare fruchtbeladene Pflanze",
	[6752] = "Sonderbare wedelbestückte Pflanze",
	[6906] = "Rotraptornest",
	[6907] = "Blauraptornest",
	[6908] = "Gelbraptornest",
	[7510] = "Sprießender Wedel",
	[9630] = "Flagonguts Fossil",
	[10076] = "Wahrsageschale",
	[11713] = "Todeskappe",
	[11714] = "Schorfstängling",
	[12666] = "Zwielichtfoliant",
	[13360] = "Relikt von Mathystra",
	[13891] = "Schlangenflaum",
	[13949] = "Eingedellte Eisentruhe",
	[15084] = "Der Funkelmat 5200",
	[15085] = "Der Funkelmat 5200",
	[16393] = "Uralte Flamme",
	[17182] = "Dröhnkiste 827",
	[17183] = "Dröhnkiste 411",
	[17184] = "Dröhnkiste 323",
	[17188] = "Die Lage von Ameth'Aran",
	[17189] = "Der Untergang von Ameth'Aran",
	[17282] = "Pflanzenbündel",
	[17783] = "Antike Statuette",
	[19015] = "Elunes Träne",
	[19016] = "Mit Sternenstaub bedeckter Busch",
	[19021] = "Rostige Truhe",
	[19022] = "Abgenutzte Truhe",
	[19024] = "Verborgener Schrein",
	[19027] = "Foliant von Mel'Thandris",
	[19030] = "Erdhaufen",
	[19283] = "Kompendium der Gefallenen",
	[19284] = "Mythologie der Titanen",
	[19595] = "Torhüter-Unterstand",
	[19596] = "Schläferversteck",
	[19597] = "Druidenversteck",
	[19598] = "Grabhügelversteck",
	[19599] = "Krallenbau-Hort",
	[19602] = "Konstruktionspläne der Venture Co.",
	[19603] = "Dokumente der Venture Co.",
	[19861] = "Henrik Lonebrows Tagebuch",
	[19869] = "Raketenwagentrümmer",
	[19877] = "Velindes Spind",
	[19901] = "Kreis der Gefangenschaft",
	[20352] = "Kreis der Gefangenschaft",
	[20359] = "Ei von Onyxia",
	[20447] = "Harpyiennahrungsmittel",
	[20691] = "Cozzles Schließkiste",
	[20725] = "Das Vermächtnis der Aspekte",
	[20726] = "Anfänge der Bedrohung durch die Untoten",
	[20727] = "Gizmoriumtransportkiste",
	[20805] = "Rizzels Pläne",
	[20807] = "Uralte Kohlenpfanne",
	[20920] = "Blaulaubknolle",
	[20985] = "Lockere Erde",
	[20992] = "Schwarzer Schild",
	[21015] = "Hufabdrücke",
	[21016] = "Hufabdrücke",
	[21042] = "Abzeichen der Wache von Theramore",
	[21052] = "Geldkassette der Defias",
	[21277] = "Kiste mit Löchern",
	[21530] = "Schnüffelnasenbesitzeranleitung",
	[22245] = "Sack Fleisch",
	[22246] = "Träne von Theradras",
	[22550] = "Draenethystkristalle",
	[24798] = "Sonnengetrocknetes Treibholz",
	[28024] = "Karawanentruhe",
	[28604] = "Verstreute Kiste",
	[30854] = "Artefakt der Atal'ai",
	[30855] = "Artefakt der Atal'ai",
	[30856] = "Artefakt der Atal'ai",
	[32569] = "Galens Geldkassette",
	[35251] = "Karnitols Truhe",
	[35252] = "Uraltes Relikt",
	[36738] = "Das Buch von Ur",
	[37099] = "Schrifttafel der Atal'ai",
	[50935] = "Sack Korn",
	[50936] = "Sack Gerste",
	[50937] = "Sack Roggen",
	[50961] = "Malems Truhe",
	[50982] = "Die verbrannte Eiche",
	[51708] = "Elizas Graberde",
	[58369] = "Gestohlene Eisentruhe",
	[58595] = "Geheimlager der Brennenden Klinge",
	[61934] = "Kohlenpfanne der schlafenden Flamme",
	[61935] = "Regelventil",
	[61936] = "Treibstoffzufuhrventil",
	[68865] = "Schnüffelnasenleitstecken",
	[85562] = "Eisenbands Geldkassette",
	[85563] = "Stumpfzahns Geldkassette",
	[86492] = "Kiste mit Elunit",
	[89634] = "Eisenkoralle",
	[89635] = "Sonnenverbrannte Schale",
	[91138] = "Jordans Hammer",
	[92013] = "Foliant der Kabale",
	[92420] = "Bailors Erz",
	[92423] = "Beschädigte Truhe",
	[93192] = "Herzholz",
	[102984] = "Binks Werkzeugkasten",
	[102985] = "Balnirlöwenmäulchen",
	[103574] = "Gefüllte Verwahrungskästen",
	[103628] = "Urs Abhandlung über Schattenmagie",
	[103821] = "Doans Geldkassette",
	[104564] = "Bingles’ Werkzeugeimer",
	[104569] = "Bingles’ Werkzeugeimer",
	[104574] = "Bingles’ Werkzeugeimer",
	[104575] = "Bingles Superspreng",
	[105169] = "Agamands Waffenregal",
	[105170] = "Agamands Waffenregal",
	[105171] = "Agamands Waffenregal",
	[105172] = "Agamands Waffenregal",
	[105174] = "Truhe mit Verwahrungskästen",
	[105175] = "Inkantation der Manifestation",
	[112888] = "Staubiges Regal",
	[112948] = "Verschlossene Geldkassette der 'Kühnheit'",
	[113757] = "Schattenschmiedecache",
	[113768] = "Osterei",
	[113791] = "Kohlenpfanne von Everfount",
	[123329] = "Baelogs Truhe",
	[123462] = "Das Juwel der Südlichen Meere",
	[125477] = "Verdächtige Urne",
	[126049] = "Magenta Kappengruppen",
	[126158] = "Tallonkais Kommode",
	[126260] = "Uralte Truhe",
	[129127] = "Gallywix' Schließkassette",
	[131474] = "Die Scheiben von Norgannon",
	[138492] = "Splitter von Myzrael",
	[140911] = "Rolle blassgelber Seidenfaden",
	[141812] = "Stein der Bindung",
	[141832] = "Gong von Zul’Farrak",
	[141853] = "Violetter Tragan",
	[141857] = "Stein der Bindung",
	[141858] = "Stein der Bindung",
	[141859] = "Stein der Bindung",
	[141931] = "Hippogryphenei",
	[141979] = "Antiker Schatz",
	[141980] = "Geisterhafte Schließkassette",
	[142071] = "Ei-o-Mat",
	[142076] = "Claras frische Äpfel",
	[142088] = "Schrifttafel des Willens",
	[142122] = "Steckbrief",
	[142127] = "Rin'jis Geheimnis",
	[142151] = "Versiegeltes Fass",
	[142179] = "Pavillon von Solarsal",
	[142181] = "Gestohlene Fracht",
	[142184] = "Truhe des Kapitäns",
	[142185] = "Flamme von Byltan",
	[142186] = "Flamme von Lahassa",
	[142187] = "Flamme von Imbel",
	[142188] = "Flamme von Samha",
	[142189] = "Unauffälliger Orientierungspunkt",
	[142191] = "Vorratskiste der Horde",
	[142195] = "Schlachtplan der Waldpfoten",
	[142343] = "Podest von Uldum",
	[142344] = "Künstlicher Extrapolator",
	[142345] = "Matrix-Prägograph 3005-A",
	[142475] = "Matrix-Prägograph 3005-B",
	[142476] = "Matrix-Prägograph 3005-C",
	[142477] = "Thermadrahts Safe",
	[142487] = "Der Funkelmat 5200",
	[142696] = "Matrix-Prägograph 3005-D",
	[142702] = "Giftflasche",
	[142715] = "Schrifttafel von Theka",
	[142958] = "Feralas: Ein historischer Abriss",
	[143980] = "Gordunnischriftrolle",
	[144053] = "Kieselschliffs Feldmesserausstattung",
	[144054] = "Shays Truhe",
	[144063] = "Monolith von Equinex",
	[144064] = "Gordunnierdhügel",
	[144066] = "Erster Käfig der Bleichborken",
	[144067] = "Zweiter Käfig der Bleichborken",
	[144068] = "Dritter Käfig der Bleichborken",
	[144070] = "Scharfschnabels Käfig",
	[147557] = "Gestohlenes Silber",
	[148498] = "Altar von Suntara",
	[148499] = "Felix' Kasten",
	[148504] = "Ein verdächtiger Grabstein",
	[148506] = "Schattenhammerartefakt",
	[148512] = "Essenz-Born",
	[148513] = "Schrifttafel von Jin'yael",
	[148514] = "Schrifttafel von Markri",
	[148515] = "Schrifttafel von Sael'hai",
	[148516] = "Schrifttafel von Beth'Amara",
	[148832] = "Statue der Atal'ai",
	[148836] = "Altar von Hakkar",
	[148838] = "Götze von Hakkar",
	[149025] = "Wachpostenkohlenpfanne",
	[149030] = "Wachpostenkohlenpfanne",
	[149031] = "Wachpostenkohlenpfanne",
	[149032] = "Wachpostenkohlenpfanne",
	[149036] = "Marvons Truhe",
	[149047] = "Fackel der Vergeltung",
	[149480] = "Rune von Jin'yael",
	[149481] = "Rune von Beth'Amara",
	[149482] = "Rune von Markri",
	[149483] = "Rune von Sael'hai",
	[149502] = "Hort des schwarzen Drachenschwarms",
	[150075] = "Steckbrief",
	[150140] = "Arkaner Fokussierungskristall",
	[151286] = "Kaldoreifoliant der Beschwörung",
	[152094] = "Hyazinthpilz",
	[152095] = "Mondblütenlilie",
	[152097] = "Belnistrasz' Kohlenpfanne",
	[152608] = "Beute der Kolkar",
	[152618] = "Beute der Kolkar",
	[152622] = "Azsharitformation",
	[153123] = "Kim'jaels Ausrüstung",
	[153205] = "Altar des Entweihers",
	[153239] = "Wildekinfeder",
	[153556] = "Relikt von Thaurissan",
	[154357] = "Glitzernder Matsch",
	[156561] = "Steckbrief",
	[157936] = "Erdhaufen von Un'Goro",
	[160836] = "Reliktkasten",
	[160840] = "Weicher Erdhaufen",
	[160845] = "Dunkler Kasten",
	[161495] = "Geheimsafe",
	[161504] = "Ein kleines Pack",
	[161505] = "Ein havariertes Floß",
	[161521] = "Forscherausrüstung",
	[161526] = "Kiste mit Lebensmitteln",
	[161527] = "Dinosaurierknochen",
	[161557] = "Millys Ernte",
	[161752] = "Werkzeugkiste",
	[164659] = "Grüner Machtkristall",
	[164661] = "Gelber Machtkristall",
	[164662] = "Ausrüstungskästen",
	[164689] = "Denkmal für Franclorn Schmiedevater",
	[164778] = "Blauer Machtkristall",
	[164780] = "Roter Machtkristall",
	[164798] = "Evowurzel",
	[164820] = "Namensschild des Dunkelbewahrers",
	[164867] = "GESUCHT",
	[164868] = "SOFORT TÖTEN",
	[164869] = "Spektraler Kelch",
	[164885] = "Verderbter Nachtdrache",
	[164886] = "Verderbte Liedblume",
	[164887] = "Verderbte Windblüte",
	[164888] = "Verderbte Peitscherwurzel",
	[164909] = "Havariertes Ruderboot",
	[164910] = "Verschnörkelte Truhe",
	[164911] = "Fässchen mit Donnerbräu Lagerbier",
	[164953] = "Große Lederrucksäcke",
	[164954] = "Kapsel der Zukk'ash",
	[164955] = "Nördlicher Kristallpylon",
	[164956] = "Westlicher Kristallpylon",
	[164957] = "Östlicher Kristallpylon",
	[164958] = "Blutblütensprössling",
	[165554] = "Herz des Berges",
	[166863] = "Frisches Dreschadongerippe",
	[169243] = "Truhe der Sieben",
	[169294] = "Schrifttafel der Sieben",
	[171938] = "Kaktusapfel",
	[171939] = "Verderbte Liedblume",
	[171942] = "Verderbte Liedblume",
	[173232] = "Schmiedekunstpläne",
	[173265] = "Hölzernes Plumpsklo",
	[173266] = "Goldstahls Geschäftsbuch",
	[173284] = "Verderbte Peitscherwurzel",
	[173324] = "Verderbter Nachtdrache",
	[173327] = "Verderbte Windblüte",
	[174594] = "Verderbte Liedblume",
	[174595] = "Verderbte Liedblume",
	[174596] = "Verderbte Liedblume",
	[174597] = "Verderbte Liedblume",
	[174598] = "Verderbte Liedblume",
	[174599] = "Verderbte Windblüte",
	[174600] = "Verderbte Windblüte",
	[174601] = "Verderbte Windblüte",
	[174602] = "Verderbte Windblüte",
	[174603] = "Verderbte Windblüte",
	[174604] = "Verderbte Windblüte",
	[174605] = "Verderbte Peitscherwurzel",
	[174606] = "Verderbte Peitscherwurzel",
	[174607] = "Verderbte Peitscherwurzel",
	[174608] = "Verderbter Nachtdrache",
	[174682] = "Vorsicht, Pterrordax!",
	[174684] = "Verderbter Nachtdrache",
	[174686] = "Verderbte Peitscherwurzel",
	[174708] = "Verderbte Windblüte",
	[174709] = "Verderbte Windblüte",
	[174712] = "Verderbte Liedblume",
	[174713] = "Verderbte Liedblume",
	[174728] = "Beschädigte Kiste",
	[174793] = "Schwarmbrutstätte der Gorishi",
	[174848] = "Testausrüstung",
	[175084] = "Der Funkelmat 5200",
	[175165] = "Schließkassette der Silbermorgen",
	[175166] = "Schließkassette der Nebelschleier",
	[175207] = "Gestrandete Meereskreatur",
	[175226] = "Gestrandete Meereskreatur",
	[175227] = "Gestrandete Meereskreatur",
	[175230] = "Gestrandete Meereskreatur",
	[175233] = "Gestrandete Meereskreatur",
	[175245] = "Vater Flamme",
	[175264] = "Brutlingessenz",
	[175320] = "GESUCHT: Gurgelbacke!",
	[175324] = "Frosthagelsplitter",
	[175329] = "Nusslager der Schwarzfelle",
	[175330] = "Obstlager der Schwarzfelle",
	[175331] = "Getreidelager der Schwarzfelle",
	[175334] = "Bijous Habseligkeiten",
	[175369] = "Dienstboteneingang am Ältestenplatz",
	[175382] = "Doomriggers Kasten",
	[175384] = "Ei eines Steilhangflügeldrachen",
	[175385] = "Dunkelsteinschrifttafel",
	[175407] = "Mondbestrahlte Feder",
	[175487] = "Dritte Schrifttafel von Mosh'aru",
	[175488] = "Vierte Schrifttafel von Mosh'aru",
	[175524] = "Geheimnisvoller roter Kristall",
	[175565] = "Fremdartiges Ei",
	[175566] = "Düsterkraut",
	[175586] = "Jarons Wagen",
	[175587] = "Beschädigte Kiste",
	[175606] = "Spitzenspinnenei",
	[175621] = "Uroks Tributhaufen",
	[175629] = "Jarons Ladung",
	[175704] = "Angesengter Brief",
	[175708] = "Vorratskisten von Crossroads",
	[175785] = "Unauffällige Dokumente",
	[175802] = "Kleine Schließkassette",
	[175886] = "Beschlagene Pike",
	[175888] = "Fragment eines Hochgeborenenrelikts",
	[175889] = "Uraltes Ei",
	[175891] = "Fragment eines Hochgeborenenrelikts",
	[175892] = "Fragment eines Hochgeborenenrelikts",
	[175893] = "Fragment eines Hochgeborenenrelikts",
	[175894] = "Janices Paket",
	[175924] = "Verschlossener Schrank",
	[175925] = "Plumpsklo",
	[175926] = "Frau Dalsons Tagebuch",
	[175928] = "Brandpulveragave",
	[175944] = "Hochheiliges Feuer des Lebens",
	[175949] = "Fünfte Schrifttafel von Mosh'aru",
	[175950] = "Sechste Schrifttafel von Mosh'aru",
	[175965] = "Frostraunens Balsamierungsflüssigkeit",
	[175966] = "Verzauberter scharlachroter Faden",
	[175970] = "Ungeschmiedete runenverzierte Brustplatte",
	[176089] = "Ungebrannte Plattenstulpen",
	[176090] = "Menschliche Überreste",
	[176091] = "Kessel der Totenwaldfelle",
	[176092] = "Kasten mit Anzündern",
	[176112] = "Malors Geldkassette",
	[176115] = "Steckbrief: Arnak Grimmtotem",
	[176116] = "Pamelas Puppenkopf",
	[176142] = "Pamelas Puppe, linke Seite",
	[176143] = "Pamelas Puppe, rechte Seite",
	[176145] = "Joseph Rotpfads Monument",
	[176150] = "Modriger Foliant",
	[176158] = "Kohlenpfanne des Schmerzes",
	[176159] = "Kohlenpfanne der Bosheit",
	[176160] = "Kohlenpfanne des Leidens",
	[176161] = "Kohlenpfanne des Hasses",
	[176189] = "Skelettierte Meeresschildkröte",
	[176190] = "Gestrandete Meeresschildkröte",
	[176191] = "Gestrandete Meeresschildkröte",
	[176192] = "Verzeichnis der Abtrünnigen",
	[176196] = "Gestrandete Meeresschildkröte",
	[176197] = "Gestrandete Meeresschildkröte",
	[176198] = "Gestrandete Meeresschildkröte",
	[176206] = "Davils Buchband",
	[176207] = "Rotpfads Schild",
	[176208] = "Horgus' Schädel",
	[176209] = "Zertrümmertes Schwert von Marduk",
	[176213] = "Blut von Helden",
	[176245] = "Scharlachrotes Archiv",
	[176249] = "Geißeldaten",
	[176317] = "Der Argentumtresor",
	[176325] = "Schmiedekunstpläne",
	[176344] = "Dokumententruhe",
	[176356] = "Hochheilige Schriften der Hochgeborenen",
	[176361] = "Geißelkessel",
	[176392] = "Geißelkessel",
	[176393] = "Geißelkessel",
	[176484] = "Die Besitzurkunde für Brill",
	[176485] = "Die Besitzurkunde für Darrowehr",
	[176486] = "Die Besitzurkunde für Süderstade",
	[176487] = "Die Besitzurkunde für Tarrens Mühle",
	[176544] = "Überreste von Eva Sarkhoff",
	[176545] = "Überreste von Lucien Sarkhoff",
	[176581] = "Kristall der Hand von Iruxos",
	[176582] = "Schalentierfalle",
	[176630] = "Andenken der Erinnerung",
	[176631] = "Menethils Geschenk",
	[176634] = "Kerlonians Truhe",
	[176751] = "Kodoknochen",
	[176785] = "Munitionskiste",
	[176793] = "Kleinholzbündel",
	[177240] = "Lockerer Erdhaufen",
	[177241] = "Arajs Phylakterium",
	[177243] = "Dämonenportal",
	[177264] = "Symbol der verlorenen Ehre",
	[177287] = "Unvollendetes Gemälde",
	[177289] = "Geißelkessel",
	[177464] = "Großer Termitenhügel",
	[177490] = "Kiste vom Sägewerk des Nordkamms",
	[177491] = "Termitenfass",
	[177544] = "Josephs Truhe",
	[177624] = "Xabraxxis Dämonentasche",
	[177667] = "Zerrissene Rolle",
	[177675] = "Erdhaufen",
	[177684] = "Stein von Shy-Rotam",
	[177747] = "Registratur von Quel'Thalas",
	[177750] = "Lunarfungusblüte",
	[177784] = "Riesenweichpanzermuschel",
	[177786] = "Rackmores Truhe",
	[177787] = "Rackmores Logbuch",
	[177789] = "Augustus' Quittungsbuch",
	[177804] = "Zerfleischte menschliche Überreste",
	[177805] = "Zerfleischte menschliche Überreste",
	[177806] = "Zerfleischte menschliche Überreste",
	[177904] = "Steckbrief: Besseleth",
	[177926] = "Gaeasamenkorn",
	[177929] = "Gaeaerdhügel",
	[177964] = "Tiefenstein",
	[178084] = "Felix' Truhe",
	[178085] = "Felix' Bolzeneimer",
	[178087] = "Thazz'rils Hacke",
	[178090] = "Marlas Grab",
	[178104] = "Resonitkristall",
	[178144] = "Trolltruhe",
	[178145] = "Resonitbehälter",
	[178184] = "Saphir von Aku'mai",
	[178185] = "Saphir von Aku'mai",
	[178186] = "Saphir von Aku'mai",
	[178195] = "Öl des Kriegshymnenklans",
	[178204] = "Axtlieferung des Kriegshymnenklans",
	[178227] = "Murguts Totemkorb",
	[178553] = "Kapsel des Ashischwarms",
	[178609] = "Feiertagsschnee",
	[179485] = "Beschädigte Falle",
	[179499] = "Gerbekorb der Oger",
	[179501] = "Knot Zwingschraubs Behälter",
	[179516] = "Fengus Truhe",
	[179517] = "Schatz der Shen'dralar",
	[179544] = "Die sterblichen Überreste von Telmius Traumsucher",
	[179545] = "Die Truhe des Prinzen",
	[179547] = "Ein verstaubter Foliant",
	[179551] = "Hydraxis Truhe",
	[179552] = "Bauplan: Feldreparaturbot 74A",
	[179553] = "Kernfragment",
	[179559] = "Teufelsrankensplitter",
	[179562] = "Erhitzte Uralte Klinge",
	[179564] = "Tribut der Gordok",
	[179565] = "Staubiger Reliquienschrein",
	[179697] = "Arenaschatztruhe",
	[179703] = "Behälter des Feuerfürsten",
	[179826] = "Geheimpläne: Feuriger Fluxus",
	[179827] = "Gesucht/Vermisst/Verloren & Gefunden",
	[179828] = "Dunkeleisenkissen",
	[179832] = "Verziertes Kissen von Kissenquetscher",
	[179879] = "Befehlskugel",
	[179880] = "Drakkisaths Brandzeichen",
	[179913] = "Zu den Waffen!",
	[179914] = "Knochenhaufen",
	[179915] = "Schädelhaufen",
	[179922] = "Gefäß mit besudeltem Blut",
	[180215] = "Thoriumvorkommen der Hakkari",
	[180229] = "Verwunschener Hoodoohaufen",
	[180248] = "Ein Schwarm Leckerfische",
	[180327] = "Kohlenpfanne des Wahnsinns",
	[180366] = "Ramponierter Ausrüstungskasten",
	[180368] = "Schrifttafel des Wahnsinns",
	[180369] = "Schlammiges aufgewühltes Gewässer",
	[180435] = "Noggles Ranzen",
	[180436] = "Zwielichtschrifttafelfragment",
	[180448] = "Steckbrief: Totenstachel",
	[180453] = "Glyphenverzierter Kristall des Regalschwarms",
	[180454] = "Glyphenverzierter Kristall des Ashischwarms",
	[180455] = "Glyphenverzierter Kristall des Zoraschwarms",
	[180456] = "Geringer Windstein",
	[180461] = "Windstein",
	[180466] = "Großer Windstein",
	[180501] = "Zwielichtschrifttafelfragment",
	[180503] = "Sandiges Kochbuch",
	[180526] = "Gong von Bethekk",
	[180570] = "Bierfässchen",
	[180633] = "Kristallträne",
	[180642] = "Unscheinbare Kiste",
	[180652] = "Frisch aufgewühlter Dreck",
	[180662] = "Schiffswrackteile",
	[180665] = "Drakonisch für Dummies",
	[180666] = "Drakonisch für Dummies",
	[180667] = "Drakonisch für Dummies",
	[180669] = "Wirbelnder Mahlstrom",
	[180682] = "Ein Schwarm öliger Schwarzmaulfische",
	[180684] = "Ein Schwarm großer Weisenfische",
	[180685] = "Schwimmende Wrackteile",
	[180690] = "Großer Skarabäuskasten",
	[180691] = "Skarabäuskasten",
	[180712] = "Steinschuppenaalschwarm",
	[180717] = "Der Skarabäusgong",
	[180743] = "Sorgfältig verpacktes Geschenk",
	[180746] = "Leicht geschütteltes Geschenk",
	[180747] = "Fröhlich verpacktes Geschenk",
	[180748] = "Tickendes Geschenk",
	[180751] = "Treibende Wrackteile",
	[180793] = "Festtagsgeschenk",
	[180794] = "Tagebuch von Jandice Barov",
	[180901] = "Blutsegelwrackteile",
	[181053] = "Korb voller Bluttang",
	[181073] = "Duftender Kessel",
	[181074] = "Arenabeute",
	[181083] = "Sothos' und Jariens Erbstücke",
	[181085] = "Vorratskiste von Stratholme",
	[181098] = "Vulkanasche",
	[181366] = "Truhe der Vier Reiter",
	[181597] = "Silithysthaufen",
	[181598] = "Silithystgeysir",
	[181672] = "Weidenmann",
	[181686] = "Holzstapel",
	[181687] = "Holzstapel",
	[190483] = "Dokumententruhe",
	[190484] = "Dokumententruhe",
	[201579] = "Schlüsselsteinscherbe",
	[207724] = "Schiffswracktrümmer",
	[375544] = "Holzstatuette",
	[386675] = "Vergrabener Schatz",
	[386691] = "Bibliotheksbuch",
	[386759] = "Bibliotheksbuch",
	[386777] = "Verstaubte Kiste",
	[387466] = "Rostige Schließkassette",
	[387477] = "Lagertruhe der Defias",
	[392029] = "Belohnung des Schwertkämpfers",
	[397987] = "Lagertruhe der Kobolde",
	[402215] = "Verkohlte Notiz",
	[403041] = "Sprengvorräte",
	[403102] = "Beutelager der Borstennacken",
	[403105] = "Windzornzapfen",
	[403718] = "Prärieblume",
	[404352] = "Artefaktlagertruhe",
	[404433] = "Mondtruhe",
	[404695] = "Durchnässte Lagertruhe",
	[404911] = "Versteckte Truhe",
	[404941] = "Reliktkasten",
	[405149] = "Wandgemälde von Ta'zo",
	[405628] = "Beutelager der Frostmane",
	[405633] = "Schließkiste der Felsenkiefer",
	[405879] = "Fibel der Apothekervereinigung",
	[406006] = "Götze",
	[406736] = "Verlorene Kiste",
	[406918] = "Kuriertasche",
	[407117] = "Verlassenes Schnappkiefernest",
	[407120] = "Leeres Schnappkiefernest",
	[407247] = "Lichtungsblume",
	[407289] = "Kriegsbanner der Horde",
	[407291] = "Kriegsbanner der Allianz",
	[407312] = "Hungriger Götze",
	[407347] = "Altar der Dornen",
	[407352] = "Kiste der Knarzklauen",
	[407453] = "Südmeerbeutelager",
	[407454] = "Schießpulverfass",
	[407457] = "Stallburschenkoffer",
	[407510] = "Geätzte Schnitzerei",
	[407566] = "Goblinfoliant",
	[407731] = "Werkzeugkasten des Steinmetzes",
	[407734] = "Knarzklauenkiste",
	[407850] = "Versunkener Reliquienschrein",
	[407918] = "Leerer Trophäenkasten",
	[407983] = "Haufen gestohlener Bücher",
	[408004] = "Umschlungener Verseuchungsstapel",
	[408014] = "Gnomenfoliant",
	[408718] = "Ausrüstungslager",
	[408799] = "Götze der Tiefe",
	[408802] = "Knorrige Harpune",
	[409289] = "Seltsame Kugel",
	[409315] = "Zerschmetterte Kugel",
	[409496] = "Schriftrollen",
	[409501] = "Dalaranauswahl",
	[409562] = "Zauberbuch",
	[409692] = "Schriftrollen",
	[409700] = "Handbuch",
	[409711] = "Schriftrollen",
	[409717] = "Schriftrollen",
	[409731] = "Schriftrollen",
	[409735] = "Zauberbuch",
	[409754] = "Aufgehängter Schild",
	[409758] = "Weggeworfener Helm",
	[409949] = "Zwillingseulenstatue",
	[410299] = "Arkane Geheimnisse",
	[410369] = "Toter Briefkasten",
	[410528] = "Verzierte Truhe",
	[411328] = "Schlummernde Knochen",
	[411348] = "Staubige Truhe",
	[411358] = "Handwerkertruhe",
	[411674] = "Prophezeiung des Tods eines Königs",
	[411710] = "Dämonisches Reliquiar",
	[411715] = "Alteks Zweig",
	[412224] = "Dunkler Ritualstein",
	[414532] = "Cliffspring-Truhe",
	[414624] = "Leuchtturmvorrat",
	[414646] = "Überreste",
	[414658] = "Geröll",
	[414663] = "Götze der Shatterspear",
	[415106] = "Ausgebrannte Überreste",
	[415107] = "Ausgebrannte Überreste",
	[417072] = "Festgenagelte Planke",
	[417353] = "Gelöschtes Lagerfeuer",
	[418855] = "Illaris Beutetruhe",
	[422483] = "Der Wiederverwertungsmat 9000",
	[422911] = "Versiegeltes Fass",
	[422919] = "Angezapftes Schattenschmiedefass",
	[423569] = "Fallengelassener Beutel",
	[423695] = "Buchband der Erlösung",
	[423841] = "Gefrorene Überreste",
	[424005] = "Taschenmüll",
	[424006] = "Hastig eingerollter Beutel",
	[424007] = "Geschnitzte Figure",
	[424010] = "Planke mit Nagel",
	[424012] = "Erdhaufen",
	[424074] = "Quadrangulationssignalgeber 001",
	[424075] = "Quadrangulationssignalgeber 002",
	[433596] = "Verzauberte Kriegstruhe",
	[439557] = "Alptraummoos",
	[439558] = "Kalteisenvorkommen",
	[439627] = "Traumwurzel",
	[439628] = "Katzengoldvorkommen",
	[439762] = "Sternenlotus",
	[439778] = "Sternensilberader",
	[439810] = "Mondwurzel",
	[439815] = "Große Mondsteinformation",
	[441113] = "Ogermagiertext",
	[441114] = "Geheimnisvolle Kiste",
	[441119] = "Ungeschlüpftes grünes Drachenei",
	[441124] = "Traumberührtes Drachenei",
	[441128] = "Vibrierende Kiste",
	[441129] = "Azsharische Prophezeiung",
	[441133] = "Sternenberührtes Drachenei",
	[441140] = "Summender Kasten",
	[441141] = "Traumperle",
	[441222] = "Grabhügel",
	[441310] = "Mondscheindrachenei",
	[441312] = "Notizen des wahnsinnigen Bewahrers",
	[441314] = "Harpyienschrift",
	[441848] = "Kleiner Bau",
	[441946] = "Schrein des Mondes",
	[441947] = "Schrein des Tieres",
	[441948] = "Schrein des Wächters",
	[455812] = "Schwert von Knappe Cuthbert",
	[457088] = "Fortgeschrittener Schwertkampf",
	[457089] = "Die Schattenverbindung",
	[457090] = "Berühmte (und berüchtigte) Waldläufer von Azeroth",
	[457091] = "Chens Trainingshandbuch",
	[457092] = "Der Furor von Sturmgrimm",
	[457093] = "Schonungslose Gerechtigkeit: Die Geschichte eines Zwerges",
	[457094] = "Die wahre Natur des Lichts",
	[457095] = "Elemente für Dummies Band I: Frost",
	[457096] = "Erster sein: Das Boxhandbuch eines Muskelprotzes",
	[457097] = "Elemente für Dummies Band I: Feuer",
	[457098] = "Die innere Katze finden: Ein Leitfaden für moderne Druidenkünste",
	[457099] = "Zirenes Leitfaden für den Schlagabtausch",
	[457100] = "Renziks Gedanken zu \"fairem\" Kämpfen",
	[457101] = "Die Riten von Mak'Gora",
	[457102] = "Elemente für Dummies Band I: Arkan",
	[462233] = "Schimmerndes geschmolzenes Gestein",
	[462236] = "Mysteriöse Truhe",
	[495500] = "Schattenflammentruhe",
	[495503] = "Chromatischer Hort",
	[495505] = "Begünstigter Reichtum",
	[100000001] = "Nicht angezündete Fackel",
});
for key,value in pairs({
	[11] = "|cFFAAFFAADies war erst Phase 1 von WoW Classic verfügbar.|r",
	[1606] = "|cFFAAFFAADies war erst Phase 2 von Season of Discovery verfügbar.|r",
	[1607] = "|cFFAAFFAADies war erst Phase 3 von Season of Discovery verfügbar.|r",
	[1608] = "|cFFAAFFAADies war erst Phase 4 von Season of Discovery verfügbar.|r",
	[1609] = "|cFFAAFFAADies war erst Phase 5 von Season of Discovery verfügbar.|r",
	[1610] = "|cFFAAFFAADies war erst Phase 6 von Season of Discovery verfügbar.|r",
	[1611] = "|cFFAAFFAADies war erst Phase 7 von Season of Discovery verfügbar.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "Stufe 10",
	[7] = "Stufe 20",
	[8] = "Stufe 30",
	[9] = "Stufe 40",
	[10] = "Stufe 50",
	[11] = "Stufe 60",
	[42] = "Erforscht die östlichen Königreiche",
	[43] = "Erforscht Kalimdor",
	[121] = "Kochgeselle",
	[122] = "Expertenkoch",
	[123] = "Der Kochfachmann",
	[126] = "Anglergeselle",
	[127] = "Expertenangler",
	[128] = "Anglerfachmann",
	[131] = "Geselle in Erster Hilfe",
	[132] = "Experte in Erster Hilfe",
	[133] = "Fachmann in Erster Hilfe",
	[238] = "Ein ehrenhafter Sieg",
	[239] = "25.000 ehrenhafte Siege",
	[306] = "Meisterangler von Azeroth",
	[389] = "Gurubashi Arenameister",
	[396] = "Gurubashi Arenagroßmeister",
	[416] = "Skarabäuslord",
	[424] = "Warum? Weil er rot ist!",
	[425] = "Atiesh, Hohestab des Wächters",
	[428] = "Donnerzorn, Gesegnete Klinge des Windsuchers",
	[429] = "Sulfuras, Hand von Ragnaros",
	[509] = "10.000 ehrenhafte Siege",
	[512] = "5.000 ehrenhafte Siege",
	[513] = "100 ehrenhafte Siege",
	[515] = "500 ehrenhafte Siege",
	[516] = "1.000 ehrenhafte Siege",
	[520] = "20 ehrfürchtige Fraktionen",
	[521] = "15 ehrfürchtige Fraktionen",
	[522] = "Jemand mag mich!",
	[523] = "5 ehrfürchtige Fraktionen",
	[524] = "10 ehrfürchtige Fraktionen",
	[546] = "Sicher angelegt",
	[627] = "Erforscht Dun Morogh",
	[628] = "Todesminen",
	[629] = "Flammenschlund",
	[630] = "Höhlen des Wehklagens",
	[631] = "Burg Schattenfang",
	[633] = "Verlies von Sturmwind",
	[635] = "Kral der Klingenhauer",
	[636] = "Hügel der Klingenhauer",
	[641] = "Versunkener Tempel",
	[642] = "Schwarzfelstiefen",
	[643] = "Untere Schwarzfelsspitze",
	[684] = "Onyxias Hort (Stufe 60)",
	[685] = "Pechschwingenhort",
	[686] = "Geschmolzener Kern",
	[687] = "Tempel von Ahn'Qiraj",
	[689] = "Ruinen von Ahn'Qiraj",
	[706] = "Frostwolfheuler",
	[707] = "Streitwidder der Sturmlanzen",
	[708] = "Held des Frostwolfklans",
	[709] = "Held der Sturmlanzengarde",
	[710] = "Der Entweihte",
	[711] = "Ritter von Arathor",
	[712] = "Vorhut des Kriegshymnenklans",
	[713] = "Schildwache der Silberschwingen",
	[714] = "Der Eroberer",
	[727] = "Ruft die Kavallerie!",
	[728] = "Erforscht Durotar",
	[729] = "Die Zügel des Todesstreitrosses",
	[736] = "Erforscht Mulgore",
	[750] = "Erforscht das Brachland",
	[760] = "Erforscht das Alteracgebirge",
	[761] = "Erforscht das Arathihochland",
	[765] = "Erforscht das Ödland",
	[766] = "Erforscht die verwüsteten Lande",
	[768] = "Erforscht Tirisfal",
	[769] = "Erforscht den Silberwald",
	[770] = "Erforscht die westlichen Pestländer",
	[771] = "Erforscht die östlichen Pestländer",
	[772] = "Erforscht das Vorgebirge des Hügellands",
	[773] = "Erforscht das Hinterland",
	[774] = "Erforscht die sengende Schlucht",
	[775] = "Erforscht die brennende Steppe",
	[776] = "Erforscht den Wald von Elwynn",
	[777] = "Erforscht den Gebirgspass der Totenwinde",
	[778] = "Erforscht den Dämmerwald",
	[779] = "Erforscht Loch Modan",
	[780] = "Erforscht das Rotkammgebirge",
	[781] = "Erforscht das Schlingendorntal",
	[782] = "Erforscht die Sümpfe des Elends",
	[802] = "Erforscht Westfall",
	[841] = "Erforscht das Sumpfland",
	[842] = "Erforscht Teldrassil",
	[844] = "Erforscht die Dunkelküste",
	[845] = "Erforscht das Eschental",
	[846] = "Erforscht Tausend Nadeln",
	[847] = "Erforscht das Steinkrallengebirge",
	[848] = "Erforscht Desolace",
	[849] = "Erforscht Feralas",
	[850] = "Erforscht die Düstermarschen",
	[851] = "Erforscht die Tanariswüste",
	[852] = "Erforscht Azshara",
	[853] = "Erforscht den Teufelswald",
	[854] = "Erforscht den Krater von Un'Goro",
	[855] = "Erforscht die Mondlichtung",
	[856] = "Erforscht Silithus",
	[857] = "Erforscht Winterquell",
	[871] = "Segel setzen, Admiral!",
	[879] = "Old School Reiter",
	[880] = "Schneller zulianischer Tiger",
	[881] = "Schneller Razzashiraptor",
	[891] = "Aufsatteln!",
	[907] = "Der Vollstrecker",
	[940] = "Die Grünen Hügel des Schlingendorntals",
	[944] = "Die stehen auf mich in diesem Tunnel",
	[946] = "Die Argentumdämmerung",
	[955] = "Die Hydraxianer",
	[956] = "Brut von Nozdormu",
	[957] = "Held des Stamms der Zandalari",
	[1307] = "Obere Schwarzfelsspitze",
	[1676] = "Meister der Lehren der östlichen Königreiche",
	[1677] = "Meister der Lehren der östlichen Königreiche",
	[1678] = "Meister der Lehren in Kalimdor",
	[1680] = "Meister der Lehren in Kalimdor",
	[2116] = "Wappenrock der Argentumdämmerung",
	[2141] = "Stallbesitzer",
	[2142] = "Die Scheune wird voll",
	[2336] = "Am Rande des Wahnsinns",
	[2357] = "Schreckensross von Xoroth",
	[2358] = "Streitross",
	[2496] = "Das Fünfte Element",
	[3356] = "Frostsäbler aus Winterquell",
	[5788] = "Agent der Shen'dralar",
	[16433] = "Eisenseele (Saison der Meisterschaft)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "Erreicht Stufe 10.",
	[7] = "Erreicht Stufe 20.",
	[8] = "Erreicht Stufe 30.",
	[9] = "Erreicht Stufe 40.",
	[10] = "Erreicht Stufe 50.",
	[11] = "Erreicht Stufe 60.",
	[42] = "Erforscht die Regionen der östlichen Königreiche.",
	[43] = "Erforscht die Regionen Kalimdors.",
	[121] = "Werdet Kochgeselle.",
	[122] = "Werdet Expertenkoch.",
	[123] = "Werdet Kochfachmann.",
	[126] = "Werdet Anglergeselle.",
	[127] = "Werdet Expertenangler.",
	[128] = "Werdet Anglerfachmann.",
	[131] = "Werdet Geselle der Ersten Hilfe.",
	[132] = "Werdet Experte in Erster Hilfe.",
	[133] = "Werdet Fachmann in Erster Hilfe.",
	[238] = "Erringt einen ehrenhaften Sieg.",
	[239] = "Erringt 25.000 ehrenhafte Siege.",
	[306] = "Gewinnt den Angelwettbewerb in der Beutebucht oder den Angelwettstreit der Kalu'ak.",
	[389] = "Plündert den Schmuck des Arenameisters in der Arena der Gurubashi.",
	[396] = "Schließt die Quest von Störtebrecher ab, um den Schmuck des Arenagroßmeisters zu erhalten.",
	[416] = "Die Tore von Ahn'Qiraj geöffnet.",
	[424] = "Erhaltet einen roten Qirajiresonanzkristall.",
	[425] = "Träger von Atiesh, Hohestab des Wächters.",
	[428] = "Träger von Donnerzorn, Gesegnete Klinge des Windsuchers.",
	[429] = "Träger von Sulfuras, Hand von Ragnaros.",
	[509] = "Erringt 10.000 ehrenhafte Siege.",
	[512] = "Erringt 5.000 ehrenhafte Siege.",
	[513] = "Erringt 100 ehrenhafte Siege.",
	[515] = "Erringt 500 ehrenhafte Siege.",
	[516] = "Erringt 1.000 ehrenhafte Siege.",
	[520] = "Erreicht bei 20 Fraktionen einen ehrfürchtigen Ruf.",
	[521] = "Erreicht bei 15 Fraktionen einen ehrfürchtigen Ruf.",
	[522] = "Erreicht einen ehrfürchtigen Ruf.",
	[523] = "Erreicht bei 5 Fraktionen einen ehrfürchtigen Ruf.",
	[524] = "Erreicht bei 10 Fraktionen einen ehrfürchtigen Ruf.",
	[546] = "Kauft 7 zusätzliche Bankplätze.",
	[627] = "Erforscht Dun Morogh und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[628] = "Bezwingt Edwin van Cleef.",
	[629] = "Bezwingt Taragaman den Hungerleider.",
	[630] = "Bezwingt Mutanus den Verschlinger.",
	[631] = "Bezwingt Erzmagier Arugal.",
	[633] = "Bezwingt Bazil Thredd.",
	[634] = "Bezwingt Robogenieur Thermadraht.",
	[635] = "Bezwingt Charlga Klingenflanke.",
	[636] = "Bezwingt Amnennar den Kältebringer.",
	[638] = "Besiegt Archaedas.",
	[640] = "Bezwingt Prinzessin Theradras.",
	[641] = "Bezwingt Eranikus' Schemen.",
	[642] = "Bezwingt Imperator Dagran Thaurissan.",
	[643] = "Bezwingt Oberanführer Wyrmthalak.",
	[646] = "Bezwingt die bösen Drahtzieher der Invasion von Stratholme.",
	[684] = "Bezwingt die klassische Stufe-60-Version von Onyxia.",
	[685] = "Bezwingt Nefarian.",
	[686] = "Bezwingt Ragnaros.",
	[687] = "Bezwingt C'Thun.",
	[688] = "Bezwingt Hakkar.",
	[689] = "Bezwingt Ossirian den Narbenlosen.",
	[706] = "Erhaltet einen Frostwolfheuler.",
	[707] = "Erhaltet einen Streitwidder der Sturmlanzen.",
	[708] = "Erreicht einen ehrfürchtigen Ruf beim Frostwolfklan.",
	[709] = "Erreicht einen ehrfürchtigen Ruf bei der Sturmlanzengarde.",
	[710] = "Erreicht einen ehrfürchtigen Ruf bei den Entweihten.",
	[711] = "Erreicht einen ehrfürchtigen Ruf beim Bund von Arathor.",
	[712] = "Erreicht einen ehrfürchtigen Ruf bei der Vorhut des Kriegshymnenclans.",
	[713] = "Erreicht einen ehrfürchtigen Ruf bei der Schildwache der Silberschwingen.",
	[714] = "Erhöht Euren Ruf in der Kriegshymnenschlucht, dem Arathibecken und dem Alteractal auf ehrfürchtig.",
	[727] = "Erhaltet eines der Kriegsreittiere durch das Ehrensystem.",
	[728] = "Erforscht Durotar und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[729] = "Erhaltet die Zügel des Todesstreitrosses von Baron Totenschwur in Stratholme.",
	[736] = "Erforscht Mulgore und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[750] = "Erforscht das Brachland und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[760] = "Erforscht das Alteracgebirge und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[761] = "Erforscht das Arathihochland und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[765] = "Erforscht das Ödland und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[766] = "Erforscht die verwüsteten Lande und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[768] = "Erforscht Tirisfal und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[769] = "Erforscht den Silberwald und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[770] = "Erforscht die westlichen Pestländer und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[771] = "Erforscht die östlichen Pestländer und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[772] = "Erforscht das Vorgebirge des Hügellands und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[773] = "Erforscht das Hinterland und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[774] = "Erforscht die sengende Schlucht und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[775] = "Erforscht die brennende Steppe und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[776] = "Erforscht den Wald von Elwynn und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[777] = "Erforscht den Gebirgspass der Totenwinde und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[778] = "Erforscht den Dämmerwald und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[779] = "Erforscht Loch Modan und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[780] = "Erforscht das Rotkammgebirge und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[781] = "Erforscht das Schlingendorntal und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[782] = "Erforscht die Sümpfe des Elends und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[802] = "Erforscht Westfall und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[841] = "Erforscht das Sumpfland und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[842] = "Erforscht Teldrassil und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[844] = "Erforscht die Dunkelküste und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[845] = "Erforscht das Eschental und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[846] = "Erforscht Tausend Nadeln und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[847] = "Erforscht das Steinkrallengebirge und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[848] = "Erforscht Desolace und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[849] = "Erforscht Feralas und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[850] = "Erforscht die Düstermarschen und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[851] = "Erforscht die Tanariswüste und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[852] = "Erforscht Azshara und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[853] = "Erforscht den Teufelswald und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[854] = "Erforscht den Krater von Un'Goro und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[855] = "Erforscht die Mondlichtung und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[856] = "Erforscht Silithus und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[857] = "Erforscht Winterquell und enthüllt die verdeckten Gebiete auf der Weltkarte.",
	[871] = "Erhaltet den Blutsegeladmiralshut... und versucht, zwischendurch etwas frische Luft zu tanken.",
	[879] = "Besitzer eines der ursprünglichen epischen Reittiere, die nicht mehr erhältlich sind.",
	[880] = "Erhaltet den schnellen zulianischen Tiger vom Hohepriester Thekal in Zul'Gurub.",
	[881] = "Erhaltet den schnellen Razzashiraptor von Blutfürst Mandokir in Zul'Gurub.",
	[891] = "Erlernt die Fähigkeit 'Unerfahrener Reiter'.",
	[907] = "Erhöht Euren Ruf in der Kriegshymnenschlucht, dem Arathibecken und dem Alteractal auf ehrfürchtig.",
	[940] = "Schließt alle Hemet Nesingwary-Quests im Schlingendorntal ab, bis hin zu 'Die Grünen Hügel des Schlingendorntals' und 'Großwildjäger'.",
	[944] = "Erreicht bei der Holzschlundfeste den Status ehrfürchtig.",
	[946] = "Erreicht bei der Argentumdämmerung den Status ehrfürchtig.",
	[955] = "Erreicht bei den Hydraxianern den Status ehrfürchtig.",
	[956] = "Erreicht bei der Brut Nozdormus den Status ehrfürchtig.",
	[957] = "Erreicht beim Stamm der Zandalari den Status ehrfürchtig.",
	[1307] = "Bezwingt General Drakkisath.",
	[1676] = "Schließt 700 Quests in den östlichen Königreichen ab.",
	[1677] = "Schließt 550 Quests in den östlichen Königreichen ab.",
	[1678] = "Schließt 700 Quests in Kalimdor ab.",
	[1680] = "Schließt 685 Quests in Kalimdor ab.",
	[2116] = "Einen Wappenrock der Argentumdämmerung durch das Ereignis 'Invasion der Geißel' erhalten.",
	[2141] = "Erhaltet 10 Reittiere.",
	[2142] = "Erhaltet 25 Reittiere.",
	[2336] = "Erreicht bei den Blutsegelbukanieren den Status Wohlwollend und in der Beutebucht, der Ewigen Warte, Gadgetzan, Ratschet, dem Dunkelmond-Jahrmarkt, Rabenholdt und Shen'dralar den Status Ehrfürchtig.",
	[2357] = "Die Hexenmeisterquest zur Beschwörung eines Schreckensrosses von Xoroth abgeschlossen.",
	[2358] = "Die Paladinquest zur Erlangung eines Streitrosses abgeschlossen.",
	[2496] = "Erhaltet eine wässrige Quintessenz.",
	[3356] = "Erhaltet einen Frostsäbler aus Winterquell.",
	[5788] = "Erreicht bei den Shen'dralar den Status ehrfürchtig.",
	[16433] = "Erreicht Stufe 60 ohne zu sterben während der Saison der Meisterschaft.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Heldentaten",
	[92] = "Allgemein",
	[95] = "Spieler gegen Spieler",
	[96] = "Quests",
	[97] = "Erkundung",
	[168] = "Dungeon & Schlachtzug",
	[169] = "Berufe",
	[170] = "Kochkunst",
	[171] = "Angeln",
	[172] = "Erste Hilfe",
	[201] = "Ruf",
	[14777] = "Östliche Königreiche",
	[14778] = "Kalimdor",
	[14801] = "Alteractal",
	[14802] = "Arathibecken",
	[14804] = "Kriegshymnenschlucht",
	[14808] = "Classic",
	[14861] = "Classic",
	[14864] = "Classic",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "fr" then
localize(L.HEADER_NAMES, {
	[-1000013] = "Objets communs des vendeurs",
	[-1000015] = "Maître des démons",
	[-1000025] = "Évènements saisonniers",
	[-1000034] = "Instructrice de monte",
	[-1000040] = "Maître d'armes",
	[-1000048] = "Dragons du Cauchemar",
	[-1000162] = "Apparences Partagées",
	[-1000163] = "Apparence unique",
	[-1000165] = "Ensembles Tier 0.5",
	[-1000166] = "Capitaines",
	[-1000168] = "Les quatre cavaliers",
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (Est)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (Nord)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (Ouest)",
	[-1000179] = "Cimetière",
	[-1000180] = "Librairie",
	[-1000181] = "Armurerie",
	[-1000182] = "Cathédrale",
	[-1000185] = "Défenseurs Atal'ai",
	[-1000191] = "Battre un Lieutenant",
	[-1000192] = "Gagnez la Bataille",
	[-1000193] = "Parlez aux Morts",
	[-1000195] = "Parlez à Grizzby",
	[-1000196] = "Parlez à N'ora",
	[-1000198] = "Parlez à Frère Romulus",
	[-1000201] = "Foire de Sombrelune",
	[-1000223] = "Fête du Feu du solstice d’été",
	[-1000227] = "Concours de pêche de Strangleronce",
	[-1000234] = "Effort de guerre d’Ahn'Qiraj",
	[-1000235] = "L'ouverture de la Porte des ténèbres",
	[-1000236] = "Le Sceptre des Sables changeants",
	[-1000244] = "Edition Collector",
	[-1000273] = "Saison de Découverte",
	[-1000274] = "Compréhension",
	[-1000275] = "Étage 1",
	[-1000276] = "Étage 2",
	[-1000277] = "Chasse aux Monstres",
	[-1000278] = "Gravure",
	[-1000279] = "Fournitures isolées",
	[-1000373] = "Nouveau personnage",
	[-1000376] = "Bagarre Musclée",
	[-1000377] = "Polymorphe Sauvage",
	[-1000378] = "Courtiers D'âmes",
	[-1000380] = "Prime",
	[-1000970] = "Étage 3",
	[-1001035] = "Poisson de saison : bar d'été",
	[-1001036] = "Poisson de saison : calmar d'hiver",
	[-1001058] = "Bosquet du cauchemar",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000033] = "Contient des objets de récompenses ou disponibles dans d’autres contenus de la section qui les contient.\nIls sont regroupés ici dans le but de réduire la duplication de nombreuses sources possibles.",
	[-1000040] = "Un maître d'armes est un PNJ qui offre aux personnages la possibilité d'apprendre des compétences d'armes spécifiques, dont la disponibilité varie d'un maître d'armes à l'autre. Toutes les compétences d'armes peuvent être entraînées au niveau 1, à l'exception des armes d'hast qui nécessitent le niveau 20.\n\nL'entraînement avec un maître d'armes est devenu obsolète dans le patch 4.0.1, car toutes les compétences d'armes appropriées à la classe sont désormais apprises par chaque classe lors de sa création. Les maîtres d'armes ont été retirés du jeu peu de temps après.",
	[-1000162] = "Les éléments de cette liste sont des apparences partagées pour l'élément ci-dessus. En mode Apparence unique, cette liste peut vous aider à comprendre pourquoi ou pourquoi un élément spécifique serait marqué Collecté.",
	[-1000163] = "Cet article a une apparence unique. Vous devez collecter cet objet spécifiquement pour gagner l’apparence.",
	[-1000273] = "Cette saison apporte un niveau maximum initial de 25 et une nouvelle fin de partie de niveau 25, comprenant un raid Blackfathom Deeps à 10 joueurs avec de nouvelles mécaniques, des boss nouveaux et réinventés pour défier les tactiques et stratégies des joueurs, et de nouvelles récompenses.",
	[-1000278] = "La gravure de runes est un nouveau système récemment annoncé pour Season of Discovery. Il permet à chaque classe d'adapter son expérience de jeu en débloquant de nouvelles capacités uniques!",
	[-1000279] = "Les objets de quête Waylaid Supplies proviennent des foules de niveau 6 et surtout partout en Azeroth. Ces quêtes nécessitent la livraison des fournitures Waylaid à un représentant de l'organisation en échange de quelques pièces d'argent, d'expérience et de réputation. Bien sûr, il manque des articles dans la livraison de fournitures, et vous pouvez les compléter pour obtenir de plus grandes récompenses de réputation.",
	[-1000376] = "Seule la personne qui porte le coup final sur l'ivrogne obtiendra un crédit, peu importe qui a touché la cible en premier. Il n'y a pas de crédit de groupe pour cela.",
	[-1000377] = "Lancez Polymorph sur les créatures affectées par Wild Polymorph pour les transformer en apprentis. Chacun vous donnera une note. Collectez 6 notes pour apprendre la rune.",
	[-1000380] = "Cette liste contient des éléments impossibles à obtenir que ATT Discord a signalés comme des bogues que Blizzard n'a pas encore corrigés.\n\nREMARQUE : Tous les filtres sont ignorés dans cette liste pour des raisons de visibilité. Seuls les éléments retirés du jeu en raison d'une négligence plutôt que d'un gigantesque dragon cracheur de feu sont présents sur cette liste.\n\nAux développeurs de Blizzard : veuillez corriger les éléments et les rencontres répertoriés ci-dessous.",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "Artéfact",
});
localize(ObjectNames, {
	[31] = "Statue du vieux lion",
	[32] = "Coffre englouti",
	[33] = "Coffre verrouillé",
	[34] = "Vieille cruche",
	[35] = "Coffre du capitaine",
	[36] = "Tonneau cassé",
	[47] = "Avis de recherche !",
	[52] = "Chute des Gurubashi",
	[54] = "La tombe de l'empereur",
	[55] = "Un corps à moitié dévoré",
	[56] = "Cadavre de Rolf",
	[57] = "Lune surplombant la Vallée",
	[58] = "Gri'lek le Vagabond",
	[59] = "Monticule de poussière",
	[60] = "Avis de recherche : Gath'Ilzogg",
	[61] = "Un tombeau dégradé par les intempéries",
	[68] = "Avis de recherche",
	[76] = "Une jarre vide",
	[119] = "Caisse d'Abercrombie",
	[256] = "AVIS DE RECHERCHE",
	[257] = "Tonneau suspect",
	[259] = "Tonneau à moitié enseveli",
	[261] = "Caisse endommagée",
	[263] = "Ravitaillements de Kurzen",
	[264] = "Ravitaillements de Kurzen",
	[269] = "Tonneau de Tonneblonde gardé",
	[270] = "Tonneau de Tonneblonde non gardé",
	[271] = "Caisses de la Ligue des mineurs",
	[272] = "Placard à viande de MacGrann",
	[276] = "Panier à chatoyante",
	[287] = "Archives d'Hérode la Paperasse",
	[288] = "Coffre-fort d'Hérode la Paperasse",
	[290] = "Penderie de Furlbrow",
	[321] = "Larme de Tilloa",
	[331] = "Terre meuble",
	[333] = "Relique ancienne",
	[334] = "Relique ancienne",
	[375] = "Potiron de Tirisfal",
	[711] = "Avis de recherche !",
	[759] = "La source sacrée",
	[1166] = "Coffre d'Alexston",
	[1557] = "Table de dîner de Lillith",
	[1560] = "Coffre de stockage",
	[1561] = "Caisse scellée",
	[1562] = "Coffre du maréchal Haggard",
	[1571] = "Livres de sorts poussiéreux",
	[1585] = "Charge explosive",
	[1586] = "Caisse de bougies",
	[1593] = "Bateau chargé de cadavres",
	[1594] = "Etagère de livres de Berard",
	[1599] = "Tombe peu profonde",
	[1609] = "Catapulte des Gueules-de-dragon",
	[1610] = "Filon d'incendicite",
	[1627] = "Caisse de Dalaran",
	[1673] = "Gangrenoix",
	[1721] = "Boulet et chaîne verrouillés",
	[1722] = "Boulet et chaîne verrouillés",
	[1723] = "Fleurs de fangemufle",
	[1727] = "Tonneau de Shindigger",
	[1728] = "Carpette poussiéreuse",
	[1736] = "Chargement de fer",
	[1738] = "Documents du Syndicat",
	[1739] = "Documents du Syndicat",
	[1740] = "Documents du Syndicat",
	[1759] = "Registre municipal d'Hillsbrad",
	[1760] = "Bibliothèque dégradée par les intempéries",
	[1761] = "Proclamation de Hautebrande",
	[1763] = "AVIS DE RECHERCHE",
	[1765] = "Coffre en bois usé",
	[1768] = "Flamme d'Azel",
	[1769] = "Flamme de Veraz",
	[1770] = "Flamme d'Uzel",
	[2008] = "Dangereux !",
	[2059] = "Un cadavre de Nain",
	[2068] = "Porto Pupellyverbos",
	[2076] = "Chaudron bouillonnant",
	[2083] = "Correspondance de la Voile sanglante",
	[2084] = "Racine de Musquash",
	[2086] = "Cartes de la Voile sanglante",
	[2087] = "Ordres de la Voile sanglante",
	[2289] = "Canot de sauvetage abîmé",
	[2553] = "Un parchemin trempé",
	[2554] = "Devinette de Cortello",
	[2555] = "Parchemin moisi",
	[2560] = "Bouteille à moitié ensevelie",
	[2576] = "Autel des marées",
	[2652] = "Cadavre d'Ebenezer Bouclerouille",
	[2656] = "Lettre détrempée",
	[2688] = "Clé cruciale",
	[2689] = "Pierre de Lien occidentale",
	[2690] = "Pierre de Lien extérieure",
	[2691] = "Pierre de Lien orientale",
	[2701] = "Fragments iridescents",
	[2702] = "Pierre de Lien intérieure",
	[2704] = "Cache d'explosifs",
	[2707] = "Cartes de la Folie de la Vierge",
	[2708] = "Cartes de l'Esprit des Pins argentés",
	[2709] = "Journal de la Folie de la Vierge",
	[2710] = "Journal de l'Esprit des Pins argentés",
	[2712] = "Gemme elfique calcifiée",
	[2713] = "Tableau des recherches",
	[2714] = "Granit d'Alterac",
	[2716] = "Coffre de Trelane",
	[2717] = "Cantine de Trelane",
	[2718] = "Coffret de Trelane",
	[2724] = "Sac d'avoine",
	[2734] = "Coffre détrempé",
	[2739] = "Coffre de la plume noire",
	[2740] = "Coffre de la griffe du corbeau",
	[2741] = "Coffre des cieux",
	[2742] = "Coffre du nichoir",
	[2743] = "Urne en pierre gravée",
	[2744] = "Palourde géante",
	[2842] = "Pilier de diamant",
	[2848] = "Pilier d'opale",
	[2858] = "Pilier d'améthyste",
	[2867] = "Caisse de ravitaillement pour l'excavation",
	[2868] = "Carte chiffonnée",
	[2875] = "Squelette de Nain décrépi",
	[2891] = "Crânes trophées de Balia'mah",
	[2892] = "Crânes trophées de Ziata'jai",
	[2893] = "Crânes trophées de Zul'Mamwe",
	[2907] = "Cruche d'eau",
	[2908] = "Caisse de ravitaillements scellée",
	[2910] = "Pierre de puits",
	[2912] = "Pomme de pin",
	[2933] = "Sceau de la Terre",
	[3076] = "Carte couverte de poussière",
	[3189] = "Plan d'attaque : Vallée des Épreuves",
	[3190] = "Plan d'attaque : Village de Sen’jin",
	[3192] = "Plan d'attaque : Orgrimmar",
	[3236] = "Boîte à outils gnome",
	[3237] = "Sombrelance emprisonné",
	[3238] = "Tonneau vide de Chen",
	[3239] = "Coffre de Benedict",
	[3240] = "Œuf de fouette-queue",
	[3290] = "Sac de ravitaillement dérobé",
	[3525] = "L'Autel de feu",
	[3640] = "Champignon chargé",
	[3642] = "Butin des Kolkar",
	[3643] = "Vieille cantine",
	[3644] = "Machine volante de Bael Modan",
	[3646] = "Coffre du général Doublenattes",
	[3685] = "Antre des silithides",
	[3737] = "Fissure bouillonnante",
	[3767] = "Marché de Drizzlik",
	[3768] = "Fragile – Ne pas jeter",
	[3972] = "AVIS DE RECHERCHE",
	[4072] = "Valve de contrôle principale",
	[4141] = "Console de contrôle",
	[4406] = "Œufs d'araignées Tissebois",
	[4608] = "Pousse de sylvain",
	[5620] = "Pierres de puissance imparfaites",
	[6751] = "Plante aux fruits étranges",
	[6752] = "Plantes aux feuilles étranges",
	[6906] = "Nid de raptor rouge",
	[6907] = "Nid de raptor bleu",
	[6908] = "Nid de raptor jaune",
	[7510] = "Racine éclose",
	[9630] = "Fossile de Flagongut",
	[10076] = "Coupe de divination",
	[11713] = "Amanite phalloïde",
	[11714] = "Pédoncule d'amanite",
	[12666] = "Tome du Crépuscule",
	[13360] = "Relique de Mathystra",
	[13891] = "Fleur de serpent",
	[13949] = "Coffre de fer",
	[15084] = "Le Brille-o-Matic 5200",
	[15085] = "Le Brille-o-Matic 5200",
	[16393] = "Flamme antique",
	[17182] = "Bigobox 827",
	[17183] = "Bigobox 411",
	[17184] = "Bigobox 323",
	[17188] = "Le Lai d'Ameth'Aran",
	[17189] = "La Chute de Ameth'Aran",
	[17282] = "Botte de plantes",
	[17783] = "Statuette antique",
	[19015] = "Larme d'Elune",
	[19016] = "Buisson couvert de poussière d'étoile",
	[19021] = "Coffre rouillé",
	[19022] = "Coffre usé",
	[19024] = "Autel caché",
	[19027] = "Tome de Mel'Thandris",
	[19030] = "Monticule de poussière",
	[19283] = "Compendium des Déchus",
	[19284] = "Mythologie des Titans",
	[19595] = "Banque du portier",
	[19596] = "Cache des Dormants",
	[19597] = "Cache des druides",
	[19598] = "Cache des saisons",
	[19599] = "Provision du corbeau",
	[19602] = "Plans d'ingénieur de la KapitalRisk.",
	[19603] = "Documents de la KapitalRisk.",
	[19861] = "Journal d'Henrig Lonebrow",
	[19869] = "Décombres de chariot explosif",
	[19877] = "Placard de Velinde",
	[19901] = "Cercle d'emprisonnement",
	[20352] = "Cercle d'emprisonnement",
	[20359] = "Œuf d'Onyxia",
	[20447] = "Nourriture de harpie",
	[20691] = "Cantine de Cozzle",
	[20725] = "L'Héritage des aspects",
	[20726] = "Naissance de la menace des morts-vivants",
	[20727] = "Caisse du Bidulium",
	[20805] = "Plans de Séhouf",
	[20807] = "Brasero antique",
	[20920] = "Racines de Feuillebleue",
	[20985] = "Poussière flottante",
	[20992] = "Bouclier noir",
	[21015] = "Traces de sabot",
	[21016] = "Traces de sabot",
	[21042] = "Ecusson de la garde de Theramore",
	[21052] = "Coffre des Défias",
	[21277] = "Caisse trouée",
	[21530] = "Manuel d'utilisateur de Sniffetarin",
	[22245] = "Sac de viande",
	[22246] = "Larme de Theradras",
	[22550] = "Cristaux de draenéthyste",
	[24798] = "Bois flotté séché au soleil",
	[28024] = "Coffre de la caravane",
	[28604] = "Caisse éparpillée",
	[30854] = "Artefact atal'ai",
	[30855] = "Artefact atal'ai",
	[30856] = "Artefact atal'ai",
	[32569] = "Coffre de Galen",
	[35251] = "Coffre de Karnitol",
	[35252] = "Relique ancienne",
	[36738] = "Le Livre d'Ur",
	[37099] = "Tablette atal'ai",
	[50935] = "Sac de maïs",
	[50936] = "Sac d'orge",
	[50937] = "Sac de seigle",
	[50961] = "Coffre de Malem",
	[50982] = "Le chêne carbonisé",
	[51708] = "Boue du tombeau d'Eliza",
	[58369] = "Coffre en fer dérobé",
	[58595] = "Planque de la Lame ardente",
	[61934] = "Brasero de la Flamme Dormante",
	[61935] = "Valve de réglage",
	[61936] = "Valve de contrôle du carburant",
	[68865] = "Bâtons de commandement de Sniffetarin",
	[85562] = "Coffre de Baguefer",
	[85563] = "Coffre de Dent-Morte",
	[86492] = "Caisse d'élunite",
	[89634] = "Corail de fer",
	[89635] = "Coquille brûlée par le soleil",
	[91138] = "Marteau de Jordan",
	[92013] = "Tome de la Cabale",
	[92420] = "Minerai de Bailor",
	[92423] = "Coffre endommagé",
	[93192] = "Cœur du bois",
	[102984] = "Boîte à outils de Bink",
	[102985] = "Gueules-de-loup de Balnir",
	[103574] = "Coffre de stockage rempli",
	[103628] = "Traité d'Ur sur la Magie des Ombres",
	[103821] = "Coffre de Doan",
	[104564] = "Seau d'outils de Bingles",
	[104569] = "Seau d'outils de Bingles",
	[104574] = "Seau d'outils de Bingles",
	[104575] = "Capsuleur soufflant de Bingles",
	[105169] = "Râtelier d'armes Agamand",
	[105170] = "Râtelier d'armes Agamand",
	[105171] = "Râtelier d'armes Agamand",
	[105172] = "Râtelier d'armes Agamand",
	[105174] = "Caisse de coffres de stockage",
	[105175] = "Chants de manifestation",
	[112888] = "Étagère poussiéreuse",
	[112948] = "Coffre verrouillé de l'Intrépide",
	[113757] = "Cachette d'Ombreforge",
	[113768] = "Oeuf de Pâques",
	[113791] = "Brasero de la Fontaine éternelle",
	[123329] = "Coffre de Baelog",
	[123462] = "Le Joyau des mers du Sud",
	[125477] = "Urne ostentatoire",
	[126049] = "Champignons magenta",
	[126158] = "Commode de Tallonkai",
	[126260] = "Coffre ancien",
	[129127] = "Coffret de Gallywix",
	[131474] = "Les disques de Norgannon",
	[138492] = "Fragments de Myzrael",
	[140911] = "Bobine de fil de soie chartreuse",
	[140971] = "Gahz'ridienne",
	[141812] = "Pierre de lien",
	[141832] = "Gong de Zul'Farrak",
	[141853] = "Tragan pourpre",
	[141857] = "Pierre de lien",
	[141858] = "Pierre de lien",
	[141859] = "Pierre de lien",
	[141931] = "Œuf d'hippogriffe",
	[141979] = "Trésor ancien",
	[141980] = "Coffret spectral",
	[142071] = "Œuf-O-Matic",
	[142076] = "Pommes fraîches de Clara",
	[142088] = "Tablette de volonté",
	[142122] = "Avis de recherche",
	[142127] = "Secret de Rin'ji",
	[142151] = "Tonneau scellé",
	[142179] = "Belvédère de Solarsal",
	[142181] = "Cargaison volée",
	[142184] = "Coffre du capitaine",
	[142185] = "Flamme de Byltan",
	[142186] = "Flamme de Lahassa",
	[142187] = "Flamme de Imbel",
	[142188] = "Flamme de Samha",
	[142189] = "Monument dissimulé",
	[142191] = "Caisse de ravitaillement de la Horde",
	[142195] = "Plan de bataille des Griffebois",
	[142343] = "Piédestal d'Uldum",
	[142344] = "Extrapolateur artificiel",
	[142345] = "Matrice d'encodage 3005-A",
	[142475] = "Matrice d'encodage 3005-B",
	[142476] = "Matrice d'encodage 3005-C",
	[142477] = "Coffre de Thermojoncteur",
	[142487] = "Le Brille-o-Matic 5200",
	[142696] = "Matrice d'encodage 3005-D",
	[142702] = "Bouteille de venin",
	[142715] = "Tablette de Theka",
	[142958] = "Féralas : une histoire",
	[143980] = "Parchemin gordunni",
	[144053] = "Equipement d'analyse de Scrimshank",
	[144054] = "Coffre de Shay",
	[144063] = "Monolithe d'Equinex",
	[144064] = "Monticule de poussière de Gordunni",
	[144066] = "Première cage de Fanécorce",
	[144067] = "Deuxième cage de Fanécorce",
	[144068] = "Troisième cage de Fanécorce",
	[144070] = "Cage de Bec-Tranchant",
	[147557] = "Argent volé",
	[148498] = "Autel de Suntara",
	[148499] = "Boîte de Felix",
	[148504] = "Une tombe ostentatoire",
	[148506] = "Artéfact du Crépuscule",
	[148512] = "Réceptacle d'essence",
	[148513] = "Tablette de Jin'yael",
	[148514] = "Tablette de Markri",
	[148515] = "Tablette de Sael'hai",
	[148516] = "Tablette de Beth'Amara",
	[148832] = "Statue atal'ai",
	[148836] = "Autel d'Hakkar",
	[148838] = "Idole d'Hakkar",
	[149025] = "Brasero de sentinelle",
	[149030] = "Brasero de sentinelle",
	[149031] = "Brasero de sentinelle",
	[149032] = "Brasero de sentinelle",
	[149036] = "Coffre de Marvon",
	[149047] = "Torche de vindicte",
	[149480] = "Rune de Jin'yael",
	[149481] = "Rune de Beth'Amara",
	[149482] = "Rune de Markri",
	[149483] = "Rune de Sael'hai",
	[149502] = "Trésor du Vol noir",
	[150075] = "Avis de recherche",
	[150140] = "Cristal de focalisation des arcanes",
	[151286] = "Tome d'invocation kaldorei",
	[152094] = "Champignon jacinthe",
	[152095] = "Lys pétale de lune",
	[152097] = "Brasero de Belnistrasz",
	[152608] = "Butin des Kolkar",
	[152618] = "Butin des Kolkar",
	[152622] = "Formation d'azsharite",
	[153123] = "Equipement de Kim'jael",
	[153205] = "Autel du Souilleur",
	[153239] = "Plume d'Indomptable",
	[153556] = "Relique de Thaurissan",
	[154357] = "Boue luisante",
	[156561] = "Avis de recherche",
	[157936] = "Tas de poussière d'Un'Goro",
	[160836] = "Coffret à relique",
	[160840] = "Monticule de terre",
	[160845] = "Coffre sombre",
	[161495] = "Coffre secret",
	[161504] = "Un petit paquet",
	[161505] = "Une épave de radeau",
	[161521] = "Equipement de recherche",
	[161526] = "Caisse de nourriture",
	[161527] = "Os de dinosaure",
	[161557] = "Récolte de Milly",
	[161752] = "Seau d'outils",
	[164659] = "Cristal de puissance vert",
	[164661] = "Cristal de puissance jaune",
	[164662] = "Boîtes d'équipement",
	[164689] = "Monument de Franclorn Le Forgebusier",
	[164778] = "Cristal de puissance bleu",
	[164780] = "Cristal de puissance rouge",
	[164798] = "Evoracine",
	[164820] = "Nom du Gardien noir",
	[164867] = "AVIS DE RECHERCHE",
	[164868] = "TUER À VUE",
	[164869] = "Calice spectral",
	[164885] = "Dragon nocturne corrompu",
	[164886] = "Fleur-de-chant corrompue",
	[164887] = "Fleur-de-vent corrompue",
	[164888] = "Navetille corrompue",
	[164909] = "Épave de barque",
	[164910] = "Coffre orné",
	[164911] = "Tonneau de Tonnebière",
	[164953] = "Grands sacs à dos en cuir",
	[164954] = "Alvéole de Zukk'ash",
	[164955] = "Pylône de cristal nord",
	[164956] = "Pylône de cristal ouest",
	[164957] = "Pylône de cristal est",
	[164958] = "Pousse de Pétale-de-sang",
	[165554] = "Cœur de la montagne",
	[166863] = "Carcasse fraîche de battrodon",
	[169243] = "Coffre des sept",
	[169294] = "Tablette des Sept",
	[171938] = "Pomme de cactus",
	[171939] = "Fleur-de-chant corrompue",
	[171942] = "Fleur-de-chant corrompue",
	[173232] = "Plans de forgeron",
	[173265] = "Toilettes en bois",
	[173266] = "Livre de Bonnacier",
	[173284] = "Navetille corrompue",
	[173324] = "Dragon nocturne corrompu",
	[173327] = "Fleur-de-vent corrompue",
	[174594] = "Fleur-de-chant corrompue",
	[174595] = "Fleur-de-chant corrompue",
	[174596] = "Fleur-de-chant corrompue",
	[174597] = "Fleur-de-chant corrompue",
	[174598] = "Fleur-de-chant corrompue",
	[174599] = "Fleur-de-vent corrompue",
	[174600] = "Fleur-de-vent corrompue",
	[174601] = "Fleur-de-vent corrompue",
	[174602] = "Fleur-de-vent corrompue",
	[174603] = "Fleur-de-vent corrompue",
	[174604] = "Fleur-de-vent corrompue",
	[174605] = "Navetille corrompue",
	[174606] = "Navetille corrompue",
	[174607] = "Navetille corrompue",
	[174608] = "Dragon nocturne corrompu",
	[174682] = "Attention aux pterreurdactyles",
	[174684] = "Dragon nocturne corrompu",
	[174686] = "Navetille corrompue",
	[174708] = "Fleur-de-vent corrompue",
	[174709] = "Fleur-de-vent corrompue",
	[174712] = "Fleur-de-chant corrompue",
	[174713] = "Fleur-de-chant corrompue",
	[174728] = "Caisse endommagée",
	[174848] = "Equipement de test",
	[175084] = "Le Brille-o-Matic 5200",
	[175165] = "Coffret de l'Aube argentée",
	[175166] = "Coffret du Voile de brume",
	[175207] = "Créature marine échouée",
	[175226] = "Créature marine échouée",
	[175227] = "Créature marine échouée",
	[175230] = "Créature marine échouée",
	[175233] = "Créature marine échouée",
	[175245] = "Flamme du père",
	[175264] = "Essence de rejeton",
	[175320] = "AVIS DE RECHERCHE : Fondeboue !",
	[175324] = "Éclats cognegivre",
	[175329] = "Réserves de noix des Noirbois",
	[175330] = "Réserves de fruits des Noirbois",
	[175331] = "Réserves de céréales des Noirbois",
	[175334] = "Affaires de Bijou",
	[175369] = "Entrée de service de la place des Anciens",
	[175382] = "Coffret de Frèteruine",
	[175384] = "Œuf de wyverne de Haut-perchoir",
	[175385] = "Tablette de Sombrepierre",
	[175407] = "Plume de chouettard lunaire",
	[175487] = "Troisième tablette Mosh'aru",
	[175488] = "Quatrième Tablette Mosh'aru",
	[175524] = "Mystérieux cristal rouge",
	[175565] = "Œuf étrange",
	[175566] = "Herbe des ténèbres",
	[175586] = "Chariot de Jaron",
	[175587] = "Caisse endommagée",
	[175606] = "Œuf d'araignée du pic",
	[175621] = "Autel des offrandes d'Urok",
	[175629] = "Fournitures de Jaron",
	[175704] = "Lettre roussie",
	[175708] = "Caisses de ravitaillement de la Croisée",
	[175785] = "Documents discrets",
	[175802] = "Petit coffret",
	[175886] = "Pique de fortune",
	[175888] = "Fragment de relique de Bien-né",
	[175889] = "Œuf antique",
	[175891] = "Fragment de relique de Bien-né",
	[175892] = "Fragment de relique de Bien-né",
	[175893] = "Fragment de relique de Bien-né",
	[175894] = "Colis de Janice",
	[175924] = "Cabinet verrouillé",
	[175925] = "Toilettes",
	[175926] = "Journal de Mme Dalson",
	[175928] = "Agave d'incendia",
	[175944] = "Feu de vie sacré",
	[175949] = "Cinquième tablette Mosh'aru",
	[175950] = "Sixième tablette Mosh'aru",
	[175965] = "Fluide d’embaumement de Murmegivre",
	[175966] = "Fil écarlate enchanté",
	[175970] = "Cuirasse runique inachevée",
	[176089] = "Gantelets en plaques inachevés",
	[176090] = "Cadavres humains",
	[176091] = "Chaudron des Mort-bois",
	[176092] = "Boîte de bombes incendiaires",
	[176112] = "Coffre de Malor",
	[176115] = "Avis de recherche : Arnak Totem-sinistre",
	[176116] = "Tête de la poupée de Pamela",
	[176142] = "Flanc gauche de la poupée de Pamela",
	[176143] = "Flanc droit de la poupée de Pamela",
	[176145] = "Monument de Joseph Senterouge",
	[176150] = "Tome moisi",
	[176158] = "Brasero de la Douleur",
	[176159] = "Brasero de la Malice",
	[176160] = "Brasero de la Souffrance",
	[176161] = "Brasero de la Haine",
	[176189] = "Squelette de tortue de mer",
	[176190] = "Tortue de mer échouée",
	[176191] = "Tortue de mer échouée",
	[176192] = "Catalogue de l'Indocile",
	[176196] = "Tortue de mer échouée",
	[176197] = "Tortue de mer échouée",
	[176198] = "Tortue de mer échouée",
	[176206] = "Libram de Davil",
	[176207] = "Bouclier de Senterouge",
	[176208] = "Crâne d'Horgus",
	[176209] = "Epée brisée de Marduk",
	[176213] = "Sang des héros",
	[176245] = "Archives écarlates",
	[176249] = "Donnée du Fléau",
	[176317] = "Le Coffre d'argent",
	[176325] = "Plans de forgeron",
	[176344] = "Coffre de documents",
	[176356] = "Textes sacrés des Bien-nés",
	[176361] = "Chaudron du Fléau",
	[176392] = "Chaudron du Fléau",
	[176393] = "Chaudron du Fléau",
	[176484] = "Titre de propriété de Brill",
	[176485] = "Titre de propriété de Caer Darrow",
	[176486] = "Titre de propriété d’Austrivage",
	[176487] = "Titre de propriété de Moulin-de-Tarren",
	[176544] = "Cadavre d'Eva Sarkhoff",
	[176545] = "Cadavre de Lucien Sarkhoff",
	[176581] = "Cristal de la Main d'Iruxos",
	[176582] = "Casier à crustacés",
	[176630] = "Livre du souvenir",
	[176631] = "Don de Menethil",
	[176634] = "Coffre de Kerlonian",
	[176751] = "Os de kodo",
	[176785] = "Caisse de munitions",
	[176793] = "Fagot de bois",
	[177240] = "Mont fangeux",
	[177241] = "Phylactère d'Araj",
	[177243] = "Portail démoniaque",
	[177264] = "Symbole de l'honneur perdu",
	[177287] = "Peinture inachevée",
	[177289] = "Chaudron du Fléau",
	[177464] = "Grande termitière",
	[177490] = "Caisse de la scierie de la Crête du nord",
	[177491] = "Tonneau de termites",
	[177544] = "Coffre de Joseph",
	[177624] = "Sac des démons de Xabraxxis",
	[177667] = "Parchemin déchiré",
	[177675] = "Monticule de poussière",
	[177747] = "Registre de Quel'Thalas",
	[177750] = "Floraison fongique lunaire",
	[177784] = "Praire géante",
	[177786] = "Coffre de Rackmore",
	[177787] = "Journal de Rackmore",
	[177789] = "Livre de compte d'Augustus",
	[177804] = "Restes humains mutilés",
	[177805] = "Restes humains mutilés",
	[177806] = "Restes humains mutilés",
	[177904] = "Avis de recherche : Besseleth",
	[177926] = "Graine de Gaïa",
	[177929] = "Monticule de poussière de Gaïa",
	[177964] = "Pierre de la Brasse",
	[178084] = "Coffre de Felix",
	[178085] = "Seau de boulons de Felix",
	[178087] = "Pioche de Thazz'ril",
	[178090] = "Tombe de Marla",
	[178104] = "Cristal de résonite",
	[178144] = "Coffre de Troll",
	[178145] = "Gangue de résonite",
	[178184] = "Saphir d’Aku’Mai",
	[178185] = "Saphir d’Aku’Mai",
	[178186] = "Saphir d’Aku’Mai",
	[178195] = "Huile chanteguerre",
	[178204] = "Cargaison de haches chanteguerres",
	[178227] = "Panier à Totems de Murgut",
	[178553] = "Alvéole de la Ruche'Ashi",
	[178609] = "Neige d'hiver",
	[179485] = "Piège cassé",
	[179499] = "Panier de tanin ogre",
	[179501] = "Réserve de Noué Dédodevie",
	[179516] = "Coffre de Fengus",
	[179517] = "Trésor des Shen'dralar",
	[179544] = "Squelette de Telmius Cherche-Rêve",
	[179545] = "Le coffre du prince",
	[179547] = "Un tome poussiéreux",
	[179551] = "Coffre d'Hydraxis",
	[179552] = "Schéma : Robot réparateur 74A",
	[179553] = "Fragment du Magma",
	[179559] = "Fragment de gangrevigne",
	[179562] = "Ancienne épée chauffée",
	[179564] = "Tribut des Gordok",
	[179565] = "Reliquaire poussiéreux",
	[179697] = "Coffre au trésor de l'arène",
	[179703] = "Cachette du seigneur du Feu",
	[179826] = "Plans secrets : Flux embrasé",
	[179827] = "Avis de recherche / Disparu / Trouvé & Perdu",
	[179828] = "Oreiller sombrefer",
	[179832] = "Oreiller brodé de Pincetaie",
	[179879] = "Orbe de commandement",
	[179880] = "Marque de Drakkisath",
	[179913] = "Aux armes !",
	[179914] = "Pile d'ossements",
	[179915] = "Pile de crânes",
	[179922] = "Calice de sang corrompu",
	[180215] = "Filon de thorium hakkari",
	[180229] = "Pile de déchets",
	[180248] = "Banc de courbines",
	[180327] = "Brasero de la Folie",
	[180366] = "Boîte d'appâts abîmée",
	[180368] = "Tablette de la folie",
	[180369] = "Eaux troubles et agitées",
	[180435] = "Sacoche de Noggle",
	[180436] = "Fragment de la tablette du Crépuscule",
	[180448] = "Avis de recherche : Poigne-de-mort",
	[180453] = "Cristal orné de glyphes de la Ruche'Regal",
	[180454] = "Cristal orné de glyphes de la Ruche'Ashi",
	[180455] = "Cristal orné de glyphes de la Ruche'Zora",
	[180456] = "Pierre des vents inférieure",
	[180461] = "Pierre du vent",
	[180466] = "Pierre des vents supérieure",
	[180501] = "Fragment de la tablette du Crépuscule",
	[180503] = "Livre de cuisine sableux",
	[180526] = "Gong de Bethekk",
	[180570] = "Tonneau",
	[180633] = "Larme cristalline",
	[180642] = "Caisse anodine",
	[180652] = "Terre fraîchement remuée",
	[180662] = "Débris de goélette",
	[180665] = "Le draconique pour les nuls",
	[180666] = "Le draconique pour les nuls",
	[180667] = "Le draconique pour les nuls",
	[180669] = "Maelström tourbillonnant",
	[180682] = "Banc de bouches-noires huileux",
	[180684] = "Banc de grandes sagerelles",
	[180685] = "Débris trempés",
	[180690] = "Grand coffre de scarabées",
	[180691] = "Coffre de scarabées",
	[180712] = "Banc d'anguilles pierre-écaille",
	[180717] = "Le gong du Scarabée",
	[180743] = "Cadeau soigneusement emballé",
	[180746] = "Cadeau secoué doucement",
	[180747] = "Cadeau à l'emballage multicolore",
	[180748] = "Cadeau tic-taquant",
	[180751] = "Débris flottants",
	[180793] = "Cadeau de fête",
	[180794] = "Journal de Jandice Barov",
	[180901] = "Débris de la Voile sanglante",
	[181053] = "Panier de varech de sang",
	[181073] = "Chaudron parfumé",
	[181074] = "Butin de l'arène",
	[181083] = "Possessions de Sothos et Jarien",
	[181085] = "Caisse de fournitures de Stratholme",
	[181098] = "Cendre volcanique",
	[181366] = "Coffre des quatre cavaliers",
	[181597] = "Monticule de silithyste",
	[181598] = "Geyser de silithyste",
	[181672] = "Effigie de l'homme d'osier",
	[181686] = "Tas de bois",
	[181687] = "Tas de bois",
	[190483] = "Coffre de documents",
	[190484] = "Coffre de documents",
	[201579] = "Éclat de la pierre de voûte",
	[207724] = "Débris d’épave",
	[375544] = "Figurine en bois",
	[386675] = "Trésor enfoui",
	[386691] = "Livre de la bibliothèque",
	[386759] = "Livre de la bibliothèque",
	[386777] = "Coffre poussiéreux",
	[387466] = "Coffret poussiéreux",
	[387477] = "Boîte de rangement des Défias",
	[392029] = "Récompense de l’épéiste",
	[397987] = "Boîte de rangement de Kobold",
	[402215] = "Note calcinée",
	[403041] = "Fournitures pour dynamitage",
	[403102] = "Cache à butin dos-hirsute",
	[403105] = "Cône de Furie-des-vents",
	[403718] = "Fleur de prairie",
	[404352] = "Entrepôt de l’Artéfact",
	[404433] = "Coffre lunaire",
	[404695] = "Boîte de rangement détrempée",
	[404830] = "Coffre poussiéreux",
	[404911] = "Cache dissimulée",
	[404941] = "Coffret à relique",
	[405149] = "Fresque de Ta’zo",
	[405201] = "Cache de l’épave",
	[405628] = "Cache à butin crins-de-givre",
	[405633] = "Cantine mâcheroc",
	[405879] = "Manuel de la Société des apothicaires",
	[405946] = "Coffre poussiéreux",
	[406736] = "Planque perdue",
	[406918] = "Sac de messager",
	[407117] = "Nid de gueule d’acier abandonné",
	[407120] = "Nid de gueule d’acier vide",
	[407247] = "Fleur de la clairière",
	[407289] = "Bannière de guerre de la Horde",
	[407291] = "Bannière de guerre de l’Alliance",
	[407312] = "Idole affamée",
	[407347] = "Autel des épines",
	[407454] = "Baril de poudre à canon",
	[407457] = "Malle de palefrenier",
	[407505] = "Sculpture gravée",
	[407510] = "Sculpture gravée",
	[407566] = "Tome gobelin",
	[407731] = "Boîte à outils de maçon",
	[407734] = "Cache pin-tordu",
	[407850] = "Reliquaire englouti",
	[407918] = "Présentoir à trophées vide",
	[407983] = "Pile de livres dérobés",
	[408004] = "Pile de chancre enchevêtré",
	[408014] = "Tome gnome",
	[408718] = "Réserve d’équipement",
	[408799] = "Idole des profondeurs",
	[408802] = "Harpon noueux",
	[409289] = "Orbe étrange",
	[409315] = "Orbe fracassé",
	[409496] = "Parchemins",
	[409501] = "Abrégé de Dalaran",
	[409562] = "Grimoire",
	[409692] = "Parchemins",
	[409700] = "Manuel",
	[409711] = "Parchemins",
	[409717] = "Parchemins",
	[409731] = "Parchemins",
	[409735] = "Grimoire",
	[409754] = "Bouclier mural",
	[409758] = "Heaume abandonné",
	[409942] = "Statue de chouettes jumelles",
	[410020] = "Statue de chouette",
	[410299] = "Secrets arcaniques",
	[410369] = "Piquet boîte morte",
	[410847] = "Coffre rouillé",
	[411328] = "Os endormis",
	[411348] = "Coffre poussiéreux",
	[411358] = "Coffre d’artisan",
	[411674] = "Prophétie de la chute d’un roi",
	[412224] = "Pierre de rituel des ténèbres",
	[414532] = "Coffre de la Bondissante",
	[414624] = "Planque du phare",
	[414646] = "Vestige",
	[414658] = "Débris",
	[414663] = "Idole Briselance",
	[414713] = "Vestiaire",
	[415106] = "Restes brûlés",
	[415107] = "Restes brûlés",
	[415614] = "Formules mystérieuses",
	[417072] = "Planche à clous",
	[417353] = "Feu de camp éteint",
	[418855] = "Cache de butin d’Illari",
	[422483] = "Recycle-o-Matic 9000",
	[422911] = "Tonneau scellé",
	[422919] = "Fût ombreforge en perce",
	[423569] = "Bourse perdue",
	[423695] = "Libram de délivrance",
	[423703] = "Marteau de guerre brisé",
	[423841] = "Dépouille gelée",
	[424005] = "Litière de poche",
	[424006] = "Besace roulée à la hâte",
	[424007] = "Figurine sculptée",
	[424010] = "Planche clouée",
	[424012] = "Monticule de terre",
	[424074] = "Balise de quandrangulation 001",
	[424075] = "Balise de quandrangulation 002",
	[433596] = "Coffre de guerre envoûté",
	[439557] = "Mousse des cauchemars",
	[439558] = "Gisement de fer froid",
	[439627] = "Oniracine",
	[439628] = "Filon de pyrite",
	[439762] = "Lotus stellaire",
	[439778] = "Veine d’astrargent",
	[439810] = "Racine lunaire",
	[439815] = "Formation de pierre de lune supérieure",
	[441113] = "Texte de l’ogre magi",
	[441114] = "Boîte mystérieuse",
	[441119] = "Œuf de dragon vert non-éclos",
	[441124] = "Œuf de dragon touché par le Rêve",
	[441128] = "Caisse vibrante",
	[441129] = "Prophétie d’Azshara",
	[441133] = "Œuf de dragon touché par les étoiles",
	[441140] = "Boîte bourdonnante",
	[441141] = "Perle onirique",
	[441222] = "Tumulus",
	[441310] = "Œuf de dragon lueur-de-lune",
	[441312] = "Notes du gardien fou",
	[441314] = "Diatribe de harpie",
	[441848] = "Petit terrier",
	[441946] = "Sanctuaire de la Lune",
	[441947] = "Sanctuaire de la Bête",
	[441948] = "Sanctuaire du gardien",
	[455812] = "Épée de l’écuyer Cuthbert",
	[457088] = "Maniement avancé de l’épée",
	[457089] = "Le lien de l’ombre",
	[457090] = "Forestiers célèbres (et funestes) d’Azeroth",
	[457091] = "Manuel d’entraînement de Chen",
	[457092] = "La fureur de Hurlorage",
	[457093] = "Justice expéditive : l’histoire d’un Nain",
	[457094] = "La véritable nature de la Lumière",
	[457095] = "Les éléments pour les Nuls, vol. 1 : Givre",
	[457096] = "Arriver premier : la boxe pour les bastonneurs",
	[457097] = "Les éléments pour les Nuls, vol. 2 : Feu",
	[457098] = "Trouver votre félin intérieur : guide du druidisme moderne",
	[457099] = "Guide de l’encaissement des beignes, par Zirène",
	[457100] = "Réflexions de Renzik sur les combats « à la loyale »",
	[457101] = "Les rites de Mak’Gora",
	[457102] = "Les éléments pour les Nuls, vol. 3 : Arcanes",
	[462233] = "Roche en fusion chatoyante",
	[462236] = "Coffre mystérieux",
	[495500] = "Cache d’Ombreflamme",
	[495503] = "Trésor chromatique",
	[495505] = "Richesse chérie",
	[100000001] = "Torche éteinte",
});
for key,value in pairs({
	[11] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 1 du WoW Classic.|r",
	[1606] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 2 du Season of Discovery.|r",
	[1607] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 3 du Season of Discovery.|r",
	[1608] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 4 du Season of Discovery.|r",
	[1609] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 5 du Season of Discovery.|r",
	[1610] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 6 du Season of Discovery.|r",
	[1611] = "|cFFAAFFAACeci n'était pas disponible avant le Phase 7 du Season of Discovery.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "Niveau 10",
	[7] = "Niveau 20",
	[8] = "Niveau 30",
	[9] = "Niveau 40",
	[10] = "Niveau 50",
	[11] = "Niveau 60",
	[42] = "Exploration des Royaumes de l'est",
	[43] = "Exploration de Kalimdor",
	[121] = "Compagnon cuisinier",
	[122] = "Expert cuisinier",
	[123] = "Artisan cuisinier",
	[126] = "Compagnon pêcheur",
	[127] = "Expert pêcheur",
	[128] = "Artisan pêcheur",
	[131] = "Compagnon secouriste",
	[132] = "Expert secouriste",
	[133] = "Artisan secouriste",
	[238] = "Une victoire honorable",
	[239] = "25 000 victoires honorables",
	[306] = "Maître pêcheur d'Azeroth",
	[389] = "Maître de l'arène des Gurubashi",
	[396] = "Grand maître de l'arène des Gurubashi",
	[416] = "Seigneur scarabée",
	[424] = "Pourquoi ? Parce que !!!",
	[425] = "Atiesh, grand bâton du Gardien",
	[428] = "Lame-tonnerre, épée bénie du Cherchevent",
	[429] = "Sulfuras, Main de Ragnaros",
	[509] = "10 000 victoires honorables",
	[512] = "5 000 victoires honorables",
	[513] = "100 victoires honorables",
	[515] = "500 victoires honorables",
	[516] = "1 000 victoires honorables",
	[520] = "20 réputations exaltées",
	[521] = "15 réputations exaltées",
	[522] = "Quelqu'un m'aime",
	[523] = "5 réputations exaltées",
	[524] = "10 réputations exaltées",
	[546] = "Chambre forte",
	[627] = "Exploration de Dun Morogh",
	[628] = "Mortemines",
	[629] = "Gouffre de Ragefeu",
	[630] = "Cavernes des Lamentations",
	[631] = "Donjon d’Ombrecroc",
	[633] = "Prison de Hurlevent",
	[635] = "Kraal de Tranchebauge",
	[636] = "Souilles de Tranchebauge",
	[641] = "Temple englouti",
	[642] = "Profondeurs de Rochenoire",
	[643] = "Bas du pic Rochenoire",
	[684] = "Le repaire d'Onyxia (niveau 60)",
	[685] = "Repaire de l’Aile noire",
	[686] = "Cœur du Magma",
	[687] = "Temple d’Ahn’Qiraj",
	[688] = "Zul’Gurub",
	[689] = "Ruines d'Ahn'Qiraj",
	[706] = "Hurleur loup-de-givre",
	[707] = "Destrier de bataille foudrepique",
	[708] = "Héros du clan Loup-de-givre",
	[709] = "Héros de la garde Foudrepique",
	[710] = "Profanateur",
	[711] = "Chevalier d'Arathor",
	[712] = "Voltigeur Chanteguerre",
	[713] = "Sentinelle d'Aile-argent",
	[714] = "Conquérant",
	[727] = "Voilà la cavalerie",
	[728] = "Exploration de Durotar",
	[729] = "Rênes de destrier de la mort",
	[736] = "Exploration de Mulgore",
	[750] = "Exploration des Tarides",
	[760] = "Exploration des montagnes d'Alterac",
	[761] = "Exploration des hautes-terres Arathies",
	[765] = "Exploration des Terres ingrates",
	[766] = "Exploration des Terres foudroyées",
	[768] = "Exploration des clairières de Tirisfal",
	[769] = "Exploration de la forêt des Pins argentés",
	[770] = "Exploration des Maleterres de l'ouest",
	[771] = "Exploration des Maleterres de l'est",
	[772] = "Exploration des contreforts de Hautebrande",
	[773] = "Exploration des Hinterlands",
	[774] = "Exploration de la gorge des Vents brûlants",
	[775] = "Exploration des Steppes ardentes",
	[776] = "Exploration de la forêt d'Elwynn",
	[777] = "Exploration du défilé de Deuillevent",
	[778] = "Exploration du bois de la Pénombre",
	[779] = "Exploration du Loch Modan",
	[780] = "Exploration des Carmines",
	[781] = "Exploration de la vallée de Strangleronce",
	[782] = "Exploration du marais des Chagrins",
	[802] = "Exploration de la marche de l'Ouest",
	[841] = "Exploration des Paluns",
	[842] = "Exploration de Teldrassil",
	[844] = "Exploration de Sombrivage",
	[845] = "Exploration d'Orneval",
	[846] = "Exploration des Mille pointes",
	[847] = "Exploration des Serres-Rocheuses",
	[848] = "Exploration de Désolace",
	[849] = "Exploration de Féralas",
	[850] = "Exploration du marécage d'Âprefange",
	[851] = "Exploration du désert de Tanaris",
	[852] = "Exploration d'Azshara",
	[853] = "Exploration de Gangrebois",
	[854] = "Exploration du cratère d'Un'Goro",
	[855] = "Exploration de Reflet-de-Lune",
	[856] = "Exploration de Silithus",
	[857] = "Exploration du Berceau-de-l'Hiver",
	[871] = "En avant toutes, Amiral !",
	[879] = "Monture de la vieille école",
	[880] = "Tigre zulien rapide",
	[881] = "Raptor razzashi rapide",
	[891] = "En selle !",
	[907] = "Le justicier",
	[940] = "Les vertes collines de Strangleronce",
	[944] = "Il y a de l'amour dans ce tunnel",
	[946] = "L'Aube d'argent",
	[955] = "Les Hydraxiens",
	[956] = "Progéniture de Nozdormu",
	[957] = "Héros de la tribu Zandalar",
	[1307] = "Sommet du pic Rochenoire",
	[1676] = "Maître des traditions des Royaumes de l'est",
	[1677] = "Maître des traditions des Royaumes de l'est",
	[1678] = "Maître des traditions de Kalimdor",
	[1680] = "Maître des traditions de Kalimdor",
	[2116] = "Tabard de l'Aube d'argent",
	[2141] = "Gardien d'écuries",
	[2142] = "L'écurie se remplit",
	[2336] = "Tous des malades",
	[2357] = "Destrier de l'effroi de Xoroth",
	[2358] = "Destrier",
	[2496] = "Le cinquième élément",
	[3356] = "Sabre-de-givre de Berceau-de-l'Hiver",
	[5788] = "Agent des Shen’dralar",
	[16433] = "Âme de fer (saison de la Maîtrise)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "Atteindre le niveau 10.",
	[7] = "Atteindre le niveau 20.",
	[8] = "Atteindre le niveau 30.",
	[9] = "Atteindre le niveau 40.",
	[10] = "Atteindre le niveau 50.",
	[11] = "Atteindre le niveau 60.",
	[42] = "Explorer les régions des Royaumes de l'est.",
	[43] = "Explorer les régions de Kalimdor.",
	[121] = "Devenir un compagnon cuisinier.",
	[122] = "Devenir un expert cuisinier.",
	[123] = "Devenir un artisan cuisinier.",
	[126] = "Devenir un compagnon pêcheur.",
	[127] = "Devenir un expert pêcheur.",
	[128] = "Devenir un artisan pêcheur.",
	[131] = "Devenir un compagnon secouriste.",
	[132] = "Devenir expert secouriste.",
	[133] = "Devenir artisan secouriste.",
	[238] = "Obtenir une victoire honorable.",
	[239] = "Obtenir 25 000 victoires honorables.",
	[306] = "Gagner le concours de pêche de Baie-du-Butin ou le tournoi de pêche kalu'ak.",
	[389] = "Obtenir le bijou Maître de l'arène dans l'arène des Gurubashi.",
	[396] = "Achever la quête de Court John Mithril pour obtenir le bijou Grand maître de l'arène.",
	[416] = "Avoir ouvert les portes d'Ahn'Qiraj.",
	[424] = "Obtenir un cristal de résonance qiraji rouge.",
	[425] = "S'équiper d'Atiesh, grand bâton du Gardien.",
	[428] = "S'équiper de la Lame-tonnerre, épée bénie du Cherchevent.",
	[429] = "S'équiper de Sulfuras, Main de Ragnaros.",
	[509] = "Obtenir 10 000 victoires honorables.",
	[512] = "Obtenir 5 000 victoires honorables.",
	[513] = "Obtenir 100 victoires honorables.",
	[515] = "Obtenir 500 victoires honorables.",
	[516] = "Obtenir 1 000 victoires honorables.",
	[520] = "Monter 20 réputations jusqu'à Exalté.",
	[521] = "Monter 15 réputations jusqu'à Exalté.",
	[522] = "Monter une réputation jusqu'à Exalté.",
	[523] = "Monter 5 réputations jusqu'à Exalté.",
	[524] = "Monter 10 réputations jusqu'à Exalté.",
	[546] = "Acheter 7 emplacements de sac supplémentaires.",
	[627] = "Explorer Dun Morogh et révéler les zones voilées de la carte du monde.",
	[628] = "Vaincre Edwin VanCleef.",
	[629] = "Vaincre Taragaman l'Affameur.",
	[630] = "Vaincre Mutanus le Dévoreur.",
	[631] = "Vaincre l’archimage Arugal.",
	[633] = "Vaincre Bazil Thredd.",
	[634] = "Vaincre le mekgénieur Thermojoncteur.",
	[635] = "Vaincre Charlga Trancheflanc.",
	[636] = "Vaincre Amnennar le Porte-Froid.",
	[638] = "Détruisez Archaedas.",
	[640] = "Vaincre la princesse Theradras.",
	[641] = "Vaincre l’Ombre d’Eranikus.",
	[642] = "Vaincre l’empereur Dagran Thaurissan.",
	[643] = "Vaincre le seigneur Wyrmthalak.",
	[646] = "Triompher des pièges maléfiques qui hantent Stratholme.",
	[684] = "Vaincre la version classique de niveau 60 d'Onyxia.",
	[685] = "Vaincre Nefarian.",
	[686] = "Vaincre Ragnaros.",
	[687] = "Vaincre C’Thun.",
	[688] = "Vaincre Hakkar.",
	[689] = "Vaincre Ossirian l’Intouché.",
	[706] = "Obtenir un hurleur loup-de-givre.",
	[707] = "Obtenir un destrier de bataille foudrepique.",
	[708] = "Être exalté auprès du clan Loup-de-givre.",
	[709] = "Être exalté auprès de la garde Foudrepique.",
	[710] = "Être exalté auprès des Profanateurs réprouvés.",
	[711] = "Être exalté auprès de la ligue d'Arathor.",
	[712] = "Être exalté auprès des voltigeurs Chanteguerre.",
	[713] = "Être exalté auprès des sentinelles d'Aile-argent.",
	[714] = "Être exalté auprès des factions du goulet des Chanteguerres, du bassin Arathi et de la vallée d'Alterac.",
	[727] = "Obtenir l'une des montures de guerre par le système d'honneur.",
	[728] = "Explorer Durotar et révéler les zones voilées de la carte du monde.",
	[729] = "Obtenir les rênes de destrier de la mort sur le baron Vaillefendre à Stratholme.",
	[736] = "Explorer Mulgore et révéler les zones voilées de la carte du monde.",
	[750] = "Explorer les Tarides et révéler les zones voilées de la carte du monde.",
	[760] = "Explorer les montagnes d'Alterac et révéler les zones voilées de la carte du monde.",
	[761] = "Explorer les hautes-terres Arathies et révéler les zones voilées de la carte du monde.",
	[765] = "Explorer les Terres ingrates et révéler les zones voilées de la carte du monde.",
	[766] = "Explorer les Terres foudroyées et révéler les zones voilées de la carte du monde.",
	[768] = "Explorer les clairières de Tirisfal et révéler les zones voilées de la carte du monde.",
	[769] = "Explorer la forêt des Pins argentés et révéler les zones voilées de la carte du monde.",
	[770] = "Explorer les Maleterres de l'ouest et révéler les zones voilées de la carte du monde.",
	[771] = "Explorer les Maleterres de l'est et révéler les zones voilées de la carte du monde.",
	[772] = "Explorer les contreforts de Hautebrande et révéler les zones voilées de la carte du monde.",
	[773] = "Explorer les Hinterlands et révéler les zones voilées de la carte du monde.",
	[774] = "Explorer la gorge des Vents brûlants et révéler les zones voilées de la carte du monde.",
	[775] = "Explorer les Steppes ardentes et révéler les zones voilées de la carte du monde.",
	[776] = "Explorer la forêt d'Elwynn et révéler les zones voilées de la carte du monde.",
	[777] = "Explorer le défilé de Deuillevent et révéler les zones voilées de la carte du monde.",
	[778] = "Explorer le bois de la Pénombre et révéler les zones voilées de la carte du monde.",
	[779] = "Explorer le Loch Modan et révéler les zones voilées de la carte du monde.",
	[780] = "Explorer les Carmines et révéler les zones voilées de la carte du monde.",
	[781] = "Explorer la vallée de Strangleronce et révéler les zones voilées de la carte du monde.",
	[782] = "Explorer le marais des Chagrins et révéler les zones voilées de la carte du monde.",
	[802] = "Explorer la marche de l'Ouest et révéler les zones voilées de la carte du monde.",
	[841] = "Explorer les Paluns et révéler les zones voilées de la carte du monde.",
	[842] = "Explorer Teldrassil et révéler les zones voilées de la carte du monde.",
	[844] = "Explorer Sombrivage et révéler les zones voilées de la carte du monde.",
	[845] = "Explorer Orneval et révéler les zones voilées de la carte du monde.",
	[846] = "Explorer les Mille pointes et révéler les zones voilées de la carte du monde.",
	[847] = "Explorer les Serres-Rocheuses et révéler les zones voilées de la carte du monde.",
	[848] = "Explorer Désolace et révéler les zones voilées de la carte du monde.",
	[849] = "Explorer Féralas et révéler les zones voilées de la carte du monde.",
	[850] = "Explorer le marécage d'Âprefange et révéler les zones voilées de la carte du monde.",
	[851] = "Explorer le désert de Tanaris et révéler les zones voilées de la carte du monde.",
	[852] = "Explorer Azshara et révéler les zones voilées de la carte du monde.",
	[853] = "Explorer Gangrebois et révéler les zones voilées de la carte du monde.",
	[854] = "Explorer le cratère d'Un'Goro et révéler les zones voilées de la carte du monde.",
	[855] = "Explorer Reflet-de-Lune et révéler les zones voilées de la carte du monde.",
	[856] = "Explorer Silithus et révéler les zones voilées de la carte du monde.",
	[857] = "Explorer le Berceau-de-l'Hiver et révéler les zones voilées de la carte du monde.",
	[871] = "Obtenir le bicorne d'amiral de la Voile sanglante… et essayer de prendre l'air de temps en temps.",
	[879] = "Être propriétaire de l'une des anciennes montures épiques qui ne sont plus accessibles.",
	[880] = "Obtenir le tigre zulien rapide sur le grand prêtre Thekal à Zul'Gurub.",
	[881] = "Obtenir le raptor Razzashi rapide sur le seigneur sanglant Mandokir à Zul’Gurub.",
	[891] = "Apprendre la compétence Apprenti cavalier.",
	[907] = "Être exalté auprès des factions du goulet des Chanteguerres, du bassin Arathi et de la vallée d'Alterac.",
	[940] = "Achever toutes les quêtes d'Hemet Nesingwary dans la vallée de Strangleronce, y compris « Les vertes collines de Strangleronce » et « La chasse au gros gibier ».",
	[944] = "Être exalté auprès des Grumegueules.",
	[946] = "Être exalté auprès de l'Aube d'argent.",
	[955] = "Être exalté auprès des Hydraxiens.",
	[956] = "Être exalté auprès de la Progéniture de Nozdormu.",
	[957] = "Être exalté auprès de la tribu Zandalar.",
	[1307] = "Vaincre le général Drakkisath.",
	[1676] = "Achever 700 quêtes dans les Royaumes de l'est.",
	[1677] = "Achever 550 quêtes dans les Royaumes de l'est.",
	[1678] = "Achever 700 quêtes en Kalimdor.",
	[1680] = "Achever 685 quêtes en Kalimdor.",
	[2116] = "Avoir obtenu un tabard de l'Aube d'argent lors de l'invasion du Fléau.",
	[2141] = "Obtenir 10 montures.",
	[2142] = "Obtenir 25 montures.",
	[2336] = "Être honoré auprès de la Voile sanglante et exalté auprès de Baie-du-Butin, Long-Guet, Gadgetzan, Cabestan, la foire de Sombrelune, Ravenholdt et Shen’dralar.",
	[2357] = "Avoir achevé la quête de démoniste « Le destrier de l'effroi de Xoroth ».",
	[2358] = "Avoir achevé la quête de paladin pour obtenir un destrier.",
	[2496] = "Obtenir une quintessence aquatique.",
	[3356] = "Obtenir un sabre-de-givre de Berceau-de-l'Hiver.",
	[5788] = "Être exalté auprès des Shen’dralar.",
	[16433] = "Atteindre le niveau 60 sans jamais mourir au cours de la saison de la Maîtrise.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Tours de force",
	[92] = "Général",
	[95] = "Joueur contre Joueur",
	[96] = "Quêtes",
	[97] = "Exploration",
	[168] = "Donjons & raids",
	[169] = "Métiers",
	[170] = "Cuisine",
	[171] = "Pêche",
	[172] = "Secourisme",
	[201] = "Réputation",
	[14777] = "Royaumes de l'est",
	[14778] = "Kalimdor",
	[14801] = "Vallée d'Alterac",
	[14802] = "Bassin Arathi",
	[14804] = "Goulet des Chanteguerres",
	[14808] = "Classique",
	[14861] = "Classique",
	[14864] = "Classique",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "it" then
localize(L.HEADER_NAMES, {
	[-1000025] = "Festività",
	[-1000034] = "Istruttore di equitazione",
	[-1000162] = "Aspetti Condivisi",
	[-1000163] = "Aspetto unico",
	[-1000168] = "I Cavalieri dell'Apocalisse",
	[-1000191] = "Sconfiggi un Tenente",
	[-1000192] = "Vinci la Battaglia",
	[-1000193] = "Parla con i Morti",
	[-1000195] = "Parla con Grizzby",
	[-1000196] = "Parla con N'ora",
	[-1000198] = "Parla con Fratello Romulus",
	[-1000201] = "Fiera di Lunacupa",
	[-1000223] = "Fuochi di Mezza Estate",
	[-1000227] = "Gara di Pesca a Rovotorto",
	[-1000235] = "L'apertura del Portale Oscuro",
	[-1000236] = "Scettro delle Sabbie Mutevoli",
	[-1000273] = "La Stagione delle Scoperte",
	[-1000274] = "Comprensione",
	[-1000275] = "Livello 1",
	[-1000276] = "Livello 2",
	[-1000277] = "Caccia ai Mostri",
	[-1000279] = "Forniture Waylaid",
	[-1000373] = "Nuovo personaggio",
	[-1000376] = "Rissa Corpulenta",
	[-1000377] = "Polimorfo Selvaggio",
	[-1000378] = "Broker Dell'anima",
	[-1000380] = "Premio",
	[-1000970] = "Livello 3",
	[-1001035] = "Pesce di stagione: spigola estiva",
	[-1001036] = "Pesce di stagione: calamari invernali",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000162] = "Gli elementi in questo elenco sono aspetti condivisi per l'elemento precedente. Nella modalità Aspetto unico, questo elenco può aiutarti a capire perché o perché un oggetto specifico verrebbe contrassegnato come Raccolto.",
	[-1000163] = "Questo oggetto ha un aspetto unico. Devi raccogliere questo oggetto appositamente per guadagnare l'aspetto.",
	[-1000273] = "Questa stagione porta un limite di livello iniziale di 25 e un nuovo gioco finale di livello 25, incluso un raid di Blackfathom Deeps per 10 giocatori con nuove meccaniche, boss nuovi e reinventati per sfidare le tattiche e le strategie dei giocatori e nuove ricompense.",
	[-1000278] = "L'incisione delle rune è un nuovo sistema recentemente annunciato per la Stagione delle Scoperte. Permette a ogni classe di personalizzare la propria esperienza di gioco sbloccando nuove abilità uniche!",
	[-1000279] = "Gli oggetti della missione Waylaid Supplies vengono rilasciati dai mob di livello 6 e soprattutto su Azeroth. Queste missioni richiedono la consegna delle Forniture Waylaid a un rappresentante dell'organizzazione in cambio di argento, esperienza e reputazione. Naturalmente, ci sono degli articoli mancanti nella spedizione di rifornimenti e puoi integrarli per ottenere maggiori ricompense in termini di reputazione.",
	[-1000376] = "Solo la persona che ottiene il colpo finale sull'ubriaco riceverà il credito, indipendentemente da chi ha toccato per primo il bersaglio. Non è previsto alcun credito collettivo per questo.",
	[-1000377] = "Lancia Polymorph sulle creature affette da Wild Polymorph per trasformarle di nuovo in apprendisti. Ognuno ti darà una nota. Raccogli 6 note per imparare la runa.",
	[-1000380] = "Questo elenco contiene elementi non ottenibili che ATT Discord ha segnalato come bug che Blizzard deve ancora correggere.\n\nNOTA: tutti i filtri vengono ignorati in questo elenco per motivi di visibilità. In questo elenco sono presenti solo gli oggetti rimossi dal gioco a causa di negligenza e non un gigantesco drago sputafuoco.\n\nAgli sviluppatori Blizzard: correggete gli oggetti e gli incontri elencati di seguito.",
});
localize(ObjectNames, {
	[31] = "Vecchia Statua di Leone",
	[34] = "Vecchio Fiasco",
	[35] = "Scrigno del Capitano",
	[36] = "Barile Spezzato",
	[47] = "Ricercato!",
	[55] = "Corpo Smangiucchiato",
	[56] = "Cadavere di Rolf",
	[60] = "Ricercato: Gath'ilzogg",
	[61] = "Tomba Rovinata",
	[68] = "Manifesto dei Ricercati",
	[256] = "RICERCATO",
	[257] = "Barile Sospetto",
	[259] = "Barile Mezzo Sepolto",
	[261] = "Cassa Danneggiata",
	[269] = "Barile Custodito di Birra del Tuono",
	[1557] = "Tavolo da Pranzo di Lillith",
	[1561] = "Cassa Sigillata",
	[1586] = "Cassa di Candele",
	[1609] = "Catapulta delle Fauci di Drago",
	[1627] = "Cassa di Dalaran",
	[1673] = "Vilpigna",
	[1740] = "Documenti della Lega dei Tagliagole",
	[1765] = "Cassa di Legno Consumata",
	[2059] = "Cadavere di un Nano",
	[2076] = "Calderone Ribollente",
	[2083] = "Corrispondenza dei Velerosse",
	[2289] = "Scialuppa di Salvataggio Rovinata",
	[2553] = "Pergamena Zuppa",
	[2555] = "Pergamena Ammuffita",
	[2652] = "Cadavere di Ebenezer Rustlocke",
	[2688] = "Pietra Angolare",
	[2689] = "Pietra del Vincolo Occidentale",
	[2690] = "Pietra del Vincolo Esterno",
	[2691] = "Pietra del Vincolo Orientale",
	[2701] = "Frammento Iridescente",
	[2702] = "Pietra del Vincolo Interno",
	[2704] = "Cassa di Esplosivi",
	[2713] = "Bacheca dei Ricercati",
	[2734] = "Cassa Fradicia",
	[2739] = "Cassa della Piuma Nera",
	[2740] = "Cassa dell'Artiglio del Corvo",
	[2741] = "Cassa del Cielo",
	[2742] = "Cassa di Nidificazione",
	[2868] = "Mappa Sgualcita",
	[2875] = "Scheletro Danneggiato di Nano",
	[2908] = "Cassa di Rifornimenti Sigillata",
	[2910] = "Pietra del Pozzo",
	[2912] = "Corno d'Ambra",
	[3076] = "Mappa Macchiata",
	[3189] = "Piano d'Attacco: Valle delle Sfide",
	[3190] = "Piano d'Attacco: Villaggio di Sen'jin",
	[3192] = "Piano d'Attacco: Orgrimmar",
	[3236] = "Cassetta degli Attrezzi Gnomesca",
	[3290] = "Sacca di Provviste Rubate",
	[3525] = "Altare del Fuoco",
	[3640] = "Fungo Carico di Spore",
	[3643] = "Vecchio Scrigno",
	[3737] = "Fessura Ribollente",
	[3972] = "RICERCATO",
	[4072] = "Valvola di Controllo Principale",
	[4141] = "Console di Comando",
	[4406] = "Uova di Telalegno",
	[4608] = "Germoglio di Alberiano",
	[5620] = "Pietre del Potere Difettose",
	[6751] = "Strana Pianta da Frutto",
	[6752] = "Strana Pianta Frondosa",
	[7510] = "Pianta Rigogliosa",
	[15084] = "Lavatutto 5200",
	[15085] = "Lavatutto 5200",
	[16393] = "Fiamma Antica",
	[17182] = "Transanalizzatore 827",
	[17183] = "Transanalizzatore 411",
	[17783] = "Statuetta Antica",
	[19015] = "Lacrima di Elune",
	[19016] = "Cespuglio Coperto di Polvere Stellare",
	[19021] = "Cassa Arrugginita",
	[19022] = "Forziere Consumato",
	[19024] = "Santuario Nascosto",
	[19027] = "Tomo di Mel'Thandris",
	[19030] = "Mucchio di Terra",
	[19877] = "Baule di Velinde",
	[20359] = "Uovo di Onyxia",
	[20691] = "Scrigno di Chiavearmata",
	[20725] = "Eredità degli Aspetti",
	[20727] = "Cassa per Spedizioni di Gizmorium",
	[20985] = "Terra Smossa",
	[20992] = "Scudo Nero",
	[21042] = "Distintivo della Guardia di Theramore",
	[22245] = "Sacca di Carne",
	[22246] = "Lacrima di Theradras",
	[32569] = "Forziere di Galen",
	[35251] = "Cassa di Karnitol",
	[37099] = "Tavoletta Atal'ai",
	[58369] = "Cassa di Ferro Rubata",
	[61934] = "Braciere della Fiamma Sopita",
	[61935] = "Valvola di Regolazione",
	[61936] = "Valvola di Controllo del Carburante",
	[91138] = "Martello di Jordan",
	[112888] = "Mensola Polverosa",
	[112948] = "Forziere Chiuso dell'Intrepida",
	[113757] = "Scrigno di Forgiascura",
	[113768] = "Uovo Decorato",
	[123329] = "Cassa di Baelog",
	[123462] = "Il Gioiello di Mari del Sud",
	[125477] = "Urna Notevole",
	[126049] = "Funghi Magenta",
	[126158] = "Cassettone di Tallonkai",
	[126260] = "Cassa Antica",
	[129127] = "Cassetta di Sicurezza di Gallywix",
	[131474] = "Dischi di Norgannon",
	[138492] = "Frammento di Myzrael",
	[140911] = "Rocchetta di Filo di Seta Verdastro",
	[141832] = "Gong di Zul'farrak",
	[141853] = "Amanita Viola",
	[141931] = "Uovo di Ippogrifo",
	[141979] = "Tesoro Antico",
	[142088] = "Tavoletta della Volontà",
	[142122] = "Manifesto dei Ricercati",
	[142151] = "Barile Sigillato",
	[142179] = "Padiglione di Solarsal",
	[142184] = "Cassa del Capitano",
	[142185] = "Fiamma di Byltan",
	[142186] = "Fiamma di Lahassa",
	[142187] = "Fiamma di Imbel",
	[142188] = "Fiamma di Samha",
	[142195] = "Piani di Battaglia degli Gnoll",
	[142343] = "Piedistallo di Uldum",
	[142344] = "Estrapolatore Artificiale",
	[142475] = "Perforatrice per Matrici 3005-B",
	[142476] = "Perforatrice per Matrici 3005-C",
	[142487] = "Lavatutto 5200",
	[142696] = "Perforatrice per Matrici 3005-D",
	[142702] = "Bottiglia di Veleno",
	[142715] = "Tavoletta di Theka",
	[143980] = "Pergamena dei Gordunni",
	[144053] = "Equipaggiamento Topografico di Scrimshank",
	[144063] = "Monolito Equinex",
	[144066] = "Prima Gabbia degli Scorzasecca",
	[144067] = "Seconda Gabbia degli Scorzasecca",
	[144068] = "Terza Gabbia degli Scorzasecca",
	[144070] = "Gabbia di Beccaguzzo",
	[148498] = "Altare di Suntara",
	[148499] = "Scatola di Felix",
	[148504] = "Lapide Notevole",
	[148506] = "Manufatto Crepuscolare",
	[149025] = "Braciere della Sentinella",
	[149030] = "Braciere della Sentinella",
	[149031] = "Braciere della Sentinella",
	[149032] = "Braciere della Sentinella",
	[149036] = "Cassa di Marvon",
	[152097] = "Braciere di Belnistrasz",
	[152618] = "Bottino dei Kolkar",
	[152622] = "Formazione di Azsharite",
	[153239] = "Penna di Silvagufo",
	[154357] = "Fango Scintillante",
	[156561] = "Manifesto dei Ricercati",
	[160836] = "Reliquiario",
	[160845] = "Forziere Oscuro",
	[161495] = "Cassaforte Segreta",
	[161505] = "Zattera Distrutta",
	[161521] = "Equipaggiamento Scientifico",
	[161526] = "Cassa di Cibo",
	[161527] = "Osso di Dinosauro",
	[161752] = "Secchio degli Attrezzi",
	[164659] = "Cristallo Energetico Verde",
	[164661] = "Cristallo Energetico Giallo",
	[164689] = "Monumento a Franclorn Forgiabruna",
	[164778] = "Cristallo Energetico Blu",
	[164780] = "Cristallo Energetico Rosso",
	[164820] = "Targa del Guardiano Oscuro",
	[164867] = "RICERCATO",
	[164868] = "UCCIDERE A VISTA",
	[164869] = "Calice Spettrale",
	[164909] = "Barca a Remi Distrutta",
	[164910] = "Cassa Ornata",
	[164911] = "Barile di Birra dei Birratuono",
	[164953] = "Grosse Sacche in Pelle",
	[164954] = "Baccello Zukk'ash",
	[164955] = "Pilastro di Cristallo Settentrionale",
	[164956] = "Pilastro di Cristallo Occidentale",
	[164957] = "Pilastro di Cristallo Orientale",
	[164958] = "Germoglio Petalorosso",
	[165554] = "Cuore della Montagna",
	[166863] = "Carcassa Fresca di Plesiosauro",
	[169243] = "Cassa dei Sette",
	[169294] = "Tavoletta dei Sette",
	[171938] = "Cactus",
	[173232] = "Progetti di Forgiatura",
	[173265] = "Latrina di Legno",
	[174682] = "Attenzione ai Pterrordattili",
	[174728] = "Cassa Danneggiata",
	[174848] = "Equipaggiamento di Prova",
	[175084] = "Lavatutto 5200",
	[175207] = "Creatura Marina Arenata",
	[175227] = "Creatura Marina Arenata",
	[175245] = "Padre Fiamma",
	[175324] = "Frammento di Magliofreddo",
	[175334] = "Beni di Bijou",
	[175382] = "Scrigno del Portarovina",
	[175385] = "Tavoletta di Pietra Nera",
	[175566] = "Erba Tenebrosa",
	[175586] = "Carro di Jaron",
	[175587] = "Cassa Danneggiata",
	[175606] = "Uovo del Ragno dei Bastioni",
	[175629] = "Rifornimenti di Jaron",
	[175785] = "Documenti Incospicui",
	[175886] = "Picca a Spuntoni",
	[175889] = "Uovo Antico",
	[175925] = "Latrina",
	[175949] = "Quinta Tavoletta Mosh'aru",
	[175950] = "Sesta Tavoletta Mosh'aru",
	[175966] = "Filo Scarlatto Incantato",
	[175970] = "Pettorale Corazzato Runico Non Forgiato",
	[176089] = "Guanti Lunghi a Piastre non Fusi",
	[176090] = "Resti di Umanoide",
	[176091] = "Calderone dei Legnomorto",
	[176092] = "Scatola Incendiaria",
	[176112] = "Forziere di Malor",
	[176116] = "Testa della Bambola di Pamela",
	[176142] = "Parte Sinistra della Bambola di Pamela",
	[176143] = "Parte Destra della Bambola di Pamela",
	[176145] = "Monumento di Joseph Tracciarossa",
	[176158] = "Braciere del Dolore",
	[176159] = "Braciere della Malizia",
	[176160] = "Braciere della Sofferenza",
	[176161] = "Braciere dell'Odio",
	[176189] = "Scheletro di Tartaruga Marina",
	[176190] = "Tartaruga Marina Arenata",
	[176196] = "Tartaruga Marina Arenata",
	[176206] = "Libro di Davil",
	[176207] = "Scudo di Tracciarossa",
	[176208] = "Teschio di Horgus",
	[176209] = "Spada Infranta di Marduk",
	[176245] = "Archivio Scarlatto",
	[176249] = "Dati sul Flagello",
	[176325] = "Progetti di Forgiatura",
	[176392] = "Calderone del Flagello",
	[176582] = "Trappola per Crostacei",
	[176630] = "Grimorio della Rimembranza",
	[176631] = "Dono di Menethil",
	[176751] = "Ossa di Kodo",
	[176785] = "Cassa di Munizioni",
	[176793] = "Catasta di Legna",
	[177241] = "Filatterio di Araj",
	[177243] = "Portale Demoniaco",
	[177264] = "Simbolo dell'Onore Perduto",
	[177287] = "Quadro Incompleto",
	[177464] = "Grande Tumulo di Termiti",
	[177544] = "Cassa di Joseph",
	[177667] = "Pergamena Strappata",
	[177784] = "Bivalve Gusciomolle Gigante",
	[177786] = "Cassa di Rackmore",
	[177787] = "Diario di Rackmore",
	[177789] = "Libro Mastro di Augustus",
	[177805] = "Resti Mutilati di Umanoide",
	[177964] = "Pietra Profonda",
	[178084] = "Cassa di Felix",
	[178085] = "Contenitore di Viti di Felix",
	[178087] = "Piccone di Thazz'ril",
	[178090] = "Tomba di Marla",
	[178104] = "Cristallo di Resonite",
	[178144] = "Cassa dei Troll",
	[178184] = "Zaffiro di Aku'mai",
	[178185] = "Zaffiro di Aku'mai",
	[178186] = "Zaffiro di Aku'mai",
	[178195] = "Olio dei Cantaguerra",
	[178204] = "Spedizione d'Asce dei Cantaguerra",
	[178227] = "Cesto del Totem di Murgut",
	[178553] = "Baccello dell'Alveare Ashi",
	[178609] = "Neve Festiva",
	[179485] = "Trappola Rotta",
	[179499] = "Cestello di Colorante Ogre",
	[179516] = "Cassa di Fengus",
	[179517] = "Il Tesoro degli Shen'dralar",
	[179544] = "Resti Scheletrici di Telmius Cercasogni",
	[179545] = "Cassa del Principe",
	[179552] = "Schema: Robot di Riparazione 74A",
	[179553] = "Frammento di Nucleo",
	[179559] = "Frammento di Vil Vite",
	[179564] = "Tributo dei Gordok",
	[179565] = "Reliquiario Polveroso",
	[179697] = "Cassa del Tesoro dell'Arena",
	[179703] = "Cassa del Signore del Fuoco",
	[179828] = "Cuscino dei Ferroscuro",
	[179832] = "Cuscino Decorato di Pillaclencher",
	[179879] = "Globo del Comando",
	[179880] = "Marchio di Drakkisath",
	[179914] = "Pila d'Ossa",
	[179915] = "Pila di Teschi",
	[179922] = "Recipiente di Sangue Corrotto",
	[180327] = "Braciere della Follia",
	[180435] = "Sacca di Noggle",
	[180436] = "Frammento di Tavoletta del Crepuscolo",
	[180448] = "Manifesto dei Ricercati: Chelafunesta",
	[180453] = "Cristallo con Glifi dell'Alveare Regal",
	[180454] = "Cristallo con Glifi dell'Alveare Ashi",
	[180455] = "Cristallo con Glifi dell'Alveare Zora",
	[180456] = "Pietra del Vento Minore",
	[180461] = "Pietra del Vento",
	[180466] = "Pietra del Vento Maggiore",
	[180501] = "Frammento di Tavoletta del Crepuscolo",
	[180503] = "Libro di Ricette Insabbiato",
	[180570] = "Barile",
	[180633] = "Lacrima di Cristallo",
	[180642] = "Cassa Incospicua",
	[180662] = "Rottami di Goletta",
	[180665] = "Draconico per Negati",
	[180666] = "Draconico per Negati",
	[180667] = "Draconico per Negati",
	[180669] = "Maelstrom Turbinoso",
	[180682] = "Banco di Boccanera Oleosi",
	[180684] = "Banco di Gran Pescisalvia",
	[180685] = "Rottami Fradici",
	[180690] = "Grande Forziere dello Scarabeo",
	[180691] = "Forziere dello Scarabeo",
	[180712] = "Banco di Anguille Squamapietra",
	[180743] = "Regalo Incartato con Cura",
	[180746] = "Dono Dolcemente Scosso",
	[180747] = "Regalo Incartato Gioiosamente",
	[180748] = "Regalo Ticchettante",
	[180751] = "Rottami Galleggianti",
	[180793] = "Dono Festivo",
	[180901] = "Rottami dei Velerosse",
	[181053] = "Cesto di Algasangue",
	[181073] = "Calderone Profumato",
	[181085] = "Cassa di Rifornimenti di Stratholme",
	[181366] = "Cassa dei Cavalieri dell'Apocalisse",
	[181597] = "Mucchio di Silitisti",
	[181598] = "Geyser Silitista",
	[181672] = "Effige dell'Uomo di Paglia",
	[181686] = "Catasta di Legno dei Cantaguerra",
	[201579] = "Frammento a Incastro",
	[207724] = "Pezzi del Relitto",
});
for key,value in pairs({
	[11] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 1 di WoW Classic.|r",
	[1606] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 2 di Season of Discovery.|r",
	[1607] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 3 di Season of Discovery.|r",
	[1608] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 4 di Season of Discovery.|r",
	[1609] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 5 di Season of Discovery.|r",
	[1610] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 6 di Season of Discovery.|r",
	[1611] = "|cFFAAFFAAQuesto non era disponibile fino al Phase 7 di Season of Discovery.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[81] = "Feats of Strength",
	[92] = "General",
	[95] = "Player vs. Player",
	[96] = "Quests",
	[97] = "Exploration",
	[168] = "Dungeons & Raids",
	[169] = "Professions",
	[170] = "Cooking",
	[171] = "Fishing",
	[172] = "First Aid",
	[201] = "Reputation",
	[14777] = "Eastern Kingdoms",
	[14778] = "Kalimdor",
	[14801] = "Alterac Valley",
	[14802] = "Arathi Basin",
	[14804] = "Warsong Gulch",
	[14808] = "Classic",
	[14861] = "Classic",
	[14864] = "Classic",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "pt" then
localize(L.HEADER_NAMES, {
	[-1000015] = "Treinamento de Demônios",
	[-1000025] = "Feriados",
	[-1000034] = "Treinamento de Montaria",
	[-1000040] = "Mestre de Armas",
	[-1000162] = "Aparências Compartilhadas",
	[-1000163] = "Aparência Única",
	[-1000168] = "Os Quatro Cavaleiros",
	[-1000191] = "Derrote um Tenente",
	[-1000192] = "Ganhe a Batalha",
	[-1000193] = "Fale com os Mortos",
	[-1000195] = "Fale com o Grizzby",
	[-1000196] = "Fale com o N'ora",
	[-1000198] = "Fale com o Irmão Romulus",
	[-1000201] = "Feira de Negraluna",
	[-1000223] = "Festival do Fogo do Solstício",
	[-1000227] = "Festerê de Pesca da Selva do Espinhaço",
	[-1000235] = "A abertura do Portal Negro",
	[-1000236] = "Cetro das Areias Cambiantes",
	[-1000273] = "Temporada de Descoberta",
	[-1000274] = "Compreensão",
	[-1000275] = "Nível 1",
	[-1000276] = "Nível 2",
	[-1000277] = "Caça aos Monstros",
	[-1000278] = "Gravura",
	[-1000279] = "Suprimentos emboscados",
	[-1000373] = "Novo personagem",
	[-1000376] = "Briga Corpulenta",
	[-1000377] = "Polimorfo Selvagem",
	[-1000378] = "Corretores de Almas",
	[-1000380] = "Recompensa",
	[-1000970] = "Nível 3",
	[-1001035] = "Peixe sazonal: robalo de verão",
	[-1001036] = "Peixe sazonal: Lula de Inverno",
	[-1001058] = "Bosque do Pesadelo",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000040] = "Um mestre de armas é um NPC que oferece aos personagens a oportunidade de aprender habilidades específicas com armas, cuja disponibilidade varia de um mestre de armas para outro. Todas as habilidades com armas podem ser treinadas no nível 1, exceto as armas de haste, que exigem nível 20.\n\nO treinamento com um mestre de armas tornou-se obsoleto no Patch 4.0.1, já que todas as proficiências de armas apropriadas à classe agora são aprendidas por cada classe após a criação. Os mestres de armas foram removidos do jogo logo depois.",
	[-1000162] = "Os itens nesta lista são aparências compartilhadas do item acima. No Modo de Aparência Única, esta lista pode ajudá-lo a entender por que ou não um item específico seria marcado como Coletado.",
	[-1000163] = "Este item tem uma aparência única. Você deve coletar este item especificamente para ganhar a aparência.",
	[-1000273] = "Esta temporada traz um limite de nível inicial de 25 e um novo jogo final de nível 25, incluindo um ataque Blackfathom Deeps para 10 jogadores com novas mecânicas, chefes novos e reimaginados para desafiar as táticas e estratégias dos jogadores e novas recompensas.",
	[-1000278] = "A gravação de runas é um novo sistema anunciado recentemente para a Temporada de Descobertas. Ele permite que cada classe personalize sua experiência de jogo, desbloqueando novas habilidades únicas!",
	[-1000279] = "Itens de missão Waylaid Supplies são obtidos de mobs de nível 6 e acima de Azeroth. Essas missões exigem a entrega dos Suprimentos Waylaid a um representante da organização em troca de um pouco de prata, experiência e reputação. É claro que faltam itens na remessa de suprimentos e você pode complementá-los para obter maiores recompensas de reputação.",
	[-1000376] = "Somente a pessoa que acertar o golpe final no bêbado receberá o crédito, independentemente de quem bateu primeiro no alvo. Não há crédito de grupo para isso.",
	[-1000377] = "Lance Polymorph em criaturas afetadas por Wild Polymorph para transformá-las novamente em aprendizes. Cada um lhe dará uma nota. Colete 6 notas para aprender a runa.",
	[-1000380] = "Esta lista contém itens inacessíveis que o ATT Discord relatou como bugs que a Blizzard ainda não corrigiu.\n\nNOTA: Todos os filtros são ignorados nesta lista para visibilidade. Apenas itens removidos do jogo por negligência, em vez de um gigantesco dragão cuspidor de fogo, estão presentes nesta lista.\n\nPara os desenvolvedores da Blizzard: Corrijam os itens e encontros listados abaixo.",
});
localize(ObjectNames, {
	[31] = "Estátua de Leão Antiga",
	[32] = "Baú Afundado",
	[33] = "Baú Trancado",
	[34] = "Velho Garrafão",
	[35] = "Maleta do Capitão",
	[36] = "Barril Quebrado",
	[47] = "Procura-se!",
	[52] = "A Queda de Gurubashi",
	[54] = "A Tumba do Imperador",
	[55] = "Corpo semi-devorado",
	[56] = "Cadáver de Rodolfo",
	[57] = "A lua cobre o vale",
	[58] = "Gri'lek, o Errante",
	[59] = "Monte de Terra Solta",
	[60] = "Procura-se: Gath'Ilzogg",
	[61] = "A Velha Lápide",
	[68] = "Pôster de Procura-se",
	[76] = "Jarra Vazia",
	[119] = "Caixote do Abercrombie",
	[256] = "PROCURA-SE",
	[257] = "Barril Suspeito",
	[259] = "Barril Semienterrado",
	[261] = "Caixote Danificado",
	[263] = "Suprimentos de Kurzen",
	[264] = "Suprimentos de Kurzen",
	[269] = "Barril de Cerveja do Trovão Protegido",
	[270] = "Barril de Cerveja do Trovão Desprotegido",
	[271] = "Caixotes da Liga dos Mineradores",
	[272] = "Depósito de Carne de MacGrann",
	[276] = "Cesta de Tremulerva",
	[287] = "Registros do Contador Herodes",
	[288] = "Cofre do Contador Herodes",
	[290] = "Guarda-roupas do Taturana",
	[321] = "Lágrima de Tirsa",
	[331] = "Terra Solta",
	[333] = "Relíquia Antiga",
	[334] = "Relíquia Antiga",
	[375] = "Abóbora de Tirisfal",
	[711] = "Procura-se!",
	[759] = "A Fonte Sagrada",
	[1166] = "Baú do Aleixo",
	[1557] = "Mesa de Jantar da Lillith",
	[1560] = "Baú de Estoque",
	[1561] = "Caixote Selado",
	[1562] = "Baú do Marechal Haggard",
	[1571] = "Grimórios Empoeirados",
	[1585] = "Carga Explosiva",
	[1586] = "Caixote de Velas",
	[1593] = "Barco Cheio de Cadáveres",
	[1594] = "Prateleira de Livros de Berardo",
	[1599] = "Cova Rasa",
	[1609] = "Catapulta da Presa do Dragão",
	[1627] = "Caixote de Dalaran",
	[1673] = "Pinha Vil",
	[1721] = "Bola e corrente presas",
	[1722] = "Bola e Corrente Trancada",
	[1723] = "Cogumelo Fuçalama",
	[1727] = "Barril de Stout do Festeiro",
	[1728] = "Tapete Empoeirado",
	[1736] = "Carregamento de Ferro",
	[1738] = "Documentos da Camarilha",
	[1739] = "Documentos da Camarilha",
	[1740] = "Documentos da Camarilha",
	[1759] = "Cartório de Eira dos Montes",
	[1760] = "Estante de Livros Surrada",
	[1761] = "Proclamação de Eira dos Montes",
	[1763] = "PROCURA-SE",
	[1765] = "Baú de Madeira Gasto",
	[1768] = "Chama de Azel",
	[1769] = "Chama de Veraz",
	[1770] = "Chama de Uzel",
	[2008] = "Perigo!",
	[2059] = "Cadáver Enânico",
	[2068] = "Xerez de Pupellyverbos",
	[2076] = "Caldeirão Borbulhante",
	[2083] = "Correspondência dos Vela Sangrenta",
	[2084] = "Raiz Almiscarada",
	[2086] = "Cartas de Navegação dos Vela Sangrenta",
	[2087] = "Ordens da Vela Sangrenta",
	[2289] = "Bote Salva-vidas Arruinado",
	[2553] = "Pergaminho Encharcado",
	[2554] = "Charada do Cortello",
	[2555] = "Pergaminho Mofado",
	[2560] = "Garrafa Semienterrada",
	[2576] = "Altar das Marés",
	[2652] = "Cadáver de Ebenezer Rustlocke",
	[2656] = "Carta Encharcada",
	[2688] = "Pedra-chave",
	[2689] = "Pedra da União Ocidental",
	[2690] = "Pedra da União Externa",
	[2691] = "Pedra da União Oriental",
	[2701] = "Fragmentos Iridescentes",
	[2702] = "Pedra da União Interna",
	[2704] = "Caixa de Explosivos",
	[2707] = "Mapas da Extravagância da Donzela",
	[2708] = "Mapas do Espírito de Pinhaprata",
	[2709] = "Diário de Bordo da Extravagância da Donzela",
	[2710] = "Diário de Bordo do Espírito de Pinhaprata",
	[2712] = "Gema Élfica Calcificada",
	[2713] = "Quadro de Procurados",
	[2714] = "Granito de Alterac",
	[2716] = "Baú de Trelane",
	[2717] = "Caixote de Trelane",
	[2718] = "Cofre de Trelane",
	[2724] = "Saco de Aveia",
	[2734] = "Baú Encharcado",
	[2739] = "Baú da Pena Negra",
	[2740] = "Baú da Garra de Corvo",
	[2741] = "Baú do Céu",
	[2742] = "Baú da Nidificação",
	[2743] = "Urna de Pedra com Gravuras",
	[2744] = "Marisco Gigante",
	[2848] = "Pilar de Opala",
	[2858] = "Pilar de Ametista",
	[2867] = "Caixote de Suprimentos da Escavação",
	[2868] = "Mapa Amassado",
	[2875] = "Esqueleto de Anão Danificado",
	[2891] = "Crânios-troféu de Balia'mah",
	[2892] = "Crânios-troféu de Ziata'jai",
	[2893] = "Crânios-troféu de Zul'Mamwe",
	[2907] = "Jarra d'Água",
	[2908] = "Caixote de Suprimentos Lacrado",
	[2910] = "Pedra de Poço",
	[2912] = "Pinhâmbar",
	[2933] = "Selo da Terra",
	[3076] = "Mapa Sujo de Terra",
	[3189] = "Plano de Ataque: Vale das Provações",
	[3190] = "Plano de Ataque: Aldeia Sen'jin",
	[3192] = "Plano de Ataque: Orgrimmar",
	[3236] = "Caixa de Ferramentas Gnômica",
	[3237] = "Lançanegra Aprisionado",
	[3238] = "Barril Vazio do Chen",
	[3239] = "Baú do Bento",
	[3240] = "Ovos de Açoitacauda",
	[3290] = "Saco de Suprimentos Roubado",
	[3525] = "O Altar de Fogo",
	[3640] = "Cogumelo Carregado",
	[3642] = "Butim de Kolkar",
	[3643] = "Maleta Velha",
	[3644] = "Máquina Voadora de Bael Modan",
	[3646] = "Cofre do General Duas-tranças",
	[3685] = "Monte de Terra Silitídeo",
	[3737] = "Rachadura Borbulhante",
	[3767] = "Empório de Drizzlik",
	[3768] = "Frágil - Não Deixe Cair",
	[3972] = "PROCURA-SE",
	[4072] = "Válvula Principal",
	[4141] = "Painel de Controle",
	[4406] = "Ovos de Lenhateia",
	[4608] = "Broto de Muscoide",
	[5620] = "Pedras do Poder Defeituosas",
	[6751] = "Planta Frutífera Estranha",
	[6752] = "Planta Frondosa Estranha",
	[6906] = "Ninho de Raptor Vermelho",
	[6907] = "Ninho de Raptor Azul",
	[6908] = "Ninho de Raptor Amarelo",
	[7510] = "Fronde Desenvolvida",
	[9630] = "Fóssil do Pançacheia",
	[10076] = "Bacia de Vidência",
	[11713] = "Cogumelo-cicuta",
	[11714] = "Galho de Piolho",
	[12666] = "Tomo do Crepúsculo",
	[13360] = "Relíquia de Mathistra",
	[13891] = "Ofídea",
	[13949] = "Baú Coberto de Ferro",
	[15084] = "A Brastematic 5200",
	[15085] = "A Brastematic 5200",
	[16393] = "Chama Antiga",
	[17182] = "Caixazorra 827",
	[17183] = "Caixazorra 411",
	[17184] = "Caixazorra 323",
	[17188] = "A Fundação de Ameth'Aran",
	[17189] = "A Queda de Ameth'Aran",
	[17282] = "Pacote de Plantas",
	[17783] = "Estatueta Ancestral",
	[19015] = "Lágrima de Eluna",
	[19016] = "Arbusto de Poeira Estelar Coberto",
	[19021] = "Baú Enferrujado",
	[19022] = "Baú Gasto",
	[19024] = "Santuário Escondido",
	[19027] = "Tomo de Mel'Thandris",
	[19030] = "Monturo de Terra",
	[19283] = "Compêndio dos Caídos",
	[19284] = "Mitologia dos Titãs",
	[19595] = "Guarnição do Guarda-pórtico",
	[19596] = "Esconderijo do Adormecido",
	[19597] = "Esconderijo do Druida",
	[19598] = "Esconderijo da Ermida",
	[19599] = "Tesouro do Retiro do Gadanho",
	[19602] = "Plano de Engenharia da Empreendimentos S.A.",
	[19603] = "Documentos da Empreendimentos S.A.",
	[19861] = "Diário de Henrig Monocelha",
	[19869] = "Destroços de Carro-foguete",
	[19877] = "Armário de Velinde",
	[19901] = "Círculo de Encarceramento",
	[20352] = "Círculo de Encarceramento",
	[20359] = "Ovo de Onyxia",
	[20447] = "Comida de Harpia",
	[20691] = "Maleta do Cosella",
	[20725] = "O Legado dos Aspectos",
	[20726] = "Início da Ameaça dos Mortos-vivos",
	[20727] = "Caixote de Embarque da Pinacotreca",
	[20805] = "Projeto Desprotegido do Rebu",
	[20807] = "Braseiro Antigo",
	[20920] = "Tubérculo Folhazul",
	[20985] = "Terra Solta",
	[20992] = "Escudo Negro",
	[21015] = "Pegadas de casco",
	[21016] = "Pegadas de casco",
	[21042] = "Insígnia da Guarda de Theramore",
	[21052] = "Caixa-forte dos Défias",
	[21277] = "Caixote com Furos",
	[21530] = "Manual de Proprietário do Fungafuça",
	[22245] = "Saco de Carne",
	[22246] = "Lágrima de Theradras",
	[22550] = "Cristal de Draenetista",
	[24798] = "Madeira Flutuante Seca ao Sol",
	[28024] = "Baú da Caravana",
	[30854] = "Artefato Atal'ai",
	[30855] = "Artefato Atal'ai",
	[30856] = "Artefato Atal'ai",
	[32569] = "Cofre do Galen",
	[35251] = "Baú de Karnitol",
	[35252] = "Relíquia Antiga",
	[36738] = "O Livro de Ur",
	[37099] = "Tabuleta Atal'ai",
	[50935] = "Saco de Milho",
	[50936] = "Saco de Cevada",
	[50937] = "Saco de Centeio",
	[50961] = "Baú de Malem",
	[50982] = "O Carvalho Calcinado",
	[51708] = "Terra da Cova de Eliza",
	[58369] = "Baú de Ferro Roubado",
	[58595] = "Tesouro da Lâmina Ardente",
	[61934] = "Braseiro da Chama Latente",
	[61935] = "Válvula de Regulagem",
	[61936] = "Válvula de Controle de Combustível",
	[68865] = "Bastões de Comando do Fungafuça",
	[85563] = "Caixa-forte do Dente-podre",
	[86492] = "Cratera de Elunita",
	[89634] = "Coral de Ferro",
	[89635] = "Casca Queimada de Sol",
	[91138] = "Martelo de Jardel",
	[92013] = "Tomo do Conluio",
	[92420] = "Minério do Bailor",
	[92423] = "Baú Danificado",
	[93192] = "Palocórdio",
	[102984] = "Caixa de Ferramentas de Bink",
	[102985] = "Boca-de-leão de Balnir",
	[103574] = "Cofre de Contenção Cheio",
	[103628] = "Tratado de Ur sobre Umbromancia",
	[103821] = "Caixa-forte de Doan",
	[104564] = "Balde de Ferramentas do Bingles",
	[104569] = "Balde de Ferramentas do Bingles",
	[104574] = "Balde de Ferramentas do Bingles",
	[104575] = "Detona-cuca do Gomez",
	[105169] = "Cavalete de Armas dos Agamand",
	[105170] = "Cavalete de Armas dos Agamand",
	[105171] = "Cavalete de Armas dos Agamand",
	[105172] = "Cavalete de Armas dos Agamand",
	[105174] = "Baú de Cofres de Contenção",
	[105175] = "Cantochão da Manifestação",
	[112888] = "Prateleira Empoeirada",
	[112948] = "Cofre Trancado do Intrépido",
	[113757] = "Baú de Umbraforja",
	[113768] = "Ovo Colorido Brilhante",
	[113791] = "Braseiro da Fonteterna",
	[123329] = "Baú de Baelog",
	[123462] = "A Joia dos Mares do Sul",
	[125477] = "Urna Evidente",
	[126049] = "Colônia de Campânulas Magenta",
	[126158] = "Cômoda de Tallonkai",
	[126260] = "Baú Antigo",
	[129127] = "Cofre de Gallywix",
	[131474] = "Os Discos de Norgannon",
	[138492] = "Estilhaços de Myzrael",
	[140911] = "Bobina de Seda Chartreuse Leve",
	[141832] = "Gongo de Zul'Farrak",
	[141853] = "Tragão Violeta",
	[141931] = "Ovo de Hipogrifo",
	[141979] = "Tesouro Antigo",
	[142071] = "Ovomático",
	[142088] = "Tabuleta da Vontade",
	[142122] = "Cartaz de Procura-se",
	[142127] = "Segredo de Rin'ji",
	[142151] = "Barril Lacrado",
	[142179] = "Gazebo de Solarsal",
	[142181] = "Carga Roubada",
	[142184] = "Baú do Capitão",
	[142185] = "Chama de Byltan",
	[142186] = "Chama de Lahassa",
	[142187] = "Chama de Imbel",
	[142188] = "Chama de Samha",
	[142195] = "Mapa de Batalha de Patábua",
	[142343] = "Pedestal de Uldum",
	[142344] = "Extrapolador Artificial",
	[142345] = "Matriz Perfuradora 3005-A",
	[142475] = "Matriz Perfuradora 3005-B",
	[142476] = "Matriz Perfuradora 3005-C",
	[142487] = "A Brastematic 5200",
	[142696] = "Matriz Perfuradora 3005-D",
	[142702] = "Garrafa de Peçonha",
	[142715] = "Tabuleta de Theka",
	[142958] = "Feralas: Uma História",
	[143980] = "Pergaminho Gordunni",
	[144053] = "Aparelho de Inspeção do Anilhacido",
	[144063] = "Monolito de Equinex",
	[144066] = "Primeira Jaula Cascasseca",
	[144067] = "Segunda Jaula Cascasseca",
	[144068] = "Terceira Jaula Cascasseca",
	[144070] = "Gaiola do Bicoafiado",
	[147557] = "Prata Roubada",
	[148498] = "Altar de Suntara",
	[148499] = "Caixa do Félix",
	[148504] = "Lápide Evidente",
	[148506] = "Artefato do Crepúsculo",
	[148513] = "Tabuleta de Jin'yael",
	[148514] = "Tabuleta de Markri",
	[148515] = "Tabuleta de Sael'hai",
	[148516] = "Tabuleta de Beth'Amara",
	[149025] = "Braseiro Sentinela",
	[149030] = "Braseiro Sentinela",
	[149031] = "Braseiro Sentinela",
	[149032] = "Braseiro Sentinela",
	[149036] = "Baú do Marlon",
	[149502] = "Tesouro da Revoada Negra",
	[150075] = "Cartaz de Procura-se",
	[151286] = "Tomo Kaldorei da Evocação",
	[152095] = "Lírio Lunapétala",
	[152097] = "Braseiro de Belnistrasz",
	[152618] = "Butim do Kolkar",
	[152622] = "Formação de Azsharita",
	[153123] = "Equipamento de Kam'arawn",
	[153239] = "Pena de Coruscante",
	[154357] = "Lama Irisada",
	[156561] = "Pôster de Procura-se",
	[157936] = "Monte de Terra de Un'Goro",
	[160836] = "Arca de Relíquia",
	[160845] = "Cofre Sombrio",
	[161495] = "Cofre Secreto",
	[161504] = "Um Pacote Pequeno",
	[161505] = "Bote Naufragado",
	[161521] = "Equipamento de Pesquisa",
	[161526] = "Caixote de Comestíveis",
	[161527] = "Osso de Dinossauro",
	[161557] = "Colheita da Madel",
	[161752] = "Balde de Ferramentas",
	[164659] = "Cristal de Poder Verde",
	[164661] = "Cristal de Poder Amarelo",
	[164689] = "Monumento de Franclorn Forjífice",
	[164778] = "Cristal de Poder Azul",
	[164780] = "Cristal de Poder Vermelho",
	[164820] = "Placa de Identificação do Guardião Sombrio",
	[164867] = "PROCURA-SE",
	[164868] = "SE VIR, MATE",
	[164869] = "Cálice Espectral",
	[164885] = "Dragão Noturno Corrompido",
	[164886] = "Flor da Canção Corrompida",
	[164887] = "Botão Selvagem Corrompido",
	[164888] = "Raiz-açoite Corrompida",
	[164909] = "Canoa Destruída",
	[164910] = "Baú Ornamentado",
	[164911] = "Barril de Cervaforte",
	[164953] = "Mochilas Grandes de Couro",
	[164954] = "Carapaça de Zukk'ash",
	[164955] = "Torre de Cristal Norte",
	[164956] = "Torre de Cristal Oeste",
	[164957] = "Torre de Cristal Oriental",
	[164958] = "Broto de Pétala Sangrenta",
	[165554] = "Coração da Montanha",
	[166863] = "Carcaça de Manguadonte Fresca",
	[169243] = "Baú dos Sete",
	[169294] = "Tabuletas dos Sete",
	[171938] = "Sabra",
	[171939] = "Flor da Canção Corrompida",
	[171942] = "Flor da Canção Corrompida",
	[173232] = "Instruções de Ferraria",
	[173265] = "Banheiro de Madeira",
	[173284] = "Raiz-açoite Corrompida",
	[173324] = "Dragão Noturno Corrompido",
	[173327] = "Botão Selvagem Corrompido",
	[174594] = "Flor da Canção Corrompida",
	[174595] = "Flor da Canção Corrompida",
	[174596] = "Flor da Canção Corrompida",
	[174597] = "Flor da Canção Corrompida",
	[174598] = "Flor da Canção Corrompida",
	[174599] = "Botão Selvagem Corrompido",
	[174600] = "Botão Selvagem Corrompido",
	[174601] = "Botão Selvagem Corrompido",
	[174602] = "Botão Selvagem Corrompido",
	[174603] = "Botão Selvagem Corrompido",
	[174604] = "Botão Selvagem Corrompido",
	[174605] = "Raiz-açoite Corrompida",
	[174606] = "Raiz-açoite Corrompida",
	[174607] = "Raiz-açoite Corrompida",
	[174608] = "Dragão Noturno Corrompido",
	[174682] = "Cuidado com o Pterrordax",
	[174684] = "Dragão Noturno Corrompido",
	[174686] = "Raiz-açoite Corrompida",
	[174708] = "Botão Selvagem Corrompido",
	[174709] = "Botão Selvagem Corrompido",
	[174712] = "Flor da Canção Corrompida",
	[174713] = "Flor da Canção Corrompida",
	[174728] = "Caixote Danificado",
	[174848] = "Equipamento de Teste",
	[175084] = "A Brastematic 5200",
	[175165] = "Baú do Aurora de Prata",
	[175166] = "Baú do Véu das Brumas",
	[175207] = "Criatura Marinha Encalhada",
	[175226] = "Criatura Marinha Encalhada",
	[175227] = "Criatura Marinha Encalhada",
	[175230] = "Criatura Marinha Encalhada",
	[175233] = "Criatura Marinha Encalhada",
	[175245] = "Chama Paternal",
	[175320] = "PROCURA-SE: Lodofundo!",
	[175324] = "Lascas de Friomalho",
	[175329] = "Reservas de Castanha Bosquenero",
	[175330] = "Reservas de Fruta Bosquenero",
	[175331] = "Reservas de Grão Bosquenero",
	[175334] = "Pertences de Biju",
	[175382] = "Cofre do Finitudo",
	[175384] = "Ovo de Mantícora de Alcândora",
	[175385] = "Tabuleta de Pedranegra",
	[175407] = "Pena Lunamarca",
	[175524] = "Cristal Vermelho Misterioso",
	[175565] = "Ovo Alienígena",
	[175566] = "Erva-do-emo",
	[175586] = "Carroça de Jaron",
	[175587] = "Caixote Danificado",
	[175606] = "Ovo de Aranha do Pináculo",
	[175629] = "Suprimentos do Jaron",
	[175708] = "Caixote de Suprimentos da Encruzilhada",
	[175785] = "Documentos Inconspícuos",
	[175802] = "Cofre Pequeno",
	[175886] = "Pique da Brutalidade",
	[175888] = "Fragmento da Relíquia dos Altaneiros",
	[175889] = "Ovo Velho",
	[175891] = "Fragmento da Relíquia dos Altaneiros",
	[175892] = "Fragmento da Relíquia dos Altaneiros",
	[175893] = "Fragmento da Relíquia dos Altaneiros",
	[175894] = "Embrulho da Janice",
	[175924] = "Armário Trancado",
	[175925] = "Casinha",
	[175926] = "Diário da Sra. Dalson",
	[175928] = "Agave Incendia",
	[175949] = "Quinta Tabuleta Mosh'aru",
	[175950] = "Sexta Tabuleta Mosh'aru",
	[175965] = "Fluido de Embalsamamento de Friomúrmuro",
	[175966] = "Fio Escarlate Encantado",
	[175970] = "Peitoral Rúnico Não Forjado",
	[176089] = "Manoplas de Placa Crua",
	[176090] = "Restos Humanos",
	[176091] = "Caldeirão de Lenha Morta",
	[176092] = "Caixa de Explosivos",
	[176112] = "Cofre de Malor",
	[176115] = "Pôster de Procura-se – Arnak Temível Totem",
	[176116] = "Cabeça da Boneca de Pâmela",
	[176142] = "Parte Esquerda da Boneca de Pâmela",
	[176143] = "Parte Direita da Boneca de Pâmela",
	[176145] = "Monumento do Josefo Trilharrubra",
	[176158] = "Braseiro da Dor",
	[176159] = "Braseiro da Malícia",
	[176160] = "Braseiro do Sofrimento",
	[176161] = "Braseiro do Ódio",
	[176189] = "Tartaruga Marinha Descarnada",
	[176190] = "Tartaruga Marinha Encalhada",
	[176191] = "Tartaruga Marinha Encalhada",
	[176192] = "Catálogo do Imprevisível",
	[176196] = "Tartaruga Marinha Encalhada",
	[176197] = "Tartaruga Marinha Encalhada",
	[176198] = "Tartaruga Marinha Encalhada",
	[176206] = "Incunábulo de Davil",
	[176207] = "Escudo de Trilharrubra",
	[176208] = "Crânio de Horgus",
	[176209] = "Espada Estilhaçada de Marduk",
	[176213] = "Sangue dos Heróis",
	[176245] = "Arquivo Escarlate",
	[176249] = "Dados do Flagelo",
	[176325] = "Instruções de Ferraria",
	[176344] = "Baú de Documentos",
	[176361] = "Caldeirão do Flagelo",
	[176392] = "Caldeirão do Flagelo",
	[176393] = "Caldeirão do Flagelo",
	[176484] = "A Escritura de Montalvo",
	[176485] = "A Escritura de Castro das Flechas",
	[176486] = "A Escritura de Costa Sul",
	[176487] = "A Escritura da Serraria Tarren",
	[176544] = "Restos Mortais de Eva Sarkhoff",
	[176545] = "Restos Mortais de Lucien Sarkhoff",
	[176582] = "Armadilha de Lagostim",
	[176630] = "Souvenir da Memória",
	[176631] = "Dádiva de Menethil",
	[176634] = "Baú de Kerlonian",
	[176751] = "Ossos de Kodo",
	[176785] = "Caixote de Munições",
	[176793] = "Feixe de Lenha",
	[177241] = "Filactério de Araj",
	[177243] = "Portal Demoníaco",
	[177264] = "Símbolo da Honra Perdida",
	[177287] = "Pintura Incompleta",
	[177289] = "Caldeirão do Flagelo",
	[177464] = "Cupinzeiro Grande",
	[177491] = "Barril de Cupins",
	[177544] = "Baú do Josefo",
	[177667] = "Pergaminho Rasgado",
	[177750] = "Broto Fúngico Lunar",
	[177784] = "Marisco de Casca Mole Gigante",
	[177786] = "Baú de Rodovalho",
	[177787] = "Diário de Rodovalho",
	[177789] = "Livro-caixa do Augustus",
	[177805] = "Restos Humanos Esquartejados",
	[177904] = "Pôster de Procura-se: Besseleth",
	[177964] = "Pedra das Profundezas",
	[178084] = "Baú do Félix",
	[178085] = "Balde de Parafusos do Félix",
	[178087] = "Picareta de Thazz'ril",
	[178090] = "Túmulo de Marla",
	[178104] = "Cristal de Ressonita",
	[178144] = "Baú dos Trolls",
	[178184] = "Safira de Aku'Mai",
	[178185] = "Safira de Aku'Mai",
	[178186] = "Safira de Aku'Mai",
	[178195] = "Óleo dos Brado Guerreiro",
	[178204] = "Carregamento de Machados dos Brado Guerreiro",
	[178227] = "Cesto do Totem de Murgut",
	[178553] = "Receptáculo Colme'Ashi",
	[178609] = "Neve de Feriado",
	[179485] = "Armadilha Quebrada",
	[179499] = "Cesta de Tanino Ôgrico",
	[179501] = "Tesouro do Fiapo Agulhacerta",
	[179516] = "Baú de Fengus",
	[179517] = "Tesouro dos Shen'dralar",
	[179544] = "Restos Descarnados de Telmius Romanesca",
	[179545] = "Baú do Príncipe",
	[179552] = "Diagrama: Robô de Reparos em Campo 74A",
	[179553] = "Fragmento de Núcleo",
	[179559] = "Lasca de Vinhavil",
	[179562] = "Lâmina Antiga Incandescente",
	[179564] = "Homenagem a Gordok",
	[179565] = "Relicário Empoeirado",
	[179697] = "Baú do Tesouro da Arena",
	[179703] = "Baú do Senhor do Fogo",
	[179827] = "Procurados/Desaparecidos/Achados e Perdidos",
	[179828] = "Travesseiro de Ferro Negro",
	[179832] = "Travesseiro Ornado da Alma Fada",
	[179879] = "Orbe de Comando",
	[179880] = "Marca de Drakkisath",
	[179913] = "Chamado às armas!",
	[179914] = "Pilha de Ossos",
	[179915] = "Pilha de Crânios",
	[179922] = "Recipiente com Sangue Maculado",
	[180229] = "Amontoado de Mandingas Azarentas",
	[180248] = "Cardume de Papas-finas",
	[180327] = "Braseiro da Loucura",
	[180366] = "Caixa de Ferramentas Desgastada",
	[180368] = "Tabuleta da Loucura",
	[180369] = "Águas Revoltas Barrentas",
	[180435] = "Algibeira do Noggel",
	[180436] = "Fragmento de Tabuleta do Crepúsculo",
	[180448] = "Cartaz de Procura-se: Agarramata",
	[180453] = "Cristal Entalhado de Glifos de Colme'Régia",
	[180454] = "Cristal Entalhado de Glifos de Colme'Ashi",
	[180455] = "Cristal Entalhado de Glifos de Colme'Zora",
	[180456] = "Pedra Eólica Menor",
	[180461] = "Pedra Eólica",
	[180466] = "Pedra Eólica Maior",
	[180501] = "Fragmento de Tabuleta do Crepúsculo",
	[180503] = "Livro de Receitas da Sandy",
	[180526] = "Gongo de Bethekk",
	[180570] = "Barril",
	[180633] = "Lágrima Cristalina",
	[180642] = "Caixote Inconspícuo",
	[180662] = "Destroços da Escuna",
	[180665] = "Dracônico para Leigos",
	[180666] = "Dracônico para Leigos",
	[180667] = "Dracônico para Leigos",
	[180669] = "Voragem Serpenteante",
	[180682] = "Cardume de Bocaneras Oleosos",
	[180684] = "Cardume de Sabichões Maiores",
	[180685] = "Destroços Encharcados",
	[180690] = "Grande Arca do Escaravelho",
	[180691] = "Arca do Escaravelho",
	[180712] = "Grande Cardume de Enguias Petrescamas",
	[180743] = "Presente Cuidadosamente Embrulhado",
	[180746] = "Presente Chacoalhado Gentilmente",
	[180747] = "Presente Alegremente Embrulhado",
	[180748] = "Presente Tiquetaqueante",
	[180751] = "Destroços Flutuantes",
	[180793] = "Presente Festivo",
	[180794] = "Diário de Janice Barov",
	[180901] = "Destroços dos Vela Sangrenta",
	[181053] = "Cesta de Algassangue",
	[181073] = "Caldeirão Cheiroso",
	[181085] = "Caixote de Suprimentos de Stratholme",
	[181098] = "Cinza Vulcânica",
	[181366] = "Baú dos Quatro Cavaleiros",
	[181597] = "Monte de Terra Silitista",
	[181598] = "Gêiser Silitista",
	[181672] = "Efígie do Homem de Palha",
	[181686] = "Pilha de Tábuas dos Brado Guerreiro",
	[181687] = "Pilha de Madeira",
	[190483] = "Baú de Documentos",
	[190484] = "Baú de Documentos",
	[201579] = "Fragmento do Monolito",
	[207724] = "Destroços do Naufrágio",
	[375544] = "Estatueta de Madeira",
	[387466] = "Cofre Enferrujado",
	[387477] = "Estoque dos Défias",
	[397987] = "Estoque dos Kobolds",
	[404695] = "Estoque Encharcado",
	[404911] = "Baú Escondido",
	[405633] = "Maleta Pedraqueixo",
	[405879] = "Cartilha da Sociedade dos Boticários",
	[406006] = "Ídolo",
	[406736] = "Estoque Perdido",
	[406918] = "Bolsa de Mensageiro",
	[408014] = "Tomo Gnômico",
	[415106] = "Restos Queimados",
	[415107] = "Restos Queimados",
	[417072] = "Tábua com Pregos",
	[417353] = "Fogueira de Acampamento Extinta",
	[422911] = "Barril Lacrado",
	[423695] = "Incunábulo da Libertação",
	[424005] = "Lixo de Bolso",
	[424006] = "Algibeira Enrolada às Pressas",
	[424007] = "Estatueta Entalhada",
	[424010] = "Tábua com Pregos",
	[424012] = "Monturo de Terra",
	[424074] = "Sinalizador de Quadrangulação 001",
	[439557] = "Musgo do Pesadelo",
	[439558] = "Depósito de Ferro Frio",
	[439627] = "Raiz-de-sonho",
	[439628] = "Veio de Ouro de Tolo",
	[439810] = "Raiz-da-lua",
	[439815] = "Formação de Pedras-da-lua Maiores",
	[441113] = "Texto de Magus Ogro",
	[441114] = "Caixa Misteriosa",
	[441119] = "Ovo de Dragão Verde Choco",
	[441124] = "Ovo de Dragão Tocado pelo Sonho",
	[441128] = "Caixote Vibratório",
	[441129] = "Profecia Azshariana",
	[441310] = "Ovo de Dragão do Brilho da Lua",
	[441312] = "Anotações do Guardião Louco",
	[441314] = "Escrito das Harpias",
	[441947] = "Altar da Fera",
	[441948] = "Altar do Guardião",
	[455812] = "Espada do Escudeiro Cuteberto",
	[457088] = "Esgrima Avançada",
	[457090] = "Famosos (e Infames) Patrulheiros de Azeroth",
	[457091] = "Manual de Treino de Chen",
	[457092] = "A Fúria de Tempesfúria",
	[457095] = "Elementos Para Leigos Volume I: Gelo",
	[457096] = "Seja o Primeiro: Guia de Boxe do Brigão",
	[457097] = "Elementos Para Leigos Volume II: Fogo",
	[457099] = "Guia de Zerene para Levar Socos",
	[457100] = "Comentários de Renzik sobre a Luta \"Justa\"",
	[457101] = "Os Ritos do Mak'Gora",
	[457102] = "Elementos Para Leigos Volume III: Arcano",
	[462233] = "Rochedo Derretido Cintilante",
	[100000001] = "Tocha Apagada",
});
for key,value in pairs({
	[11] = "|cFFAAFFAAIsto não estava disponível até Phase 1 de WoW Classic.|r",
	[1606] = "|cFFAAFFAAIsto não estava disponível até Phase 2 de Season of Discovery.|r",
	[1607] = "|cFFAAFFAAIsto não estava disponível até Phase 3 de Season of Discovery.|r",
	[1608] = "|cFFAAFFAAIsto não estava disponível até Phase 4 de Season of Discovery.|r",
	[1609] = "|cFFAAFFAAIsto não estava disponível até Phase 5 de Season of Discovery.|r",
	[1610] = "|cFFAAFFAAIsto não estava disponível até Phase 6 de Season of Discovery.|r",
	[1611] = "|cFFAAFFAAIsto não estava disponível até Phase 7 de Season of Discovery.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "Nível 10",
	[7] = "Nível 20",
	[8] = "Nível 30",
	[9] = "Nível 40",
	[10] = "Nível 50",
	[11] = "Nível 60",
	[42] = "Explorar os Reinos do Leste",
	[43] = "Explorar Kalimdor",
	[121] = "Cozinheiro Profissional",
	[122] = "Cozinheiro Perito",
	[123] = "Cozinheiro Artífice",
	[126] = "Pescador Profissional",
	[127] = "Pescador Perito",
	[128] = "Pescador Artífice",
	[131] = "Socorrista Profissional",
	[132] = "Socorrista Perito",
	[133] = "Socorrista Artífice",
	[238] = "Abate honroso",
	[239] = "25.000 jogadores abatidos honrosamente",
	[306] = "Mestre Pescador de Azeroth",
	[389] = "Mestre da Arena de Gurubashi",
	[396] = "Grande Mestre da Arena de Gurubashi",
	[416] = "Senhor dos Escaravelhos",
	[424] = "Pra quê? Pra ver melhor...",
	[425] = "Atiesh, Grande Cajado do Guardião",
	[428] = "Tormentária",
	[429] = "Sulfuras, a Mão de Ragnaros",
	[509] = "10.000 jogadores abatidos honrosamente",
	[512] = "5000 Jogadores Abatidos Honrosamente",
	[513] = "100 Jogadores Abatidos Honrosamente",
	[515] = "500 Jogadores Abatidos Honrosamente",
	[516] = "1000 Jogadores Abatidos Honrosamente",
	[520] = "Exaltado por 20 facções",
	[521] = "Exaltado por 15 facções",
	[522] = "Alguém gosta de mim",
	[523] = "Exaltado por 5 facções",
	[524] = "Exaltado por 10 facções",
	[546] = "Poupança fácil",
	[627] = "Explorar Dun Morogh",
	[628] = "Minas Mortas",
	[629] = "Cavernas Ígneas",
	[630] = "Caverna Ululante",
	[631] = "Bastilha da Presa Negra",
	[633] = "Cárcere de Ventobravo",
	[635] = "Urzal dos Tuscos",
	[636] = "Urzal dos Mortos",
	[641] = "Templo Submerso",
	[642] = "Abismo Rocha Negra",
	[643] = "Pico da Rocha Negra Inferior",
	[684] = "Covil da Onyxia (Nível 60)",
	[685] = "Covil Asa Negra",
	[686] = "Núcleo Derretido",
	[687] = "Templo de Ahn'Qiraj",
	[689] = "Ruínas de Ahn'Qiraj",
	[706] = "Uivador Lobo do Gelo",
	[707] = "Carneiro de Batalha Lançatroz",
	[708] = "Herói do Clã Lobo do Gelo",
	[709] = "Herói da Guarda de Lançatroz",
	[710] = "O Profanador",
	[711] = "Cavaleiro de Arathor",
	[712] = "Pioneiro Brado Guerreiro",
	[713] = "Sentinela da Asa de Prata",
	[714] = "O Conquistador",
	[727] = "Chamem a cavalaria!",
	[728] = "Explorar Durotar",
	[729] = "Rédeas do Corcel da Morte",
	[736] = "Explorar Mulgore",
	[750] = "Explorar os Sertões",
	[760] = "Explorar a Cordilheira de Alterac",
	[761] = "Explorar o Planalto Arathi",
	[765] = "Explorar os Ermos",
	[766] = "Explorar a Barreira do Inferno",
	[768] = "Explorar as Clareiras de Tirisfal",
	[769] = "Explorar a Floresta de Pinhaprata",
	[770] = "Explorar as Terras Pestilentas Ocidentais",
	[771] = "Explorar as Terras Pestilentas Orientais",
	[772] = "Explorar o Contraforte de Eira dos Montes",
	[773] = "Explorar as Terras Agrestes",
	[774] = "Explorar a Garganta Abrasadora",
	[775] = "Explorar as Estepes Ardentes",
	[776] = "Explorar a Floresta de Elwynn",
	[777] = "Explorar a Trilha do Vento Morto",
	[778] = "Explorar a Floresta do Crepúsculo",
	[779] = "Explorar Loch Modan",
	[780] = "Explorar as Montanhas Cristarrubra",
	[781] = "Explorar a Selva do Espinhaço",
	[782] = "Explorar o Pântano das Mágoas",
	[802] = "Explorar o Cerro Oeste",
	[841] = "Explorar o Pantanal",
	[842] = "Explorar Teldrassil",
	[844] = "Explorar a Costa Negra",
	[845] = "Explorar o Vale Gris",
	[846] = "Explorar Mil Agulhas",
	[847] = "Explorar a Cordilheira das Torres de Pedra",
	[848] = "Explorar Desolação",
	[849] = "Explorar Feralas",
	[850] = "Explorar o Pântano Vadeoso",
	[851] = "Explorar o Deserto de Tanaris",
	[852] = "Explorar Azshara",
	[853] = "Explorar a Selva Maleva",
	[854] = "Explorar a Cratera Un'Goro",
	[855] = "Explorar a Clareira da Lua",
	[856] = "Explorar Silithus",
	[857] = "Explorar Hibérnia",
	[871] = "Ioho, Almirante!",
	[879] = "Porque quando eu tinha a sua idade...",
	[880] = "Tigre Zulian Veloz",
	[881] = "Raptor Razzashi Veloz",
	[891] = "Meu primeiro pangaré",
	[907] = "Justicar",
	[940] = "Grande Espinhaço: Veredas",
	[944] = "Eles me amam naquele túnel",
	[946] = "A Aurora Argêntea",
	[955] = "Senhores das Águas Hidraxianos",
	[956] = "Prole de Nozdormu",
	[957] = "Herói da Tribo Zandalar",
	[1307] = "Pico da Rocha Negra Superior",
	[1676] = "Historiador dos Reinos do Leste",
	[1677] = "Historiador dos Reinos do Leste",
	[1678] = "Historiador de Kalimdor",
	[1680] = "Historiador de Kalimdor",
	[2116] = "Tabardo da Aurora Argêntea",
	[2141] = "Cavalariço",
	[2142] = "Peão de estábulo cheio",
	[2336] = "Dormir não dá reputação",
	[2357] = "Corcel Medonho de Zorote",
	[2358] = "Corcel",
	[2496] = "O quinto elemento",
	[3356] = "Sabre-de-gelo de Hibérnia",
	[5788] = "Agente dos Shen'dralar",
	[16433] = "Alma de Ferro (Temporada de Maestria)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "Alcançar o nível 10.",
	[7] = "Alcançar o nível 20.",
	[8] = "Alcançar o nível 30.",
	[9] = "Alcançar o nível 40.",
	[10] = "Alcançar o nível 50.",
	[11] = "Alcançar o nível 60.",
	[42] = "Explorar todas as regiões dos Reinos do Leste.",
	[43] = "Explorar todas as regiões de Kalimdor.",
	[121] = "Tornar-se Cozinheiro Profissional.",
	[122] = "Tornar-se Cozinheiro Perito.",
	[123] = "Tornar-se Cozinheiro Artífice.",
	[126] = "Tornar-se Pescador Profissional.",
	[127] = "Tornar-se Pescador Perito.",
	[128] = "Tornar-se Pescador Artífice.",
	[131] = "Tornar-se Profissional em Primeiros Socorros.",
	[132] = "Tornar-se Perito em Primeiros Socorros.",
	[133] = "Tornar-se Artífice em Primeiros Socorros.",
	[238] = "Abater um jogador honrosamente.",
	[239] = "Alcançar um total de 25.000 jogadores abatidos honrosamente.",
	[306] = "Vencer o torneio de pesca da Angra do Butim ou o Campeonato de Pesca dos Kalu'ak.",
	[389] = "Obter o berloque Mestre da Arena na Arena de Gurubashi.",
	[396] = "Cumprir a missão do João Tampinha Mithril para obter o berloque Grande Mestre da Arena.",
	[416] = "Participou da abertura dos portões de Ahn'Qiraj.",
	[424] = "Obter um Cristal Ressonante Qiraji Vermelho.",
	[425] = "Empunhar Atiesh, o Grande Cajado do Guardião.",
	[428] = "Empunhar Tormentária, a Lâmina Sagrada do Perseguidor dos Ventos.",
	[429] = "Empunhar Sulfuras, a Mão de Ragnaros.",
	[509] = "Alcançar um total de 10.000 jogadores abatidos honrosamente.",
	[512] = "Alcançar um total de 5.000 Jogadores Abatidos Honrosamente.",
	[513] = "Alcançar um total de 100 Jogadores Abatidos Honrosamente.",
	[515] = "Alcançar um total de 500 Jogadores Abatidos Honrosamente.",
	[516] = "Alcançar um total de 1000 Jogadores Abatidos Honrosamente.",
	[520] = "Tornar-se exaltado por 20 facções.",
	[521] = "Tornar-se exaltado por 15 facções.",
	[522] = "Tornar-se exaltado por uma facção.",
	[523] = "Tornar-se exaltado por 5 facções.",
	[524] = "Tornar-se exaltado por 10 facções.",
	[546] = "Comprar 7 compartimentos bancários.",
	[627] = "Explorar Dun Morogh, revelando as áreas encobertas do mapa.",
	[628] = "Derrotar Edwin VanCleef.",
	[629] = "Derrotar Taragaman, o Famélico.",
	[630] = "Derrotar Mutanus, o Devorador.",
	[631] = "Derrotar o Arquimago Arugal.",
	[633] = "Derrotar Basílio Taborda.",
	[634] = "Derrote o Mecangenheiro Termaplugue.",
	[635] = "Derrotar Charlga Talhaflanco.",
	[636] = "Derrotar Amnennar, o Frigífero.",
	[638] = "Derrote Arkhaedas.",
	[640] = "Derrotar a Princesa Theradras.",
	[641] = "Derrotar o Vulto de Erânicos.",
	[642] = "Derrotar o Imperador Dagran Thaurissan.",
	[643] = "Derrotar o Lorde Supremo Serpethalak.",
	[646] = "Derrotar os malignos gênios do crime que habitam Stratholme.",
	[684] = "Derrotar a versão clássica (nível 60) de Onyxia.",
	[685] = "Derrotar Nefarian.",
	[686] = "Derrotar Ragnaros.",
	[687] = "Derrotar C'Thun.",
	[688] = "Derrotar Hakkar.",
	[689] = "Derrotar Ossirian, o Intocado.",
	[706] = "Obter um Uivador Lobo do Gelo.",
	[707] = "Obter um Carneiro de Batalha Lançatroz.",
	[708] = "Tornar-se exaltado pelo Clã Lobo do Gelo.",
	[709] = "Tornar-se exaltado pela Guarda de Lançatroz.",
	[710] = "Tornar-se exaltado pelos Profanadores Renegados.",
	[711] = "Tornar-se exaltado pela Liga de Arathor.",
	[712] = "Tornar-se exaltado pelos Pioneiros do Brado Guerreiro.",
	[713] = "Tornar-se exaltado pelas Sentinelas da Asa de Prata.",
	[714] = "Elevar sua reputação para exaltado pela Ravina Brado Guerreiro, pela Bacia Arathi e pelo Vale Alterac.",
	[727] = "Obter uma das montarias de guerra através do sistema de honra.",
	[728] = "Explorar Durotar, revelando as áreas encobertas do mapa.",
	[729] = "Obter as Rédeas do Corcel da Morte do Barão Rivendare em Stratholme.",
	[736] = "Explorar Mulgore, revelando as áreas encobertas do mapa.",
	[750] = "Explorar os Sertões, revelando as áreas encobertas do mapa.",
	[760] = "Explorar as Montanhas de Alterac, revelando as áreas encobertas do mapa.",
	[761] = "Explorar o Planalto Arathi, revelando as áreas encobertas do mapa.",
	[765] = "Explorar os Ermos, revelando as áreas encobertas do mapa.",
	[766] = "Explorar a Barreira do Inferno, revelando as áreas encobertas do mapa.",
	[768] = "Explorar as Clareiras de Tirisfal, revelando as áreas encobertas do mapa.",
	[769] = "Explorar a Floresta de Pinhaprata, revelando as áreas encobertas do mapa.",
	[770] = "Explorar as Terras Pestilentas Ocidentais, revelando as áreas encobertas do mapa.",
	[771] = "Explorar as Terras Pestilentas Orientais, revelando as áreas encobertas do mapa.",
	[772] = "Explorar o Contraforte de Eira dos Montes, revelando as áreas encobertas do mapa.",
	[773] = "Explorar as Terras Agrestes, revelando as áreas encobertas do mapa.",
	[774] = "Explorar a Garganta Abrasadora, revelando as áreas encobertas do mapa.",
	[775] = "Explorar as Estepes Ardentes, revelando as áreas encobertas do mapa.",
	[776] = "Explorar a Floresta de Elwynn, revelando as áreas encobertas do mapa.",
	[777] = "Explorar a Trilha do Vento Morto, revelando as áreas encobertas do mapa.",
	[778] = "Explorar a Floresta do Crepúsculo, revelando as áreas encobertas do mapa.",
	[779] = "Explorar Loch Modan, revelando as áreas encobertas do mapa.",
	[780] = "Explorar as Montanhas Cristarrubra, revelando as áreas encobertas do mapa.",
	[781] = "Explorar a Selva do Espinhaço, revelando as áreas cobertas do mapa do mundo.",
	[782] = "Explorar o Pântano das Mágoas, revelando as áreas encobertas do mapa.",
	[802] = "Explorar o Cerro Oeste, revelando as áreas encobertas do mapa.",
	[841] = "Explorar o Pantanal, revelando as áreas encobertas do mapa.",
	[842] = "Explorar Teldrassil, revelando as áreas encobertas do mapa.",
	[844] = "Explorar a Costa Negra, revelando as áreas encobertas do mapa.",
	[845] = "Explorar o Vale Gris, revelando as áreas encobertas do mapa.",
	[846] = "Explorar Mil Agulhas, revelando as áreas encobertas do mapa.",
	[847] = "Explorar a Cordilheira das Torres de Pedra, revelando as áreas encobertas do mapa.",
	[848] = "Explorar Desolação, revelando as áreas encobertas do mapa.",
	[849] = "Explorar Feralas, revelando as áreas encobertas do mapa.",
	[850] = "Explorar o Pântano Vadeoso, revelando as áreas encobertas do mapa.",
	[851] = "Explorar o Deserto de Tanaris, revelando as áreas encobertas do mapa-múndi.",
	[852] = "Explorar Azshara, revelando as áreas encobertas do mapa.",
	[853] = "Explorar a Selva Maleva, revelando as áreas encobertas do mapa.",
	[854] = "Explorar a Cratera Un'Goro, revelando as áreas encobertas do mapa.",
	[855] = "Explorar a Clareira da Lua, revelando as áreas encobertas do mapa.",
	[856] = "Explorar Silithus, revelando as áreas encobertas do mapa.",
	[857] = "Explorar Hibérnia, revelando as áreas encobertas do mapa.",
	[871] = "Obter o Chapéu do Almirante dos Vela Sangrenta... e tentar respirar um pouco de ar fresco de vez em quando.",
	[879] = "Proprietário de uma das montarias épicas originais que não podem ser mais obtidas.",
	[880] = "Obter o Tigre Zulian Veloz do Sumo Sacerdote Thekal em Zul'Gurub.",
	[881] = "Obter o Raptor Razzashi Veloz do Sangrelorde Mandokir em Zul'Gurub",
	[891] = "Alcançar o nível de Aprendiz de Montaria.",
	[907] = "Elevar sua reputação para exaltado pela Ravina Brado Guerreiro, pela Bacia Arathi e pelo Vale Alterac.",
	[940] = "Cumprir as missões de Rosarães Guima na Selva do Espinhaço até a missão Grande Espinhaço: Veredas e A Grande Caçada.",
	[944] = "Tornar-se exaltado pelo Domínio dos Presamatos.",
	[946] = "Tornar-se exaltado pela Aurora Argêntea.",
	[955] = "Tornar-se exaltado pelos Senhores das Águas Hidraxianos.",
	[956] = "Tornar-se exaltado pela Prole de Nozdormu.",
	[957] = "Tornar-se exaltado pela Tribo Zandalar.",
	[1307] = "Derrotar o General Drakkisath.",
	[1676] = "Cumprir 700 missões nos Reinos do Leste.",
	[1677] = "Cumprir 550 missões nos Reinos do Leste.",
	[1678] = "Cumprir 700 missões em Kalimdor.",
	[1680] = "Cumprir 685 missões em Kalimdor.",
	[2116] = "Obter um Tabardo da Aurora Argêntea no evento da Invasão do Flagelo.",
	[2141] = "Obter 10 montarias.",
	[2142] = "Obter 25 montarias.",
	[2336] = "Elevar sua reputação para Honrado entre os Bucaneiros da Vela Sangrenta e Exaltado na Angra do Butim, Visteterna, Geringontzan, Vila Catraca, Feira de Negraluna, Corvoforte e Shen'dralar.",
	[2357] = "Completar a missão de bruxo Corcel Medonho de Zorote.",
	[2358] = "Completar a missão de paladino para obter um Corcel.",
	[2496] = "Obter uma Quintessência Aquática.",
	[3356] = "Obter um Sabre-de-gelo de Hibérnia.",
	[5788] = "Tornar-se exaltado pelos Shen'dralar.",
	[16433] = "Alcançar o nível 60 sem ter morrido nenhuma vez durante a Temporada de Maestria.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Proezas Memoráveis",
	[92] = "Geral",
	[95] = "Jogador x Jogador",
	[96] = "Missões",
	[97] = "Exploração",
	[168] = "Masmorras e Raides",
	[169] = "Profissões",
	[170] = "Culinária",
	[171] = "Pesca",
	[172] = "Primeiros Socorros",
	[201] = "Reputação",
	[14777] = "Reinos do Leste",
	[14778] = "Kalimdor",
	[14801] = "Vale Alterac",
	[14802] = "Bacia Arathi",
	[14804] = "Ravina Brado Guerreiro",
	[14808] = "Clássico",
	[14861] = "Clássico",
	[14864] = "Clássico",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "ru" then
localize(L.HEADER_NAMES, {
	[-1000010] = "Общая добыча с боссов",
	[-1000013] = "Обычные предметы у Торговцев",
	[-1000015] = "Наставник демонов",
	[-1000019] = "Исследование",
	[-1000021] = "Точка полета",
	[-1000025] = "Праздники",
	[-1000032] = "Редкие",
	[-1000034] = "Учитель верховой езды",
	[-1000038] = "Сундук с сокровищами",
	[-1000040] = "Эксперт по оружию",
	[-1000042] = "Мировые Боссы",
	[-1000044] = "Добыча локации",
	[-1000048] = "Драконы Кошмара",
	[-1000162] = "Общие Облики",
	[-1000163] = "Уникальный Облик",
	[-1000165] = "Комплекты T0.5",
	[-1000166] = "Капитаны",
	[-1000168] = "Четыре Всадника",
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (Восток)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (Север)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (Запад)",
	[-1000179] = "Кладбище",
	[-1000180] = "Библиотека",
	[-1000181] = "Оружейная",
	[-1000182] = "Собор",
	[-1000185] = "Защитники Атал'ай",
	[-1000191] = "Победить лейтенанта",
	[-1000192] = "Выиграй битву",
	[-1000193] = "Поговорите с мертвыми",
	[-1000195] = "Поговорите с Grizzby",
	[-1000196] = "Поговорите с Н'ора",
	[-1000198] = "Поговорите с Брат Ромул",
	[-1000201] = "Ярмарка Новолуния",
	[-1000218] = "Неделя урожая",
	[-1000223] = "Огненный Солнцеворот",
	[-1000227] = "Рыбомания Тернистой долины",
	[-1000234] = "Война в Ан'Кираже",
	[-1000235] = "Открытие Темного портала",
	[-1000236] = "Скипетр Зыбучих песков",
	[-1000237] = "Вторжение Плети",
	[-1000244] = "Коллекционное издание",
	[-1000273] = "Сезон открытий",
	[-1000274] = "Понимание",
	[-1000275] = "Уровень 1",
	[-1000276] = "Уровень 2",
	[-1000277] = "Охота на монстров",
	[-1000278] = "Гравировка",
	[-1000279] = "Подстерегающие припасы",
	[-1000373] = "Новый персонаж",
	[-1000376] = "Крепкая драка",
	[-1000377] = "Дикий полиморф",
	[-1000378] = "Душевные брокеры",
	[-1000380] = "Премия",
	[-1000970] = "Уровень 3",
	[-1001035] = "Сезонная рыба: летний окунь",
	[-1001036] = "Сезонная рыба: зимний кальмар",
	[-1001058] = "Роща Кошмаров",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000025] = "Чтобы выполнить упомянутые в данной секции Штучки, может быть нужен какой-то праздник.",
	[-1000033] = "Штучки, которые можно получить в награду с разного контента в родительской секции.\nОни собраны здесь, чтобы уменьшить количество источников, когда Штучка доступна из многих мест.",
	[-1000040] = "Мастер оружия - это NPC, который предлагает персонажам возможность изучить определенные навыки обращения с оружием, доступность которых варьируется от одного мастера к другому. Все навыки обращения с оружием можно изучить на уровне 1, кроме древкового оружия, для которого требуется уровень 20.\n\nОбучение с мастером оружия стало устаревшим в патче 4.0.1, так как все соответствующие классу навыки владения оружием теперь изучаются каждым классом при создании. Вскоре после этого из игры были удалены мастера оружия.",
	[-1000162] = "Предметы из данного списка - общие облики для предмета выше. Для Режима Уникальных Обликов, этот список может помочь Вам разобраться, почему определённый предмт отмечен как Получен или нет.",
	[-1000163] = "Этот предмет имеет Уникальный Облик. Вы должны получить именно этот предмет для открытия Облика.",
	[-1000273] = "В этом сезоне начальный максимальный уровень равен 25, а также новый финал для 25-го уровня, включающий рейд в Непроглядную Пучину для 10 игроков с новой механикой, новыми и переосмысленными боссами, которые бросят вызов тактике и стратегии игроков, а также свежими наградами.",
	[-1000278] = "Гравировка рун — это новая система, недавно анонсированная в сезоне «Открытие». Это позволяет каждому классу адаптировать свой игровой процесс, открывая новые уникальные способности!",
	[-1000279] = "Квестовые предметы Waylaid Supplies падают с мобов 6-го уровня и выше по всему Азероту. Эти квесты требуют доставки Запасных припасов представителю организации в обмен на немного серебра, опыта и репутации. Конечно, в поставке припасов отсутствуют предметы, и вы можете дополнить их, чтобы получить больше репутации.",
	[-1000376] = "Зачет получит только тот, кто нанесет последний удар по пьяному, независимо от того, кто первым нанес удар по цели. Для этого не существует группового кредита.",
	[-1000377] = "Примените «Превращение» к существам, пораженным «Диким превращением», чтобы снова превратить их в учеников. Каждый даст вам записку. Соберите 6 нот, чтобы выучить руну.",
	[-1000380] = "Этот список содержит Недоступные предметы, что Дискорд ATT сообщил как ошибки, которые Blizzard ещё не исправили.\n\nВНИМАНИЕ: Все фильтры игнорируются в данном списке для видимости. Только предметы, удалённые из игры из-за халатности, но не из-за гигантского огнедышащего дракона, перечислены в данном списке.\n\nК разработчикам Blizzard: Пожалуйста, почините предметы и события, перечисленные ниже.",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "Артефакты",
});
localize(ObjectNames, {
	[31] = "Статуя старого льва",
	[32] = "Затонувший сундук",
	[33] = "Запертый сундук",
	[34] = "Старый кувшин",
	[35] = "Сундучок капитана",
	[36] = "Разбитая бочка",
	[47] = "Розыск!",
	[52] = "Водопад Гурубаши",
	[54] = "Гробница императора",
	[55] = "Обглоданный труп",
	[56] = "Труп Рольфа",
	[57] = "Луна над долиной",
	[58] = "Гри'лек Странник",
	[59] = "Куча рыхлой земли",
	[60] = "Разыскивается: Гат'Илзогг",
	[61] = "Заброшенная могила",
	[68] = "Плакат \"Разыскивается\"",
	[76] = "Пустой кувшин",
	[119] = "Ящик Аберкромби",
	[256] = "РАЗЫСКИВАЕТСЯ",
	[257] = "Подозрительная бочка",
	[259] = "Полузакопанная бочка",
	[261] = "Поврежденный ящик",
	[263] = "Припасы Курцена",
	[264] = "Припасы Курцена",
	[269] = "Охраняемая бочка Громового эля",
	[270] = "Неохраняемая бочка Громового эля",
	[271] = "Ящики Лиги Рудокопов",
	[272] = "Мясной ледник Макгранна",
	[276] = "Корзинка с звездолистом",
	[287] = "Записи букмекера Ирода",
	[288] = "Сейф букмекера Ирода",
	[290] = "Платяной шкаф Хмуроброва",
	[321] = "Слеза Тиллоа",
	[331] = "Рыхлая земля",
	[333] = "Древняя святыня",
	[334] = "Древняя святыня",
	[375] = "Тирисфальская тыква",
	[711] = "Розыск!",
	[759] = "Святой источник",
	[1166] = "Сундук Алекстона",
	[1557] = "Обеденный стол Лилит",
	[1560] = "Ящик",
	[1561] = "Запечатанный ящик",
	[1562] = "Сундук маршала Хаггарда",
	[1571] = "Пыльные заклинательные книги",
	[1585] = "Взрывчатка",
	[1586] = "Ящик со свечами",
	[1593] = "Корабль с трупами",
	[1594] = "Книжная полка Берарда",
	[1599] = "Неглубокая могила",
	[1609] = "Катапульта клана Драконьей Пасти",
	[1610] = "Ароматитовая жила",
	[1627] = "Ящик из Даларана",
	[1673] = "Шишка Скверны",
	[1721] = "Запертые шар и цепь",
	[1722] = "Запертые шар и цепь",
	[1723] = "Цветок Грязного Рыла",
	[1727] = "Бочонок \"Землекопского крепкого\"",
	[1728] = "Пыльный коврик",
	[1736] = "Партия железа",
	[1738] = "Документы Синдиката",
	[1739] = "Документы Синдиката",
	[1740] = "Документы Синдиката",
	[1759] = "Регистрационная книга Хилсбрада",
	[1760] = "Старый книжный шкаф",
	[1761] = "Хилсбрадское официальное объявление",
	[1763] = "РАЗЫСКИВАЕТСЯ",
	[1765] = "Подержанный деревянный сундук",
	[1768] = "Пламя Азеля",
	[1769] = "Пламя Вераза",
	[1770] = "Пламя Узеля",
	[2008] = "ОПАСНО!",
	[2059] = "Труп дворфа",
	[2068] = "Портвейн Пупелливербоса",
	[2076] = "Бурлящий котел",
	[2083] = "Переписка Кровавого Паруса",
	[2084] = "Мускусный корень",
	[2086] = "Карты пиратов Кровавого паруса",
	[2087] = "Приказы пиратов Кровавого паруса",
	[2289] = "Разбитая спасательная шлюпка",
	[2553] = "Промокший свиток",
	[2554] = "Загадка Кортелло",
	[2555] = "Заплесневелый свиток",
	[2560] = "Полузакопанная бутылка",
	[2576] = "Алтарь Приливов",
	[2652] = "Труп Эбенезера Ржавый Засов",
	[2656] = "Промокшее письмо",
	[2688] = "Краеугольный камень",
	[2689] = "Западный связывающий камень",
	[2690] = "Внешний связывающий камень",
	[2691] = "Восточный связывающий камень",
	[2701] = "Радужные осколки",
	[2702] = "Внутренний связывающий камень",
	[2704] = "Тайный склад взрывчатки",
	[2707] = "Карты \"Девичьей Блажи\"",
	[2708] = "Карты \"Духа Серебряного бора\"",
	[2709] = "Судовой журнал \"Девичьей Блажи\"",
	[2710] = "Судовой журнал \"Духа Серебряного бора\"",
	[2712] = "Окаменевший эльфийский самоцвет",
	[2713] = "Розыск!",
	[2714] = "Альтеракский гранит",
	[2716] = "Сундук Трелана",
	[2717] = "Сундучок Трелана",
	[2718] = "Денежный ящик Трелана",
	[2724] = "Мешок овса",
	[2734] = "Отсыревший сундук",
	[2739] = "Сундук Черного пера",
	[2740] = "Сундук Вороньего Когтя",
	[2741] = "Сундук Небес",
	[2742] = "Сундук Гнездования",
	[2743] = "Резная каменная урна",
	[2744] = "Гигантский моллюск",
	[2842] = "Алмазный столп",
	[2848] = "Опаловый столп",
	[2858] = "Аметистовый столп",
	[2867] = "Ящик с припасами с карьера",
	[2868] = "Мятая карта",
	[2875] = "Рассыпающийся дворфийский скелет",
	[2891] = "Трофейные черепа Балиа'ма",
	[2892] = "Зиата'джайские трофейные черепа",
	[2893] = "Трофейные черепа Зулмамбве",
	[2907] = "Кувшин для воды",
	[2908] = "Запечатанный ящик с припасами",
	[2910] = "Камень у источника",
	[2912] = "Янтарное семя",
	[2933] = "Печать земли",
	[3076] = "Карта с пятнами грязи",
	[3189] = "План нападения на Долину Испытаний",
	[3190] = "План нападения на деревню Сен'джин",
	[3192] = "План нападения на Оргриммар",
	[3236] = "Ящик с гномскими инструментами",
	[3237] = "Останки пленника из клана Черного Копья",
	[3238] = "Пустой бочонок Чена",
	[3239] = "Сундук Бенедикта",
	[3240] = "Яйца кнутохвоста",
	[3290] = "Украденный мешок с припасами",
	[3525] = "Алтарь Огня",
	[3640] = "Спелый гриб",
	[3642] = "Добыча Колкара",
	[3643] = "Старый сундучок",
	[3644] = "Бейлмоданский ветролет",
	[3646] = "Сейф генерала Двукоссы",
	[3685] = "Курган силитида",
	[3737] = "Бурлящая расщелина",
	[3767] = "Ящик c пометкой \"Лавка Дриззлика\"",
	[3768] = "Ящик с пометкой \"Хрупкое! Не ронять!\"",
	[3972] = "РАЗЫСКИВАЕТСЯ",
	[4072] = "Главный клапан управления",
	[4141] = "Панель управления",
	[4406] = "Яйца чащобного тенетника",
	[4608] = "Побег древесника",
	[5620] = "Силовой камень с изъяном",
	[6751] = "Чудоягодник",
	[6752] = "Растение со странными листьями",
	[6906] = "Гнездо красного ящера",
	[6907] = "Гнездо синего ящера",
	[6908] = "Гнездо желтого ящера",
	[7510] = "Росток папоротника",
	[9630] = "Окаменелость Бутылопуза",
	[10076] = "Гадальная чаша",
	[11713] = "Мертвянка",
	[11714] = "Ножка струпника",
	[12666] = "Сумеречный фолиант",
	[13360] = "Реликвия Матистры",
	[13891] = "Змеецвет",
	[13949] = "Ржавый железный сундук",
	[15084] = "Чистер 5200",
	[15085] = "Чистер 5200",
	[16393] = "Древнее пламя",
	[17182] = "Жужжалка 827",
	[17183] = "Жужжалка 411",
	[17184] = "Жужжалка 323",
	[17188] = "Песнь об Амет'Аране",
	[17189] = "Падение Амет'Арана",
	[17282] = "Пучок трав",
	[17783] = "Древняя статуэтка",
	[19015] = "Слеза Элуны",
	[19016] = "Кустарник, покрытый звездной пылью",
	[19021] = "Ржавый сундук",
	[19022] = "Подержанный сундук",
	[19024] = "Потаенное святилище",
	[19027] = "Фолиант Мел'Тандриса",
	[19030] = "Куча грязи",
	[19283] = "\"Компендиум павших\"",
	[19284] = "\"Мифология Титанов\"",
	[19595] = "Светильник Привратника",
	[19596] = "Тайник Спящих",
	[19597] = "Тайник друидов",
	[19598] = "Тайник в кургане",
	[19599] = "Сокровищница Обители Когтя",
	[19602] = "Чертежи механизмов Торговой Компании",
	[19603] = "Бумаги Торговой компании",
	[19861] = "Дневник Хенрига Хмурня",
	[19869] = "Обломки болида",
	[19877] = "Сундучок Велинды",
	[19901] = "Круг Заточения",
	[20352] = "Круг Заточения",
	[20359] = "Яйцо Ониксии",
	[20447] = "Пищевые запасы гарпий",
	[20691] = "Сундучок Коззла",
	[20725] = "Наследие Аспектов",
	[20726] = "\"Истоки угрозы нежити\"",
	[20727] = "Упаковочный ящик Гизмориума",
	[20805] = "Неохраняемые чертежи Риззла",
	[20807] = "Древняя жаровня",
	[20920] = "Корень синелиста",
	[20985] = "Рыхлая земля",
	[20992] = "Черный щит",
	[21015] = "Следы копыт",
	[21016] = "Следы копыт",
	[21042] = "Кокарда Тераморской стражи",
	[21052] = "Сейф Братства Справедливости",
	[21277] = "Ящик с отверстиями",
	[21530] = "Справочник владельца Шмыгуноса",
	[22245] = "Мешок мяса",
	[22246] = "Слеза Терадрас",
	[22550] = "Кристаллы дренейского аметиста",
	[24798] = "Сухой плавник",
	[28024] = "Сундук из каравана",
	[28604] = "Разбитый ящик",
	[30854] = "Артефакт Атал'ай",
	[30855] = "Артефакт Атал'ай",
	[30856] = "Артефакт Атал'ай",
	[32569] = "Сейф Галена",
	[35251] = "Сундук Карнитола",
	[35252] = "Древняя святыня",
	[36738] = "Книга Ура",
	[37099] = "Табличка племени Атал'ай",
	[50935] = "Мешок кукурузы",
	[50936] = "Мешок ячменя",
	[50937] = "Мешок ржи",
	[50961] = "Сундук Малема",
	[50982] = "Опаленный дуб",
	[51708] = "Земля с могилы Элизы",
	[58369] = "Краденый железный сундук",
	[58595] = "Тайник клана Пылающего Клинка",
	[61934] = "Жаровня Дремлющего Пламени",
	[61935] = "Перепускной клапан",
	[61936] = "Топливный распределительный клапан",
	[68865] = "Палочка-погонялочка для шмыгуносов",
	[85562] = "Сейф Сталекрута",
	[85563] = "Сейф Мертвозуба",
	[86492] = "Ящик с элунитом",
	[89634] = "Железный коралл",
	[89635] = "Высохшая на солнце скорлупа",
	[91138] = "Молот Джордана",
	[92013] = "Фолиант заговора",
	[92420] = "Руда Бэйлора",
	[92423] = "Поврежденный сундук",
	[93192] = "Сердцедрево",
	[102984] = "Ящик для инструментов Бинк",
	[102985] = "Львиный зев Бальнира",
	[103574] = "Заполненная шкатулка-духоловка",
	[103628] = "Трактат Ура по темной магии",
	[103821] = "Сейф Доана",
	[104564] = "Ведро с инструментами Бинглза",
	[104569] = "Ведро с инструментами Бинглза",
	[104574] = "Ведро с инструментами Бинглза",
	[104575] = "Сорвиголовка Бинглза",
	[105169] = "Оружейная стойка Агамонда",
	[105170] = "Оружейная стойка Агамонда",
	[105171] = "Оружейная стойка Агамонда",
	[105172] = "Оружейная стойка Агамонда",
	[105174] = "Ящик со шкатулками-духоловками",
	[105175] = "Свиток заклятия Проявления",
	[112888] = "Пыльная полка",
	[112948] = "Запертый сейф на \"Отважном\".",
	[113757] = "Тайник Тенегорна",
	[113768] = "Ярко окрашенное яйцо",
	[113791] = "Жаровня Вечного источника",
	[123329] = "Сундук Бейлога",
	[123462] = "Драгоценный камень Южных морей",
	[125477] = "Подозрительная урна",
	[126049] = "Семейка грибов-малиновиков",
	[126158] = "Посудный шкаф Таллонкая",
	[126260] = "Древний сундук",
	[129127] = "Сейф Галливикса",
	[131474] = "Диски Норганнона",
	[138492] = "Кристаллы Мизраэль",
	[140911] = "Катушка светло-оливковых шелковых ниток",
	[140971] = "Газ'рилльское украшение",
	[141812] = "Связывающий камень",
	[141832] = "Гонг Зул'Фаррака",
	[141853] = "Фиалковый траган",
	[141857] = "Связывающий камень",
	[141858] = "Связывающий камень",
	[141859] = "Связывающий камень",
	[141931] = "Яйцо гиппогрифа",
	[141979] = "Древнее сокровище",
	[141980] = "Призрачный сейф",
	[142071] = "Яйц-О-Матик",
	[142076] = "Свежие яблоки Клары",
	[142088] = "Табличка воли",
	[142122] = "Плакат \"Разыскивается\"",
	[142127] = "Секрет Рин'джи",
	[142151] = "Запечатанная бочка",
	[142179] = "Соларсальская Беседка",
	[142181] = "Краденый груз",
	[142184] = "Сундук капитана",
	[142185] = "Пламя Бильтана",
	[142186] = "Пламя Лахассы",
	[142187] = "Пламя Имбела",
	[142188] = "Пламя Самхи",
	[142189] = "Не вызывающий подозрений ориентир",
	[142191] = "Ящик Орды с припасами",
	[142195] = "Тактическая карта стаи Древолапов",
	[142343] = "Ульдумский пьедестал",
	[142344] = "Искусственный экстраполятор",
	[142345] = "Матричный перфограф 3005-A",
	[142475] = "Матричный перфограф 3005-B",
	[142476] = "Матричный перфограф 3005-C",
	[142477] = "Предохранитель Термоштепселя",
	[142487] = "Чистер 5200",
	[142696] = "Матричный перфограф 3005-D",
	[142702] = "Флакон с ядом",
	[142715] = "Табличка Теки",
	[142958] = "Фералас: История",
	[143980] = "Свиток Гордунни",
	[144053] = "Обозревательное устройство Холстомера",
	[144054] = "Сундук Шаи",
	[144063] = "Монолит Равноденствия",
	[144064] = "Куча земли Гордунни",
	[144066] = "Первая клетка племени Сухокожих",
	[144067] = "Вторая клетка племени Сухокожих",
	[144068] = "Третья клетка племени Сухокожих",
	[144070] = "Клетка Остроклюва",
	[147557] = "Украденное серебро",
	[148498] = "Алтарь Сунтары",
	[148499] = "Ящик Феликса",
	[148504] = "Подозрительное надгробие",
	[148506] = "Сумеречный Артефакт",
	[148512] = "Купель сущности",
	[148513] = "Табличка Джин'яэль",
	[148514] = "Табличка Маркри",
	[148515] = "Табличка Саэль'Хай",
	[148516] = "Табличка Бет'Амары",
	[148832] = "Статуя Аталаи",
	[148836] = "Алтарь Хаккара",
	[148838] = "Идол Хаккара",
	[149025] = "Жаровня на башне",
	[149030] = "Жаровня на башне",
	[149031] = "Жаровня на башне",
	[149032] = "Жаровня на башне",
	[149036] = "Сундук Марвона",
	[149047] = "Факел воздаяния",
	[149480] = "Руна Джин'яэль",
	[149481] = "Руна Бет'Амары",
	[149482] = "Руна Маркри",
	[149483] = "Руна Саэл'Хаи",
	[149502] = "Сокровищница черных драконов",
	[150075] = "Плакат \"Разыскивается\"",
	[150140] = "Кристалл средоточия чар",
	[151286] = "Калдорайский фолиант Призыва",
	[152094] = "Гиацинтовый гриб",
	[152095] = "Лунная лилия",
	[152097] = "Жаровня Белнистраза",
	[152608] = "Добыча Колкара",
	[152618] = "Добыча Колкара",
	[152622] = "Отложение азшарита",
	[153123] = "Оборудование Ким'джаеля",
	[153205] = "Алтарь Осквернителя",
	[153239] = "Перо дикого совуха",
	[153556] = "Мощи Тауриссана",
	[154357] = "Блестящая грязь",
	[156561] = "Плакат \"Разыскивается\"",
	[157936] = "Куча земли Ун'Горо",
	[160836] = "Реликварий",
	[160840] = "Куча рыхлой земли",
	[160845] = "Черный ящик",
	[161495] = "Потайной сейф",
	[161504] = "Небольшая сумка",
	[161505] = "Разбитый плот",
	[161521] = "Исследовательское оборудование",
	[161526] = "Ящик с провизией",
	[161527] = "Кость динозавра",
	[161557] = "Урожай Милли",
	[161752] = "Ведро с инструментами",
	[164659] = "Зеленый кристалл силы",
	[164661] = "Желтый кристалл силы",
	[164662] = "Ящики cо старой одеждой",
	[164689] = "Монумент Франклорну Искуснику",
	[164778] = "Синий кристалл силы",
	[164780] = "Красный кристалл силы",
	[164798] = "Корень вечерника",
	[164820] = "Табличка с именем темного хранителя",
	[164867] = "РАЗЫСКИВАЕТСЯ",
	[164868] = "УБИТЬ НА МЕСТЕ",
	[164869] = "Призрачный кубок",
	[164885] = "Оскверненный Ночной дракон",
	[164886] = "Оскверненный песнецвет",
	[164887] = "Оскверненный ветроцвет",
	[164888] = "Гнилой кнутокорень",
	[164909] = "Разбитая гребная лодка",
	[164910] = "Украшенный сундук",
	[164911] = "Бочонок громоварского светлого",
	[164953] = "Большие кожаные рюкзаки",
	[164954] = "Кокон Зукк'аш",
	[164955] = "Северный хрустальный пилон",
	[164956] = "Западный хрустальный пилон",
	[164957] = "Восточный хрустальный пилон",
	[164958] = "Росток кровоцвета",
	[165554] = "Сердце Горы",
	[166863] = "Свежий труп жесткозуба",
	[169243] = "Сундук Семерых",
	[169294] = "Табличка Семерых",
	[171938] = "Плод кактуса",
	[171939] = "Оскверненный песнецвет",
	[171942] = "Оскверненный песнецвет",
	[173232] = "Чертежи кузнечного дела",
	[173265] = "Деревянный туалет",
	[173266] = "Учетная книга Сталлера",
	[173284] = "Гнилой кнутокорень",
	[173324] = "Оскверненный Ночной дракон",
	[173327] = "Оскверненный ветроцвет",
	[174594] = "Оскверненный песнецвет",
	[174595] = "Оскверненный песнецвет",
	[174596] = "Оскверненный песнецвет",
	[174597] = "Оскверненный песнецвет",
	[174598] = "Оскверненный песнецвет",
	[174599] = "Оскверненный ветроцвет",
	[174600] = "Оскверненный ветроцвет",
	[174601] = "Оскверненный ветроцвет",
	[174602] = "Оскверненный ветроцвет",
	[174603] = "Оскверненный ветроцвет",
	[174604] = "Оскверненный ветроцвет",
	[174605] = "Гнилой кнутокорень",
	[174606] = "Гнилой кнутокорень",
	[174607] = "Гнилой кнутокорень",
	[174608] = "Оскверненный Ночной дракон",
	[174682] = "Опасайся терродактилей",
	[174684] = "Оскверненный Ночной дракон",
	[174686] = "Гнилой кнутокорень",
	[174708] = "Оскверненный ветроцвет",
	[174709] = "Оскверненный ветроцвет",
	[174712] = "Оскверненный песнецвет",
	[174713] = "Оскверненный песнецвет",
	[174728] = "Поврежденный ящик",
	[174793] = "Инкубатор Улья Гориши",
	[174848] = "Испытательное оборудование",
	[175084] = "Чистер 5200",
	[175165] = "Сейф Серебряной Зари",
	[175166] = "Сейф Туманной Пелены",
	[175207] = "Выброшенная на берег морская тварь",
	[175226] = "Выброшенная на берег морская тварь",
	[175227] = "Выброшенная на берег морская тварь",
	[175230] = "Выброшенная на берег морская тварь",
	[175233] = "Выброшенная на берег морская тварь",
	[175245] = "Огонь отцов",
	[175264] = "Сущность детеныша дракона",
	[175320] = "Разыскивается: Глубомрак!",
	[175324] = "Кристаллы великанов Ледяного Молота",
	[175329] = "Ореховый склад Чернолесья",
	[175330] = "Фруктовый склад Чернолесья",
	[175331] = "Зернохранилище племени Чернолесья",
	[175334] = "Вещи Блестяшки",
	[175369] = "Черный ход на площадь Старейшин",
	[175382] = "Металлический ящик Рокового Зажима",
	[175384] = "Яйцо виверны Скального гнездовья",
	[175385] = "Табличка Темного Камня",
	[175407] = "Осененное луной перо",
	[175487] = "Третья табличка Мошару",
	[175488] = "Четвертая табличка Мошару",
	[175524] = "Таинственный красный кристалл",
	[175565] = "Странное яйцо",
	[175566] = "Мракоцвет",
	[175586] = "Фургон Джерона",
	[175587] = "Поврежденный ящик",
	[175606] = "Яйцо скального паука",
	[175621] = "Груда приношений Арроку",
	[175629] = "Припасы Джерона",
	[175704] = "Опаленное письмо",
	[175708] = "Ящики с припасами для Перекрестка",
	[175785] = "Не вызывающие подозрений документы",
	[175802] = "Маленький сейф",
	[175886] = "Копье грубой силы",
	[175888] = "Фрагмент реликвии высокорожденных",
	[175889] = "Древнее яйцо",
	[175891] = "Фрагмент реликвии высокорожденных",
	[175892] = "Фрагмент реликвии высокорожденных",
	[175893] = "Фрагмент реликвии высокорожденных",
	[175894] = "Посылка Дженис",
	[175924] = "Запертый шкаф",
	[175925] = "Туалет",
	[175926] = "Дневник миссис Далсон",
	[175928] = "Огненная агава",
	[175944] = "Священный огонь Жизни",
	[175949] = "Пятая табличка Мошару",
	[175950] = "Шестая табличка Мошару",
	[175965] = "Бальзамировочный состав Ледяного Шепота",
	[175966] = "Зачарованная алая нить",
	[175970] = "Распаянный рунический латный нагрудник",
	[176089] = "Неопалимые латные рукавицы",
	[176090] = "Человеческие останки",
	[176091] = "Котел Мертвого Леса",
	[176092] = "Ящик с зажигательной смесью",
	[176112] = "Сейф Малора",
	[176115] = "Плакат \"Разыскивается\": Арнак Зловещий Тотем",
	[176116] = "Голова куклы Памелы",
	[176142] = "Левая половинка куклы Памелы",
	[176143] = "Правая половинка куклы Памелы",
	[176145] = "Монумент Джозефа Редпата",
	[176150] = "Заплесневелый фолиант",
	[176158] = "Жаровня Боли",
	[176159] = "Жаровня Злобы",
	[176160] = "Жаровня Страдания",
	[176161] = "Жаровня Ненависти",
	[176189] = "Скелет морской черепахи",
	[176190] = "Выбросившаяся на берег морская черепаха",
	[176191] = "Выброшенная на берег морская черепаха",
	[176192] = "Перечень Заблудших",
	[176196] = "Выбросившаяся на берег морская черепаха",
	[176197] = "Выброшенная на берег морская черепаха",
	[176198] = "Выброшенная на берег морская черепаха",
	[176206] = "Манускрипт Дейвила",
	[176207] = "Щит Редпата",
	[176208] = "Череп Хоргуса",
	[176209] = "Сломанный меч Мардука",
	[176213] = "Кровь героев",
	[176245] = "Архивы Алого ордена",
	[176249] = "Сведения о Плети",
	[176317] = "Серебряный Оплот",
	[176325] = "Чертежи кузнечного дела",
	[176344] = "Ящик с документами",
	[176356] = "Священные письмена высокорожденных",
	[176361] = "Котел Плети",
	[176392] = "Котел Плети",
	[176393] = "Котел Плети",
	[176484] = "Документы на Брилл",
	[176485] = "Документы на Каэр Дарроу",
	[176486] = "Документы на Южнобережье",
	[176487] = "Документы на Мельницу Таррен",
	[176544] = "Останки Евы Саркофф",
	[176545] = "Останки Люсьена Саркоффа",
	[176581] = "Кристалл Руки Ируксоса",
	[176582] = "Ловушка на моллюска",
	[176630] = "Книга воспоминаний",
	[176631] = "Дар Менетила",
	[176634] = "Сундук Керлониана",
	[176751] = "Кости кодо",
	[176785] = "Ящик со снарядами",
	[176793] = "Вязанка дров",
	[177240] = "Куча рыхлой земли",
	[177241] = "Оберег Аража",
	[177243] = "Портал демонов",
	[177264] = "Символ утраченной чести",
	[177287] = "Незаконченная картина",
	[177289] = "Котел Плети",
	[177464] = "Большой термитник",
	[177490] = "Ящик с лесопилки Северного Кряжа",
	[177491] = "Термитная бочка",
	[177544] = "Сундук Джозефа",
	[177624] = "Демонова сума Забраксиса",
	[177667] = "Разорванный свиток",
	[177675] = "Куча грязи",
	[177684] = "Камень Ши-Ротам",
	[177747] = "Реестр Кель'Таласа",
	[177750] = "Лунный Плеснецвет",
	[177784] = "Гигантский моллюск в мягком панцире",
	[177786] = "Сундук Ракмора",
	[177787] = "Записи Ракмора",
	[177789] = "Книга рецептов Августа",
	[177804] = "Изуродованный человеческий труп",
	[177805] = "Изуродованный человеческий труп",
	[177806] = "Изуродованный человеческий труп",
	[177904] = "Плакат: \"Разыскивается\": Бесселет",
	[177926] = "Семя Геи",
	[177929] = "Земляной курган Геи",
	[177964] = "Глубинный Камень",
	[178084] = "Сундук Феликса",
	[178085] = "Феликсово ведро с гайками",
	[178087] = "Кирка Тазз'рила",
	[178090] = "Могила Марлы",
	[178104] = "Кристалл резонита",
	[178144] = "Тролльский сундук",
	[178145] = "Резонитовый ящик",
	[178184] = "Сапфир Аку'мая",
	[178185] = "Сапфир Аку'мая",
	[178186] = "Сапфир Аку'мая",
	[178195] = "Масло Песни Войны",
	[178204] = "Партия топоров Песни Войны",
	[178227] = "Корзина тотема Мургута",
	[178553] = "Кокон Улья Аши",
	[178609] = "Праздничный снег",
	[179485] = "Сломанная ловушка",
	[179499] = "Огрский дубильный чан",
	[179501] = "Тайник Уззла Наперстяка",
	[179516] = "Сундук Фенгуса",
	[179517] = "Сокровище шен'дралар",
	[179544] = "Останки Тельмия Сновидца",
	[179545] = "Сундук принца",
	[179547] = "Пыльный фолиант",
	[179551] = "Сундук Гидраксиса",
	[179552] = "Схема: полевой ремонтный робот 74A",
	[179553] = "Осколок из Огненных Недр",
	[179559] = "Осколок сквернита",
	[179562] = "Древний закаленный клинок",
	[179564] = "Приношения Гордока",
	[179565] = "Пыльный реликварий",
	[179644] = "Плененный страж ужаса",
	[179697] = "Сундук с сокровищами арены",
	[179703] = "Тайник повелителя огня",
	[179826] = "Секретный рецепт: огненный плавень",
	[179827] = "Розыск/Пропал без вести/Найден",
	[179828] = "Подушка дворфа из клана Черного Железа",
	[179832] = "Вышитая подушка Крепких Тисков",
	[179879] = "Сфера Приказа",
	[179880] = "Клеймо Драккисата",
	[179913] = "К оружию!",
	[179914] = "Груда костей",
	[179915] = "Груда черепов",
	[179922] = "Сосуд с порченой кровью",
	[180215] = "Ториевая жила Хаккари",
	[180229] = "Груда зачарованных худу",
	[180248] = "Косяк вкуснорыбы",
	[180327] = "Жаровня Безумия",
	[180366] = "Побитый ящик для рыболовных снастей",
	[180368] = "Табличка Безумия",
	[180369] = "Грязный водоворот",
	[180435] = "Сумка Ноггла",
	[180436] = "Фрагмент сумеречной таблички",
	[180448] = "Плакат: \"Разыскивается\": Смертехват",
	[180453] = "Покрытый письменами кристалл Улья Регал",
	[180454] = "Покрытый письменами кристалл Улья Аши",
	[180455] = "Покрытый письменами кристалл Улья Зора",
	[180456] = "Меньший камень Ветров",
	[180461] = "Камень Ветров",
	[180466] = "Больший Ветровой Камень",
	[180501] = "Фрагмент сумеречной таблички",
	[180503] = "Занесенная песком поваренная книга",
	[180526] = "Гонг Бетекка",
	[180570] = "Бочонок",
	[180633] = "Хрустальная слеза",
	[180642] = "Не вызывающий подозрений сундук",
	[180652] = "Только что выброшенная земля",
	[180662] = "Разбитая шхуна",
	[180665] = "\"Драконий язык для чайников\"",
	[180666] = "\"Драконий язык для чайников\"",
	[180667] = "\"Драконий язык для чайников\"",
	[180669] = "Кружащий Водоворот",
	[180682] = "Косяк масляного черноротика",
	[180684] = "Косяк большого шалфокуня",
	[180685] = "Плавающие обломки",
	[180690] = "Большой сундук Скарабея",
	[180691] = "Сундук Скарабея",
	[180712] = "Стайка каменного угря",
	[180717] = "Гонг Скарабея",
	[180743] = "Тщательно упакованный подарок",
	[180746] = "Слегка помятый подарок",
	[180747] = "Подарок в яркой упаковке",
	[180748] = "Тикающий подарок",
	[180751] = "Обломки в воде",
	[180793] = "Подарок в разноцветной упаковке",
	[180794] = "Дневник Джандис Баровой",
	[180901] = "Обломки кораблекрушения Кровавого Паруса",
	[181053] = "Корзина ламинарии кровавой",
	[181073] = "Котел Ароматов",
	[181074] = "Трофеи арены",
	[181083] = "Наследие Сотоса и Джариена",
	[181085] = "Стратхольм - ящик с припасами",
	[181098] = "Вулканический пепел",
	[181366] = "Сундук четырех всадников",
	[181597] = "Курган силитиста",
	[181598] = "Гейзер силитиста",
	[181672] = "Фигурка Плетеного человека",
	[181686] = "Штабель пиломатериалов",
	[181687] = "Штабель пиломатериалов",
	[190483] = "Ящик с документами",
	[190484] = "Ящик с документами",
	[201579] = "Осколок краеугольного камня",
	[207724] = "Обломки кораблекрушения",
	[375544] = "Деревянная статуэтка",
	[386675] = "Зарытое сокровище",
	[386691] = "Книга из библиотеки",
	[386759] = "Книга из библиотеки",
	[386777] = "Пыльный сундук",
	[387466] = "Ржавый сейф",
	[387477] = "Тайник Братства Справедливости",
	[392029] = "Награда мечника",
	[397987] = "Тайник кобольдов",
	[402215] = "Обгоревшая записка",
	[403041] = "Припасы для взрывов",
	[403102] = "Склад добычи Дыбогривов",
	[403105] = "Шишка неистовства ветра",
	[403718] = "Луговой цветок",
	[404352] = "Хранилище артефактов",
	[404433] = "Лунный сундук",
	[404695] = "Отсыревший тайник",
	[404911] = "Тайник",
	[404941] = "Реликварий",
	[405149] = "Фреска с Та'зо",
	[405628] = "Склад добычи Мерзлогривов",
	[405633] = "Сундучок племени Каменной Челюсти",
	[405879] = "Ученик фармацевтического общества",
	[406006] = "Идол",
	[406736] = "Забытый тайник",
	[406918] = "Сумка посланника",
	[407117] = "Заброшенное гнездо хрустогрыза",
	[407120] = "Пустое гнездо хрустогрыза",
	[407247] = "Цветок с поляны",
	[407289] = "Боевой штандарт Орды",
	[407312] = "Голодный идол",
	[407347] = "Алтарь шипов",
	[407352] = "Тайник племени Кривой Сосны",
	[407453] = "Тайник с добычей братства Южных Морей",
	[407454] = "Бочонок с порохом",
	[407457] = "Сундучок смотрителя стойл",
	[407505] = "Резьба",
	[407510] = "Резьба",
	[407566] = "Гоблинская книга",
	[407731] = "Ящик с инструментами каменщика",
	[407734] = "Тайник Кривой Сосны",
	[407918] = "Пустая витрина для трофеев",
	[408004] = "Перемешанная куча гнили",
	[408014] = "Гномья книга",
	[408718] = "Тайник со снаряжением",
	[408799] = "Идол Глубин",
	[408802] = "Корявый гарпун",
	[409289] = "Странная сфера",
	[409315] = "Разбитая сфера",
	[409496] = "Свитки",
	[409562] = "Книга заклинаний",
	[409692] = "Свитки",
	[409700] = "Руководство",
	[409711] = "Свитки",
	[409731] = "Свитки",
	[409735] = "Книга заклинаний",
	[409758] = "Выброшенный шлем",
	[409942] = "Статуя одной из сов",
	[409949] = "Статуя одной из сов",
	[410020] = "Статуя совы",
	[410299] = "Секреты тайной магии",
	[410847] = "Ржавый сейф",
	[411328] = "Спящие кости",
	[411348] = "Пыльный сундук",
	[411358] = "Сундук мастера",
	[414532] = "Сундук, найденный у реки Скалистой",
	[414624] = "Тайник в маяке",
	[414663] = "Идол Пронзающего Копья",
	[415106] = "Прогоревшие останки",
	[415107] = "Прогоревшие останки",
	[415614] = "Таинственные формулы",
	[417072] = "Доска с гвоздями",
	[417353] = "Потушенный костер",
	[418855] = "Тайник Иллари",
	[422911] = "Запечатанная бочка",
	[422919] = "Початый тенегорнский бочонок",
	[423569] = "Потерянный мешочек",
	[423695] = "Манускрипт избавления",
	[423841] = "Обледенелые останки",
	[424005] = "Карманный мусор",
	[424006] = "Наскоро завернутая сумка",
	[424007] = "Вырезанная статуэтка",
	[424010] = "Доска с гвоздями",
	[424012] = "Куча грязи",
	[424075] = "Квадрангуляционный маяк 002",
	[439627] = "Сон-корень",
	[439628] = "Жила ложного золота",
	[439762] = "Звездный лотос",
	[439778] = "Жила звездного серебра",
	[439810] = "Лунный корень",
	[439815] = "Отложение большого лунного камня",
	[441124] = "Усиленное Сном яйцо дракона",
	[441128] = "Вибрирующий ящик",
	[441129] = "Азшарское пророчество",
	[441133] = "Усиленное звездами яйцо дракона",
	[441140] = "Гудящая коробка",
	[441141] = "Жемчужина Сна",
	[441310] = "Лунное яйцо дракона",
	[441312] = "Записки безумного хранителя",
	[441314] = "Бессвязные записи гарпии",
	[441848] = "Маленькая яма",
	[441946] = "Святилище луны",
	[441947] = "Святилище зверя",
	[441948] = "Святилище стража",
	[455812] = "Меч оруженосца Катберта",
	[457090] = "Прославленные (и бесславные) следопыты Азерота",
	[457091] = "Боевое руководство Чэня",
	[457092] = "Гнев Ярости Бури",
	[457093] = "Ударное правосудие: история одного дворфа",
	[457095] = "Стихии для чайников, том I: лед",
	[457096] = "Стань первым: руководство по кулачному бою",
	[457097] = "Стихии для чайников, том II: огонь",
	[457098] = "Душа кошки: руководство по современному друидизму",
	[457099] = "Руководство Зайрина по выдерживанию тумаков",
	[457100] = "Мысли Рензика о \"справедливых\" поединках",
	[462233] = "Сверкающая расплавленная скала",
	[100000001] = "Незажженный факел",
});
for key,value in pairs({
	[1] = "Никогда Не Доступны [NYI]",
	[2] = "Убраны Из Игры",
	[3] = "Кошелек Blizzard",
	[4] = "ПвП Элита / Гладиатор",
	[5] = "Неизучаемые",
})
do phases[key].name = value; end
for key,value in pairs({
	[1] = "|cFFFF0000Никогда не был доступен игрокам.|r",
	[2] = "|cFFFF0000Был убран из игры.|r",
	[3] = "|cFFAAFFAAМожет быть скрыто за вложением денег, возможно, игровой магазин, другая игра Blizzard и \"Пригласи Друга\".|r",
	[4] = "|cFFFFAAAAЭто больше нельзя будет купить или получить в коллекцию, если у вас нет необходимого PvP титула или если вы не входили в топ % лучших в этом сезоне.|r",
	[5] = "|cFFFFAAAAЭто нельзя собрать, выучить навсегда или использовать для трансмогрификации.|r",
	[11] = "|cFFAAFFAAЭто было недоступно до Phase 1 из WoW Classic.|r",
	[1606] = "|cFFAAFFAAЭто было недоступно до Phase 2 из Season of Discovery.|r",
	[1607] = "|cFFAAFFAAЭто было недоступно до Phase 3 из Season of Discovery.|r",
	[1608] = "|cFFAAFFAAЭто было недоступно до Phase 4 из Season of Discovery.|r",
	[1609] = "|cFFAAFFAAЭто было недоступно до Phase 5 из Season of Discovery.|r",
	[1610] = "|cFFAAFFAAЭто было недоступно до Phase 6 из Season of Discovery.|r",
	[1611] = "|cFFAAFFAAЭто было недоступно до Phase 7 из Season of Discovery.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "10-й уровень",
	[7] = "20-й уровень",
	[8] = "30-й уровень",
	[9] = "40-й уровень",
	[10] = "50-й уровень",
	[11] = "60-й уровень",
	[42] = "Восточные королевства",
	[43] = "Калимдор",
	[121] = "Повар-подмастерье",
	[122] = "Повар-умелец",
	[123] = "Повар-искусник",
	[126] = "Рыболов-подмастерье",
	[127] = "Рыболов-умелец",
	[128] = "Рыболов-искусник",
	[131] = "Подмастерье первой помощи",
	[132] = "Умелец оказывать первую помощь",
	[133] = "Искусник оказания первой помощи",
	[238] = "Победа в PvP",
	[239] = "25000 почетных побед в PvP",
	[306] = "Лучший рыболов Азерота",
	[389] = "Повелитель арены Гурубаши",
	[396] = "Великий хозяин арены Гурубаши",
	[416] = "Король-скарабей",
	[424] = "Почему? Потому что он красный.",
	[425] = "Атиеш, большой посох Стража",
	[428] = "Грозовая Ярость, благословленный клинок Искателя Ветра",
	[429] = "Сульфурас, Рука Рагнароса",
	[509] = "10000 почетных побед в PvP",
	[512] = "5000 почетных побед в PvP",
	[513] = "100 почетных побед в PvP",
	[515] = "500 почетных побед в PvP",
	[516] = "1000 почетных побед в PvP",
	[520] = "Превознесение среди 20 фракций",
	[521] = "Превознесение среди 15 фракций",
	[522] = "Я кому-то нравлюсь!",
	[523] = "Превознесение среди 5 фракций",
	[524] = "Превознесение среди 10 фракций",
	[546] = "Банковская ячейка",
	[627] = "Дун Морог",
	[628] = "Мертвые копи",
	[629] = "Огненная Пропасть",
	[630] = "Пещеры Стенаний",
	[631] = "Крепость Темного Клыка",
	[633] = "Тюрьма Штормграда",
	[634] = "Гномреган",
	[635] = "Лабиринты Иглошкурых",
	[636] = "Курганы Иглошкурых",
	[638] = "Ульдаман",
	[640] = "Мародон",
	[641] = "Затонувший храм",
	[642] = "Глубины Черной горы",
	[643] = "Нижняя часть пика Черной горы",
	[646] = "Стратхольм",
	[684] = "Логово Ониксии",
	[685] = "Логово Крыла Тьмы",
	[686] = "Огненные Недра",
	[687] = "Храм Ан'Киража",
	[688] = "Зул'Гуруб",
	[689] = "Руины Ан'Киража",
	[706] = "Верховой Северный Волк",
	[707] = "Боевой скакун Грозовой Вершины",
	[708] = "Герой клана Северного Волка",
	[709] = "Герой Стражи Грозовой Вершины",
	[710] = "Осквернитель",
	[711] = "Рыцарь Аратора",
	[712] = "Всадник из клана Песни Войны",
	[713] = "Часовой Среброкрылых",
	[714] = "Завоеватель",
	[727] = "Кавалеристы, вперед!",
	[728] = "Дуротар",
	[729] = "Поводья коня смерти",
	[736] = "Мулгор",
	[750] = "Степи",
	[760] = "Альтеракские горы",
	[761] = "Нагорье Арати",
	[765] = "Бесплодные земли",
	[766] = "Выжженные земли",
	[768] = "Тирисфальские леса",
	[769] = "Серебряный бор",
	[770] = "Западные Чумные земли",
	[771] = "Восточные Чумные земли",
	[772] = "Предгорья Хилсбрада",
	[773] = "Внутренние земли",
	[774] = "Тлеющее ущелье",
	[775] = "Пылающие степи",
	[776] = "Элвиннский лес",
	[777] = "Перевал Мертвого Ветра",
	[778] = "Сумеречный лес",
	[779] = "Лок Модан",
	[780] = "Красногорье",
	[781] = "Тернистая долина",
	[782] = "Болото Печали",
	[802] = "Западный Край",
	[841] = "Болотина",
	[842] = "Тельдрассил",
	[844] = "Темные берега",
	[845] = "Ясеневый лес",
	[846] = "Тысяча игл",
	[847] = "Когтистые горы",
	[848] = "Пустоши",
	[849] = "Фералас",
	[850] = "Пылевые топи",
	[851] = "Пустыня Танарис",
	[852] = "Азшара",
	[853] = "Оскверненный лес",
	[854] = "Кратер Ун'Горо",
	[855] = "Лунная поляна",
	[856] = "Силитус",
	[857] = "Зимние Ключи",
	[871] = "Якорь мне в глотку!",
	[879] = "Олдскульный наездник",
	[880] = "Стремительный зулианский тигр",
	[881] = "Стремительный ящер Раззаши",
	[891] = "Четыре ноги – лучше",
	[907] = "Вершитель правосудия",
	[940] = "Зеленые холмы Тернистой долины",
	[944] = "В том тоннеле меня любят!",
	[946] = "Серебряный Рассвет",
	[955] = "Гидраксианские Повелители Вод",
	[956] = "Род Ноздорму",
	[957] = "Герой племени Зандалар",
	[1307] = "Верхняя часть пика Черной горы",
	[1676] = "Хранитель мудрости Восточных королевств",
	[1677] = "Хранитель мудрости Восточных королевств",
	[1678] = "Хранитель мудрости Калимдора",
	[1680] = "Хранитель мудрости Калимдора",
	[2116] = "Гербовая накидка Серебряного Рассвета",
	[2141] = "Конюшенный",
	[2142] = "Пополняя конюшню",
	[2336] = "Чокнутый",
	[2357] = "Зоротианский конь погибели",
	[2358] = "Скакун",
	[2496] = "Пятый элемент",
	[3356] = "Ледопард Зимних Ключей",
	[5788] = "Посланник Шен'дралар",
	[16433] = "Душа из железа (сезон мастерства)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "Достигните 10-го уровня.",
	[7] = "Достигните 20-го уровня.",
	[8] = "Достигните 30-го уровня.",
	[9] = "Достигните 40-го уровня.",
	[10] = "Достигните 50-го уровня.",
	[11] = "Достигните 60-го уровня.",
	[42] = "Исследуйте все местности Восточных королевств.",
	[43] = "Исследуйте все местности Калимдора.",
	[121] = "Станьте поваром-подмастерьем.",
	[122] = "Станьте поваром-умельцем.",
	[123] = "Станьте поваром-искусником.",
	[126] = "Станьте рыболовом-подмастерьем.",
	[127] = "Станьте рыболовом-умельцем.",
	[128] = "Станьте рыболовом-искусником.",
	[131] = "Станьте подмастерьем первой помощи.",
	[132] = "Станьте умельцем в деле оказания первой помощи.",
	[133] = "Станьте искусником в деле оказания первой помощи.",
	[238] = "Одержите почетную победу в PvP.",
	[239] = "Одержите 25000 почетных побед в PvP.",
	[306] = "Одержите победу в состязании рыболовов Пиратской Бухты или в калуакском рыбоборье.",
	[389] = "Добудьте аксессуар Повелителя Арены на арене Гурубаши.",
	[396] = "Выполните задание Коротышки Джона Мифрила, чтобы получить аксессуар великого мастера Арены.",
	[416] = "Откройте Врата Ан'Киража.",
	[424] = "Получите Красный киражский резонирующий кристалл.",
	[425] = "Владелец Атиеша, большого посоха Стража.",
	[428] = "Владелец Грозовой Ярости, благословенного клинка Искателя Ветра.",
	[429] = "Владелец Сульфараса, Руки Рагнароса.",
	[509] = "Одержите 10000 почетных побед в PvP.",
	[512] = "Одержите 5000 почетных побед в PvP.",
	[513] = "Одержите 100 почетных побед в PvP.",
	[515] = "Одержите 500 почетных побед в PvP.",
	[516] = "Одержите 1000 почетных побед в PvP.",
	[520] = "Добейтесь того, чтобы вас превозносили 20 фракций.",
	[521] = "Добейтесь того, чтобы вас превозносили 15 фракций.",
	[522] = "Добейтесь того, чтобы вас превозносила какая-либо фракция.",
	[523] = "Добейтесь того, чтобы вас превозносили 5 фракций.",
	[524] = "Добейтесь того, чтобы вас превозносили 10 фракций.",
	[546] = "Купите 7 дополнительных ячеек в банке.",
	[627] = "Исследуйте Дун Морог, открыв все его области на карте.",
	[628] = "Победите Эдвина ван Клифа.",
	[629] = "Победите Баззалана.",
	[630] = "Убейте Мутануса Пожирателя.",
	[631] = "Победите верховного мага Аругала.",
	[633] = "Победите Базиля Тредда.",
	[634] = "Убейте анжинера Термоштепселя.",
	[635] = "Убейте Чарлгу Остробок.",
	[636] = "Убейте Амненнара Хладовея.",
	[638] = "Убейте Аркедаса.",
	[640] = "Убейте Принцессу Терадрас.",
	[641] = "Убейте Тень Эраникуса.",
	[642] = "Убейте императора Даграна Тауриссана.",
	[643] = "Убейте Властителя Змейталака.",
	[646] = "Очистите Стратхольм от населяющих его воплощений зла.",
	[684] = "Победите Ониксию.",
	[685] = "Убейте Нефариана.",
	[686] = "Убейте Рагнароса.",
	[687] = "Убейте К'Туна.",
	[688] = "Убейте Хаккара.",
	[689] = "Убейте Оссириана Неуязвимого.",
	[706] = "Получите верхового Северного Волка.",
	[707] = "Получите Боевого скакуна Грозовой Вершины.",
	[708] = "Добейтесь того, чтобы вас превозносили в клане Северного Волка.",
	[709] = "Добейтесь того, чтобы вас превозносила Стража Грозовой Вершины.",
	[710] = "Добейтесь того, чтобы вас превозносили в клане Осквернителей.",
	[711] = "Добейтесь того, чтобы вас превозносили в Лиге Аратора.",
	[712] = "Добейтесь того, чтобы вас превозносили Всадники Песни Войны.",
	[713] = "Добейтесь того, чтобы вас превозносили Среброкрылые Часовые.",
	[714] = "Добейтесь того, чтобы вас превозносили в Ущелье Песни Войны, Низине Арати и Альтеракской долине.",
	[727] = "Получите боевое верховое животное за очки чести.",
	[728] = "Исследуйте Дуротар, открыв все его области на карте.",
	[729] = "Получите поводья коня смерти у Барона Ривендера из Стратхольма.",
	[736] = "Исследуйте Мулгор, открыв все его области на карте.",
	[750] = "Исследуйте Степи, открыв все их области на карте.",
	[760] = "Исследуйте Альтеракские горы, открыв все их области на карте.",
	[761] = "Исследуйте Нагорье Арати, открыв все его области на карте.",
	[765] = "Исследуйте Бесплодные земли, открыв все их области на карте.",
	[766] = "Исследуйте Выжженные земли, открыв все их области на карте.",
	[768] = "Исследуйте Тирисфальские леса, открыв все их области на карте.",
	[769] = "Исследуйте Серебряный бор, открыв все его области на карте.",
	[770] = "Исследуйте Западные Чумные земли, открыв все их области на карте.",
	[771] = "Исследуйте Восточные Чумные земли, открыв все их области на карте.",
	[772] = "Исследуйте Предгорья Хилсбрада, открыв все их области на карте.",
	[773] = "Исследуйте Внутренние земли, открыв все их области на карте.",
	[774] = "Исследуйте Тлеющее ущелье, открыв все его области на карте.",
	[775] = "Исследуйте Пылающие степи, открыв все их области на карте.",
	[776] = "Исследуйте Элвиннский лес, открыв все его области на карте.",
	[777] = "Исследуйте Перевал Мертвого Ветра, открыв все его области на карте.",
	[778] = "Исследуйте Сумеречный лес, открыв все его области на карте.",
	[779] = "Исследуйте Лок Модан, открыв все его области на карте.",
	[780] = "Исследуйте Красногорье, открыв все его области на карте.",
	[781] = "Исследуйте Тернистую долину, открыв все ее области на карте.",
	[782] = "Исследуйте Болото Печали, открыв все его области на карте.",
	[802] = "Исследуйте Западный Край, открыв все его области на карте.",
	[841] = "Исследуйте Болотину, открыв все ее области на карте.",
	[842] = "Исследуйте Тельдрассил, открыв все его области на карте.",
	[844] = "Исследуйте Темные берега, открыв все их области на карте.",
	[845] = "Исследуйте Ясеневый лес, открыв все его области на карте.",
	[846] = "Исследуйте Тысячу игл, открыв все их области на карте.",
	[847] = "Исследуйте Когтистые горы, открыв все их области на карте.",
	[848] = "Исследуйте Пустоши, открыв все их области на карте.",
	[849] = "Исследуйте Фералас, открыв все его области на карте.",
	[850] = "Исследуйте Пылевые топи, открыв все его области на карте.",
	[851] = "Исследуйте пустыню Танарис, открыв все ее области на карте.",
	[852] = "Исследуйте Азшару, открыв все ее области на карте.",
	[853] = "Исследуйте Оскверненный лес, открыв все его области на карте.",
	[854] = "Исследуйте Кратер Ун'Горо, открыв все его области на карте.",
	[855] = "Исследуйте Лунную поляну, открыв все ее области на карте.",
	[856] = "Исследуйте Силитус, открыв все его области на карте.",
	[857] = "Исследуйте Зимние Ключи, открыв все их области на карте.",
	[871] = "Получите Адмиральскую шляпу Кровавого Паруса… и почаще выходите на свежий воздух.",
	[879] = "Владелец одного из старых эпических верховых животных, которых уже нельзя получить в игре.",
	[880] = "Получите Стремительного зулианского тигра от Верховного Жреца Текала в Зул'Гурубе.",
	[881] = "Получите стремительного ящера Раззаши от Мандокира Повелителя Крови из Зул'Гуруба.",
	[891] = "Станьте учеником в деле верховой езды.",
	[907] = "Добейтесь того, чтобы вас превозносили в Ущелье Песни Войны, Низине Арати и Альтеракской долине.",
	[940] = "Выполните все задания Хеминга Эрнестуэя в Тернистой долине, включая финальное – \"\"Охотник на крупную дичь\"\".",
	[944] = "Добейтесь того, чтобы вас превозносила Крепость Древобрюхов.",
	[946] = "Добейтесь того, чтобы вас превозносил Серебряный Рассвет.",
	[955] = "Добейтесь того, чтобы вас превозносили Гидраксианские Повелители Вод.",
	[956] = "Добейтесь того, чтобы вас превозносил Род Ноздорму.",
	[957] = "Добейтесь того, чтобы вас превозносило племя Зандалар.",
	[1307] = "Убейте Генерала Драккисата.",
	[1676] = "Выполните 700 заданий в Восточных королевствах.",
	[1677] = "Выполните 550 заданий в Восточных королевствах.",
	[1678] = "Выполните 700 заданий в Калимдоре.",
	[1680] = "Выполните 685 заданий в Калимдоре.",
	[2116] = "Получите Гербовую накидку Серебряного Рассвета во время вторжения Плети.",
	[2141] = "Получите 10 средств передвижения.",
	[2142] = "Получите 25 средств передвижения.",
	[2336] = "Добейтесь того, чтобы пираты из шайки Кровавого Паруса начали относиться к вам с уважением, а обитатели Пиратской Бухты, Круговзора, Прибамбасска, Кабестана, ярмарки Новолуния, поместья Черного Ворона и шен'дралар начали вас превозносить.",
	[2357] = "Выполнено задание для чернокнижников \"\"Зоротианский конь погибели\"\".",
	[2358] = "Выполнено задание для паладина на получение скакуна.",
	[2496] = "Получите квинтэссенцию воды.",
	[3356] = "Получите ледопарда Зимних Ключей.",
	[5788] = "Добейтесь того, чтобы вас превозносили Шен'дралар.",
	[16433] = "Достигните в ходе сезона мастерства 60-го уровня, ни разу не умерев.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Великие подвиги",
	[92] = "Общее",
	[95] = "PvP",
	[96] = "Задания",
	[97] = "Исследование",
	[168] = "Подземелья и рейды",
	[169] = "Профессии",
	[170] = "Кулинария",
	[171] = "Рыбная ловля",
	[172] = "Первая помощь",
	[201] = "Репутация",
	[14777] = "Восточные королевства",
	[14778] = "Калимдор",
	[14801] = "Альтеракская долина",
	[14802] = "Низина Арати",
	[14804] = "Ущелье Песни Войны",
	[14808] = "World of Warcraft",
	[14861] = "World of Warcraft",
	[14864] = "World of Warcraft",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "ko" then
localize(_.CategoryNames, {
	[1] = "투사체",
	[2] = "소모품",
	[58] = "축제 요리",
	[63] = "일반 요리",
	[70] = "특별한 별미",
	[183] = "부품",
	[184] = "폭발물",
	[185] = "고글",
	[188] = "장치",
	[189] = "총과 활",
	[190] = "조준경",
	[191] = "장비",
	[194] = "폭죽",
	[215] = "재료",
	[218] = "머리",
	[219] = "어깨",
	[220] = "가슴",
	[221] = "손",
	[222] = "손목",
	[223] = "허리",
	[224] = "다리",
	[225] = "발",
	[226] = "방패",
	[227] = "무기",
	[228] = "해골 열쇠",
	[230] = "재료",
	[233] = "가방",
	[234] = "머리",
	[235] = "어깨",
	[236] = "가슴",
	[237] = "손목",
	[238] = "허리",
	[239] = "손",
	[240] = "다리",
	[241] = "발",
	[242] = "등",
	[243] = "속옷",
	[247] = "재료",
	[249] = "방어구 키트",
	[250] = "가방",
	[251] = "머리",
	[252] = "어깨",
	[253] = "가슴",
	[254] = "손목",
	[255] = "손",
	[256] = "허리",
	[257] = "다리",
	[258] = "발",
	[259] = "등",
	[638] = "물약",
	[639] = "비약",
	[640] = "영약",
	[641] = "변환식",
	[642] = "장비",
	[643] = "오일",
	[644] = "재료",
	[690] = "장화 마법부여",
	[691] = "손목 마법부여",
	[692] = "가슴 마법부여",
	[693] = "망토 마법부여",
	[694] = "장갑 마법부여",
	[695] = "무기 마법부여",
	[696] = "방패 마법부여",
	[697] = "장비",
	[698] = "마법봉",
	[699] = "오일",
	[700] = "장신구",
	[701] = "재료",
});
localize(L.HEADER_NAMES, {
	[-1000015] = "악마 훈련사",
	[-1000025] = "축제",
	[-1000034] = "전문 기수",
	[-1000040] = "무기 전문가",
	[-1000162] = "공유된 모습",
	[-1000163] = "독특한 외관",
	[-1000168] = "4인 기사단",
	[-1000191] = "중위를 처치하세요",
	[-1000192] = "전투에서 승리하세요",
	[-1000193] = "죽은 자와 대화",
	[-1000195] = "그리즈비와 대화",
	[-1000196] = "노라와 대화",
	[-1000198] = "로물루스 형제와 대화하세요",
	[-1000201] = "다크문 유랑단",
	[-1000223] = "한여름 불꽃축제",
	[-1000227] = "가시덤불 골짜기 낚시왕 선발대회",
	[-1000235] = "어둠의 문 열기",
	[-1000236] = "흐르는 모래의 홀",
	[-1000243] = "블리즈컨",
	[-1000273] = "발견의 계절",
	[-1000274] = "이해력",
	[-1000275] = "층 1",
	[-1000276] = "층 2",
	[-1000277] = "몬스터 사냥",
	[-1000278] = "각인술",
	[-1000279] = "웨이레이드 보급품",
	[-1000373] = "새로운 캐릭터",
	[-1000376] = "건장한 난투",
	[-1000377] = "야생 변이",
	[-1000378] = "소울 브로커",
	[-1000380] = "하사품",
	[-1000970] = "층 3",
	[-1001035] = "제철 생선: 여름 농어",
	[-1001036] = "제철 생선: 겨울 오징어",
	[-1001058] = "악몽의 숲",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000040] = "웨폰 마스터는 캐릭터에게 특정 무기 기술을 배울 수 있는 기회를 제공하는 NPC로, 사용 가능 여부는 웨폰 마스터마다 다릅니다. 모든 무기 기술은 레벨 20이 필요한 폴암을 제외하고 레벨 1에서 훈련할 수 있습니다.\n\n4.0.1 패치에서는 각 병과가 생성 시 모든 병과에 적합한 무기 숙련도를 배우게 되므로 무기 전문가와의 훈련은 더 이상 필요하지 않게 되었습니다. 무기 마스터는 곧 게임에서 제거되었습니다.",
	[-1000162] = "이 목록의 항목은 위 항목의 공유 모양입니다. 고유 외형 모드에서 이 목록은 특정 항목이 수집됨으로 표시되는 이유와 이유를 이해하는 데 도움이 될 수 있습니다.",
	[-1000163] = "이 아이템은 독특한 외형을 가지고 있습니다. 외형을 획득하려면 이 아이템을 특별히 수집해야 합니다.",
	[-1000273] = "이번 시즌에는 새로운 메커니즘이 포함된 10인 Blackfathom Deeps 레이드, 플레이어 전술과 전략에 도전할 수 있는 새롭고 재구성된 보스, 새로운 보상을 포함하여 초기 레벨 상한이 25이고 새로운 레벨 25 최종 게임이 제공됩니다.",
	[-1000278] = "룬 각인은 최근 발견의 시즌에 발표된 새로운 시스템입니다. 이를 통해 각 클래스는 새로운 고유 능력을 잠금 해제하여 게임 플레이 경험을 맞춤화할 수 있습니다!",
	[-1000279] = "길레이드 보급품 퀘스트 아이템은 아제로스 전역의 6레벨 이상의 몹에게서 드롭됩니다. 이 퀘스트는 약간의 은화, 경험치, 평판을 대가로 조직 대표에게 Waylaid 보급품을 전달하도록 요청합니다. 물론, 보급품 배송에 누락된 품목이 있으며, 이를 보완하여 더 큰 평판 보상을 받을 수 있습니다.",
	[-1000376] = "누가 먼저 목표물을 두드렸는지에 상관없이 술에 취한 사람에게 마지막 타격을 가한 사람만 크레딧을 받습니다. 이에 대한 그룹 크레딧은 없습니다.",
	[-1000377] = "야생 변이에 걸린 동물에게 변이를 시전하여 그들을 다시 견습생으로 되돌리세요. 각자가 당신에게 메모를 줄 것입니다. 노트 6개를 모아 룬을 배워보세요.",
	[-1000380] = "이 목록에는 ATT Discord에서 Blizzard가 아직 수정하지 않은 버그로 보고한 얻을 수 없는 항목이 포함되어 있습니다.\n\n참고: 가시성을 위해 이 목록 내에서 모든 필터는 무시됩니다. 거대한 불을 뿜는 용이 아닌 부주의로 인해 게임에서 제거된 아이템만 이 목록에 있습니다.\n\n블리자드 개발자 여러분께: 아래 나열된 아이템과 만남을 수정해 주세요.",
});
localize(ObjectNames, {
	[31] = "오래된 사자상",
	[32] = "가라앉은 상자",
	[33] = "잠긴 궤짝",
	[34] = "낡은 단지",
	[35] = "선장의 사물함",
	[36] = "부서진 통",
	[47] = "현상 수배!",
	[52] = "구루바시의 몰락",
	[54] = "제국의 무덤",
	[55] = "반쯤 파먹힌 시체",
	[56] = "롤프의 시체",
	[57] = "골짜기의 달",
	[58] = "방랑자 그리렉",
	[59] = "대충 덮인 흙무더기",
	[60] = "현상 수배: 가스일조그",
	[61] = "낡은 묘비",
	[68] = "현상수배 전단",
	[76] = "빈 단지",
	[119] = "에이버크롬비의 상자",
	[256] = "현상 수배!",
	[257] = "수상한 통",
	[259] = "반쯤 묻힌 통",
	[261] = "부서진 상자",
	[263] = "쿠르젠 보급품",
	[264] = "쿠르젠 보급품",
	[269] = "야벤이 지키고 있는 썬더브루 맥주통",
	[270] = "아무도 지키지 않는 썬더브루 맥주통",
	[271] = "광부 조합 상자",
	[272] = "맥그란의 고기 상자",
	[276] = "쉼머위드 바구니",
	[287] = "사서 헤로드의 기록",
	[288] = "사서 헤로드의 금고",
	[290] = "펄브로우의 옷장",
	[321] = "틸로아의 눈물",
	[331] = "대충 덮인 흙더미",
	[333] = "고대 유물",
	[334] = "고대 유물",
	[375] = "티리스팔 호박",
	[711] = "현상 수배!",
	[759] = "신성한 샘물",
	[1166] = "알렉스턴의 궤짝",
	[1557] = "릴리스의 제단",
	[1560] = "보관함",
	[1561] = "봉인된 함",
	[1562] = "치안대장 해거드의 상자",
	[1571] = "더러운 마법책",
	[1585] = "폭발물",
	[1586] = "양초 상자",
	[1593] = "시체 더미 나룻배",
	[1594] = "베랄드의 책장",
	[1599] = "얕은 무덤",
	[1609] = "용아귀 투석기",
	[1610] = "발연 광맥",
	[1627] = "달라란 상자",
	[1673] = "악의 열매",
	[1721] = "단단히 잠긴 족쇄",
	[1722] = "단단히 잠긴 족쇄",
	[1723] = "진흙주둥이꽃",
	[1727] = "신디거 스타우트 맥주통",
	[1728] = "더러운 양탄자",
	[1736] = "철괴 상자",
	[1738] = "비밀결사대 문서",
	[1739] = "비밀결사대 문서",
	[1740] = "비밀결사대 문서",
	[1759] = "힐스브래드 마을의 기록부",
	[1760] = "오래된 책장",
	[1761] = "힐스브래드 선언문",
	[1763] = "현상 수배!",
	[1765] = "낡은 나무 궤짝",
	[1768] = "아젤의 불꽃",
	[1769] = "베라즈의 불꽃",
	[1770] = "우젤의 불꽃",
	[2008] = "위험!",
	[2059] = "드워프 시체",
	[2068] = "퍼플리버보스 포트 와인",
	[2076] = "끓고 있는 가마솥",
	[2083] = "붉은해적단 통신문",
	[2084] = "사향쥐 뿌리",
	[2086] = "붉은해적단 해도",
	[2087] = "붉은해적단의 명령서",
	[2289] = "난파된 구명정",
	[2553] = "젖은 두루마리",
	[2554] = "코르텔로의 수수께끼",
	[2555] = "곰팡이 슨 두루마리",
	[2560] = "반쯤 묻힌 병",
	[2576] = "해일의 제단",
	[2652] = "에벤에셀 러스트로크의 시체",
	[2656] = "물에 젖은 편지",
	[2688] = "쐐기돌",
	[2689] = "서부 봉인석",
	[2690] = "외부 봉인석",
	[2691] = "동부 봉인석",
	[2701] = "오색 결정",
	[2702] = "내부 봉인석",
	[2704] = "숨겨진 폭탄",
	[2707] = "메이든즈 폴리호의 해도",
	[2708] = "실버파인 스피릿호의 해도",
	[2709] = "메이든즈 폴리호의 항해일지",
	[2710] = "실버파인 스피릿호의 항해일지",
	[2712] = "엘프의 보석",
	[2713] = "현상 수배 전단",
	[2714] = "알터랙 화강암",
	[2716] = "트렐레인의 궤짝",
	[2717] = "트렐레인의 사물함",
	[2718] = "트렐레인의 금고",
	[2724] = "귀리 부대",
	[2734] = "흠뻑 젖은 상자",
	[2739] = "검은 깃털의 상자",
	[2740] = "까마귀 발톱의 상자",
	[2741] = "천상의 상자",
	[2742] = "안식의 상자",
	[2743] = "돌조각 단지",
	[2744] = "대합",
	[2842] = "다이아몬드 기둥",
	[2848] = "오팔 기둥",
	[2858] = "자수정 기둥",
	[2867] = "발굴조사단 보급 상자",
	[2868] = "구겨진 지도",
	[2875] = "훼손된 드워프 해골",
	[2891] = "발리아마 전리품 해골",
	[2892] = "지아타자이 전리품 해골",
	[2893] = "줄맘웨 전리품 해골",
	[2907] = "물병",
	[2908] = "도장 찍힌 보급품 상자",
	[2910] = "우물돌",
	[2912] = "대지열매",
	[2933] = "대지의 봉인",
	[3076] = "지저분한 지도",
	[3189] = "공격 계획서: 시험의 골짜기",
	[3190] = "공격 계획서: 센진 마을",
	[3192] = "공격 계획서: 오그리마",
	[3236] = "노움 공구상자",
	[3237] = "사로잡힌 검은창부족의 영혼",
	[3238] = "첸의 빈 술통",
	[3239] = "베네딕트의 상자",
	[3240] = "붉은발톱랩터 알",
	[3290] = "도둑맞은 보급품 부대",
	[3525] = "불의 제단",
	[3640] = "숙성한 버섯",
	[3642] = "콜카르 노획물 궤짝",
	[3643] = "낡은 사물함",
	[3644] = "바엘 모단 비행기",
	[3646] = "트윈브레이드 장군의 금고",
	[3685] = "실리시드 흙더미",
	[3737] = "거품이 나오는 균열",
	[3767] = "드리즐릭 잡화상자",
	[3768] = "취급 주의",
	[3972] = "현상 수배!",
	[4072] = "주제어 밸브",
	[4141] = "제어 장치",
	[4406] = "나무그물거미알",
	[4608] = "나무괴물 씨눈",
	[5620] = "혼란의 마법석",
	[6751] = "이상한 열매의 식물",
	[6752] = "이상한 잎의 식물",
	[6906] = "붉은 랩터 둥지",
	[6907] = "파란 랩터 둥지",
	[6908] = "노란 랩터 둥지",
	[7510] = "싹튼 잎",
	[9630] = "플라곤구트의 화석",
	[10076] = "수정점 그릇",
	[11713] = "알광대버섯",
	[11714] = "껄껄이그물버섯",
	[12666] = "황혼의 마법책",
	[13360] = "마시스트라 유물",
	[13891] = "불뱀꽃",
	[13949] = "움푹 파인 철제 궤짝",
	[15084] = "빤질빤질세척기 5200",
	[15085] = "빤질빤질세척기 5200",
	[16393] = "고대의 불꽃",
	[17182] = "윙윙상자 827",
	[17183] = "윙윙상자 411",
	[17184] = "버즈박스 323",
	[17188] = "아메스아란의 부흥",
	[17189] = "아메스아란의 멸망",
	[17282] = "식물 꾸러미",
	[17783] = "고대 조각상",
	[19015] = "엘룬의 눈물",
	[19016] = "별가루 덮인 풀",
	[19021] = "녹슨 궤짝",
	[19022] = "낡은 궤짝",
	[19024] = "숨겨진 제단",
	[19027] = "멜탄드리스의 마법책",
	[19030] = "흙무더기",
	[19283] = "타락의 개요",
	[19284] = "티탄 신화",
	[19595] = "문지기의 우리",
	[19596] = "잠든 자의 은닉처",
	[19597] = "드루이드의 은닉처",
	[19598] = "지하굴 은신처",
	[19599] = "갈퀴발톱굴 저장고",
	[19602] = "투자개발회사의 토목 공사 계획서",
	[19603] = "투자개발회사의 문서",
	[19861] = "헨리그 론브로우의 일지",
	[19869] = "로켓 자동차 파편",
	[19877] = "벨린데의 사물함",
	[19901] = "구속의 마법진",
	[20352] = "구속의 마법진",
	[20359] = "오닉시아의 알",
	[20447] = "하피 식량",
	[20691] = "코즐의 사물함",
	[20725] = "고대의 유산",
	[20726] = "언데드 위협의 기원",
	[20727] = "기즈모리움 화물 상자",
	[20805] = "아무도 지키지 않는 리즐의 설계도",
	[20807] = "고대 화톳불",
	[20920] = "청엽수 줄기",
	[20985] = "푸석푸석한 흙더미",
	[20992] = "검은 방패",
	[21015] = "발굽 자국",
	[21016] = "발굽 자국",
	[21042] = "테라모어 경비병 휘장",
	[21052] = "데피아즈단 금고",
	[21277] = "구멍 난 상자",
	[21530] = "땅다람쥐 설명서",
	[22245] = "고기 부대",
	[22246] = "테라드라스의 눈물",
	[22550] = "드레니시스트 수정",
	[24798] = "볕에 말린 유목",
	[28024] = "짐마차 상자",
	[30854] = "아탈라이 유물",
	[30855] = "아탈라이 유물",
	[30856] = "아탈라이 유물",
	[32569] = "갈렌의 금고",
	[35251] = "카니톨의 궤짝",
	[35252] = "고대 유물",
	[36738] = "우르의 책",
	[37099] = "아탈라이 서판",
	[50935] = "옥수수 부대",
	[50936] = "보리 부대",
	[50937] = "호밀 부대",
	[50961] = "말렘의 궤짝",
	[50982] = "참나무 숯",
	[51708] = "엘리자의 무덤",
	[58369] = "훔친 철제 궤짝",
	[58595] = "불타는 칼날단 은신처",
	[61934] = "희미한 불꽃의 화로",
	[61935] = "압력 조절 밸브",
	[61936] = "연료 조절 밸브",
	[68865] = "땅다람쥐 지휘봉",
	[85562] = "아이언밴드의 금고",
	[85563] = "썩은니의 금고",
	[86492] = "엘루니트 상자",
	[89634] = "철산호",
	[89635] = "바짝 마른 알껍질",
	[91138] = "조던의 망치",
	[92013] = "비밀의 고서",
	[92420] = "베일러의 광석",
	[92423] = "부서진 궤짝",
	[93192] = "사랑나무",
	[102984] = "빙크의 연장통",
	[102985] = "발니르 금어초",
	[103574] = "채워진 속박의 상자",
	[103628] = "우르의 흑마법 논문",
	[103821] = "도안의 금고",
	[104564] = "빙글스의 공구통",
	[104569] = "빙글스의 공구통",
	[104574] = "빙글스의 공구통",
	[104575] = "빙글스의 깡그리싸그리 폭탄",
	[105169] = "아가만드 무기 선반",
	[105170] = "아가만드 무기 선반",
	[105171] = "아가만드 무기 선반",
	[105172] = "아가만드 무기 선반",
	[105174] = "속박의 상자",
	[105175] = "현신의 주문서",
	[112888] = "먼지투성이 선반",
	[112948] = "용감무쌍호의 잠긴 금고",
	[113757] = "어둠괴철로 금고",
	[113768] = "오색찬란한 알",
	[113791] = "영원의 샘 제단",
	[123329] = "밸로그의 궤짝",
	[123462] = "남쪽바다 해적단 보석",
	[125477] = "특이한 항아리",
	[126049] = "자홍버섯",
	[126158] = "탈론카이의 옷장",
	[126260] = "고대 궤짝",
	[129127] = "갤리윅스의 금고",
	[131474] = "노르간논의 원반",
	[138492] = "미즈라엘의 결정",
	[140911] = "밝은 황록색 비단 실타래",
	[140971] = "가즈리디안",
	[141812] = "봉인석",
	[141832] = "줄파락 징",
	[141853] = "제비수염버섯",
	[141931] = "히포그리프 알",
	[141979] = "고대의 보물",
	[142071] = "자동부화기",
	[142088] = "결의의 서판",
	[142122] = "현상 수배 전단",
	[142127] = "린지의 비밀",
	[142151] = "봉인된 통",
	[142179] = "솔라살 전망대",
	[142181] = "도난당한 화물",
	[142184] = "선장의 상자",
	[142185] = "빌탄의 불꽃",
	[142186] = "라하사의 불꽃",
	[142187] = "임벨의 불꽃",
	[142188] = "삼하의 불꽃",
	[142195] = "덩굴발 작전도",
	[142343] = "울둠 대좌",
	[142344] = "인공장치 검출기",
	[142345] = "행렬 천공기록기 3005-A",
	[142475] = "행렬 천공기록기 3005-B",
	[142476] = "행렬 천공기록기 3005-C",
	[142487] = "빤질빤질세척기 5200",
	[142696] = "행렬 천공기록기 3005-D",
	[142702] = "독약병",
	[142715] = "데카의 서판",
	[142958] = "페랄라스의 역사",
	[143980] = "골두니 두루마리",
	[144053] = "슈섕크의 측량 장비",
	[144063] = "에퀴넥스 비석탑",
	[144064] = "골두니 흙더미",
	[144066] = "첫번째 마른나무껍질 우리",
	[144067] = "두번째 마른나무껍질 우리",
	[144068] = "세번째 마른나무껍질 우리",
	[144070] = "뾰족부리의 우리",
	[147557] = "도둑맞은 은화",
	[148498] = "선타라의 제단",
	[148504] = "눈에 띄는 묘비",
	[148506] = "황혼의 유물",
	[148513] = "진야엘 서판",
	[148514] = "마크리 서판",
	[148515] = "샤엘하이 서판",
	[148516] = "베스아마라 서판",
	[149025] = "감시의 화롯불",
	[149030] = "감시의 화롯불",
	[149031] = "감시의 화롯불",
	[149032] = "감시의 화롯불",
	[149036] = "마본의 궤짝",
	[149502] = "검은용군단의 보물",
	[150075] = "현상 수배 전단",
	[151286] = "칼도레이 소환의 고서",
	[152094] = "히아신스 버섯",
	[152095] = "달봉우리 백합",
	[152097] = "벨리스트라즈의 화로",
	[152618] = "콜카르 노획물 궤짝",
	[152622] = "아즈샤리트 결정체",
	[153123] = "킴야엘의 장비",
	[153239] = "올빼미야수 깃털",
	[154357] = "번들거리는 진흙",
	[156561] = "현상수배 전단",
	[157936] = "운고로 흙더미",
	[160836] = "유물 금고",
	[160845] = "검은 금고",
	[161495] = "비밀 금고",
	[161504] = "작은 배낭",
	[161505] = "난파된 나룻배",
	[161521] = "탐사 장비",
	[161526] = "식량 상자",
	[161527] = "공룡 뼈",
	[161557] = "밀리의 수확물",
	[161752] = "연장통",
	[164659] = "녹색 마력의 수정",
	[164661] = "노란 마력의 수정",
	[164689] = "프랑클론 포지라이트의 기념비",
	[164778] = "푸른 마력의 수정",
	[164780] = "붉은 마력의 수정",
	[164820] = "암흑의 문지기 명판",
	[164867] = "현상 수배!",
	[164868] = "사살 지령",
	[164869] = "유령의 성배",
	[164885] = "오염된 어둠용풀",
	[164886] = "오염된 노래꽃",
	[164887] = "오염된 바람꽃",
	[164888] = "오염된 채찍뿌리",
	[164909] = "난파된 나룻배",
	[164910] = "화려한 궤짝",
	[164911] = "썬더브루 맥주통",
	[164953] = "큰 가죽 배낭",
	[164954] = "주크애쉬 고치",
	[164955] = "북쪽 수정탑",
	[164956] = "서쪽 수정탑",
	[164957] = "동쪽 수정탑",
	[164958] = "붉은꽃잎덩굴손 씨눈",
	[165554] = "산의 정수",
	[166863] = "방금 죽은 트레샤돈 시체",
	[169243] = "일곱 현자의 궤짝",
	[169294] = "일곱 현자의 서판",
	[171938] = "선인장 사과",
	[171939] = "오염된 노래꽃",
	[171942] = "오염된 노래꽃",
	[173232] = "대장기술 도면",
	[173265] = "나무 간이화장실",
	[173284] = "오염된 채찍뿌리",
	[173324] = "오염된 어둠용풀",
	[173327] = "오염된 바람꽃",
	[174594] = "오염된 노래꽃",
	[174595] = "오염된 노래꽃",
	[174596] = "오염된 노래꽃",
	[174597] = "오염된 노래꽃",
	[174598] = "오염된 노래꽃",
	[174599] = "오염된 바람꽃",
	[174600] = "오염된 바람꽃",
	[174601] = "오염된 바람꽃",
	[174602] = "오염된 바람꽃",
	[174603] = "오염된 바람꽃",
	[174604] = "오염된 바람꽃",
	[174605] = "오염된 채찍뿌리",
	[174606] = "오염된 채찍뿌리",
	[174607] = "오염된 채찍뿌리",
	[174608] = "오염된 어둠용풀",
	[174682] = "테러닥스 주의",
	[174684] = "오염된 어둠용풀",
	[174686] = "오염된 채찍뿌리",
	[174708] = "오염된 바람꽃",
	[174709] = "오염된 바람꽃",
	[174712] = "오염된 노래꽃",
	[174713] = "오염된 노래꽃",
	[174728] = "부서진 상자",
	[174848] = "실험용 장비",
	[175084] = "빤질빤질세척기 5200",
	[175165] = "은빛 새벽호 금고",
	[175166] = "안개 장막호의 금고",
	[175207] = "떠내려온 바다 생물",
	[175226] = "떠내려온 바다 생물",
	[175227] = "떠내려온 바다 생물",
	[175230] = "떠내려온 바다 생물",
	[175233] = "떠내려온 바다 생물",
	[175245] = "태초의 불꽃",
	[175320] = "현상 수배: 먹구렁!",
	[175324] = "서리망치거인 조각",
	[175329] = "검은나무일족 열매 저장고",
	[175330] = "검은나무일족 과일 저장고",
	[175331] = "검은나무일족 곡식 저장고",
	[175334] = "비쥬의 소지품",
	[175382] = "파멸의 궤",
	[175384] = "마루둥지 와이번 알",
	[175385] = "다크스톤 서판",
	[175407] = "달빛 깃든 깃털",
	[175524] = "신비한 붉은 수정",
	[175565] = "괴상한 알",
	[175566] = "어둠풀",
	[175586] = "야론의 짐마차",
	[175587] = "부서진 상자",
	[175606] = "첨탑 거미알",
	[175629] = "야론의 보급품",
	[175708] = "크로스로드 보급품 상자",
	[175785] = "눈에 띄지 않는 문서",
	[175802] = "작은 금고",
	[175886] = "날카로운 장창",
	[175888] = "귀족 유물 조각",
	[175889] = "고대의 알",
	[175891] = "귀족 유물 조각",
	[175892] = "귀족 유물 조각",
	[175893] = "귀족 유물 조각",
	[175894] = "재니스의 소포",
	[175924] = "잠긴 사물함",
	[175925] = "간이화장실",
	[175926] = "달슨 부인의 일기",
	[175928] = "불꽃 용설란",
	[175949] = "다섯번째 모쉬아루 서판",
	[175950] = "여섯번째 모쉬아루 서판",
	[175965] = "프로스트위스퍼의 불변의 영액",
	[175966] = "마력 깃든 붉은 실타래",
	[175970] = "벼리지 않은 룬문자 가슴보호갑",
	[176089] = "불타지 않은 판금 건틀릿",
	[176090] = "인간 해골",
	[176091] = "마른가지 가마솥",
	[176092] = "화염병 상자",
	[176112] = "말로의 금고",
	[176115] = "현상 수배: 아르낙 그림토템",
	[176116] = "파멜라의 인형 머리",
	[176142] = "파멜라의 인형 왼쪽 몸통",
	[176143] = "파멜라의 인형 오른쪽 몸통",
	[176145] = "조셉 레드패스의 기념비",
	[176158] = "고통의 화로",
	[176159] = "원한의 화로",
	[176160] = "고난의 화로",
	[176161] = "증오의 화로",
	[176189] = "바다거북 뼈",
	[176190] = "떠밀려 온 바다거북",
	[176191] = "떠내려온 바다거북",
	[176192] = "무법의 시대 일람",
	[176196] = "떠밀려 온 바다거북",
	[176197] = "떠내려온 바다거북",
	[176198] = "떠내려온 바다거북",
	[176206] = "다빌의 성서",
	[176207] = "레드패스의 방패",
	[176208] = "호르구스의 해골",
	[176209] = "부러진 마르두크의 검",
	[176213] = "영웅의 피",
	[176245] = "붉은십자군 기록",
	[176249] = "스컬지 자료",
	[176325] = "대장기술 도면",
	[176344] = "문서함",
	[176361] = "스컬지 가마솥",
	[176392] = "스컬지 가마솥",
	[176393] = "스컬지 가마솥",
	[176484] = "브릴 증서",
	[176485] = "카엘 다로우 증서",
	[176486] = "남녘해안 증서",
	[176487] = "타렌 제분소 증서",
	[176544] = "에바 사크호프의 유해",
	[176545] = "루시앙 사크호프의 유해",
	[176581] = "이룩소스의 손 수정",
	[176582] = "가재 통발",
	[176630] = "추억의 유품",
	[176631] = "메네실의 선물",
	[176634] = "케를로니안의 상자",
	[176751] = "코도 뼈",
	[176785] = "탄환 상자",
	[176793] = "장작 더미",
	[177241] = "아라즈의 성물함",
	[177243] = "악마의 차원문",
	[177264] = "실추된 명예의 상징",
	[177287] = "완성되지 않은 그림",
	[177289] = "스컬지 가마솥",
	[177464] = "큰 흰개미집",
	[177491] = "흰개미 통",
	[177544] = "조셉의 상자",
	[177667] = "찢어진 두루마리",
	[177750] = "달버섯",
	[177784] = "커다란 연갑 조개",
	[177786] = "랙모어의 궤짝",
	[177787] = "랙모어의 기록",
	[177789] = "아우구스투스의 회계장부",
	[177805] = "훼손된 인간 시체",
	[177904] = "현상 수배: 베스셀레스",
	[177926] = "가이아 씨앗",
	[177929] = "가이아 흙더미",
	[177964] = "심연의 돌",
	[178084] = "펠릭스의 궤짝",
	[178087] = "타즈릴의 곡괭이",
	[178090] = "말라의 무덤",
	[178104] = "리조나이트 수정",
	[178144] = "트롤 궤짝",
	[178145] = "리조나이트 광석",
	[178184] = "아쿠마이의 사파이어",
	[178185] = "아쿠마이의 사파이어",
	[178186] = "아쿠마이의 사파이어",
	[178195] = "전쟁노래 기름",
	[178204] = "전쟁노래 도끼 상자",
	[178227] = "머구트의 토템 광주리",
	[178553] = "하이브아쉬 고치",
	[178609] = "눈더미",
	[179485] = "부서진 함정",
	[179499] = "오우거 타닌 광주리",
	[179501] = "노트 팀블잭의 은닉품",
	[179516] = "펜구스의 궤짝",
	[179517] = "셴드랄라의 보물",
	[179544] = "카리엘 윈탈루스의 유해",
	[179545] = "왕자의 궤짝",
	[179552] = "설계도: 야전수리로봇 74A",
	[179553] = "핵 조각",
	[179559] = "악령덩굴 조각",
	[179562] = "달궈진 고대의 검",
	[179564] = "고르독 공물",
	[179565] = "더러운 성물함",
	[179697] = "투기장 보물상자",
	[179703] = "불의 군주의 보물",
	[179827] = "구인광고/분실물센터/지명수배",
	[179828] = "검은무쇠 베개",
	[179832] = "하녀 필라클렌처의 화려한 베개",
	[179879] = "지배의 보주",
	[179880] = "드라키사스의 낙인",
	[179913] = "전장으로!",
	[179914] = "해골 더미",
	[179915] = "해골 더미",
	[179922] = "얼룩진 피가 담긴 용기",
	[180229] = "불길한 흑마술 더미",
	[180248] = "맛둥어 떼",
	[180327] = "광기의 화로",
	[180366] = "찌그러진 낚시상자",
	[180368] = "광기의 서판",
	[180369] = "거품이는 진흙탕물",
	[180435] = "노글의 자루",
	[180436] = "황혼의 서판 조각",
	[180448] = "현상 수배: 죽음의 갈고리",
	[180453] = "문자가 새겨진 하이브레갈 수정",
	[180454] = "문자가 새겨진 하이브아쉬 수정",
	[180455] = "문자가 새겨진 하이브조라 수정",
	[180456] = "하급 바람의 돌",
	[180461] = "바람의 돌",
	[180466] = "상급 바람의 돌",
	[180501] = "황혼의 서판 조각",
	[180503] = "모래투성이 요리책",
	[180526] = "베데크의 징",
	[180570] = "맥주통",
	[180633] = "눈물의 결정",
	[180642] = "눈에 띄지 않는 궤짝",
	[180662] = "범선 잔해",
	[180665] = "왕초보를 위한 용언 완전정복",
	[180666] = "왕초보를 위한 용언 완전정복",
	[180667] = "왕초보를 위한 용언 완전정복",
	[180669] = "회오리치는 소용돌이",
	[180682] = "기름기 많은 아귀 떼",
	[180684] = "대형 총명어 떼",
	[180685] = "물에 젖은 잔해",
	[180690] = "큰 스카라베 상자",
	[180691] = "스카라베 상자",
	[180712] = "돌비늘뱀장어 떼",
	[180717] = "스카라베 징",
	[180743] = "정성스럽게 포장된 선물꾸러미",
	[180746] = "누가 살짝 흔들어 본 선물",
	[180747] = "화려하게 포장된 선물꾸러미",
	[180748] = "들썩거리는 선물상자",
	[180751] = "표류하는 잔해",
	[180793] = "축제 선물",
	[180794] = "잔다이스 바로브의 일지",
	[180901] = "붉은해적단 잔해",
	[181053] = "붉은물풀 광주리",
	[181073] = "맛있는 향기의 가마솥",
	[181074] = "투기장 전리품",
	[181085] = "스트라솔름 보급품 상자",
	[181098] = "화산재",
	[181366] = "4인 기사단 궤짝",
	[181598] = "실리시스트 모래기둥",
	[181672] = "밀짚인형",
	[181686] = "전쟁노래 목재 더미",
	[181687] = "목재 더미",
	[190483] = "문서함",
	[190484] = "문서함",
	[201579] = "쐐기돌 조각",
	[207724] = "난파선 파편",
	[386675] = "파묻힌 보물",
	[386759] = "도서관 책",
	[386777] = "먼지투성이 상자",
	[387466] = "녹슨 금고",
	[402215] = "까맣게 탄 기록",
	[403041] = "발파용 보급품",
	[403102] = "뾰족털일족 전리품 보관함",
	[403105] = "질풍의 솔방울",
	[404352] = "유물 보관함",
	[404695] = "흠뻑 젖은 은닉함",
	[404911] = "숨겨진 보관함",
	[404941] = "유물 금고",
	[405149] = "타조의 벽화",
	[405628] = "서리갈기 전리품 보관함",
	[405633] = "바위턱 사물함",
	[405879] = "왕실 연금술 학회 지침서",
	[405946] = "먼지투성이 상자",
	[406006] = "우상",
	[406736] = "잃어버린 은닉처",
	[406918] = "배낭",
	[407117] = "버려진 무쇠턱 둥지",
	[407120] = "텅 빈 무쇠턱 둥지",
	[407289] = "호드 전쟁 깃발",
	[407347] = "가시의 제단",
	[407457] = "마구간지기의 사물함",
	[407566] = "고블린어 고서",
	[407734] = "나무옹이 보관함",
	[408004] = "뒤얽힌 역병 더미",
	[408014] = "노움어 고서",
	[409692] = "두루마리",
	[409711] = "두루마리",
	[409731] = "두루마리",
	[409758] = "버려진 투구",
	[409949] = "쌍둥이 올빼미 조각상",
	[410369] = "비밀 접선 지점",
	[410528] = "장식된 상자",
	[410847] = "녹슨 금고",
	[412224] = "암흑 의식용 돌",
	[414532] = "폭포수 보관함",
	[414624] = "등대 은닉함",
	[415106] = "불타버린 잔해",
	[415107] = "불타버린 잔해",
	[417072] = "못으로 고정한 판자",
	[417353] = "꺼진 모닥불",
	[418855] = "일라리의 전리품 은닉처",
	[422483] = "자동 수습기 9000",
	[422911] = "봉인된 통",
	[422919] = "꼭지 달린 어둠괴철로단 맥주통",
	[423569] = "떨어진 주머니",
	[423695] = "구원의 성서",
	[423841] = "얼어붙은 잔해",
	[424005] = "휴대용 쓰레기통",
	[424006] = "황급히 만 주머니",
	[424007] = "조각상",
	[424010] = "못으로 고정한 판자",
	[424012] = "흙무더기",
	[424074] = "사각 측량 신호기 001",
	[424075] = "사각 측량 신호기 002",
	[424077] = "사각 측량 신호기 004",
	[439557] = "악몽 이끼",
	[439627] = "꿈뿌리",
	[439628] = "바보의 금 광맥",
	[439762] = "별빛연꽃",
	[439778] = "별빛은 광맥",
	[439810] = "달뿌리",
	[439815] = "상급 월장석 형성물",
	[441124] = "꿈에 물든 용의 알",
	[441128] = "진동하는 상자",
	[441129] = "아즈샤라의 예언",
	[441133] = "별에 물든 용의 알",
	[441140] = "웅웅거리는 상자",
	[441141] = "꿈진주",
	[441310] = "달빛너울 용의 알",
	[441312] = "광기 어린 수호자의 기록",
	[441314] = "하피의 장광설",
	[441946] = "달의 제단",
	[441947] = "야수의 제단",
	[441948] = "감시관의 제단",
	[455812] = "종자 쿠스베르트의 검",
	[457088] = "고급 검술",
	[457089] = "어둠의 유대",
	[457090] = "아제로스의 유명한(혹은 악명 높은) 순찰자",
	[457091] = "첸의 훈련 교범",
	[457092] = "스톰레이지의 격노",
	[457093] = "무딘 정의: 드워프 이야기",
	[457094] = "빛의 진정한 본질",
	[457095] = "왕초보도 이해하는 원소 마법 제1권: 냉기",
	[457096] = "누구보다 먼저: 싸움꾼의 권투 안내서",
	[457097] = "왕초보도 이해하는 원소 마법 제2권: 화염",
	[457098] = "내면의 표범을 찾아서: 현대 드루이드학 안내서",
	[457099] = "지렌의 맞는 법 강의",
	[457100] = "\"공정한\" 싸움에 대한 렌지크의 단상",
	[457101] = "막고라 의례",
	[457102] = "왕초보도 이해하는 원소 마법 제3권: 비전",
	[462233] = "일렁이는 용암 암반",
	[495500] = "암흑불길 보관함",
	[495503] = "오색 비축품",
	[495505] = "총애받는 보물",
	[100000001] = "불을 붙이지 않은 횃불",
});
for key,value in pairs({
	[11] = "|cFFAAFFAAPhase 1(WoW Classic)까지 사용할 수 없습니다.|r",
	[1606] = "|cFFAAFFAAPhase 2(Season of Discovery)까지 사용할 수 없습니다.|r",
	[1607] = "|cFFAAFFAAPhase 3(Season of Discovery)까지 사용할 수 없습니다.|r",
	[1608] = "|cFFAAFFAAPhase 4(Season of Discovery)까지 사용할 수 없습니다.|r",
	[1609] = "|cFFAAFFAAPhase 5(Season of Discovery)까지 사용할 수 없습니다.|r",
	[1610] = "|cFFAAFFAAPhase 6(Season of Discovery)까지 사용할 수 없습니다.|r",
	[1611] = "|cFFAAFFAAPhase 7(Season of Discovery)까지 사용할 수 없습니다.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "10 레벨",
	[7] = "20 레벨",
	[8] = "30 레벨",
	[9] = "40 레벨",
	[10] = "50 레벨",
	[11] = "60 레벨",
	[42] = "동부 왕국 탐험",
	[43] = "칼림도어 탐험",
	[121] = "수습 요리사",
	[122] = "숙련 요리사",
	[123] = "전문 요리사",
	[126] = "수습 낚시꾼",
	[127] = "숙련 낚시꾼",
	[128] = "전문 낚시꾼",
	[131] = "수습 응급치료사",
	[132] = "숙련 응급치료사",
	[133] = "전문 응급치료사",
	[238] = "명예로운 처치",
	[239] = "명예 승수 25,000",
	[306] = "아제로스 낚시왕",
	[389] = "구루바시 투기장 전문 검투사",
	[396] = "구루바시 투기장 최고검투사",
	[416] = "스카라베 군주",
	[424] = "왜? 붉은색이니까!",
	[425] = "아티쉬 - 수호자의 지팡이",
	[428] = "우레폭풍 - 바람추적자의 성검",
	[429] = "설퍼라스 - 라그나로스의 손",
	[509] = "명예 승수 10,000",
	[512] = "명예 승수 5,000",
	[513] = "명예 승수 100",
	[515] = "명예 승수 500",
	[516] = "명예 승수 1,000",
	[520] = "20개 세력과 확고한 동맹",
	[521] = "15개 세력과 확고한 동맹",
	[522] = "후... 이놈의 인기란...",
	[523] = "5개 세력과 확고한 동맹",
	[524] = "10개 세력과 확고한 동맹",
	[546] = "안전 예금",
	[627] = "던 모로 탐험",
	[628] = "죽음의 폐광",
	[629] = "성난불길 협곡",
	[630] = "통곡의 동굴",
	[631] = "그림자송곳니 성채",
	[633] = "스톰윈드 지하감옥",
	[634] = "놈리건",
	[635] = "가시덩굴 우리",
	[636] = "가시덩굴 구릉",
	[638] = "울다만",
	[640] = "마라우돈",
	[641] = "가라앉은 사원",
	[642] = "검은바위 나락",
	[643] = "검은바위 첨탑 하층",
	[646] = "스트라솔름",
	[684] = "오닉시아의 둥지 (레벨 60)",
	[685] = "검은날개 둥지",
	[686] = "화산 심장부",
	[687] = "안퀴라즈 사원",
	[688] = "줄구룹",
	[689] = "안퀴라즈 폐허",
	[706] = "전투 서리늑대",
	[707] = "스톰파이크 전투산양",
	[708] = "서리늑대부족 영웅",
	[709] = "스톰파이크 경비대의 영웅",
	[710] = "파멸자",
	[711] = "아라소르의 기사",
	[712] = "전쟁노래 정찰대",
	[713] = "은빛날개 파수대",
	[714] = "정복자",
	[727] = "기병대 출동!",
	[728] = "듀로타 탐험",
	[729] = "죽음의 군마 고삐",
	[736] = "멀고어 탐험",
	[750] = "불모의 땅 탐험",
	[760] = "알터랙 산맥 탐험",
	[761] = "아라시 고원 탐험",
	[765] = "황야의 땅 탐험",
	[766] = "저주받은 땅 탐험",
	[768] = "티리스팔 숲 탐험",
	[769] = "은빛소나무 숲 탐험",
	[770] = "서부 역병지대 탐험",
	[771] = "동부 역병지대 탐험",
	[772] = "힐스브래드 구릉지 탐험",
	[773] = "동부 내륙지 탐험",
	[774] = "이글거리는 협곡 탐험",
	[775] = "불타는 평원 탐험",
	[776] = "엘윈 숲 탐험",
	[777] = "죽음의 고개 탐험",
	[778] = "그늘숲 탐험",
	[779] = "모단 호수 탐험",
	[780] = "붉은마루 산맥 탐험",
	[781] = "가시덤불 골짜기 탐험",
	[782] = "슬픔의 늪 탐험",
	[802] = "서부 몰락지대 탐험",
	[841] = "저습지 탐험",
	[842] = "텔드랏실 탐험",
	[844] = "어둠의 해안 탐험",
	[845] = "잿빛 골짜기 탐험",
	[846] = "버섯구름 봉우리 탐험",
	[847] = "돌발톱 산맥 탐험",
	[848] = "잊혀진 땅 탐험",
	[849] = "페랄라스 탐험",
	[850] = "먼지진흙 습지대 탐험",
	[851] = "타나리스 사막 탐험",
	[852] = "아즈샤라 탐험",
	[853] = "악령의 숲 탐험",
	[854] = "운고로 분화구 탐험",
	[855] = "달의 숲 탐험",
	[856] = "실리더스 탐험",
	[857] = "여명의 설원 탐험",
	[871] = "제독님, 안녕?",
	[879] = "오랜 친구",
	[880] = "날쌘 줄리안 호랑이",
	[881] = "날쌘 래즈자쉬 랩터",
	[891] = "이랴!",
	[907] = "심판관",
	[940] = "가시덤불 골짜기의 푸른 언덕",
	[944] = "동굴 속에서도 이 놈의 인기란...",
	[946] = "은빛 여명회",
	[955] = "히드락시안 물의 군주",
	[956] = "노즈도르무 혈족",
	[957] = "잔달라 부족",
	[1307] = "검은바위 첨탑 상층",
	[1676] = "동부 왕국의 현자",
	[1677] = "동부 왕국의 현자",
	[1678] = "칼림도어의 현자",
	[1680] = "칼림도어의 현자",
	[2116] = "은빛 여명회 휘장",
	[2141] = "마구간지기",
	[2142] = "넘치는 마구간",
	[2336] = "내가 미쳤어!",
	[2357] = "소로스의 공포마",
	[2358] = "군마",
	[2496] = "제5원소",
	[3356] = "여명의 설원 눈호랑이",
	[5788] = "셴드랄라의 대리인",
	[16433] = "철의 영혼 (마스터리 서버)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "10 레벨 달성",
	[7] = "20 레벨 달성",
	[8] = "30 레벨 달성",
	[9] = "40 레벨 달성",
	[10] = "50 레벨 달성",
	[11] = "60 레벨 달성",
	[42] = "동부 왕국 지역 탐험",
	[43] = "칼림도어 탐험",
	[121] = "수습 요리사 되기",
	[122] = "숙련 요리사 되기",
	[123] = "전문 요리사 되기",
	[126] = "수습 낚시꾼 되기",
	[127] = "숙련 낚시꾼 되기",
	[128] = "전문 낚시꾼 되기",
	[131] = "수습 응급치료사 되기",
	[132] = "숙련 응급치료사 되기",
	[133] = "전문 응급치료사 되기",
	[238] = "명예 승수 획득",
	[239] = "명예 승수 25,000",
	[306] = "무법항 낚시왕 선발대회나 칼루아크 낚시 대회에서 우승",
	[389] = "구루바시 투기장에서 전리품으로 \"\"전문 검투사의 징표\"\" 획득",
	[396] = "땅딸보 존 미스릴의 퀘스트를 완료하여 \"\"최고검투사의 징표\"\" 획득",
	[416] = "안퀴라즈 성문 열기",
	[424] = "공명의 붉은 퀴라지 수정 획득",
	[425] = "아티쉬 - 수호자의 지팡이를 부리는 자",
	[428] = "우레폭풍 - 바람추적자의 성검을 부리는 자",
	[429] = "설퍼라스 - 라그나로스의 손을 부리는 자",
	[509] = "명예 승수 10,000",
	[512] = "명예 승수 5,000",
	[513] = "명예 승수 100",
	[515] = "명예 승수 500",
	[516] = "명예 승수 1,000",
	[520] = "20개 세력과 확고한 동맹 달성",
	[521] = "15개 세력과 확고한 동맹 달성",
	[522] = "확고한 동맹 평판 획득",
	[523] = "5개 세력과 확고한 동맹 달성",
	[524] = "10개 세력과 확고한 동맹 달성",
	[546] = "은행 가방 보관함 7개 구입",
	[627] = "던 모로 탐험 및 지역 발견",
	[628] = "에드윈 밴클리프 처치",
	[629] = "욕망의 타라가만 처치",
	[630] = "걸신들린 무타누스 처치",
	[631] = "대마법사 아루갈 처치",
	[633] = "바질 스레드 처치",
	[634] = "멕기니어 텔마플러그 처치",
	[635] = "서슬깃 차를가 처치",
	[636] = "혹한의 암네나르 처치",
	[638] = "아카에다스 처치",
	[640] = "공주 테라드라스 처치",
	[641] = "에라니쿠스의 사령 처치",
	[642] = "제왕 다그란 타우릿산 처치",
	[643] = "대군주 웜타라크 처치",
	[646] = "스트라솔름에 거주하는 악의 무리 처치",
	[684] = "레벨 60 오리지널 오닉시아 처치",
	[685] = "네파리안 처치",
	[686] = "라그나로스 처치",
	[687] = "쑨 처치",
	[688] = "학카르 처치",
	[689] = "무적의 오시리안 처치",
	[706] = "전투 서리늑대 획득",
	[707] = "스톰파이크 전투산양 획득",
	[708] = "서리늑대부족 확고한 동맹",
	[709] = "스톰파이크 경비대 확고한 동맹",
	[710] = "포세이큰 파멸단 확고한 동맹",
	[711] = "아라소르 연맹 확고한 동맹",
	[712] = "전쟁노래 정찰대 확고한 동맹",
	[713] = "은빛날개 파수대 확고한 동맹",
	[714] = "전쟁노래 협곡, 아라시 분지, 알터랙 계곡 확고한 동맹",
	[727] = "명예 시스템을 통해 전투 탈것 중 하나 획득",
	[728] = "듀로타 탐험 및 지역 발견",
	[729] = "스트라솔름의 남작 리븐데어에게서 죽음의 군마 고삐 획득",
	[736] = "멀고어 탐험 및 지역 발견",
	[750] = "불모의 땅 탐험 및 지역 발견",
	[760] = "알터랙 산맥 탐험 및 지역 발견",
	[761] = "아라시 고원 탐험 및 지역 발견",
	[765] = "황야의 땅 탐험 및 지역 발견",
	[766] = "저주받은 땅 탐험 및 지역 발견",
	[768] = "티리스팔 숲 탐험 및 지역 발견",
	[769] = "은빛소나무 숲 탐험 및 지역 발견",
	[770] = "서부 역병지대 탐험 및 지역 발견",
	[771] = "동부 역병지대 탐험 및 지역 발견",
	[772] = "힐스브래드 구릉지 탐험 및 지역 발견",
	[773] = "동부 내륙지 탐험 및 지역 발견",
	[774] = "이글거리는 협곡 탐험 및 지역 발견",
	[775] = "불타는 평원 탐험 및 지역 발견",
	[776] = "엘윈 숲 탐험 및 지역 발견",
	[777] = "죽음의 고개 탐험 및 지역 발견",
	[778] = "그늘숲 탐험 및 지역 발견",
	[779] = "모단 호수 탐험 및 지역 발견",
	[780] = "붉은마루 산맥 탐험 및 지역 발견",
	[781] = "가시덤불 골짜기 탐험 및 지역 발견",
	[782] = "슬픔의 늪 탐험 및 지역 발견",
	[802] = "서부 몰락지대 탐험 및 지역 발견",
	[841] = "저습지 탐험 및 지역 발견",
	[842] = "텔드랏실 탐험 및 지역 발견",
	[844] = "어둠의 해안 탐험 및 지역 발견",
	[845] = "잿빛 골짜기 탐험 및 지역 발견",
	[846] = "버섯구름 봉우리 탐험 및 지역 발견",
	[847] = "돌발톱 산맥 탐험 및 지역 발견",
	[848] = "잊혀진 땅 탐험 및 지역 발견",
	[849] = "페랄라스 탐험 및 지역 발견",
	[850] = "먼지진흙 습지대 탐험 및 지역 발견",
	[851] = "타나리스 사막 탐험 및 지역 발견",
	[852] = "아즈샤라 탐험 및 지역 발견",
	[853] = "악령의 숲 탐험 및 지역 발견",
	[854] = "운고로 분화구 탐험 및 지역 발견",
	[855] = "달의 숲 탐험 및 지역 발견",
	[856] = "실리더스 탐험 및 지역 발견",
	[857] = "여명의 설원 탐험 및 지역 발견",
	[871] = "붉은해적단 제독 모자를 획득하여 가끔 신선한 바람 쐬기",
	[879] = "더는 구할 수 없는 과거의 빠른 탈것 소유자",
	[880] = "줄구룹 대사제 데칼에게서 날쌘 줄리안 호랑이 획득",
	[881] = "줄구룹의 혈군주 만도키르에게서 날쌘 래즈자쉬 랩터 획득",
	[891] = "초급 타기 배우기",
	[907] = "전쟁노래 협곡, 아라시 분지, 알터랙 계곡 확고한 동맹",
	[940] = "가시덤불 골짜기의 헤멧 네싱워리 퀘스트를 \"\"가시덤불 골짜기의 푸른 언덕\"\" 및 \"\"대단한 사냥꾼\"\"까지 모두 완료",
	[944] = "나무구렁 요새 확고한 동맹",
	[946] = "은빛 여명회 확고한 동맹",
	[955] = "히드락시안 물의 군주 확고한 동맹",
	[956] = "노즈도르무 혈족 확고한 동맹",
	[957] = "잔달라 부족 확고한 동맹",
	[1307] = "사령관 드라키사스 처치",
	[1676] = "동부 왕국 퀘스트 700개 완료",
	[1677] = "동부 왕국 퀘스트 550개 완료",
	[1678] = "칼림도어 퀘스트 700개 완료",
	[1680] = "칼림도어 퀘스트 685개 완료",
	[2116] = "스컬지 침공 이벤트에서 은빛 여명회 휘장 획득",
	[2141] = "탈것 10개 획득",
	[2142] = "탈것 25개 획득",
	[2336] = "붉은해적단 우호적 평판을 달성하고 무법항, 눈망루 마을, 가젯잔, 톱니항, 다크문 유랑단, 라벤홀트 암살단, 셴드랄라와 확고한 동맹",
	[2357] = "흑마법사 퀘스트 소로스의 공포마 완료",
	[2358] = "군마 획득을 위한 성기사 퀘스트 완료",
	[2496] = "물의 정기 획득",
	[3356] = "여명의 설원 눈호랑이 획득",
	[5788] = "셴드랄라 확고한 동맹",
	[16433] = "마스터리 서버 도중 죽지 않고 60 레벨 달성",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "위업",
	[92] = "일반",
	[95] = "플레이어 대 플레이어",
	[96] = "퀘스트",
	[97] = "탐험",
	[168] = "던전 및 공격대",
	[169] = "전문 기술",
	[170] = "요리",
	[171] = "낚시",
	[172] = "응급치료",
	[201] = "평판",
	[14777] = "동부 왕국",
	[14778] = "칼림도어",
	[14801] = "알터랙 계곡",
	[14802] = "아라시 분지",
	[14804] = "전쟁노래 협곡",
	[14808] = "오리지널",
	[14861] = "오리지널",
	[14864] = "오리지널",
})
do achievementCategories[key].name = value; end
end
if simplifiedLocale == "es" then
localize(L.HEADER_NAMES, {
	[-1000015] = "Instructor de demonios",
	[-1000025] = "Festividades",
	[-1000034] = "Instructora de equitación",
	[-1000040] = "Maestro armero",
	[-1000162] = "Apariciones Compartidas",
	[-1000163] = "Apariencia única",
	[-1000168] = "Los Cuatro Jinetes",
	[-1000191] = "Derrota a un Teniente",
	[-1000192] = "Gana la Batalla",
	[-1000193] = "Hablar con los Muertos",
	[-1000195] = "Habla con el Grizzby",
	[-1000196] = "Habla con el N'ora",
	[-1000198] = "Habla con el Hermano Romulus",
	[-1000201] = "Feria de la Luna Negra",
	[-1000223] = "Festival del Fuego del Solsticio de Verano",
	[-1000227] = "Gran espectáculo de pesca de Tuercespina",
	[-1000235] = "La apertura del Portal Oscuro",
	[-1000236] = "El cetro del Mar de Dunas",
	[-1000273] = "Temporada de Descubrimiento",
	[-1000274] = "Comprensión",
	[-1000275] = "Nivel 1",
	[-1000276] = "Nivel 2",
	[-1000277] = "Caza de Monstruos",
	[-1000278] = "Grabado",
	[-1000279] = "Suministros asaltados",
	[-1000373] = "Nueva personaje",
	[-1000376] = "Pelea Corpulenta",
	[-1000377] = "Polimorfo Salvaje",
	[-1000378] = "Corredores de Almas",
	[-1000380] = "Prima",
	[-1000970] = "Nivel 3",
	[-1001035] = "Pescado de temporada: lubina de verano",
	[-1001036] = "Pescado de temporada: calamares de invierno",
	[-1001058] = "Arboleda de la Pesadilla",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000040] = "Un maestro de armas es un PNJ que ofrece a los personajes la oportunidad de aprender habilidades específicas con armas, cuya disponibilidad varía de un maestro de armas a otro. Todas las habilidades con armas se pueden entrenar en el nivel 1, excepto las armas de asta que requieren el nivel 20.\n\nEl entrenamiento con un maestro de armas quedó obsoleto en el parche 4.0.1, ya que cada clase ahora aprende todas las competencias de armas apropiadas para la clase en el momento de la creación. Los maestros de armas se eliminaron del juego poco después.",
	[-1000162] = "Los elementos de esta lista son apariencias compartidas del elemento anterior. En el modo de apariencia única, esta lista puede ayudarlo a comprender por qué o no un elemento específico se marcaría como recopilado.",
	[-1000163] = "Este artículo tiene una apariencia única. Debes recolectar este artículo específicamente para ganar la apariencia.",
	[-1000273] = "Esta temporada trae un límite de nivel inicial de 25 y un nuevo final de nivel 25, que incluye una incursión de 10 jugadores en Blackfathom Deeps con nuevas mecánicas, jefes nuevos y reinventados para desafiar las tácticas y estrategias de los jugadores, y nuevas recompensas.",
	[-1000278] = "El grabado es un nuevo sistema anunciado recientemente para Season of Discovery. ¡Permite que cada clase adapte su experiencia de juego desbloqueando nuevas habilidades únicas!",
	[-1000279] = "Los objetos de misión de Suministros Waylaid caen de mobs de nivel 6 y, sobre todo, en Azeroth. Estas misiones requieren la entrega de suministros Waylaid a un representante de la organización a cambio de algo de plata, experiencia y reputación. Por supuesto, faltan elementos en el envío de suministros y puedes complementarlos para obtener mayores recompensas de reputación.",
	[-1000376] = "Sólo la persona que dé el golpe final al borracho obtendrá crédito, independientemente de quién haya tocado el objetivo primero. No hay crédito grupal por esto.",
	[-1000377] = "Lanza Polymorph sobre criaturas afectadas por Wild Polymorph para convertirlas nuevamente en aprendices. Cada uno te dará una nota. Recoge 6 notas para aprender la runa.",
	[-1000380] = "Esta lista contiene elementos inalcanzables que ATT Discord ha informado como errores que Blizzard aún no ha solucionado.\n\nNOTA: Todos los filtros se ignoran en esta lista para mayor visibilidad. En esta lista solo están presentes los elementos eliminados del juego debido a negligencia y no a un gigantesco dragón que escupe fuego.\n\nA los desarrolladores de Blizzard: arreglen los elementos y encuentros que se enumeran a continuación.",
});
localize(ObjectNames, {
	[31] = "Estatua de león antigua",
	[32] = "Cofre sumergido",
	[33] = "Cofre cerrado",
	[34] = "Vieja jarra",
	[35] = "Baúl del Capitán",
	[36] = "Barrica rota",
	[47] = "¡Se busca!",
	[52] = "La Caída de Gurubashi",
	[54] = "La Tumba del Emperador",
	[55] = "Un cadáver medio comido",
	[56] = "Cadáver de Rolf",
	[57] = "Luna sobre el Valle",
	[58] = "Gri'lek el Trotamundos",
	[59] = "Montón de tierra",
	[60] = "Se busca: Gath'Ilzogg",
	[61] = "Una tumba erosionada",
	[68] = "Cartel de Se busca",
	[76] = "Una jarra vacía",
	[119] = "Cajón de Abercrombie",
	[256] = "SE BUSCA",
	[257] = "Barrica sospechosa",
	[259] = "Barrica semienterrada",
	[261] = "Cajón dañado",
	[263] = "Suministros Kurzen",
	[264] = "Suministros Kurzen",
	[269] = "Barrica de Cerveza del Trueno custodiado",
	[270] = "Barrica de Cerveza del Trueno sin vigilar",
	[271] = "Cajones de la Liga de Mineros",
	[272] = "Estantería de carne de MacGrann",
	[276] = "Cesta de cardaluz",
	[287] = "Documentos del corredor Herod",
	[288] = "Caja fuerte del corredor Herod",
	[290] = "Guardarropa de Furlbrow",
	[321] = "Lágrima de Tilloa",
	[331] = "Suelo blando",
	[333] = "Reliquia antigua",
	[334] = "Reliquia antigua",
	[375] = "Calabaza de Tirisfal",
	[711] = "¡Se busca!",
	[759] = "El manantial sagrado",
	[1166] = "Cofre de Alexston",
	[1557] = "Mesa de cena de Lillith",
	[1560] = "Arcón",
	[1561] = "Cajón sellado",
	[1562] = "Cofre del alguacil Haggard",
	[1571] = "Libros de hechizos polvorientos",
	[1585] = "Carga explosiva",
	[1586] = "Cajón de velas",
	[1593] = "Barco cargado de cadáveres",
	[1594] = "Estantería de Berard",
	[1599] = "Tumba poco profunda",
	[1609] = "Catapulta Faucedraco",
	[1610] = "Filón de incendicita",
	[1627] = "Cajón de Dalaran",
	[1673] = "Bellota vil",
	[1721] = "Cadena con bola de preso",
	[1722] = "Cadena con bola de preso",
	[1723] = "Flor Morrobarro",
	[1727] = "Barril de cerveza Machacacanillas",
	[1728] = "Alfombra polvorienta",
	[1736] = "Envío de hierro",
	[1738] = "Documentos de Hermandad",
	[1739] = "Documentos del Sindicato",
	[1740] = "Documentos de la Hermandad",
	[1759] = "Registro de Trabalomas",
	[1760] = "Estantería estropeada",
	[1761] = "Proclamación de Trabalomas",
	[1763] = "SE BUSCA",
	[1765] = "Cofre de madera gastado",
	[1768] = "Llama de Azel",
	[1769] = "Llama de Veraz",
	[1770] = "Llama de Uzel",
	[2008] = "¡Peligro!",
	[2059] = "Un cadáver de enano",
	[2068] = "Oporto Pupellyverbos",
	[2076] = "Caldera burbujeante",
	[2083] = "Correspondencia de los Velasangre",
	[2084] = "Zibética",
	[2086] = "Carta de navegación de los Velasangre",
	[2087] = "Pedidos de los Velasangre",
	[2289] = "Bote salvavidas inservible",
	[2553] = "Un viejo pergamino",
	[2554] = "El enigma de Cortello",
	[2555] = "Pergamino mohoso",
	[2560] = "Botella semienterrada",
	[2576] = "Altar de las Mareas",
	[2652] = "Cadáver de Ebenezer Herrumbra",
	[2656] = "Carta con marcas de agua",
	[2688] = "Piedra angular",
	[2689] = "Piedra de Vínculo Oeste",
	[2690] = "Piedra de Vínculo Exterior",
	[2691] = "Piedra de Vínculo Este",
	[2701] = "Fragmentos iridiscentes",
	[2702] = "Piedra de Vínculo Interior",
	[2704] = "Alijo de explosivos",
	[2707] = "Mapas disparatados de Maiden",
	[2708] = "Carta de navegación del Espíritu de Argénteos",
	[2709] = "Bitácora disparatada de Maiden",
	[2710] = "Bitácora del Espíritu de Argénteos",
	[2712] = "Gema élfica calcificada",
	[2713] = "Tablón de Se busca",
	[2714] = "Granito de Alterac",
	[2716] = "Cofre de Trelane",
	[2717] = "Baúl de Trelane",
	[2718] = "Arcón de Trelane",
	[2724] = "Saco de avena",
	[2734] = "Cofre encharcado",
	[2739] = "Cofre de la pluma negra",
	[2740] = "Cofre de la garra del cuervo",
	[2741] = "Cofre del cielo",
	[2742] = "Cofre del nidal",
	[2743] = "Urna de piedra labrada",
	[2744] = "Almeja gigante",
	[2842] = "Pilar de diamante",
	[2848] = "Pilar de ópalo",
	[2858] = "Pilar de amatista",
	[2867] = "Cajón de provisiones de excavación",
	[2868] = "Mapa arrugado",
	[2875] = "Esqueleto de enano maltrecho",
	[2891] = "Cráneos trofeo de Balia'mah",
	[2892] = "Cráneos trofeo de Ziata'jai",
	[2893] = "Cráneos trofeo de Zul'Mamwe",
	[2907] = "Jarra de agua",
	[2908] = "Cajón de suministros sellado",
	[2910] = "Piedra de pozo",
	[2912] = "Bellota ámbar",
	[2933] = "Sello de la Tierra",
	[3076] = "Mapa manchado",
	[3189] = "Plan de ataque: Valle de los Retos",
	[3190] = "Plan de ataque: Poblado Sen'jin",
	[3192] = "Plan de ataque: Orgrimmar",
	[3236] = "Caja de herramientas gnoma",
	[3237] = "Lanza Negra encarcelado",
	[3238] = "Barril vacío de Chen",
	[3239] = "Cofre de Benedict",
	[3240] = "Huevos de colazote",
	[3290] = "Saco de provisiones robado",
	[3525] = "El Altar de Fuego",
	[3640] = "Champiñón cargado",
	[3642] = "Botín Kolkar",
	[3643] = "Baúl antiguo",
	[3644] = "Máquina voladora de Bael Modan",
	[3646] = "Caja fuerte del general Trenzado",
	[3685] = "Montículo de silítidos",
	[3737] = "Fisura burbujeante",
	[3767] = "Emporio de Drizzlik",
	[3768] = "Frágil: evitar golpes",
	[3972] = "SE BUSCA",
	[4072] = "Válvula de control principal",
	[4141] = "Consola de control",
	[4406] = "Huevos de Tejemadera",
	[4608] = "Brote de Brezomadera",
	[5620] = "Piedras de energía imperfectas",
	[6751] = "Planta con extraños frutos",
	[6752] = "Planta con extrañas hojas",
	[6906] = "Nido de raptor rojo",
	[6907] = "Nido de raptor azul",
	[6908] = "Nido de raptor amarillo",
	[7510] = "Fronda crecida",
	[9630] = "Fósil de Gargavino",
	[10076] = "Cuenco de visión",
	[11713] = "Oronja verde",
	[11714] = "Boleto rudo",
	[12666] = "Escrito Crepuscular",
	[13360] = "Reliquia de Mathystra",
	[13891] = "Reptilia",
	[13949] = "Cofre de hierro",
	[15084] = "El Destellamatic 5200",
	[15085] = "El Destellamatic 5200",
	[16393] = "Llama antigua",
	[17182] = "Caja mecánica 827",
	[17183] = "Caja mecánica 411",
	[17184] = "Caja mecánica 323",
	[17188] = "La instauración de Ameth'Aran",
	[17189] = "La caída de Ameth'Aran",
	[17282] = "Paquete de plantas",
	[17783] = "Estatuilla antigua",
	[19015] = "Lágrima de Elune",
	[19016] = "Arbusto cubierto de polvo estelar",
	[19021] = "Cofre oxidado",
	[19022] = "Cofre desgastado",
	[19024] = "Santuario Oculto",
	[19027] = "Libro de Mel'Thandris",
	[19030] = "Túmulo de barro",
	[19283] = "Compendio de los Caídos",
	[19284] = "Mitología de los titanes",
	[19595] = "Bastión de los Porteros",
	[19596] = "Alijo de Durmientes",
	[19597] = "Alijo de druidas",
	[19598] = "Carretilla de alijo",
	[19599] = "Reserva del Cubil del Espolón",
	[19602] = "Planos de ingeniería de Ventura y Cía.",
	[19603] = "Documentos de Ventura y Cía.",
	[19861] = "Diario de Henrig Soliceja",
	[19869] = "Restos del coche cohete",
	[19877] = "Armario de Velinde",
	[19901] = "Círculo de Encarcelamiento",
	[20352] = "Círculo de Encarcelamiento",
	[20359] = "Huevo de Onyxia",
	[20447] = "Comestibles de la Arpía",
	[20691] = "Baúl de Cozzle",
	[20725] = "El legado de los Aspectos",
	[20726] = "Comienzos de la amenaza de los no-muertos",
	[20727] = "Cajón de embalaje de Gizmorium",
	[20805] = "Planes sin vigilancia de Rizzle",
	[20807] = "Blandón antiguo",
	[20920] = "Tubérculo hojazul",
	[20985] = "Tierra esparcida",
	[20992] = "Escudo negro",
	[21015] = "Huellas pezuñales",
	[21016] = "Huellas pezuñales",
	[21042] = "Identificación de guardia de Theramore",
	[21052] = "Caja fuerte de los Defias",
	[21277] = "Cajón con agujeros",
	[21530] = "Manual del instrucciones del Husmeador",
	[22245] = "Saco de carne",
	[22246] = "Lágrima de Theradras",
	[22550] = "Cristales draenetistas",
	[24798] = "Madera a la deriva desecada",
	[28024] = "Cofre de la caravana",
	[28604] = "Cajón destrozado",
	[30854] = "Artefacto de Atal'ai",
	[30855] = "Artefacto de Atal'ai",
	[30856] = "Artefacto de Atal'ai",
	[32569] = "Caja fuerte de Galen",
	[35251] = "Cofre de Karnitol",
	[35252] = "Reliquia antigua",
	[36738] = "El libro de Ur",
	[37099] = "Tablilla Atal'ai",
	[50935] = "Saco de maíz",
	[50936] = "Saco de cebada",
	[50937] = "Saco de centeno",
	[50961] = "Cofre de Malem",
	[50982] = "El Roble Carbonizado",
	[51708] = "Tierra de la tumba de Eliza",
	[58369] = "Cofre de hierro robado",
	[58595] = "Alijo del Filo Ardiente",
	[61934] = "Blandón de la Llama Latente",
	[61935] = "Válvula reguladora",
	[61936] = "Válvula de control de combustible",
	[68865] = "Varas de mando de husmeador",
	[85562] = "Caja fuerte de Vetaferro",
	[85563] = "Caja fuerte de Dentomuerto",
	[86492] = "Cajón de Elunite",
	[89634] = "Coral férreo",
	[89635] = "Cáscara asolada",
	[91138] = "Martillo de Jordan",
	[92013] = "Libro del conciliábulo",
	[92420] = "Mena de Bailor",
	[92423] = "Cofre dañado",
	[93192] = "Duramen",
	[102984] = "Caja de herramientas de Bink",
	[102985] = "Bocas de dragón de Balnir",
	[103574] = "Arca de contención llena",
	[103628] = "Tratado de Magia de las Sombras de Ur",
	[103821] = "Caja fuerte de Doan",
	[104564] = "Cubo de herramientas de Bingles",
	[104569] = "Cubo de herramientas de Bingles",
	[104574] = "Cubo de herramientas de Bingles",
	[104575] = "Cartucho de Bingles",
	[105169] = "Portaarmas de Agamand",
	[105170] = "Portaarmas de Agamand",
	[105171] = "Portaarmas de Agamand",
	[105172] = "Portaarmas de Agamand",
	[105174] = "Cofre de arcas de contención",
	[105175] = "Canto de manifestación",
	[112888] = "Estantería polvorienta",
	[112948] = "Caja fuerte de El Intrépido cerrada",
	[113757] = "Alijo de Forjatiniebla",
	[113768] = "Huevo de color vivo",
	[113791] = "Blandón de Siemprefuente",
	[123329] = "Cofre de Baelog",
	[123462] = "La joya de los Mares del Sur",
	[125477] = "Urna llamativa",
	[126049] = "Setas magenta",
	[126158] = "Vestidor de Tallonkai",
	[126260] = "Cofre antiguo",
	[129127] = "Arcón de Gallywix",
	[131474] = "Los Discos de Norgannon",
	[138492] = "Fragmentos de Myzrael",
	[140911] = "Bobina de hilo de seda verde pistacho",
	[140971] = "Gahz'rilo",
	[141812] = "Piedra de Vínculo",
	[141832] = "Gong de Zul'Farrak",
	[141853] = "Tragano violeta",
	[141857] = "Piedra de Vínculo",
	[141858] = "Piedra de Vínculo",
	[141859] = "Piedra de Vínculo",
	[141931] = "Huevo de hipogrifo",
	[141979] = "Tesoro antiguo",
	[141980] = "Arcón espectral",
	[142071] = "Huevomático",
	[142076] = "Manzanas Frescas de Clara",
	[142088] = "Tablilla de Voluntad",
	[142122] = "Cartel de Se busca",
	[142127] = "Secreto de Rin'ji",
	[142151] = "Barrica sellada",
	[142179] = "Glorieta de Solarsal",
	[142181] = "Cargamento robado",
	[142184] = "Cofre del Capitán",
	[142185] = "Llama de Byltan",
	[142186] = "Llama de Lahassa",
	[142187] = "Llama de Imbel",
	[142188] = "Llama de Samha",
	[142189] = "Hito inadvertido",
	[142191] = "Cajón de suministros de la Horda",
	[142195] = "Mapa de batalla de los Zarpaleña",
	[142343] = "Pedestal de Uldum",
	[142344] = "Extrapolador artificial",
	[142345] = "Perforágrafo Matriz 3005-A",
	[142475] = "Perforágrafo Matriz 3005-B",
	[142476] = "Perforágrafo Matriz 3005-C",
	[142477] = "Caja fuerte de Termochufe",
	[142487] = "El Destellamatic 5200",
	[142696] = "Perforágrafo Matriz 3005-D",
	[142702] = "Botella de veneno",
	[142715] = "Tablilla de Theka",
	[142958] = "Feralas: una historia",
	[143980] = "Pergamino Gordunni",
	[144053] = "Equipo de análisis de Patagolpe",
	[144054] = "Cofre de Shay",
	[144063] = "Monolito de Equinex",
	[144064] = "Túmulo de Gordunni",
	[144066] = "Primera jaula Secacorteza",
	[144067] = "Segunda jaula Secacorteza",
	[144068] = "Tercera jaula Secacorteza",
	[144070] = "Jaula de Picoafilado",
	[147557] = "Plata robada",
	[148498] = "Altar de Suntara",
	[148499] = "Caja de Félix",
	[148504] = "Una lápida llamativa",
	[148506] = "Artefacto Crepuscular",
	[148512] = "Fuente de esencia",
	[148513] = "Tablilla de Jin'yael",
	[148514] = "Tablilla de Markri",
	[148515] = "Tablilla de Sael'hai",
	[148516] = "Tablilla de Beth'Amara",
	[148832] = "Estatua Atal'ai",
	[148836] = "Altar de Hakkar",
	[148838] = "Ídolo de Hakkar",
	[149025] = "Blandón de avizor",
	[149030] = "Blandón de avizor",
	[149031] = "Blandón de avizor",
	[149032] = "Blandón de avizor",
	[149036] = "Cofre de Marvon",
	[149047] = "Antorcha de reprensión",
	[149480] = "Runa de Jin'yael",
	[149481] = "Runa de Beth'Amara",
	[149482] = "Runa de Markri",
	[149483] = "Runa de Sael'hai",
	[149502] = "Tesoro oculto del Vuelo Negro",
	[150075] = "Cartel de Se busca",
	[150140] = "Cristal de enfoque Arcano",
	[151286] = "Escrito sobre invocación kaldorei",
	[152094] = "Champiñón jacinto",
	[152095] = "Lirio alunado",
	[152097] = "Blandón de Belnistrasz",
	[152608] = "Botín de Kolkar",
	[152618] = "Botín de Kolkar",
	[152622] = "Formación de azsharita",
	[153123] = "Equipo de Kim'jael",
	[153205] = "Altar de los Rapiñadores",
	[153239] = "Pluma de lechúcico salvaje",
	[153556] = "Reliquia Thaurissan",
	[154357] = "Barro centelleante",
	[156561] = "Cartel de Se busca",
	[157936] = "Montón de porquería de Un'Goro",
	[160836] = "Arca de reliquias",
	[160840] = "Montículo de tierra blanda",
	[160845] = "Arca oscura",
	[161495] = "Caja fuerte secreta",
	[161504] = "Un paquetito",
	[161505] = "Una balsa estropeada",
	[161521] = "Equipo de investigación",
	[161526] = "Cajón de comestibles",
	[161527] = "Hueso de dinosaurio",
	[161557] = "Cosecha de Milly",
	[161752] = "Cubo de herramientas",
	[164659] = "Cristal de poder verde",
	[164661] = "Cristal de poder amarillo",
	[164662] = "Cajas de equipamiento",
	[164689] = "Monumento a Franclorn Forjador",
	[164778] = "Cristal de poder azul",
	[164780] = "Cristal de poder rojo",
	[164798] = "Raíz del mal",
	[164820] = "Placa de Guarda oscuro",
	[164867] = "SE BUSCA",
	[164868] = "MATAR INMEDIATAMENTE",
	[164869] = "Cáliz espectral",
	[164885] = "Dragón nocturno corrupto",
	[164886] = "Melodía corrupta",
	[164887] = "Flor del viento corrupta",
	[164888] = "Blancoria corrupta",
	[164909] = "Restos de un bote de remos",
	[164910] = "Cofre ornamentado",
	[164911] = "Barril de cerveza Cebatruenos",
	[164953] = "Mochilas de piel grandes",
	[164954] = "Vaina de Zukk'ash",
	[164955] = "Torre de cristal del Norte",
	[164956] = "Torre de cristal del Oeste",
	[164957] = "Torre de cristal del Este",
	[164958] = "Brote Sangrepétalo",
	[165554] = "El corazón de la montaña",
	[166863] = "Cadáver reciente de trillanodonte",
	[169243] = "Cofre de los Siete",
	[169294] = "Tablilla de los Siete",
	[171938] = "Manzana de cactus",
	[171939] = "Melodía corrupta",
	[171942] = "Melodía corrupta",
	[173232] = "Diseños de herrería",
	[173265] = "Letrina de madera",
	[173266] = "Libro de contabilidad de Buenacero",
	[173284] = "Blancoria corrupta",
	[173324] = "Dragón nocturno corrupto",
	[173327] = "Flor del viento corrupta",
	[174594] = "Melodía corrupta",
	[174595] = "Melodía corrupta",
	[174596] = "Melodía corrupta",
	[174597] = "Melodía corrupta",
	[174598] = "Melodía corrupta",
	[174599] = "Flor del viento corrupta",
	[174600] = "Flor del viento corrupta",
	[174601] = "Flor del viento corrupta",
	[174602] = "Flor del viento corrupta",
	[174603] = "Flor del viento corrupta",
	[174604] = "Flor del viento corrupta",
	[174605] = "Blancoria corrupta",
	[174606] = "Blancoria corrupta",
	[174607] = "Blancoria corrupta",
	[174608] = "Dragón nocturno corrupto",
	[174682] = "Cuidado con los pterrordáctilos",
	[174684] = "Dragón nocturno corrupto",
	[174686] = "Blancoria corrupta",
	[174708] = "Flor del viento corrupta",
	[174709] = "Flor del viento corrupta",
	[174712] = "Melodía corrupta",
	[174713] = "Melodía corrupta",
	[174728] = "Cajón dañado",
	[174848] = "Equipo de pruebas",
	[175084] = "El Destellamatic 5200",
	[175165] = "Arcón del Amanecer de Plata",
	[175166] = "Arcón del Halo de bruma",
	[175207] = "Criatura marina varada",
	[175226] = "Criatura marina varada",
	[175227] = "Criatura marina varada",
	[175230] = "Criatura marina varada",
	[175233] = "Criatura marina varada",
	[175245] = "Llama paternal",
	[175264] = "Esencia de cría",
	[175320] = "SE BUSCA: ¡Viscoso!",
	[175324] = "Esquirlas de Machacahielo",
	[175329] = "Provisiones de nueces del Bosque Negro",
	[175330] = "Provisiones de fruta del Bosque Negro",
	[175331] = "Provisiones de grano del Bosque Negro",
	[175334] = "Pertenencias de Bijou",
	[175369] = "Entrada de servicio de la Plaza de los Ancestros",
	[175382] = "Arca de Equipasino",
	[175384] = "Huevo de dracoleón Nido Alto",
	[175385] = "Tablilla de Rocanegra",
	[175407] = "Pluma Lunadón",
	[175487] = "Tercera tablilla Mosh'aru",
	[175488] = "Cuarta tablilla Mosh'aru",
	[175524] = "Cristal rojo misterioso",
	[175565] = "Huevo extraño",
	[175566] = "Hierba luminiscente",
	[175586] = "Carro de Jaron",
	[175587] = "Cajón dañado",
	[175606] = "Huevo de araña de la cumbre",
	[175621] = "Pila de tributo a Urok",
	[175629] = "Suministros de Jaron",
	[175704] = "Carta chamuscada",
	[175708] = "Cajones de suministros de El Cruce",
	[175785] = "Documentos inadvertidos",
	[175802] = "Arcón pequeño",
	[175886] = "Pica férrea",
	[175888] = "Trozo de reliquia de Altonato",
	[175889] = "Huevo antiguo",
	[175891] = "Trozo de reliquia de Altonato",
	[175892] = "Trozo de reliquia de Altonato",
	[175893] = "Trozo de reliquia de Altonato",
	[175894] = "Paquete de Janice",
	[175924] = "Armario cerrado",
	[175925] = "Letrina",
	[175926] = "Diario de la señora Dalson",
	[175928] = "Pita incendiaria",
	[175944] = "Fuego sagrado de vida",
	[175949] = "Quinta tablilla Mosh'aru",
	[175950] = "Sexta tablilla Mosh'aru",
	[175965] = "Líquido de embalsamar de Murmuhielo",
	[175966] = "Hilo escarlata encantado",
	[175970] = "Coraza rúnica sin forjar",
	[176089] = "Guanteletes de placas sin templar",
	[176090] = "Restos humanos",
	[176091] = "Caldera de Muertobosque",
	[176092] = "Caja de bombas incendiarias",
	[176112] = "Caja fuerte de Malor",
	[176115] = "Cartel de Se busca: Arnak Tótem Siniestro",
	[176116] = "Cabeza de la muñeca de Pamela",
	[176142] = "Parte izquierda de la muñeca de Pamela",
	[176143] = "Parte derecha de la muñeca de Pamela",
	[176145] = "Monumento de Joseph Rutagrana",
	[176150] = "Libro enmohecido",
	[176158] = "Blandón del Dolor",
	[176159] = "Blandón de la Maldad",
	[176160] = "Blandón del Sufrimiento",
	[176161] = "Blandón del Odio",
	[176189] = "Tortuga marina esquelética",
	[176190] = "Tortuga marina varada",
	[176191] = "Tortuga marina varada",
	[176192] = "Catálogo del Díscolo",
	[176196] = "Tortuga marina varada",
	[176197] = "Tortuga marina varada",
	[176198] = "Tortuga marina varada",
	[176206] = "Tratado de Davil",
	[176207] = "Escudo de Rutagrana",
	[176208] = "Cráneo de Horgus",
	[176209] = "Espada destrozada de Marduk",
	[176213] = "Sangre de Héroes",
	[176245] = "Archivo Escarlata",
	[176249] = "Información sobre la Plaga",
	[176317] = "Bastión Argenta",
	[176325] = "Diseños de herrería",
	[176344] = "Cofre de documentos",
	[176356] = "Sagradas escrituras de los Altonato",
	[176361] = "Caldera de la Plaga",
	[176392] = "Caldera de la Plaga",
	[176393] = "Caldera de la Plaga",
	[176484] = "Las escrituras de Rémol",
	[176485] = "Las escrituras de Castel Darrow",
	[176486] = "Las escrituras de Costasur",
	[176487] = "Las escrituras de Molino Tarren",
	[176544] = "Restos de Eva Sarkhoff",
	[176545] = "Restos de Lucien Sarkhoff",
	[176581] = "Cristal de la mano de Iruxos",
	[176582] = "Trampa para marisco",
	[176630] = "Libro de los Recuerdos",
	[176631] = "Obsequio de Menethil",
	[176634] = "Cofre de Kerlonian",
	[176751] = "Huesos de kodo",
	[176785] = "Cajón de munición",
	[176793] = "Fardo de madera",
	[177240] = "Montículo de porquería blanda",
	[177241] = "Filacteria de Araj",
	[177243] = "Portal de demonios",
	[177264] = "Símbolo de Honor perdido",
	[177287] = "Cuadro a medias",
	[177289] = "Caldera de la Plaga",
	[177464] = "Montículo grande de termitas",
	[177490] = "Cajón de la Serrería de Crestanorte",
	[177491] = "Barrica de termitas",
	[177544] = "Cofre de Joseph",
	[177624] = "Bolsa demoníaca de Xabraxxis",
	[177667] = "Pergamino roto",
	[177675] = "Túmulo de barro",
	[177747] = "Registro de Quel'Thalas",
	[177750] = "Flor de hongo lunar",
	[177784] = "Almeja blanda gigante",
	[177786] = "Cofre de Masatormento",
	[177787] = "Cuaderno de bitácora de Masatormento",
	[177789] = "Libro de entradas de Augustus",
	[177804] = "Restos humanos destrozados",
	[177805] = "Restos humanos destrozados",
	[177806] = "Restos humanos destrozados",
	[177904] = "Cartel de Se busca: Besseleth",
	[177926] = "Semilla de Gaia",
	[177929] = "Túmulo de Gaia",
	[177964] = "Piedra de las profundidades",
	[178084] = "Cofre de Félix",
	[178085] = "Cubo de tornillos de Félix",
	[178087] = "Pico de Thazz'ril",
	[178090] = "Tumba de Marla",
	[178104] = "Cristal de resonita",
	[178144] = "Cofre trol",
	[178145] = "Barril de resonita",
	[178184] = "Zafiro de Aku'Mai",
	[178185] = "Zafiro de Aku'Mai",
	[178186] = "Zafiro de Aku'Mai",
	[178195] = "Aceite Grito de Guerra",
	[178204] = "Envío de hachas de los Grito de Guerra",
	[178227] = "Cesta de tótems de Murgut",
	[178553] = "Vaina de Colmen'Ashi",
	[178609] = "Nieve de Vacaciones",
	[179485] = "Trampa rota",
	[179499] = "Cesta de tanino de ogro",
	[179501] = "Alijo de Knot Thimblejack",
	[179516] = "Cofre de Fengus",
	[179517] = "Tesoro de los Shen'dralar",
	[179544] = "Restos esqueléticos de Telmius Buscasueños",
	[179545] = "El cofre del Príncipe",
	[179547] = "Un tomo polvoriento",
	[179551] = "Arca de Hydraxis",
	[179552] = "Esquema: robot de reparación de campo 74A",
	[179553] = "Trozo del Núcleo",
	[179559] = "Fragmento de gangrevid",
	[179562] = "Hoja antigua candente",
	[179564] = "Tributo a Gordok",
	[179565] = "Relicario polvoriento",
	[179697] = "Arqueta de la arena",
	[179703] = "Alijo del Señor del Fuego",
	[179826] = "Diseños secretos: flujo ígneo",
	[179827] = "Se busca/Desaparecido/Objetos perdidos",
	[179828] = "Almohada Hierro Negro",
	[179832] = "Almohada ornamentada de Pilaprieta",
	[179879] = "Orbe de orden",
	[179880] = "Enseña de Drakkisath",
	[179913] = "¡A las armas!",
	[179914] = "Montón de huesos",
	[179915] = "Montón de cráneos",
	[179922] = "Vasija de sangre corrupta",
	[180215] = "Filón de torio de Hakkari",
	[180229] = "Montón hudú maldito",
	[180248] = "Banco de pezricos",
	[180327] = "Blandón de la Locura",
	[180366] = "Caja de aparejos maltrecha",
	[180368] = "Tablilla de Locura",
	[180369] = "Aguas fangosas",
	[180435] = "Cartera de Noggle",
	[180436] = "Fragmentos de tablilla Crepuscular",
	[180448] = "Cartel de Se busca: Pinzamorten",
	[180453] = "Cristal con inscripciones de Colmen'Regal",
	[180454] = "Cristal con inscripciones de Colmen'Ashi",
	[180455] = "Cristal con inscripciones de Colmen'Zora",
	[180456] = "Piedra de viento inferior",
	[180461] = "Piedra de viento",
	[180466] = "Piedra de viento superior",
	[180501] = "Fragmentos de tablilla Crepuscular",
	[180503] = "Libro de cocina de Sandy",
	[180526] = "Gong de Bethekk",
	[180570] = "Barril",
	[180633] = "Lágrima cristalina",
	[180642] = "Cajón inadvertido",
	[180652] = "Tierra removida",
	[180662] = "Restos de goleta",
	[180665] = "Dracónico para torpes",
	[180666] = "Dracónico para torpes",
	[180667] = "Dracónico para torpes",
	[180669] = "Remolino de vorágine",
	[180682] = "Banco de bocanegras grasos",
	[180684] = "Banco de sabiolas superior",
	[180685] = "Restos encharcados",
	[180690] = "Arca del escarabajo grande",
	[180691] = "Arca del escarabajo",
	[180712] = "Banco de anguilas escama pétrea",
	[180743] = "Presente envuelto con cuidado",
	[180746] = "Obsequio ligeramente agitado",
	[180747] = "Presente con envoltorio alegre",
	[180748] = "Presente que hace tic-tac",
	[180751] = "Restos de un naufragio",
	[180793] = "Obsequio festivo",
	[180794] = "Diario de Jandice Barov",
	[180901] = "Restos de los Velasangre",
	[181053] = "Cesta de algas de sangre",
	[181073] = "Caldera apetitosa",
	[181074] = "Botín de la arena",
	[181085] = "Cajón de suministros de Stratholme",
	[181098] = "Ceniza volcánica",
	[181366] = "Cofre de los Cuatro Jinetes",
	[181597] = "Túmulo de silitista",
	[181598] = "Géiser de silitista",
	[181672] = "Efigie del Hombre de Mimbre",
	[181686] = "Montón de madera",
	[181687] = "Montón de madera",
	[190483] = "Cofre de documentos",
	[190484] = "Cofre de documentos",
	[201579] = "Fragmento de piedra angular",
	[207724] = "Restos de naufragio",
	[375544] = "Figurilla de madera",
	[386675] = "Tesoro enterrado",
	[386759] = "Libro de la biblioteca",
	[386777] = "Cofre cubierto de polvo",
	[387466] = "Arcón oxidado",
	[387477] = "Caja secreta de los Defias",
	[392029] = "Recompensa del espadachín",
	[402215] = "Nota chamuscada",
	[403041] = "Suministros explosivos",
	[403102] = "Alijo de botín Erizapúas",
	[403105] = "Bellota Viento Furioso",
	[404352] = "Depósito del artefacto",
	[404433] = "Cofre lunar",
	[404695] = "Caja secreta empapada",
	[404911] = "Alijo oculto",
	[404941] = "Arca de reliquias",
	[405149] = "Mural de Ta'zo",
	[405628] = "Alijo de botín Peloescarcha",
	[405633] = "Baúl Comepiedras",
	[405879] = "Manual de la Sociedad de Boticarios",
	[406006] = "Ídolo",
	[406736] = "Alijo perdido",
	[406918] = "Bolsa de mensajero",
	[407117] = "Nido de quijaforte abandonado",
	[407120] = "Nido de quijaforte vacío",
	[407247] = "Flor del claro",
	[407289] = "Estandarte de guerra de la Horda",
	[407291] = "Estandarte de guerra de la Alianza",
	[407312] = "Ídolo hambriento",
	[407347] = "Altar de espinas",
	[407457] = "Baúl del mozo de establo",
	[407505] = "Talla grabada",
	[407510] = "Talla grabada",
	[407566] = "Tomo goblin",
	[407731] = "Caja de herramientas de albañil",
	[407734] = "Alijo Tuercepinos",
	[407850] = "Relicario sumergido",
	[407918] = "Expositor de trofeos vacío",
	[407983] = "Pila de libros robados",
	[408014] = "Tomo gnómico",
	[408718] = "Alijo de equipo",
	[408802] = "Arpón nudoso",
	[409501] = "Compendio de Dalaran",
	[409562] = "Libro de hechizos",
	[409692] = "Pergaminos",
	[409717] = "Pergaminos",
	[409754] = "Escudo montado en la pared",
	[409758] = "Yelmo desechado",
	[409949] = "Estatua de búho gemelo",
	[410299] = "Secretos Arcanos",
	[410369] = "Escondite secreto",
	[411674] = "Profecía sobre la muerte de un rey",
	[414532] = "Cofre de Fonroca",
	[414624] = "Alijo del faro",
	[414646] = "Resto",
	[415106] = "Restos carbonizados",
	[415107] = "Restos carbonizados",
	[415614] = "Fórmulas misteriosas",
	[417072] = "Tablón claveteado",
	[417353] = "Hoguera apagada",
	[418855] = "Alijo de botín de Illari",
	[422911] = "Barrica sellada",
	[422919] = "Barril de Forjatiniebla empezado",
	[423569] = "Bolsa extraviada",
	[423695] = "Tratado de Liberación",
	[424005] = "Basura de bolsillo",
	[424006] = "Cartera enrollada a toda prisa",
	[424007] = "Figurilla tallada",
	[424010] = "Tablón claveteado",
	[424012] = "Túmulo de barro",
	[424074] = "Baliza de cuadrangulación 001",
	[424075] = "Baliza de cuadrangulación 002",
	[439557] = "Musgo de la Pesadilla",
	[439558] = "Depósito de hierro frío",
	[439627] = "Raíz del Sueño",
	[439628] = "Filón de oro falso",
	[439762] = "Loto estelar",
	[439778] = "Filón de plataestelar",
	[439810] = "Raíz lunar",
	[439815] = "Formación de piedra lunar superior",
	[441124] = "Huevo de dragón tocado por el Sueño",
	[441128] = "Cajón vibrante",
	[441129] = "Profecía de Azshara",
	[441133] = "Huevo de dragón tocado por las estrellas",
	[441140] = "Caja zumbante",
	[441141] = "Perla onírica",
	[441310] = "Huevo de dragón de resplandor lunar",
	[441312] = "Notas del vigilante demente",
	[441314] = "Desvaríos de arpía",
	[441848] = "Madriguera pequeña",
	[441946] = "Santuario de la luna",
	[441947] = "Santuario de la bestia",
	[441948] = "Santuario del celador",
	[457095] = "Elementos para torpes, volumen I: Escarcha",
	[457097] = "Elementos para torpes, volumen II: Fuego",
	[462233] = "Escoria fundida resplandeciente",
	[100000001] = "Antorcha apagada",
});
for key,value in pairs({
	[11] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 1 de WoW Classic.|r",
	[1606] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 2 de Season of Discovery.|r",
	[1607] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 3 de Season of Discovery.|r",
	[1608] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 4 de Season of Discovery.|r",
	[1609] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 5 de Season of Discovery.|r",
	[1610] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 6 de Season of Discovery.|r",
	[1611] = "|cFFAAFFAAEsto no estuvo disponible hasta Phase 7 de Season of Discovery.|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "Nivel 10",
	[7] = "Nivel 20",
	[8] = "Nivel 30",
	[9] = "Nivel 40",
	[10] = "Nivel 50",
	[11] = "Nivel 60",
	[42] = "Explora los Reinos del Este",
	[43] = "Explora Kalimdor",
	[121] = "Oficial cocinero",
	[122] = "Cocinero experto",
	[123] = "Cocinero artesano",
	[126] = "Oficial pescador",
	[127] = "Pescador experto",
	[128] = "Pescador artesano",
	[131] = "Oficial en primeros auxilios",
	[132] = "Experto en primeros auxilios",
	[133] = "Artesano en primeros auxilios",
	[238] = "Una muerte con honor",
	[239] = "25000 muertes con honor",
	[306] = "Maestro pescador de Azeroth",
	[389] = "Maestro de la Arena Gurubashi",
	[396] = "Gran Maestro de la Arena Gurubashi",
	[416] = "Señor Escarabajo",
	[424] = "¿Por qué? Porque es rojo",
	[425] = "Atiesh, gran báculo del Guardián",
	[428] = "Trueno furioso, espada bendita del Hijo del Viento",
	[429] = "Sulfuras, Mano de Ragnaros",
	[509] = "10000 muertes con honor",
	[512] = "5000 muertes con honor",
	[513] = "100 muertes con honor",
	[515] = "500 muertes con honor",
	[516] = "1000 muertes con honor",
	[520] = "20 reputaciones Exaltado",
	[521] = "15 reputaciones Exaltado",
	[522] = "A alguien le gusto",
	[523] = "5 reputaciones Exaltado",
	[524] = "10 reputaciones Exaltado",
	[546] = "Depósito seguro",
	[627] = "Dun Morogh",
	[628] = "Minas de la Muerte",
	[629] = "Sima Ígnea",
	[630] = "Cuevas de los Lamentos",
	[631] = "Castillo de Colmillo Oscuro",
	[633] = "Mazmorras de Ventormenta",
	[635] = "Horado Rajacieno",
	[636] = "Zahúrda Rajacieno",
	[641] = "Templo Sumergido",
	[642] = "Profundidades de Roca Negra",
	[643] = "Cumbre de Roca Negra inferior",
	[684] = "Guarida de Onyxia (Nivel 60)",
	[685] = "Guarida Alanegra",
	[686] = "Núcleo de Magma",
	[687] = "Templo de Ahn'Qiraj",
	[689] = "Ruinas de Ahn'Qiraj",
	[706] = "Aullador Lobo Gélido",
	[707] = "Carnero de batalla Pico Tormenta",
	[708] = "Héroe del clan Lobo Gélido",
	[709] = "Héroe de la Guardia Pico Tormenta",
	[710] = "El Rapiñador",
	[711] = "Caballero de Arathor",
	[712] = "Escolta Grito de Guerra",
	[713] = "Centinela Ala de Plata",
	[714] = "El conquistador",
	[727] = "A mí la caballería",
	[728] = "Durotar",
	[729] = "Riendas de destrero de la muerte",
	[736] = "Mulgore",
	[750] = "Los Baldíos",
	[760] = "Montañas de Alterac",
	[761] = "Tierras Altas de Arathi",
	[765] = "Tierras Inhóspitas",
	[766] = "Las Tierras Devastadas",
	[768] = "Claros de Tirisfal",
	[769] = "Bosque de Argénteos",
	[770] = "Tierras de la Peste del Oeste",
	[771] = "Tierras de la Peste del Este",
	[772] = "Laderas de Trabalomas",
	[773] = "Las Tierras del Interior",
	[774] = "La Garganta de Fuego",
	[775] = "Las Estepas Ardientes",
	[776] = "Bosque de Elwynn",
	[777] = "Paso de la Muerte",
	[778] = "Bosque del Ocaso",
	[779] = "Loch Modan",
	[780] = "Montañas Crestagrana",
	[781] = "Vega de Tuercespina",
	[782] = "Pantano de las Penas",
	[802] = "Páramos de Poniente",
	[841] = "Los Humedales",
	[842] = "Teldrassil",
	[844] = "Costa Oscura",
	[845] = "Vallefresno",
	[846] = "Las Mil Agujas",
	[847] = "Sierra Espolón",
	[848] = "Desolace",
	[849] = "Feralas",
	[850] = "Marjal Revolcafango",
	[851] = "Desierto de Tanaris",
	[852] = "Azshara",
	[853] = "Frondavil",
	[854] = "Cráter de Un'Goro",
	[855] = "Claro de la Luna",
	[856] = "Silithus",
	[857] = "Cuna del Invierno",
	[871] = "¡Adelante, Almirante!",
	[879] = "Montura a la antigua usanza",
	[880] = "Tigre Zulian presto",
	[881] = "Raptor Razzashi presto",
	[891] = "¡Arre!",
	[907] = "El justicar",
	[940] = "Las verdes colinas de Tuercespina",
	[944] = "En ese túnel me adoran",
	[946] = "El Alba Argenta",
	[955] = "Srs. del Agua de Hydraxis",
	[956] = "Linaje de Nozdormu",
	[957] = "Héroe de la tribu Zandalar",
	[1307] = "Cumbre de Roca Negra superior",
	[1676] = "Maestro cultural de los Reinos del Este",
	[1677] = "Maestro cultural de los Reinos del Este",
	[1678] = "Maestro cultural de Kalimdor",
	[1680] = "Maestro cultural de Kalimdor",
	[2116] = "Tabardo de El Alba Argenta",
	[2141] = "Vigilante de establos",
	[2142] = "Llenar el establo",
	[2336] = "Demente supereminente",
	[2357] = "Corcel nefasto xorothiano",
	[2358] = "Destrero",
	[2496] = "El quinto elemento",
	[3356] = "Sable de Hielo de Cuna del Invierno",
	[5788] = "Agente de los Shen'dralar",
	[16433] = "Alma de hierro (temporada de maestría)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "Alcanza el nivel 10.",
	[7] = "Alcanza el nivel 20.",
	[8] = "Alcanza el nivel 30.",
	[9] = "Alcanza el nivel 40.",
	[10] = "Alcanza el nivel 50.",
	[11] = "Alcanza el nivel 60.",
	[42] = "Explora las regiones de los Reinos del Este.",
	[43] = "Explora las regiones de Kalimdor.",
	[121] = "Conviértete en oficial cocinero.",
	[122] = "Conviértete en cocinero experto.",
	[123] = "Conviértete en cocinero artesano.",
	[126] = "Conviértete en oficial pescador.",
	[127] = "Conviértete en pescador experto.",
	[128] = "Conviértete en pescador artesano.",
	[131] = "Conviértete en oficial en primeros auxilios.",
	[132] = "Conviértete en experto en primeros auxilios.",
	[133] = "Conviértete en artesano en primeros auxilios.",
	[238] = "Consigue una muerte con honor.",
	[239] = "Consigue 25000 muertes con honor.",
	[306] = "Gana el concurso de pesca de Bahía del Botín o la competición de pesca Kalu'ak.",
	[389] = "Despoja el abalorio del maestro de arena en la Arena Gurubashi.",
	[396] = "Completa la misión del Corto John Mitril para obtener el abalorio de gran maestro de arena.",
	[416] = "Has abierto las puertas de Ahn'Qiraj.",
	[424] = "Consigue un cristal resonador qiraji rojo.",
	[425] = "Poseedor de Atiesh, gran báculo del Guardián.",
	[428] = "Poseedor de Trueno furioso, espada bendita del Hijo del Viento.",
	[429] = "Poseedor de Sulfuras, Mano de Ragnaros.",
	[509] = "Consigue 10000 muertes con honor.",
	[512] = "Consigue 5000 muertes con honor.",
	[513] = "Consigue 100 muertes con honor.",
	[515] = "Consigue 500 muertes con honor.",
	[516] = "Consigue 1000 muertes con honor.",
	[520] = "Eleva 20 reputaciones a Exaltado.",
	[521] = "Eleva 15 reputaciones a Exaltado.",
	[522] = "Eleva una reputación a Exaltado.",
	[523] = "Eleva 5 reputaciones a Exaltado.",
	[524] = "Eleva 10 reputaciones a Exaltado.",
	[546] = "Compra 7 ranuras adicionales en el banco.",
	[627] = "Explora Dun Morogh y descubre todas las zonas cubiertas del mapa del mundo.",
	[628] = "Derrota a Edwin VanCleef.",
	[629] = "Derrota a Taragaman el Hambriento.",
	[630] = "Derrota a Mutanus el Devorador.",
	[631] = "Derrota al archimago Arugal.",
	[633] = "Derrota a Bazil Thredd.",
	[634] = "Derrota al mekigeniero Termochufe.",
	[635] = "Derrota a Charlga Filonavaja.",
	[636] = "Derrota a Amnennar el Gélido.",
	[638] = "Derrota a Archaedas.",
	[640] = "Derrota a la princesa Theradras.",
	[641] = "Derrota a la Sombra de Eranikus.",
	[642] = "Derrota al emperador Dagran Thaurissan.",
	[643] = "Derrota al señor supremo Vermiothalak.",
	[646] = "Derrota a los diabólicos organizadores que habitan en Stratholme.",
	[684] = "Derrota a la versión clásica de nivel 60 de Onyxia.",
	[685] = "Derrota a Nefarian.",
	[686] = "Derrota a Ragnaros.",
	[687] = "Derrota a C'Thun.",
	[688] = "Derrota a Hakkar.",
	[689] = "Derrota a Osirio el Sinmarcas.",
	[706] = "Consigue un aullador Lobo Gélido.",
	[707] = "Consigue un carnero de batalla Pico Tormenta.",
	[708] = "Alcanza la reputación Exaltado con el clan Lobo Gélido.",
	[709] = "Alcanza la reputación Exaltado con la Guardia Pico Tormenta.",
	[710] = "Alcanza la reputación Exaltado con los Rapiñadores Renegados.",
	[711] = "Alcanza la reputación Exaltado con la Liga de Arathor.",
	[712] = "Alcanza la reputación Exaltado con los Escoltas Grito de Guerra.",
	[713] = "Alcanza la reputación Exaltado con los Centinelas Ala de Plata.",
	[714] = "Eleva tu nivel de reputación en la Garganta Grito de Guerra, la Cuenca de Arathi y el Valle de Alterac a Exaltado.",
	[727] = "Consigue una de las monturas de guerra con el sistema de honor.",
	[728] = "Explora Durotar y descubre todas las zonas cubiertas del mapa del mundo.",
	[729] = "Consigue las riendas de destrero de la muerte del Barón Osahendido en Stratholme.",
	[736] = "Explora Mulgore y descubre todas las zonas cubiertas del mapa del mundo.",
	[750] = "Explora Los Baldíos y descubre todas las zonas cubiertas del mapa del mundo.",
	[760] = "Explora las Montañas de Alterac y descubre todas las zonas cubiertas del mapa del mundo.",
	[761] = "Explora las Tierras Altas de Arathi y descubre todas las zonas cubiertas del mapa del mundo.",
	[765] = "Explora las Tierras Inhóspitas y descubre todas las zonas cubiertas del mapa del mundo.",
	[766] = "Explora Las Tierras Devastadas y descubre todas las zonas cubiertas del mapa del mundo.",
	[768] = "Explora los Claros de Tirisfal y descubre todas las zonas cubiertas del mapa del mundo.",
	[769] = "Explora el Bosque de Argénteos y descubre todas las zonas cubiertas del mapa del mundo.",
	[770] = "Explora las Tierras de la Peste del Oeste y descubre todas las zonas cubiertas del mapa del mundo.",
	[771] = "Explora las Tierras de la Peste del Este y descubre todas las zonas cubiertas del mapa del mundo.",
	[772] = "Explora las Laderas de Trabalomas y descubre todas las zonas cubiertas del mapa del mundo.",
	[773] = "Explora Las Tierras del Interior y descubre todas las zonas cubiertas del mapa del mundo.",
	[774] = "Explora La Garganta de Fuego y descubre todas las zonas cubiertas del mapa del mundo.",
	[775] = "Explora Las Estepas Ardientes y descubre todas las zonas cubiertas del mapa del mundo.",
	[776] = "Explora el Bosque de Elwynn y descubre todas las zonas cubiertas del mapa del mundo.",
	[777] = "Explora el Paso de la Muerte y descubre todas las zonas cubiertas del mapa del mundo.",
	[778] = "Explora el Bosque del Ocaso y descubre todas las zonas cubiertas del mapa del mundo.",
	[779] = "Explora Loch Modan y descubre todas las zonas cubiertas del mapa del mundo.",
	[780] = "Explora las Montañas Crestagrana y descubre todas las zonas cubiertas del mapa del mundo.",
	[781] = "Explora la Vega de Tuercespina y descubre todas las zonas cubiertas del mapa del mundo.",
	[782] = "Explora el Pantano de las Penas y descubre todas las zonas cubiertas del mapa del mundo.",
	[802] = "Explora los Páramos de Poniente y descubre todas las zonas cubiertas del mapa del mundo.",
	[841] = "Explora Los Humedales y descubre todas las zonas cubiertas del mapa del mundo.",
	[842] = "Explora Teldrassil y descubre todas las zonas cubiertas del mapa del mundo.",
	[844] = "Explora Costa Oscura y descubre todas las zonas cubiertas del mapa del mundo.",
	[845] = "Explora Vallefresno y descubre todas las zonas cubiertas del mapa del mundo.",
	[846] = "Explora Las Mil Agujas y descubre todas las zonas cubiertas del mapa del mundo.",
	[847] = "Explora Sierra Espolón y descubre todas las zonas cubiertas del mapa del mundo.",
	[848] = "Explora Desolace y descubre todas las zonas cubiertas del mapa del mundo.",
	[849] = "Explora Feralas y descubre todas las zonas cubiertas del mapa del mundo.",
	[850] = "Explora el Marjal Revolcafango y descubre todas las zonas cubiertas del mapa del mundo.",
	[851] = "Explora el Desierto de Tanaris y descubre todas las zonas cubiertas del mapa del mundo.",
	[852] = "Explora Azshara y descubre todas las zonas cubiertas del mapa del mundo.",
	[853] = "Explora Frondavil y descubre todas las zonas cubiertas del mapa del mundo.",
	[854] = "Explora el Cráter de Un'Goro y descubre todas las zonas cubiertas del mapa del mundo.",
	[855] = "Explora el Claro de la Luna y descubre todas las zonas cubiertas del mapa del mundo.",
	[856] = "Explora Silithus y descubre todas las zonas cubiertas del mapa del mundo.",
	[857] = "Explora la Cuna del Invierno y descubre todas las zonas cubiertas del mapa del mundo.",
	[871] = "Consigue el Sombrero de almirante Velasangre... e intenta tomar un poco de aire fresco de vez en cuando.",
	[879] = "Poseedor de una de las monturas épicas originales que ya no se pueden conseguir.",
	[880] = "Consigue el tigre Zulian presto del sumo sacerdote Thekal en Zul'Gurub.",
	[881] = "Consigue el raptor Razzashi presto del señor sangriento Mandokir en Zul'Gurub.",
	[891] = "Aprende la habilidad aprendiz jinete.",
	[907] = "Eleva tu nivel de reputación en la Garganta Grito de Guerra, la Cuenca de Arathi y el Valle de Alterac a Exaltado.",
	[940] = "Completa todas las misiones de Hemet Nesingwary en la Vega de Tuercespina hasta Las verdes colinas de Tuercespina y Caza mayor incluidas.",
	[944] = "Alcanza la reputación Exaltado con el Bastión Fauces de Madera.",
	[946] = "Alcanza la reputación Exaltado con El Alba Argenta.",
	[955] = "Alcanza la reputación Exaltado con los Srs. del Agua de Hydraxis.",
	[956] = "Alcanza la reputación Exaltado con el Linaje de Nozdormu.",
	[957] = "Alcanza la reputación Exaltado con la tribu Zandalar.",
	[1307] = "Derrota al General Drakkisath.",
	[1676] = "Completa 700 misiones en los Reinos del Este.",
	[1677] = "Completa 550 misiones en los Reinos del Este.",
	[1678] = "Completa 700 misiones en Kalimdor.",
	[1680] = "Completa 685 misiones en Kalimdor.",
	[2116] = "Has conseguido un Tabardo de El Alba Argenta del evento Invasión de la Plaga.",
	[2141] = "Consigue 10 monturas.",
	[2142] = "Consigue 25 monturas.",
	[2336] = "Sube tu reputación hasta Honorable con los Bucaneros Velasangre, y hasta Exaltado con la Bahía del Botín, Vista Eterna, Gadgetzan, Trinquete, la Feria de la Luna Negra, Ravenholdt y Shen'dralar.",
	[2357] = "Has completado la misión de brujo Corcel nefasto xorothiano.",
	[2358] = "Has completado la misión de paladín para obtener un destrero.",
	[2496] = "Consigue una quintaesencia de agua.",
	[3356] = "Obtén un Sable de Hielo de Cuna del Invierno.",
	[5788] = "Alcanza la reputación Exaltado con los Shen'dralar",
	[16433] = "Alcanza el nivel 60 sin morir ni una sola vez durante la temporada de maestría.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Proezas de fuerza",
	[92] = "General",
	[95] = "Jugador contra Jugador",
	[96] = "Misiones",
	[97] = "Exploración",
	[168] = "Mazmorras y bandas",
	[169] = "Profesiones",
	[170] = "Cocina",
	[171] = "Pesca",
	[172] = "Primeros auxilios",
	[201] = "Reputación",
	[14777] = "Reinos del Este",
	[14778] = "Kalimdor",
	[14801] = "Valle de Alterac",
	[14802] = "Cuenca de Arathi",
	[14804] = "G. Grito de Guerra",
	[14808] = "World of Warcraft",
	[14861] = "World of Warcraft",
	[14864] = "World of Warcraft",
})
do achievementCategories[key].name = value; end
if GetLocale():sub(3,4):lower() == "mx" then
localize(L.HEADER_NAMES, {
	[-1001058] = "Arboleda de las Pesadillas",
});
for key,value in pairs({
	[428] = "Trueno Furioso, espada bendita del Hijo del Viento",
	[685] = "Guarida de Alanegra",
	[3356] = "Sable de hielo de Cuna del Invierno",
	[16433] = "Alma de hierro (Temporada de maestría)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[425] = "Equípate con Atiesh, gran báculo del Guardián.",
	[428] = "Equípate con Trueno Furioso, espada bendita del Hijo del Viento.",
	[429] = "Equípate con Sulfuras, Mano de Ragnaros.",
	[891] = "Aprende la habilidad Aprendiz jinete.",
	[2336] = "Eleva tu reputación a Honrado con los Bucaneros Velasangre, y a Exaltado con Bahía del Botín, Vista Eterna, Gadgetzan, Trinquete, Feria de la Luna Negra, Ravenholdt y Shen'dralar.",
	[16433] = "Alcanza el nivel 60 sin morir ni una vez durante la temporada de maestría.",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "Proezas de fuerza",
	[92] = "General",
	[95] = "Jugador contra Jugador",
	[96] = "Misiones",
	[97] = "Exploración",
	[168] = "Calabozos y bandas",
	[169] = "Profesiones",
	[170] = "Cocina",
	[171] = "Pesca",
	[172] = "Primeros auxilios",
	[201] = "Reputación",
	[14777] = "Reinos del Este",
	[14778] = "Kalimdor",
	[14801] = "Valle de Alterac",
	[14802] = "Cuenca de Arathi",
	[14804] = "G. Grito de Guerra",
	[14808] = "World of Warcraft",
	[14861] = "World of Warcraft",
	[14864] = "World of Warcraft",
})
do achievementCategories[key].name = value; end
end
end
if simplifiedLocale == "zh" then
localize(_.CategoryNames, {
	[3] = "塔罗牌",
});
localize(L.HEADER_NAMES, {
	[-1000010] = "首领共同掉落",
	[-1000013] = "商人共同物品",
	[-1000015] = "恶魔训练师",
	[-1000019] = "探索",
	[-1000021] = "飞行路线",
	[-1000025] = "节日",
	[-1000032] = "稀有",
	[-1000034] = "骑术训练师",
	[-1000038] = "宝箱",
	[-1000039] = "商人",
	[-1000040] = "武器大师",
	[-1000042] = "世界首领",
	[-1000044] = "地区掉落",
	[-1000048] = "梦魇之龙",
	[-1000142] = HONOR .. PAPERDOLL_SIDEBAR_TITLES,
	[-1000162] = "共享外观",
	[-1000163] = "独特外观",
	[-1000165] = "T0.5套装",
	[-1000166] = "船长",
	[-1000168] = "四骑士",
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (东)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (北)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (西)",
	[-1000179] = "墓地",
	[-1000180] = "图书馆",
	[-1000181] = "武器库",
	[-1000182] = "修道院",
	[-1000185] = "阿塔莱防御者",
	[-1000191] = "击败一名中尉",
	[-1000192] = "赢得战斗",
	[-1000193] = "与死者交谈",
	[-1000195] = "与灰熊交谈",
	[-1000196] = "与奈奥拉谈",
	[-1000198] = "与罗穆卢斯修士交谈",
	[-1000201] = "暗月马戏团",
	[-1000215] = "冬幕节",
	[-1000218] = "收获节",
	[-1000223] = "仲夏火焰节",
	[-1000227] = "荆棘谷钓鱼大赛",
	[-1000234] = "安其拉之战捐献",
	[-1000235] = "开启黑暗之门",
	[-1000236] = "流沙节杖",
	[-1000237] = "天灾入侵",
	[-1000243] = "暴雪嘉年华",
	[-1000244] = "典藏版",
	[-1000263] = "可口可乐活动",
	[-1000273] = "发现季节",
	[-1000274] = "理解",
	[-1000275] = "等级 1",
	[-1000276] = "等级 2",
	[-1000277] = "怪物狩猎",
	[-1000278] = "铭刻",
	[-1000279] = "遭劫货物",
	[-1000373] = "新角色",
	[-1000376] = "魁梧斗殴",
	[-1000377] = "野生多晶型物",
	[-1000378] = "灵魂掮客",
	[-1000380] = "赏金任务",
	[-1000969] = "梦魇入侵",
	[-1000970] = "等级 3",
	[-1001035] = "时令鱼类：夏季鲈鱼",
	[-1001036] = "时令鱼类：冬鱿鱼",
	[-1001058] = "梦魇林地",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000025] = "你可能需要在特定的节日活动中才能完成本节中的事物。",
	[-1000030] = "此部分只会显示你当前角色的专业技能，除非处于账号模式或调试模式。",
	[-1000033] = "包含有奖励或可从包含部分中的其他内容获得的事物。\n在此处合并以减少来自许多可能重复来源。",
	[-1000040] = "武器大师是一个 NPC，为角色提供学习特定武器技能的机会，不同武器大师的可用性各不相同。所有武器技能都可以在 1 级进行训练，长柄武器除外，需要 20 级。\n\n在补丁 4.0.1 中，武器大师的训练已经过时，因为现在每个班级在创建时都会学习所有适合班级的武器熟练程度。不久之后，武器大师就被从游戏中删除了。",
	[-1000162] = "此列表中的物品是以下物品的共享外观。在唯一外观模式下，此列表可帮助了解特定物品被标记为已收藏的原因。",
	[-1000163] = "此列表中的物品是独特外观。你必须专门收藏这个物品以获得外观。",
	[-1000273] = "本赛季带来了 25 级的初始等级上限和新的 25 级终局游戏，包括 10 名玩家的 Blackfathom Deeps 突袭，其中包含新的机制、新的和重新设计的 Boss 来挑战玩家的战术和策略，以及新鲜的奖励。",
	[-1000278] = "铭刻是最近在发现季节宣布的一个新系统。它允许每个班级通过解锁新的独特能力来定制他们的游戏体验！",
	[-1000279] = "'遭劫货物'任务物品从艾泽拉斯 6 级及以上的小怪中掉落。这些任务要求将'遭劫货物'交付给组织代表，以换取一些银币、经验和声望。当然，货物中也有缺少的物品，你可以补充以获得更大的声望奖励。",
	[-1000376] = "无论谁先击中目标，只有最终击中醉汉的人才会获得荣誉。对此没有团体信用。",
	[-1000377] = "对受到野生变形术影响的小动物施放变形术，将它们变回学徒。每个人都会给你一张纸条。收集 6 个笔记来学习符文。",
	[-1000380] = "此列表包含 ATT Discord 报告的无法获取的物品，这些物品是暴雪尚未修复的错误。\n\n注意：在此列表中忽略所有过滤器以获得可见性。此列表中仅显示因疏忽而从游戏中移除的物品。\n\n致暴雪开发者：请修复下面列出的物品和事件。",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "神器",
});
localize(ObjectNames, {
	[31] = "陈旧的石狮子",
	[32] = "沉没的箱子",
	[34] = "旧罐子",
	[35] = "船长的手提箱",
	[36] = "破酒桶",
	[47] = "通缉！",
	[52] = "古拉巴什的毁灭",
	[54] = "帝王之墓",
	[55] = "被吃掉一半的尸体",
	[56] = "罗尔夫的尸体",
	[57] = "月亮照耀着山谷",
	[58] = "游荡者格里雷克",
	[59] = "一堆松软的泥土",
	[60] = "通缉：加塞尔佐格",
	[61] = "破旧的坟墓",
	[68] = "通缉告示",
	[76] = "空瓶子",
	[119] = "亚伯克隆比的箱子",
	[256] = "通缉",
	[257] = "可疑的桶",
	[259] = "半埋的大桶",
	[261] = "破损的箱子",
	[263] = "库尔森补给品",
	[264] = "库尔森补给品",
	[269] = "被看守着的酒桶",
	[270] = "无人守卫的雷酒桶",
	[271] = "矿工联盟的储物箱",
	[276] = "微光草篮",
	[287] = "书呆子赫罗德的档案",
	[288] = "书呆子赫罗德的保险箱",
	[290] = "法布隆的柜子",
	[321] = "蒂罗亚之泪",
	[331] = "松软的土壤",
	[333] = "古代遗物",
	[334] = "古代遗物",
	[375] = "提瑞斯法南瓜",
	[711] = "通缉！",
	[759] = "圣泉",
	[1166] = "阿历克斯顿的箱子",
	[1557] = "莉莉丝的餐桌",
	[1560] = "储物箱",
	[1561] = "密封的箱子",
	[1562] = "哈加德的箱子",
	[1571] = "布满灰尘的法术书",
	[1585] = "爆炸品",
	[1586] = "蜡烛箱",
	[1593] = "运尸船",
	[1609] = "龙喉投石车",
	[1610] = "火岩矿脉",
	[1627] = "达拉然板条箱",
	[1673] = "魔锥果",
	[1721] = "坚固链球",
	[1722] = "坚固链球",
	[1723] = "泥头花",
	[1728] = "布满灰尘的毯子",
	[1736] = "一箱铁材",
	[1738] = "辛迪加文档",
	[1739] = "辛迪加文档",
	[1740] = "辛迪加文档",
	[1759] = "希尔斯布莱德城镇文档",
	[1760] = "陈旧的书架",
	[1761] = "希尔斯布莱德宣言",
	[1763] = "通缉",
	[1765] = "旧木箱",
	[1768] = "埃希尔之焰",
	[1769] = "沃拉兹之焰",
	[1770] = "尤基尔之焰",
	[2008] = "危险！",
	[2059] = "矮人的尸体",
	[2068] = "紫葡萄酒",
	[2076] = "冒泡的大锅",
	[2083] = "血帆海盗的信件",
	[2084] = "麝鼠根",
	[2086] = "血帆海图",
	[2087] = "血帆计划书",
	[2289] = "破损的救生艇",
	[2553] = "浸水的卷轴",
	[2554] = "科泰罗的谜题",
	[2555] = "发霉的卷轴",
	[2560] = "半埋的瓶子",
	[2576] = "海潮祭坛",
	[2652] = "伊贝尼瑟的尸体",
	[2656] = "浸水的信件",
	[2688] = "钥匙之石",
	[2689] = "西禁锢之石",
	[2690] = "外禁锢之石",
	[2691] = "东禁锢之石",
	[2701] = "虹光水晶碎块",
	[2702] = "内禁锢之石",
	[2704] = "爆炸品",
	[2707] = "处女号的航海图",
	[2708] = "银松之魂号的航海图",
	[2709] = "处女号的航海日志",
	[2710] = "银松之魂号的航海日志",
	[2712] = "石化精灵宝钻",
	[2713] = "通缉板",
	[2714] = "奥特兰克花岗岩",
	[2716] = "特雷莱恩的箱子",
	[2717] = "特雷莱恩的手提箱",
	[2718] = "特雷莱恩的箱子",
	[2724] = "一袋燕麦",
	[2734] = "浸水的箱子",
	[2739] = "黑羽之箱",
	[2740] = "鸦爪之箱",
	[2741] = "天空之箱",
	[2742] = "巢穴之箱",
	[2743] = "雕纹石罐",
	[2744] = "巨型蚌壳",
	[2842] = "钻石柱",
	[2848] = "玛瑙石柱",
	[2858] = "紫水晶石柱",
	[2867] = "挖掘场补给箱",
	[2868] = "弄皱的地图",
	[2875] = "残破的矮人骸骨",
	[2891] = "巴里亚曼颅骨堆",
	[2892] = "赞塔加颅骨堆",
	[2893] = "祖玛维颅骨堆",
	[2907] = "水罐",
	[2908] = "密封的补给箱",
	[2910] = "水井石",
	[2912] = "琥珀颗粒",
	[2933] = "大地封印",
	[3076] = "沾满泥土的地图",
	[3189] = "进攻计划：试炼谷",
	[3190] = "进攻计划：森金村",
	[3192] = "进攻计划：奥格瑞玛",
	[3236] = "侏儒工具箱",
	[3238] = "老陈的空酒桶",
	[3239] = "本尼迪克的箱子",
	[3240] = "鞭尾龙的蛋",
	[3290] = "被偷走的补给袋",
	[3525] = "火焰祭坛",
	[3640] = "丰满的蘑菇",
	[3642] = "科卡尔的战利品",
	[3643] = "旧提箱",
	[3644] = "巴尔莫丹飞行器",
	[3685] = "异种蝎土丘",
	[3737] = "冒泡的裂隙",
	[3767] = "崔斯里克的货物",
	[3768] = "易碎品",
	[3972] = "通缉",
	[4072] = "主控制阀",
	[4141] = "控制台",
	[4406] = "树林蜘蛛的卵",
	[4608] = "林精的新芽",
	[5620] = "有裂痕的能量石",
	[6751] = "奇怪的果树",
	[6752] = "奇怪的树木",
	[6906] = "红色迅猛龙巢穴",
	[6907] = "蓝色迅猛龙巢穴",
	[6908] = "黄色迅猛龙巢穴",
	[7510] = "发芽的树叶",
	[9630] = "弗拉冈特的化石",
	[10076] = "占卜之碗",
	[11713] = "毒帽蘑菇",
	[11714] = "粗柄蘑菇",
	[12666] = "暮光之书",
	[13360] = "黑暗深渊遗物",
	[13891] = "毒蛇花",
	[13949] = "铁箱",
	[15084] = "超级清洁器5200型",
	[15085] = "超级清洁器5200型",
	[16393] = "上古之火",
	[17182] = "传声盒827号",
	[17183] = "传声盒411号",
	[17184] = "传声盒323号",
	[17188] = "亚米萨兰的衰落",
	[17189] = "亚米萨兰的毁灭",
	[17282] = "草药",
	[17783] = "古代雕像",
	[19015] = "月神之泪",
	[19016] = "星尘覆盖的草丛",
	[19021] = "生锈的箱子",
	[19022] = "旧箱子",
	[19024] = "隐蔽的神龛",
	[19027] = "迈萨迪斯之书",
	[19030] = "一堆泥土",
	[19283] = "堕落者纲要",
	[19284] = "泰坦神话",
	[19595] = "守门者",
	[19602] = "风险投资公司工程计划书",
	[19861] = "亨里格·独眉的日记",
	[19869] = "火箭车碎片",
	[19877] = "维琳德的柜子",
	[19901] = "禁锢法阵",
	[20352] = "禁锢法阵",
	[20359] = "奥妮克希亚的蛋",
	[20691] = "考兹尔的箱子",
	[20725] = "巨龙的遗产",
	[20726] = "亡灵的起源",
	[20727] = "基兹莫瑞货箱",
	[20805] = "瑞兹尔的计划",
	[20807] = "古代火盆",
	[20920] = "蓝叶薯",
	[20985] = "松软的泥土",
	[20992] = "黑色盾牌",
	[21015] = "蹄印",
	[21016] = "蹄印",
	[21042] = "塞拉摩卫兵徽章",
	[21052] = "迪菲亚保险箱",
	[21277] = "开孔的箱子",
	[21530] = "地鼠训练手册",
	[22245] = "一袋肉",
	[22246] = "瑟莱德丝之泪",
	[22550] = "德莱尼水晶",
	[24798] = "晒干的流木",
	[28024] = "车队箱子",
	[30854] = "阿塔莱神器",
	[30855] = "阿塔莱神器",
	[30856] = "阿塔莱神器",
	[32569] = "加林的保险箱",
	[35251] = "卡尼托的箱子",
	[35252] = "古代遗物",
	[36738] = "乌尔之书",
	[37099] = "阿塔莱石板",
	[50935] = "一袋玉米",
	[50936] = "一袋大麦",
	[50937] = "一袋黑麦",
	[50961] = "玛雷姆的箱子",
	[50982] = "烧焦的橡木",
	[51708] = "伊莉莎的坟墓",
	[58369] = "被偷走的铁箱",
	[58595] = "火刃营地",
	[61934] = "眠炎火盆",
	[61935] = "调节阀",
	[61936] = "燃油控制阀",
	[68865] = "地鼠指挥棒",
	[85563] = "蛀牙杰克的箱子",
	[86492] = "月神矿石",
	[89634] = "铁珊瑚",
	[89635] = "晒焦的蛋壳",
	[91138] = "乔丹的铁锤",
	[92013] = "阴谋之书",
	[92420] = "白洛尔的矿石",
	[92423] = "破损的箱子",
	[93192] = "同心树",
	[102984] = "彬克的工具箱",
	[102985] = "巴尼尔金鱼草",
	[103574] = "装满的封灵箱",
	[103628] = "乌尔的暗影魔法研究论文",
	[103821] = "杜安的保险箱",
	[104564] = "宾格斯的工具箱",
	[104569] = "宾格斯的工具箱",
	[104574] = "宾格斯的工具箱",
	[104575] = "宾格斯的气压炸弹",
	[105174] = "封灵箱",
	[105175] = "显形卷轴",
	[112888] = "布满灰尘的书架",
	[112948] = "保险箱",
	[113757] = "暗影熔炉地窖",
	[113768] = "复活节彩蛋",
	[123329] = "巴尔洛戈的箱子",
	[123462] = "南海宝珠",
	[125477] = "显眼的石罐",
	[126049] = "紫色蘑菇",
	[126158] = "塔隆凯的衣柜",
	[126260] = "古代储物箱",
	[131474] = "诺甘农圆盘",
	[138492] = "密斯莱尔水晶碎块",
	[140911] = "淡绿色丝线",
	[140971] = "加兹瑞迪安",
	[141832] = "祖尔法拉克铁锣",
	[141853] = "紫色水生菇",
	[141931] = "角鹰兽的蛋",
	[141979] = "古代宝藏",
	[142071] = "测蛋器",
	[142088] = "意志石板",
	[142122] = "通缉：卡利夫·斯科比斯汀",
	[142127] = "林吉的秘密",
	[142151] = "密封的桶",
	[142179] = "索兰萨尔瞭望台",
	[142181] = "被偷走的货物",
	[142184] = "船长的箱子",
	[142185] = "拜尔坦之焰",
	[142186] = "莱哈萨之焰",
	[142188] = "萨姆哈之焰",
	[142195] = "木爪作战地图",
	[142343] = "奥丹姆石座",
	[142344] = "机械储存柜",
	[142345] = "矩阵式打孔计算机3005-A",
	[142475] = "矩阵式打孔计算机3005-B",
	[142476] = "矩阵式打孔计算机3005-C",
	[142487] = "超级清洁器5200型",
	[142696] = "矩阵式打孔计算机3005-D",
	[142702] = "毒液瓶",
	[142715] = "塞卡石板",
	[142958] = "菲拉斯的历史",
	[143980] = "戈杜尼卷轴",
	[144063] = "艾奎尼克斯石碑",
	[144064] = "戈杜尼土堆",
	[144066] = "第一只枯木牢笼",
	[144067] = "第二只枯木牢笼",
	[144068] = "第三个枯木牢笼",
	[144070] = "沙普比克的笼子",
	[148498] = "苏塔拉祭坛",
	[148504] = "明显的墓碑",
	[148506] = "暮光神器",
	[148513] = "辛耶尔石板",
	[148514] = "玛科里石板",
	[148515] = "塞尔哈石板",
	[148516] = "贝萨玛拉石板",
	[149025] = "哨岗火盆",
	[149030] = "哨岗火盆",
	[149031] = "哨岗火盆",
	[149032] = "哨岗火盆",
	[149036] = "玛尔冯的箱子",
	[149502] = "黑龙的财宝",
	[150075] = "通缉告示",
	[151286] = "卡多雷召唤宝典",
	[152095] = "月牙百合花",
	[152618] = "科卡尔的战利品",
	[152622] = "艾萨莱特晶体",
	[153123] = "基姆加尔的设备",
	[153239] = "枭兽羽毛",
	[154357] = "闪光的泥浆",
	[156561] = "通缉告示",
	[157936] = "安戈洛土堆",
	[160836] = "古物宝库",
	[160845] = "黑暗宝箱",
	[161495] = "秘密保险箱",
	[161504] = "小背包",
	[161505] = "破碎的木筏",
	[161521] = "研究设备",
	[161526] = "食物箱",
	[161527] = "恐龙骨头",
	[161557] = "米莉的葡萄",
	[161752] = "工具篮",
	[164659] = "绿色能量水晶",
	[164661] = "黄色能量水晶",
	[164689] = "弗兰克罗恩·铸铁的雕像",
	[164778] = "蓝色能量水晶",
	[164780] = "红色能量水晶",
	[164820] = "黑暗守护者的标示牌",
	[164867] = "通缉",
	[164868] = "格杀勿论",
	[164869] = "鬼魂之杯",
	[164885] = "被腐化的夜龙草",
	[164886] = "被腐化的轻歌花",
	[164887] = "被腐化的迎风花",
	[164888] = "被腐化的鞭根草",
	[164909] = "破损的独木舟",
	[164910] = "华丽的箱子",
	[164911] = "雷霆啤酒",
	[164953] = "大皮包",
	[164954] = "祖卡什虫茧",
	[164955] = "北部水晶塔",
	[164956] = "西部水晶塔",
	[164957] = "东部水晶塔",
	[164958] = "血瓣花苗",
	[165554] = "山脉之心",
	[166863] = "新鲜的蛇颈龙肉",
	[169243] = "七贤之箱",
	[169294] = "七贤石板",
	[171938] = "仙人掌果",
	[171939] = "被腐化的轻歌花",
	[171942] = "被腐化的轻歌花",
	[173232] = "锻造设计图",
	[173265] = "木制厕所",
	[173284] = "被腐化的鞭根草",
	[173324] = "被腐化的夜龙草",
	[173327] = "被腐化的迎风花",
	[174594] = "被腐化的轻歌花",
	[174595] = "被腐化的轻歌花",
	[174596] = "被腐化的轻歌花",
	[174597] = "被腐化的轻歌花",
	[174598] = "被腐化的轻歌花",
	[174599] = "被腐化的迎风花",
	[174600] = "被腐化的迎风花",
	[174601] = "被腐化的迎风花",
	[174602] = "被腐化的迎风花",
	[174603] = "被腐化的迎风花",
	[174604] = "被腐化的迎风花",
	[174605] = "被腐化的鞭根草",
	[174606] = "被腐化的鞭根草",
	[174607] = "被腐化的鞭根草",
	[174608] = "被腐化的夜龙草",
	[174682] = "当心翼手龙",
	[174684] = "被腐化的夜龙草",
	[174686] = "被腐化的鞭根草",
	[174708] = "被腐化的迎风花",
	[174709] = "被腐化的迎风花",
	[174712] = "被腐化的轻歌花",
	[174713] = "被腐化的轻歌花",
	[174728] = "破损的箱子",
	[174848] = "测试仪器",
	[175084] = "超级清洁器5200型",
	[175165] = "银色清晨号的保险箱",
	[175166] = "迷雾之纱号的保险箱",
	[175207] = "搁浅的海洋生物",
	[175226] = "搁浅的海洋生物",
	[175227] = "搁浅的海洋生物",
	[175230] = "搁浅的海洋生物",
	[175233] = "搁浅的海洋生物",
	[175245] = "烈焰之父",
	[175320] = "通缉：莫克迪普！",
	[175324] = "霜槌碎片",
	[175329] = "黑木坚果",
	[175330] = "黑木水果",
	[175331] = "黑木谷物",
	[175334] = "比修的装置",
	[175369] = "长者广场入口",
	[175382] = "末日扣环之箱",
	[175384] = "风巢双足飞龙的蛋",
	[175385] = "黑暗石板",
	[175407] = "月光羽毛",
	[175524] = "神秘的红色水晶",
	[175565] = "异型蛋",
	[175566] = "阴暗草",
	[175586] = "加隆的马车",
	[175587] = "破损的箱子",
	[175606] = "尖塔蜘蛛卵",
	[175621] = "乌洛克的贡品堆",
	[175629] = "加隆的补给物资",
	[175708] = "十字路口的补给箱",
	[175785] = "不显眼的文件",
	[175802] = "小箱子",
	[175886] = "尖锐长矛",
	[175888] = "上层精灵遗物碎片",
	[175889] = "远古之卵",
	[175891] = "上层精灵遗物碎片",
	[175892] = "上层精灵遗物碎片",
	[175893] = "上层精灵遗物碎片",
	[175894] = "詹妮丝的包裹",
	[175924] = "锁住的柜橱",
	[175925] = "厕所",
	[175926] = "达尔松夫人的日记",
	[175928] = "火岩龙舌兰",
	[175949] = "第五块摩沙鲁石板",
	[175950] = "第六块摩沙鲁石板",
	[175965] = "莱斯·霜语的防腐液",
	[175966] = "魔化血色丝线",
	[175970] = "未铸成的符文胸甲",
	[176089] = "未淬火的板甲护手",
	[176090] = "人类遗骸",
	[176091] = "死木蒸锅",
	[176092] = "火岩箱",
	[176112] = "玛洛尔的保险箱",
	[176115] = "通缉：阿纳克-恐怖图腾",
	[176116] = "帕米拉的洋娃娃的脑袋",
	[176142] = "帕米拉的洋娃娃的左身",
	[176143] = "帕米拉的洋娃娃的右身",
	[176145] = "约瑟夫·雷德帕斯的纪念碑",
	[176158] = "痛苦火盆",
	[176159] = "怨意火盆",
	[176160] = "受难火盆",
	[176161] = "仇恨火盆",
	[176189] = "海龟骨头",
	[176190] = "搁浅的海龟",
	[176191] = "搁浅的海龟",
	[176192] = "游荡者目录",
	[176196] = "搁浅的海龟",
	[176197] = "搁浅的海龟",
	[176198] = "搁浅的海龟",
	[176206] = "达维的圣契",
	[176207] = "雷德帕斯之盾",
	[176208] = "霍古斯的颅骨",
	[176209] = "马杜克的破碎之剑",
	[176213] = "英雄之血",
	[176245] = "血色十字军档案",
	[176249] = "天灾军团档案",
	[176325] = "锻造设计图",
	[176344] = "文件箱",
	[176361] = "瘟疫之锅",
	[176392] = "天灾之锅",
	[176393] = "瘟疫之锅",
	[176484] = "布瑞尔地契",
	[176485] = "凯尔达隆地契",
	[176486] = "南海镇地契",
	[176487] = "塔伦米尔地契",
	[176544] = "艾瓦·萨克霍夫的遗体",
	[176545] = "卢森·萨克霍夫的遗体",
	[176582] = "贝壳陷阱",
	[176630] = "巫妖生前的遗物",
	[176631] = "米奈希尔的礼物",
	[176634] = "克罗尼亚的箱子",
	[176751] = "科多兽骨",
	[176785] = "弹药箱",
	[176793] = "一捆木柴",
	[177241] = "阿拉基的护命匣",
	[177243] = "恶魔之门",
	[177264] = "失落荣耀的象征",
	[177287] = "未完成的油画",
	[177289] = "瘟疫之锅",
	[177464] = "大白蚁丘",
	[177491] = "白蚁桶",
	[177544] = "约瑟夫的箱子",
	[177667] = "破损的卷轴",
	[177750] = "月光蘑菇花",
	[177784] = "巨型软壳蚌",
	[177786] = "拉克摩尔的箱子",
	[177787] = "拉克摩尔的日志",
	[177789] = "奥古斯图斯的单据",
	[177805] = "破碎的人类残骸",
	[177904] = "通缉：贝瑟莱斯",
	[177964] = "深渊之石",
	[178087] = "塔兹利尔的镐",
	[178104] = "共鸣水晶",
	[178144] = "巨魔的箱子",
	[178195] = "战歌之油",
	[178204] = "一箱战歌之斧",
	[178227] = "穆戈特的图腾篮",
	[178553] = "亚什虫茧",
	[178609] = "节日大雪",
	[179485] = "损坏的陷阱",
	[179499] = "食人魔鞣酸篮",
	[179501] = "诺特·希姆加克的储物箱",
	[179516] = "芬古斯的箱子",
	[179517] = "辛德拉的宝藏",
	[179544] = "卡里尔·温萨鲁斯的骸骨",
	[179545] = "王子的箱子",
	[179552] = "结构图：修理机器人74A型",
	[179553] = "熔核碎片",
	[179559] = "水晶碎片",
	[179562] = "上古淬火之剑",
	[179564] = "戈多克贡品",
	[179565] = "覆满灰尘的箱子",
	[179697] = "竞技场财宝箱",
	[179703] = "炎魔之王的宝箱",
	[179827] = "通缉/寻物/招领",
	[179828] = "黑铁枕头",
	[179832] = "[Pillamaster's Ornate Pillow]",
	[179879] = "命令宝珠",
	[179880] = "达基萨斯的烙印",
	[179913] = "作战公告！",
	[179914] = "白骨堆",
	[179922] = "腐化之血",
	[180229] = "厄运巫毒堆",
	[180248] = "可口鱼",
	[180327] = "疯狂之缘的火盆",
	[180366] = "破碎的工具箱",
	[180368] = "疯狂石板",
	[180369] = "混浊的水",
	[180435] = "诺格的背包",
	[180436] = "暮光石板碎片",
	[180448] = "通缉布告：死亡弯钩",
	[180453] = "雷戈虫巢雕文水晶",
	[180454] = "亚什虫巢雕文水晶",
	[180455] = "佐拉虫巢雕文水晶",
	[180456] = "次级风石",
	[180461] = "风石",
	[180466] = "强力风石",
	[180501] = "暮光石板碎片",
	[180503] = "盖满沙子的烹饪书",
	[180526] = "贝瑟克之锣",
	[180570] = "小桶",
	[180633] = "水晶之泪",
	[180642] = "不起眼的箱子",
	[180662] = "帆船残骸",
	[180665] = "龙语傻瓜教程",
	[180666] = "龙语傻瓜教程",
	[180667] = "龙语傻瓜教程",
	[180669] = "湍急的漩涡",
	[180682] = "黑口鱼群",
	[180684] = "大型鼠尾鱼群",
	[180685] = "浸水的残骸",
	[180690] = "大型圣甲虫箱",
	[180691] = "圣甲虫箱",
	[180712] = "石鳞鳗群",
	[180717] = "甲虫之锣",
	[180743] = "节日礼物",
	[180746] = "轻轻摇晃过的礼品",
	[180747] = "节日礼物",
	[180748] = "条纹礼物盒",
	[180751] = "漂浮的残骸",
	[180793] = "节日礼物",
	[180794] = "詹迪斯·巴罗夫的日记",
	[180901] = "血帆船只残骸",
	[181053] = "一篮血藻",
	[181073] = "薰炉",
	[181074] = "竞技场的泥土",
	[181085] = "斯坦索姆物资箱",
	[181098] = "火山灰",
	[181597] = "水晶尘土堆",
	[181598] = "水晶尘喷孔",
	[181672] = "稻草人",
	[181686] = "木材堆",
	[181687] = "木材堆",
	[190483] = "文件箱",
	[190484] = "文件箱",
	[201579] = "钥石碎片",
	[207724] = "船只残骸",
	[386691] = "图书馆书籍",
	[386759] = "图书馆书籍",
	[386777] = "尘封的宝箱",
	[405149] = "塔佐的浮雕",
	[405633] = "石颚提箱",
	[405879] = "药剂师的会社读本",
	[406918] = "信使行囊",
	[407120] = "空荡荡的钳嘴龟的巢",
	[407289] = "部落战旗",
	[407347] = "荆棘祭坛",
	[407454] = "火药桶",
	[407457] = "马夫的箱子",
	[407566] = "地精魔典",
	[408718] = "装备贮藏",
	[408799] = "深渊神像",
	[409692] = "卷轴",
	[410369] = "秘密投放点",
	[414624] = "灯塔藏匿物",
	[415106] = "焦焚残骸",
	[415107] = "焦焚残骸",
	[417072] = "镶钉木板",
	[417353] = "熄灭的营火",
	[418855] = "伊莱丽的战利品箱",
	[422911] = "密封的桶",
	[423569] = "丢下的袋子",
	[423695] = "解脱圣契",
	[424005] = "垃圾袋",
	[424006] = "草草收起的包裹",
	[424007] = "雕刻塑像",
	[424010] = "镶钉木板",
	[424012] = "一堆泥土",
	[424074] = "四边定位信标001",
	[424075] = "四边定位信标002",
	[424076] = "四边定位信标003",
	[424077] = "四边定位信标004",
	[439627] = "梦之根",
	[439628] = "愚人金矿脉",
	[441124] = "梦触龙蛋",
	[441128] = "震动的箱子",
	[441848] = "小地洞",
	[441946] = "月亮神龛",
	[441947] = "野兽神龛",
	[441948] = "守护神龛",
	[455812] = "侍从库斯伯特之剑",
	[457088] = "《进阶剑法》",
	[457089] = "《暗影的联系》",
	[457090] = "《艾泽拉斯著名（与恶名）游侠列传》",
	[457091] = "《老陈的修炼秘诀》",
	[457093] = "《正义钝击：矮人传奇》",
	[457095] = "《元素奥义傻瓜入门第I卷：冰霜》",
	[457096] = "《先发制人：拳手搏击指南》",
	[457097] = "《元素奥义傻瓜入门第II卷：火焰》",
	[457098] = "《心若灵豹：当代德鲁伊指南》",
	[457099] = "《吉勒内扛揍指南》",
	[457100] = "《雷吉克的“公平”对决总结》",
	[457101] = "《荣耀决斗仪式》",
	[457102] = "《元素奥义傻瓜入门第III卷：奥术》",
	[462233] = "闪光的熔火岩块",
	[100000001] = "未点燃的火把",
});
for key,value in pairs({
	[1] = "从未实施 [NYI]",
	[2] = "从游戏中移除",
	[4] = "PvP 精良/角斗士",
	[5] = "不可学",
})
do phases[key].name = value; end
for key,value in pairs({
	[1] = "|cFFFF0000此项玩家永远无法获得。|r",
	[2] = "|cFFFF0000此项已从游戏中删除。|r",
	[4] = "|cFFFFAAAA除非您拥有所需的 PvP 头衔、所需的 PvP 等级或处于该赛季的前 %，否则无法再购买或解锁幻化。|r",
	[5] = "|cFFFFAAAA这不能永久收集、学习或用于幻化。|r",
	[11] = "|cFFAAFFAA该功能直到 Phase 1 的 WoW Classic 才可用。|r",
	[1606] = "|cFFAAFFAA该功能直到 Phase 2 的 Season of Discovery 才可用。|r",
	[1607] = "|cFFAAFFAA该功能直到 Phase 3 的 Season of Discovery 才可用。|r",
	[1608] = "|cFFAAFFAA该功能直到 Phase 4 的 Season of Discovery 才可用。|r",
	[1609] = "|cFFAAFFAA该功能直到 Phase 5 的 Season of Discovery 才可用。|r",
	[1610] = "|cFFAAFFAA该功能直到 Phase 6 的 Season of Discovery 才可用。|r",
	[1611] = "|cFFAAFFAA该功能直到 Phase 7 的 Season of Discovery 才可用。|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "10级",
	[7] = "20级",
	[8] = "30级",
	[9] = "40级",
	[10] = "50级",
	[11] = "60级",
	[42] = "探索东部王国",
	[43] = "探索卡利姆多",
	[121] = "中级烹饪",
	[122] = "高级厨师",
	[123] = "烹饪专家",
	[126] = "中级钓鱼",
	[127] = "高级渔夫",
	[128] = "钓鱼专家",
	[131] = "中级急救",
	[132] = "高级急救师",
	[133] = "急救专家",
	[238] = "一次荣誉击杀",
	[239] = "25000个荣誉击杀",
	[306] = "艾泽拉斯的钓鱼大师",
	[389] = "竞技场高手饰物",
	[396] = "古拉巴什竞技场大师",
	[416] = "甲虫之王",
	[424] = "红色是身份的象征",
	[425] = "埃提耶什，守护者的传说之杖",
	[428] = "雷霆之怒，逐风者的祝福之剑",
	[429] = "萨弗拉斯，炎魔拉格纳罗斯之手",
	[509] = "10000个荣誉击杀",
	[512] = "5000个荣誉击杀",
	[513] = "100个荣誉击杀",
	[515] = "500个荣誉击杀",
	[516] = "1000个荣誉击杀",
	[520] = "20个声望崇拜",
	[521] = "15个声望崇拜",
	[522] = "有人喜欢我",
	[523] = "5个声望崇拜",
	[524] = "10个声望崇拜",
	[546] = "安全仓库",
	[627] = "探索丹莫罗",
	[628] = "死亡矿井",
	[629] = "怒焰裂谷",
	[630] = "哀嚎洞穴",
	[631] = "影牙城堡",
	[633] = "暴风城监狱",
	[634] = "诺莫瑞根",
	[635] = "剃刀沼泽",
	[636] = "剃刀高地",
	[638] = "奥达曼",
	[640] = "玛拉顿",
	[641] = "沉没的神庙",
	[642] = "黑石深渊",
	[643] = "黑石塔下层",
	[646] = "斯坦索姆",
	[684] = "奥妮克希亚的巢穴（60级）",
	[685] = "黑翼之巢",
	[686] = "熔火之心",
	[687] = "安其拉神殿",
	[688] = "祖尔格拉布",
	[689] = "安其拉废墟",
	[706] = "霜狼嗥叫者",
	[707] = "雷矛军用坐骑",
	[708] = "霜狼氏族的英雄",
	[709] = "雷矛卫队的英雄",
	[710] = "污染者",
	[711] = "阿拉索的骑士",
	[712] = "战歌氏族",
	[713] = "银翼哨兵",
	[714] = "征服者",
	[727] = "呼叫骑兵",
	[728] = "探索杜隆塔尔",
	[729] = "死亡军马的缰绳",
	[736] = "探索莫高雷",
	[750] = "探索贫瘠之地",
	[760] = "探索奥特兰克山脉",
	[761] = "探索阿拉希高地",
	[765] = "探索荒芜之地",
	[766] = "探索诅咒之地",
	[768] = "探索提瑞斯法林地",
	[769] = "探索银松森林",
	[770] = "探索西瘟疫之地",
	[771] = "探索东瘟疫之地",
	[772] = "探索希尔斯布莱德丘陵",
	[773] = "探索辛特兰",
	[774] = "探索灼热峡谷",
	[775] = "探索燃烧平原",
	[776] = "探索艾尔文森林",
	[777] = "探索逆风小径",
	[778] = "探索暮色森林",
	[779] = "探索洛克莫丹",
	[780] = "探索赤脊山",
	[781] = "探索荆棘谷",
	[782] = "探索悲伤沼泽",
	[802] = "探索西部荒野",
	[841] = "探索湿地",
	[842] = "探索泰达希尔",
	[844] = "探索黑海岸",
	[845] = "探索灰谷",
	[846] = "探索千针石林",
	[847] = "探索石爪山脉",
	[848] = "探索凄凉之地",
	[849] = "探索菲拉斯",
	[850] = "探索尘泥沼泽",
	[851] = "探索塔纳利斯",
	[852] = "探索艾萨拉",
	[853] = "探索费伍德森林",
	[854] = "探索安戈洛环形山",
	[855] = "探索月光林地",
	[856] = "探索希利苏斯",
	[857] = "探索冬泉谷",
	[871] = "遵命，船长！",
	[879] = "古典坐骑",
	[880] = "迅捷祖利安猛虎",
	[881] = "拉扎什迅猛龙",
	[891] = "驾！",
	[907] = "审判者",
	[940] = "荆棘谷的青山",
	[944] = "熊怪之友",
	[946] = "银色黎明",
	[955] = "海达希亚水元素",
	[956] = "诺兹多姆的子嗣",
	[957] = "赞达拉部族的英雄",
	[1307] = "黑石塔上层",
	[1676] = "东部王国的博学者",
	[1677] = "东部王国的博学者",
	[1678] = "卡利姆多的博学者",
	[1680] = "卡利姆多的博学者",
	[2116] = "银色黎明战袍",
	[2141] = "马厩管理员",
	[2142] = "坐骑满仓",
	[2336] = "你疯了吧？！",
	[2357] = "克索诺斯的恐惧战马",
	[2358] = "军马",
	[2496] = "第五元素",
	[3356] = "冬泉霜刃豹",
	[5788] = "辛德拉的代言人",
	[16433] = "钢铁之魂（赛季服）",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "升到10级。",
	[7] = "升到20级。",
	[8] = "升到30级。",
	[9] = "升到40级。",
	[10] = "升到50级。",
	[11] = "升到60级。",
	[42] = "探索东部王国的各个区域。",
	[43] = "探索卡利姆多的各个区域。",
	[121] = "成为一名中级厨师。",
	[122] = "成为一名高级厨师。",
	[123] = "成为一名专家级厨师。",
	[126] = "成为一名中级渔夫。",
	[127] = "成为一名高级渔夫。",
	[128] = "成为一名专家级渔夫。",
	[131] = "成为一名中级急救师。",
	[132] = "成为一名高级急救师。",
	[133] = "成为一名专家级急救师。",
	[238] = "完成一次荣誉击杀。",
	[239] = "达到25000个荣誉击杀。",
	[306] = "赢得藏宝海湾钓鱼大赛或卡鲁亚克钓鱼大赛的胜利。",
	[389] = "从古拉巴什竞技场拾取竞技场高手饰物。",
	[396] = "完成小个子约翰·米斯瑞尔的任务，获得竞技场大师饰物。",
	[416] = "打开安其拉之门。",
	[424] = "获得一枚红色其拉共鸣水晶。",
	[425] = "获得埃提耶什，守护者的传说之杖。",
	[428] = "获得雷霆之怒，逐风者的祝福之剑。",
	[429] = "获得萨弗拉斯，炎魔拉格纳罗斯之手。",
	[509] = "达到10000个荣誉击杀。",
	[512] = "达到5000个荣誉击杀。",
	[513] = "达到100个荣誉击杀。",
	[515] = "达到500个荣誉击杀。",
	[516] = "达到1000个荣誉击杀。",
	[520] = "在20个势力中达到崇拜声望。",
	[521] = "在15个势力中达到崇拜声望。",
	[522] = "在一个势力中达到崇拜声望。",
	[523] = "在5个势力中达到崇拜声望。",
	[524] = "在10个势力中达到崇拜声望。",
	[546] = "购买7个额外的银行栏位。",
	[627] = "探索丹莫罗，走过世界地图中被遮住的各个角落。",
	[628] = "击败艾德温·范克里夫。",
	[629] = "击败饥饿者塔拉加曼。",
	[630] = "击败吞噬者穆坦努斯。",
	[631] = "击败大法师阿鲁高。",
	[633] = "击败巴基尔·斯瑞德。",
	[634] = "击败机械师瑟玛普拉格。",
	[635] = "击败卡尔加·刺肋。",
	[636] = "击败寒冰之王亚门纳尔。",
	[638] = "击败阿扎达斯。",
	[640] = "击败瑟莱德丝公主。",
	[641] = "击败伊兰尼库斯的阴影。",
	[642] = "击败达格兰·索瑞森大帝。",
	[643] = "击败维姆萨拉克。",
	[646] = "击败隐藏在斯坦索姆城中的邪恶头目。",
	[684] = "击败60级版本的奥妮克希亚。",
	[685] = "击败奈法利安。",
	[686] = "击败拉格纳罗斯。",
	[687] = "击败克苏恩。",
	[688] = "击败哈卡。",
	[689] = "击败无疤者奥斯里安。",
	[706] = "获得一头霜狼嗥叫者。",
	[707] = "获得一头雷矛军用坐骑。",
	[708] = "在霜狼氏族阵营中达到崇拜声望。",
	[709] = "在雷矛卫队阵营中达到崇拜声望。",
	[710] = "在污染者阵营中达到崇拜声望。",
	[711] = "在阿拉索联军阵营中达到崇拜声望。",
	[712] = "在战歌氏族阵营中达到崇拜声望。",
	[713] = "在银翼要塞阵营中达到崇拜声望。",
	[714] = "在战歌峡谷、阿拉希盆地和奥特兰克山谷中达到崇拜声望。",
	[727] = "通过荣誉系统，获取一头作战坐骑。",
	[728] = "探索杜隆塔尔，走过世界地图中被遮住的各个角落。",
	[729] = "从斯坦索姆的瑞文戴尔男爵那里获取死亡军马的缰绳。",
	[736] = "探索莫高雷，走过世界地图中被遮住的各个角落。",
	[750] = "探索贫瘠之地，走过世界地图中被遮住的各个角落。",
	[760] = "探索奥特兰克山脉，走过世界地图中被遮住的各个角落。",
	[761] = "探索阿拉希高地，走过世界地图中被遮住的各个角落。",
	[765] = "探索荒芜之地，走过世界地图中被遮住的各个角落。",
	[766] = "探索诅咒之地，走过世界地图中被遮住的各个角落。",
	[768] = "探索提瑞斯法林地，走过世界地图中被遮住的各个角落。",
	[769] = "探索银松森林，走过世界地图中被遮住的各个角落。",
	[770] = "探索西瘟疫之地，走过世界地图中被遮住的各个角落。",
	[771] = "探索东瘟疫之地，走过世界地图中被遮住的各个角落。",
	[772] = "探索希尔斯布莱德丘陵，走过世界地图中被遮住的各个角落。",
	[773] = "探索辛特兰，走过世界地图中被遮住的各个角落。",
	[774] = "探索灼热峡谷，走过世界地图中被遮住的各个角落。",
	[775] = "探索燃烧平原，走过世界地图中被遮住的各个角落。",
	[776] = "探索艾尔文森林，走过世界地图中被遮住的各个角落。",
	[777] = "探索逆风小径，走过世界地图中被遮住的各个角落。",
	[778] = "探索暮色森林，走过世界地图中被遮住的各个角落。",
	[779] = "探索洛克莫丹，走过世界地图中被遮住的各个角落。",
	[780] = "探索赤脊山，走过世界地图中被遮住的各个角落。",
	[781] = "探索荆棘谷，走过世界地图中被遮住的各个角落。",
	[782] = "探索悲伤沼泽，走过世界地图中被遮住的各个角落。",
	[802] = "探索西部荒野，走过世界地图中被遮住的各个角落。",
	[841] = "探索湿地，走过世界地图中被遮住的各个角落。",
	[842] = "探索泰达希尔，走过世界地图中被遮住的各个角落。",
	[844] = "探索黑海岸，走过世界地图中被遮住的各个角落。",
	[845] = "探索灰谷，走过世界地图中被遮住的各个角落。",
	[846] = "探索千针石林，走过世界地图中被遮住的各个角落。",
	[847] = "探索石爪山脉，走过世界地图中被遮住的各个角落。",
	[848] = "探索凄凉之地，走过世界地图中被遮住的各个角落。",
	[849] = "探索菲拉斯，走过世界地图中被遮住的各个角落。",
	[850] = "探索尘泥沼泽，走过世界地图中被遮住的各个角落。",
	[851] = "探索塔纳利斯，走过世界地图中被遮住的各个角落。",
	[852] = "探索艾萨拉，走过世界地图中被遮住的各个角落。",
	[853] = "探索费伍德森林，走过世界地图中被遮住的各个角落。",
	[854] = "探索安戈洛环形山，走过世界地图中被遮住的各个角落。",
	[855] = "探索月光林地，走过世界地图中被遮住的各个角落。",
	[856] = "探索希利苏斯，走过世界地图中被遮住的各个角落。",
	[857] = "探索冬泉谷，走过世界地图中被遮住的各个角落。",
	[871] = "获得血帆舰长之帽……然后出门去呼吸一点新鲜空气。",
	[879] = "拥有一种无法再获得的原始史诗坐骑。",
	[880] = "从祖尔格拉布的高阶祭司塞卡尔那里获取迅捷祖利安猛虎。",
	[881] = "从祖尔格拉布的血领主曼多基尔那里获取拉扎什迅猛龙。",
	[891] = "学习初级骑术。",
	[907] = "在战歌峡谷、阿拉希盆地和奥特兰克山谷中达到崇拜声望。",
	[940] = "在荆棘谷完成包括“荆棘谷的青山”和“王牌猎人”在内的所有赫米特·奈辛瓦里任务。",
	[944] = "在木喉要塞阵营中达到崇拜声望。",
	[946] = "在银色黎明阵营中达到崇拜声望。",
	[955] = "在海达希亚水元素阵营中达到崇拜声望。",
	[956] = "在诺兹多姆的子嗣阵营中达到崇拜声望。",
	[957] = "在赞达拉部族阵营中达到崇拜声望。",
	[1307] = "击败达基萨斯将军。",
	[1676] = "在东部王国完成700个任务。",
	[1677] = "在东部王国完成550个任务。",
	[1678] = "在卡利姆多完成700个任务。",
	[1680] = "在卡利姆多完成685个任务。",
	[2116] = "通过天灾入侵事件获得一件银色黎明战袍。",
	[2141] = "获得10种坐骑。",
	[2142] = "获得25种坐骑。",
	[2336] = "将你在血帆海盗的声望提升到尊敬，藏宝海湾、永望镇、加基森、棘齿城、暗月马戏团、拉文霍德和辛德拉的声望提升到崇拜。",
	[2357] = "完成克索诺斯的恐惧战马任务。",
	[2358] = "完成圣骑士的军马任务。",
	[2496] = "获得一份水之精萃。",
	[3356] = "获得一只冬泉霜刃豹。",
	[5788] = "在辛德拉阵营中达到崇拜声望。",
	[16433] = "在赛季服升到60级为止都没有死亡。",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "光辉事迹",
	[92] = "综合",
	[95] = "PvP",
	[96] = "任务",
	[97] = "探索",
	[168] = "地下城和团队",
	[169] = "专业",
	[170] = "烹饪",
	[171] = "钓鱼",
	[172] = "急救",
	[201] = "声望",
	[14777] = "东部王国",
	[14778] = "卡利姆多",
	[14801] = "奥特兰克山谷",
	[14802] = "阿拉希盆地",
	[14804] = "战歌峡谷",
	[14808] = "经典旧世",
	[14861] = "经典旧世",
	[14864] = "经典旧世",
})
do achievementCategories[key].name = value; end
if GetLocale():sub(3,4):lower() == "tw" then
localize(_.CategoryNames, {
	[106] = "卡片",
	[227] = "武器",
	[233] = "背包",
	[250] = "背包",
});
localize(L.HEADER_NAMES, {
	[-1000010] = "首領共通掉落",
	[-1000013] = "商人共通物品",
	[-1000015] = "惡魔訓練師",
	[-1000021] = "飛行路線",
	[-1000025] = "節慶",
	[-1000034] = "騎術訓練師",
	[-1000038] = "寶箱",
	[-1000040] = "武器大師",
	[-1000042] = "世界首領",
	[-1000044] = "地區掉落",
	[-1000048] = "夢魘之龍",
	[-1000162] = "共享外觀",
	[-1000163] = "獨特外觀",
	[-1000165] = "T0.5套裝",
	[-1000168] = "四騎士",
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (東)",
	[-1000201] = "暗月馬戲團",
	[-1000215] = "冬幕節",
	[-1000218] = "收穫節",
	[-1000223] = "仲夏火焰節慶",
	[-1000227] = "荊棘谷釣魚大賽",
	[-1000234] = "安其拉之戰捐獻",
	[-1000236] = "流沙節杖",
	[-1000237] = "天譴軍團入侵",
	[-1000243] = "暴雪嘉年華",
	[-1000273] = "探索賽季",
	[-1000275] = "等級 1",
	[-1000276] = "等級 2",
	[-1000277] = "怪物狩獵",
	[-1000278] = "紋刻",
	[-1000279] = "遭攔截的物資",
	[-1000280] = "製作",
	[-1000281] = "採集",
	[-1000378] = "靈魂仲介者",
	[-1000969] = "夢魘入侵",
	[-1000970] = "等級 3",
	[-1001035] = "季節性魚類：夏日鱸魚",
	[-1001036] = "季節性魚類：冬魷魚",
	[-1001058] = "夢魘林地",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000015] = "術士可以教導他們的惡魔新技能，一些高等級的魔典只能從你陣營首都的惡魔訓練師那裡購買。",
	[-1000025] = "你可能需要在特定節日的活動中才能完成本節中的事物。",
	[-1000040] = "武器大師是一個 NPC，為角色提供學習特定武器技能的機會，不同武器大師的可用性各不相同。所有武器技能都可以在 1 级進行訓練，長柄武器除外，需要 20 级。\n\n在更新 4.0.1 中，武器大師的訓練已经過時，因為现在每個職業在創建时都會學習所有適合該職業的武器熟練度。不久之後，武器大師就被從遊戲中删除了。",
	[-1000173] = "副本的這部分可以從最東邊的傳送門進入。（右側）",
	[-1000174] = "副本的這部分可以從最北邊的傳送門進入。",
	[-1000175] = "副本的這部分可以從最西邊的傳送門進入。（左側）",
	[-1000273] = "這個賽季起初將會有 25 級的上限，還會帶來全新的 25 級終局內容，包括帶有全新機制的 10 人玩家黑澗深淵副本、全新設計的首領來挑戰玩家的戰術實力，同時還會給予新獎勵。",
	[-1000278] = "紋刻是最近在探索賽季實現的一個新系統，它允許每個職業通過解鎖新的獨特能力來自訂他們的遊戲體驗！",
	[-1000279] = "'遭攔截的物資'任務物品會從艾澤拉斯各地6級及以上的怪物掉落。這些任務要求將'遭攔截的物資'交付給某個組織的代表，以換取少量銀幣、經驗值和聲望。當然，物資運送中有一些物品遺失，你可以補充這些物品以獲得更多的聲望獎勵。",
});
localize(L.HEADER_LORE, {
	[-1000048] = "這些龍中的一隻會在艾澤拉斯的相關座標隨機生成。",
});
localize(ObjectNames, {
	[179697] = "競技場寶箱",
	[180456] = "次級風石",
	[180461] = "風石",
	[405633] = "石齶置物箱",
});
for key,value in pairs({
	[1] = "從未實裝 [NYI]",
	[2] = "已從遊戲中移除",
	[3] = "暴雪點數",
	[4] = "PvP 精良/角鬥士",
	[5] = "不可學",
	[1605] = "探索賽季",
	[1606] = "第2階段",
	[1607] = "第3階段",
	[1608] = "第4階段",
	[1609] = "第5階段",
	[1610] = "第6階段",
	[1611] = "第7階段",
})
do phases[key].name = value; end
for key,value in pairs({
	[1] = "|cFFFF0000此項玩家永遠無法獲得。|r",
	[2] = "|cFFFF0000此項已從遊戲中刪除。|r",
	[3] = "|cFFAAFFAA這被鎖定在付費牆後面，例如遊戲內商店、另一個暴雪產品或招兵買馬召集令。|r",
	[4] = "|cFFFFAAAA除非您擁有所需的 PvP 頭銜、所需的 PvP 等級或處於該賽季的前 %，否則無法再購買或解鎖塑形。|r",
	[5] = "|cFFFFAAAA這不能永久收集、學習或用於塑形。|r",
	[11] = "|cFFAAFFAA該功能直到 Phase 1 的 WoW Classic 才可用。|r",
	[1606] = "|cFFAAFFAA該功能直到 第2階段 的 Season of Discovery 才可用。|r",
	[1607] = "|cFFAAFFAA該功能直到 第3階段 的 Season of Discovery 才可用。|r",
	[1608] = "|cFFAAFFAA該功能直到 第4階段 的 Season of Discovery 才可用。|r",
	[1609] = "|cFFAAFFAA該功能直到 第5階段 的 Season of Discovery 才可用。|r",
	[1610] = "|cFFAAFFAA該功能直到 第6階段 的 Season of Discovery 才可用。|r",
	[1611] = "|cFFAAFFAA該功能直到 第7階段 的 Season of Discovery 才可用。|r",
})
do phases[key].description = value; end
for key,value in pairs({
	[6] = "10級",
	[7] = "20級",
	[8] = "30級",
	[9] = "40級",
	[10] = "50級",
	[11] = "60級",
	[42] = "探索東部王國",
	[43] = "探索卡林多",
	[121] = "中級廚師",
	[122] = "高級廚師",
	[123] = "專家級廚師",
	[126] = "中級漁夫",
	[127] = "高級漁夫",
	[128] = "專家級漁夫",
	[131] = "習得中級急救技能",
	[132] = "習得高級急救技能",
	[133] = "習得專家級急救技能",
	[238] = "一個榮譽擊殺",
	[239] = "25000次榮譽擊殺",
	[306] = "艾澤拉斯釣手大師",
	[389] = "古拉巴什競技場大師",
	[396] = "古拉巴什競技場宗師",
	[416] = "聖甲蟲領主",
	[424] = "問我為什麼?因為它是紅色的",
	[425] = "阿泰絲，守護者之杖",
	[428] = "雷霆之怒，逐風者的祝福之刃",
	[429] = "薩弗拉斯，炎魔拉格納羅斯之手",
	[509] = "10000次榮譽擊殺",
	[512] = "5000次榮譽擊殺",
	[513] = "100次榮譽擊殺",
	[515] = "500次榮譽擊殺",
	[516] = "1000次榮譽擊殺",
	[520] = "20項聲望崇拜",
	[521] = "15項聲望崇拜",
	[522] = "還是有人喜歡我",
	[523] = "5項聲望崇拜",
	[524] = "10項聲望崇拜",
	[546] = "安全存放",
	[627] = "探索丹莫洛",
	[628] = "死亡礦坑",
	[633] = "暴風城監獄",
	[634] = "諾姆瑞根",
	[635] = "剃刀沼澤",
	[638] = "奧達曼",
	[640] = "瑪拉頓",
	[641] = "沉沒的神廟",
	[642] = "黑石深淵",
	[643] = "黑石塔下層",
	[684] = "奧妮克希亞的巢穴(60級)",
	[687] = "安其拉神廟",
	[688] = "祖爾格拉布",
	[689] = "安其拉廢墟",
	[707] = "雷矛軍用戰騎",
	[709] = "雷矛衛隊的英雄",
	[711] = "阿拉索騎士",
	[712] = "戰歌先遣騎",
	[713] = "銀翼哨兵",
	[727] = "呼喚騎兵",
	[728] = "探索杜洛塔",
	[729] = "死亡戰騎韁繩",
	[750] = "探索貧瘠之地",
	[760] = "探索奧特蘭克山脈",
	[765] = "探索荒蕪之地",
	[766] = "探索詛咒之地",
	[768] = "探索提里斯法林地",
	[769] = "探索銀松森林",
	[771] = "探索東瘟疫之地",
	[772] = "探索希爾斯布萊德丘陵",
	[773] = "探索辛特蘭",
	[774] = "探索灼熱峽谷",
	[775] = "探索燃燒平原",
	[776] = "探索艾爾文森林",
	[777] = "探索逆風小徑",
	[781] = "探索荊棘谷",
	[782] = "探索悲傷沼澤",
	[841] = "探索濕地",
	[842] = "探索泰達希爾",
	[845] = "探索梣谷",
	[846] = "探索千針石林",
	[847] = "探索石爪山脈",
	[848] = "探索淒涼之地",
	[850] = "探索塵泥沼澤",
	[851] = "探索塔納利斯沙漠",
	[852] = "探索艾薩拉",
	[853] = "探索費伍德森林",
	[854] = "探索安戈洛環形山",
	[856] = "探索希利蘇斯",
	[871] = "敬禮，艦隊司令!",
	[879] = "守舊坐騎",
	[881] = "迅捷拉札希迅猛龍",
	[891] = "駕駕!",
	[907] = "審判者",
	[940] = "荊棘谷的青山",
	[944] = "愛在隧道中",
	[946] = "銀色黎明",
	[955] = "海達希亞水元素",
	[956] = "諾茲多姆的子嗣",
	[957] = "贊達拉部族的英雄",
	[1307] = "黑石塔上層",
	[1676] = "東部王國博學大師",
	[1677] = "東部王國博學大師",
	[1678] = "卡林多博學大師",
	[1680] = "卡林多博學大師",
	[2116] = "銀色黎明外袍",
	[2141] = "獸欄管理者",
	[2142] = "塞滿獸倉",
	[2336] = "頭腦異常",
	[2357] = "克索諾斯恐懼戰馬",
	[2358] = "戰騎",
	[5788] = "辛德拉使者",
	[16433] = "鋼鐵之魂(大師賽季)",
})
do achievements[key].name = value; end
for key,value in pairs({
	[6] = "達到10級。",
	[7] = "達到20級。",
	[8] = "達到30級。",
	[9] = "達到40級。",
	[10] = "達到50級。",
	[11] = "達到60級。",
	[42] = "探索東部王國所有區域。",
	[43] = "探索卡林多所有區域。",
	[121] = "習得中級烹飪技能。",
	[122] = "習得高級烹飪技能。",
	[123] = "習得專家級烹飪技能。",
	[126] = "習得中級釣魚技能。",
	[127] = "習得高級釣魚技能。",
	[128] = "習得專家級釣魚技能。",
	[131] = "習得中級急救技能。",
	[132] = "習得高級急救技能。",
	[133] = "習得專家級急救技能。",
	[238] = "達成一個榮譽擊殺。",
	[239] = "達成25000次榮譽擊殺。",
	[306] = "在藏寶海灣釣魚競賽或卡魯耶克釣魚大賽中獲勝。",
	[389] = "從古拉巴什競技場中拾取競技場大師飾品。",
	[396] = "完成小個子約翰·米斯瑞爾的任務，取得競技場宗師飾物。",
	[416] = "打開安其拉之門。",
	[424] = "獲得一顆紅色其拉共鳴水晶。",
	[425] = "阿泰絲，守護者之杖的持有者。",
	[428] = "雷霆之怒，逐風者的祝福之刃的持有者。",
	[429] = "薩弗拉斯，炎魔拉格納羅斯之手的持有者。",
	[509] = "達成10000次榮譽擊殺。",
	[512] = "達成5000次榮譽擊殺。",
	[513] = "達成100次榮譽擊殺。",
	[515] = "達成500次榮譽擊殺。",
	[516] = "達成1000次榮譽擊殺。",
	[520] = "20項聲望提升至崇拜。",
	[521] = "15項聲望提升至崇拜。",
	[522] = "1項聲望提升至崇拜。",
	[523] = "5項聲望提升至崇拜。",
	[524] = "10項聲望提升至崇拜。",
	[546] = "購買7個銀行欄位。",
	[627] = "探索丹莫洛，解開世界地圖上未知的區域。",
	[628] = "擊敗艾德溫·范克里夫。",
	[629] = "擊敗『飢餓者』塔拉加曼。",
	[630] = "擊敗『吞噬者』穆坦努斯。",
	[631] = "擊敗大法師阿魯高。",
	[633] = "擊敗巴基爾·斯瑞德。",
	[634] = "擊敗機電師瑟瑪普拉格。",
	[635] = "擊敗卡爾加‧刺肋。",
	[636] = "擊敗『寒冰使者』亞門納爾。",
	[638] = "擊敗阿札達斯。",
	[640] = "擊敗瑟萊德絲公主。",
	[641] = "擊敗伊蘭尼庫斯之影。",
	[642] = "擊敗達格蘭‧索瑞森大帝。",
	[643] = "擊敗維姆薩拉克主宰。",
	[646] = "擊敗住在斯坦索姆的邪惡首腦。",
	[684] = "擊敗60級版本的艾澤拉斯奧妮克希亞。",
	[685] = "擊敗奈法利安。",
	[686] = "擊敗拉格納羅斯。",
	[687] = "擊敗克蘇恩。",
	[688] = "擊敗哈卡。",
	[689] = "擊敗『無疤者』奧斯里安。",
	[706] = "獲得一頭霜狼嗥叫者。",
	[707] = "獲得一頭雷矛軍用戰騎。",
	[708] = "在霜狼氏族獲得聲望崇拜。",
	[709] = "在雷矛衛隊獲得聲望崇拜。",
	[710] = "在污染者獲得聲望崇拜。",
	[711] = "在阿拉索聯軍獲得聲望崇拜。",
	[712] = "在戰歌先遣騎獲得聲望崇拜。",
	[713] = "在銀翼哨兵獲得聲望崇拜。",
	[714] = "你的戰歌峽谷、阿拉希盆地與奧特蘭克山谷聲望提升至崇拜。",
	[727] = "從榮譽系統中獲得一頭戰爭坐騎。",
	[728] = "探索杜洛塔，解開世界地圖上未知的區域。",
	[729] = "從斯坦索姆的瑞文戴爾男爵手中獲得死亡戰騎韁繩。",
	[736] = "探索莫高雷，解開世界地圖上未知的區域。",
	[750] = "探索貧瘠之地，解開世界地圖上未知的區域。",
	[760] = "探索奧特蘭克山脈，解開世界地圖上未知的區域。",
	[761] = "探索阿拉希高地，解開世界地圖上未知的區域。",
	[765] = "探索荒蕪之地，解開世界地圖上未知的區域。",
	[766] = "探索詛咒之地，解開世界地圖上未知的區域。",
	[768] = "探索提里斯法林地，解開世界地圖上未知的區域。",
	[769] = "探索銀松森林，解開世界地圖上未知的區域。",
	[770] = "探索西瘟疫之地，解開世界地圖上未知的區域。",
	[771] = "探索東瘟疫之地，解開世界地圖上未知的區域。",
	[772] = "探索希爾斯布萊德丘陵，解開世界地圖上未知的區域。",
	[773] = "探索辛特蘭，解開世界地圖上未知的區域。",
	[774] = "探索灼熱峽谷，解開世界地圖上未知的區域。",
	[775] = "探索燃燒平原，解開世界地圖上未知的區域。",
	[776] = "探索艾爾文森林，解開世界地圖上未知的區域。",
	[777] = "探索逆風小徑，解開世界地圖上未知的區域。",
	[778] = "探索暮色森林，解開世界地圖上未知的區域。",
	[779] = "探索洛克莫丹，解開世界地圖上未知的區域。",
	[780] = "探索赤脊山，解開世界地圖上未知的區域。",
	[781] = "探索荊棘谷，解開世界地圖上未知的區域。",
	[782] = "探索悲傷沼澤，解開世界地圖上未知的區域。",
	[802] = "探索西部荒野，解開世界地圖上未知的區域。",
	[841] = "探索濕地，解開世界地圖上未知的區域。",
	[842] = "探索泰達希爾，解開世界地圖上未知的區域。",
	[844] = "探索黑海岸，解開世界地圖上未知的區域。",
	[845] = "探索梣谷，解開世界地圖上未知的區域。",
	[846] = "探索千針石林，解開世界地圖上未知的區域。",
	[847] = "探索石爪山脈，解開世界地圖上未知的區域。",
	[848] = "探索淒涼之地，解開世界地圖上未知的區域。",
	[849] = "探索菲拉斯，解開世界地圖上未知的區域。",
	[850] = "探索塵泥沼澤，解開世界地圖上未知的區域。",
	[851] = "探索塔納利斯沙漠，解開世界地圖上未知的區域。",
	[852] = "探索艾薩拉，解開世界地圖上未知的區域。",
	[853] = "探索費伍德森林，解開世界地圖上未知的區域。",
	[854] = "探索安戈洛環形山，解開世界地圖上未知的區域。",
	[855] = "探索月光林地，解開世界地圖上未知的區域。",
	[856] = "探索希利蘇斯，解開世界地圖上未知的區域。",
	[857] = "探索冬泉谷，解開世界地圖上未知的區域。",
	[871] = "獲得血帆上將之帽…該出門去呼吸一些新鮮空氣了吧。",
	[879] = "再也無法獲得的原始史詩坐騎之一的擁有者。",
	[880] = "從祖爾格拉布的高階祭司塞卡爾手中獲得迅捷祖利安猛虎。",
	[881] = "從祖爾格拉布的血領主曼多基爾手中獲得迅捷拉札希迅猛龍。",
	[891] = "學習初級騎術。",
	[907] = "你的戰歌峽谷、阿拉希盆地與奧特蘭克山谷聲望提升至崇拜。",
	[940] = "完成赫米特·奈辛瓦里在荊棘谷的所有任務，包括荊棘谷的青山和王牌獵人。",
	[944] = "取得木喉要塞的聲望崇拜。",
	[946] = "取得銀色黎明的聲望崇拜。",
	[955] = "取得海達希亞水元素的聲望崇拜。",
	[956] = "取得諾茲多姆的子嗣的聲望崇拜。",
	[957] = "取得贊達拉部族的聲望崇拜。",
	[1307] = "擊敗達基薩斯將軍。",
	[1676] = "在東部王國完成700個任務。",
	[1677] = "在東部王國完成550個任務。",
	[1678] = "在卡林多完成700個任務。",
	[1680] = "在卡林多完成685個任務。",
	[2116] = "從天譴軍團入侵事件獲得銀色黎明外袍。",
	[2141] = "獲得10隻坐騎。",
	[2142] = "獲得25隻坐騎。",
	[2336] = "將你血帆海盜的聲望提高至尊敬，藏寶海灣、永望鎮、加基森、棘齒城、暗月馬戲團、拉文霍德和辛德拉的聲望提高至崇拜。",
	[2357] = "完成術士的克索諾斯恐懼戰馬任務。",
	[2358] = "完成聖騎士的戰騎任務。",
	[2496] = "獲得水之精萃。",
	[3356] = "獲得一隻冬泉霜刃豹。",
	[5788] = "取得辛德拉的聲望崇拜。",
	[16433] = "在大師賽季中，在完全沒有死亡的情況下達到60級。",
})
do achievements[key].description = value; end
for key,value in pairs({
	[81] = "偉業",
	[92] = "一般",
	[95] = "玩家對玩家",
	[96] = "任務",
	[97] = "探索",
	[168] = "地城與團隊",
	[169] = "專業技能",
	[170] = "烹飪",
	[171] = "釣魚",
	[172] = "急救",
	[201] = "聲望",
	[14777] = "東部王國",
	[14778] = "卡林多",
	[14801] = "奧特蘭克山谷",
	[14802] = "阿拉希盆地",
	[14804] = "戰歌峽谷",
	[14808] = "艾澤拉斯",
	[14861] = "艾澤拉斯",
	[14864] = "艾澤拉斯",
})
do achievementCategories[key].name = value; end
end
end


-- Add a Header & Filter debugger
setmetatable(_.FilterConstants, {
	__index = function(t, key)
		_.print("MISSING FilterConstant:", key);
		rawset(t, key, -9999999999);
		return -9999999999;
	end
});
setmetatable(_.HeaderConstants, {
	__index = function(t, key)
		_.print("MISSING HeaderConstant:", key);
		rawset(t, key, -9999999999);
		return -9999999999;
	end
});